/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "tools.h"
#include <qbuttongroup.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qimage.h>
#include <qpixmap.h>


#include "images/arrow_tool.xpm"
#include "images/brush_tool.xpm"
#include "images/button_tool.xpm"
#include "images/eraser_tool.xpm"
#include "images/hand_tool.xpm"
#include "images/images_tool.xpm"
#include "images/ink_bottle_tool.xpm"
#include "images/line_tool.xpm"
#include "images/oval_tool.xpm"
#include "images/paint_bucket_tool.xpm"
#include "images/pencil_tool.xpm"
#include "images/pen_tool.xpm"
#include "images/polygon_tool.xpm"
#include "images/rectangle_tool.xpm"
#include "images/sprite_tool.xpm"
#include "images/text_box_tool.xpm"
#include "images/text_tool.xpm"
#include "images/zoom_tool.xpm"



/*
 *  Constructs a Tools as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
Tools::Tools( QWidget* parent, const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    if ( !name )
      setName( "Tools" );
   buttonGroup1 = new QButtonGroup( this, "buttonGroup1" );
   buttonGroup1->setGeometry( QRect( 0, 0, 100, 450 ) );
   buttonGroup1->setExclusive( true );

   toolButton1 = new QToolButton( buttonGroup1, "toolButton1" );
   toolButton1->setGeometry( QRect( 5, 5, 32, 32 ) );
   toolButton1->setToggleButton( true );
   toolButton1->setOn( true );
   toolButton1->setIconSet( QIconSet( QPixmap (( const char** ) arrow_tool_xpm)));

   toolButton2 = new QToolButton( buttonGroup1, "toolButton2" );
   toolButton2->setGeometry( QRect( 37, 5, 32, 32 ) );
   toolButton2->setToggleButton( true );
   toolButton2->setIconSet( QIconSet( QPixmap (( const char** ) line_tool_xpm)));
   toolButton2->setUsesBigPixmap( true );

   toolButton3 = new QToolButton( buttonGroup1, "toolButton3" );
   toolButton3->setGeometry( QRect( 5, 37, 32, 32 ) );
   toolButton3->setToggleButton( true );
   toolButton3->setIconSet( QIconSet( QPixmap (( const char** ) pen_tool_xpm)));
   toolButton3->setUsesBigPixmap( false );
   
   toolButton4 = new QToolButton( buttonGroup1, "toolButton4" );
   toolButton4->setGeometry( QRect( 37, 37, 32, 32 ) );
   toolButton4->setToggleButton( true );
   toolButton4->setIconSet( QIconSet( QPixmap (( const char** ) text_tool_xpm)));
   toolButton4->setUsesBigPixmap( true );
    
   toolButton5 = new QToolButton( buttonGroup1, "toolButton5" );
   toolButton5->setEnabled( true );
   toolButton5->setGeometry( QRect( 5, 69, 32, 32 ) );
   toolButton5->setToggleButton( true );
   toolButton5->setIconSet( QIconSet( QPixmap (( const char** ) eraser_tool_xpm)));
   toolButton5->setUsesBigPixmap( false );
   
   toolButton6 = new QToolButton( buttonGroup1, "toolButton6" );
   toolButton6->setGeometry( QRect( 37, 69, 32, 32 ) );
   toolButton6->setToggleButton( true );
   toolButton6->setIconSet( QIconSet( QPixmap (( const char** ) polygon_tool_xpm)));
   toolButton6->setUsesBigPixmap( true );
    
   toolButton7 = new QToolButton( buttonGroup1, "toolButton7" );
   toolButton7->setGeometry( QRect( 5, 101, 32, 32 ) );
   toolButton7->setToggleButton( true );
   toolButton7->setIconSet( QIconSet( QPixmap (( const char** ) oval_tool_xpm)));
   toolButton7->setUsesBigPixmap( true );

    toolButton8 = new QToolButton( buttonGroup1, "toolButton8" );
    toolButton8->setGeometry( QRect( 37, 101, 32, 32 ) );
    toolButton8->setToggleButton( true );
    toolButton8->setIconSet( QIconSet( QPixmap (( const char** ) rectangle_tool_xpm)));
    toolButton8->setUsesBigPixmap( true );
      
    toolButton9 = new QToolButton( buttonGroup1, "toolButton9" );
    toolButton9->setGeometry( QRect( 5, 133, 32, 32 ) );
    toolButton9->setToggleButton( true );
    toolButton9->setIconSet( QIconSet( QPixmap (( const char** ) brush_tool_xpm)));
    toolButton9->setUsesBigPixmap( true );
    toolButton9->setUsesTextLabel( false );

    toolButton10= new QToolButton( buttonGroup1, "toolButton10" );
    toolButton10->setGeometry( QRect( 37, 133, 32, 32 ) );
    toolButton10->setToggleButton( true );
    toolButton10->setIconSet( QIconSet( QPixmap (( const char** ) pencil_tool_xpm)));
    toolButton10->setUsesBigPixmap( true );
    
    toolButton11 = new QToolButton( buttonGroup1, "toolButton11" );
    toolButton11->setGeometry( QRect( 5, 165, 32, 32 ) );
    toolButton11->setToggleButton( true );
    toolButton11->setIconSet( QIconSet( QPixmap (( const char** ) ink_bottle_tool_xpm)));
    toolButton11->setUsesBigPixmap( true );
    
    
    toolButton12 = new QToolButton( buttonGroup1, "toolButton12" );
    toolButton12->setGeometry( QRect( 37, 165, 32, 32 ) );
    toolButton12->setToggleButton( true );
    toolButton12->setIconSet( QIconSet( QPixmap (( const char** ) paint_bucket_tool_xpm)));
    toolButton12->setUsesBigPixmap( true );
    
    toolButton13 = new QToolButton( buttonGroup1, "toolButton17" );
    toolButton13->setEnabled( true );
    toolButton13->setGeometry( QRect( 5, 197, 32, 32 ) );
    toolButton13->setToggleButton( true );
    toolButton13->setIconSet( QIconSet( QPixmap (( const char** ) zoom_tool_xpm)));

    toolButton14 = new QToolButton( buttonGroup1, "toolButton14" );
    toolButton14->setEnabled( true );
    toolButton14->setGeometry( QRect( 37, 197, 32, 32 ) );
    toolButton14->setToggleButton( true );
    toolButton14->setIconSet( QIconSet( QPixmap (( const char** ) hand_tool_xpm)));

    toolButton15 = new QToolButton( buttonGroup1, "toolButton15" );
    toolButton15->setGeometry( QRect( 5, 229, 32, 32 ) );
    toolButton15->setToggleButton( true );
    toolButton15->setIconSet( QIconSet( QPixmap (( const char** ) text_box_tool_xpm)));
    toolButton15->setUsesBigPixmap( true );

    toolButton16 = new QToolButton( buttonGroup1, "toolButton16" );
    toolButton16->setGeometry( QRect( 37, 229, 32, 32 ) );
    toolButton16->setIconSet( QIconSet( QPixmap (( const char** ) sprite_tool_xpm)));
    toolButton16->setToggleButton( true );
      
    toolButton17 = new QToolButton( buttonGroup1, "toolButton17" );
    toolButton17->setGeometry( QRect( 5, 261, 32, 32 ) );
    toolButton17->setIconSet( QIconSet( QPixmap (( const char** ) button_tool_xpm)));
    toolButton17->setToggleButton( true );
    
    toolButton18 = new QToolButton( buttonGroup1, "toolButton18" );
    toolButton18->setGeometry( QRect( 37, 261, 32, 32 ) );
    toolButton18->setIconSet( QIconSet( QPixmap (( const char** ) images_tool_xpm)));
    toolButton18->setToggleButton( true );
     
    ASButton = new QToolButton( buttonGroup1, "ASButton" );
    ASButton->setGeometry( 5, 297, 64, 48 );
    ASButton->setText( tr("Launch\nAS Editor"));


    languageChange();
}



Tools::~Tools()
{
}


void Tools::languageChange()
{
    setCaption( tr( "Tools" ) );
  
   // QWhatsThis::add( this, QString::null );
   QToolTip::add( toolButton1, tr( "Move" ) );
   QToolTip::add( toolButton2, tr( "New line" ) );
   QToolTip::add( toolButton3, tr( "Bezier curves" ) + " - " + trUtf8("Not available yet" ));
   toolButton3->setEnabled(FALSE);
   QToolTip::add( toolButton4, tr( "Insert text" ) );
   QToolTip::add( toolButton5, tr( "Remove" ) );
   QToolTip::add( toolButton6, tr( "New polygon" ) );
   QToolTip::add( toolButton7, tr( "New circle" ) );
   QToolTip::add( toolButton8, tr( "New rectangle" ) );
   QToolTip::add( toolButton9, tr( "Paint" ) );
   QToolTip::add( toolButton10, tr( "Draw" ) );
   QToolTip::add( toolButton11, tr( "Change line" ) );
   QToolTip::add( toolButton12, tr( "Change fill" ) );
   QToolTip::add( toolButton13, tr( "Zoom +/-" ) );
   QToolTip::add( toolButton14, tr( "Drag" ) );
   QToolTip::add( toolButton15, tr( "New text field" ) );
   QToolTip::add( toolButton16, tr( "New movie" ) + " - " + trUtf8("Not available yet" ));
   toolButton16->setEnabled(FALSE);
   QToolTip::add( toolButton17, tr( "New button" ) );
   QToolTip::add( toolButton18, tr( "New image" ) );
}



