/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "timetableitem.h"
#include <qpainter.h>


TableItem::TableItem(QTable *parent,EditType et,const QString &text)
:QTableItem(parent,et,text)
{
  ready=effect=effect2=start=end=morphing=choosen=false;
  effectColor = QColor(Qt::white);
  effectColor2 = QColor(Qt::white);

}


void TableItem::paint( QPainter *p, const QColorGroup &cg, const QRect &cr, bool selected )
{
QTableItem::paint(p,cg,cr,selected);
   if(!ready)
   {
      p->setBrush(QColor(235,235,235));
      p->setPen(QColor(190,190,190));
      p->drawRect(-1,-1,table()->columnWidth(0)+1,table()->rowHeight(0)+1);
      p->setPen(QColor(0,0,0));
   }
   if(ready)
   {
      p->setBrush(QColor(255,255,255));
      p->setPen(QColor(190,190,190));
      p->drawRect(-1,-1,table()->columnWidth(0)+1,table()->rowHeight(0)+1);
      p->setPen(QColor(0,0,0));

      if(0)
         p->setBrush(QColor(0,0,0));
      if(start)
         p->drawEllipse (table()->columnWidth(0)-3,table()->rowHeight(0)-5,-5,-5);
      if(choosen) 
         p->setBrush(QColor(255,255,255));
      if(end && !start)
         p->drawRect(table()->columnWidth(0)-3,table()->rowHeight(0)-3,-5,-8);
    }
}
