/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef TIME_TA
#define TIME_TA

#include <qwidget.h>
#include <qtable.h>
#include <qscrollbar.h>

class timeTable : public QTable {
  Q_OBJECT
  
  
public:
 timeTable(int numR,int numC,QWidget *parent = 0,const char *name = 0);


 bool LeftClick;
 int bufferedCol;
 int bufferedRow;
 
 bool cut; //if 0 copy if 1 cut, for slotPasteFrame() 
 
public slots:
  void slotInsertFrame(int layer = -1, int frame = -1);
  void slotForceInsertFrame(int layer = -1, int frame = -1);

  void slotRemoveFrame(int layer = -1, int frame = -1);
  void slotClearFrame(int layer = -1, int frame = -1);
  void slotCopyFrame();
  void slotCutFrame();
  void slotPasteFrame();
  int frameCount();
  
  void insertLayer(int initialFrame = 0);
  void removeLayer(int);
  void clearLayer();
  bool hasAnyFrameBefore(int layer, int frame);
  bool hasAnyFrameAfter(int layer, int frame);
  void updateEffects();
  void addAS();

protected:
  void contentsMousePressEvent( QMouseEvent * );
  void contentsMouseMoveEvent(QMouseEvent *e);
  void viewportPaintEvent ( QPaintEvent * pe );

};

#endif
