/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "timeruler.h"
#include "window.h"
#include "timeline.h"
#include "timetableitem.h"
#include <qpainter.h>
#include <qsize.h>
#include <qpixmap.h>
#include "iostream"
using namespace std;

timeRuler::timeRuler (int, QWidget *parent,const char *name)
   : QWidget (parent,name)
{
   leftClickX=1;
   leftClickY=1;

   currentX=1;
   currentY=1;
} 


void timeRuler::paintEvent( QPaintEvent *)
{
  TimeLine* t = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
  QPainter p(this);
  p.setPen(Qt::black);
  QFont f( "Courier", 8, QFont::Normal );
  p.setFont(f);
  int j=1,i;
  
  for(i=0;i<frames()*9;i=i+8,j++)
  {
     p.drawLine(i,0,i,2);
     p.drawLine(i,height(),i,height()-2);
     if(!(j%5))
     {
       p.setPen(Qt::black);
       p.drawText(i,height()-5,QString::number(j));
     }
  }
  
  t->table->setCurrentCell(leftClickY/20 ,leftClickX/8);
  QBrush brush( QColor(255,153,153), Qt::SolidPattern );//Rectangulo rojo
  p.fillRect((leftClickX/8)*8+1,0,8,height(),brush );
  p.setPen(QColor(204,0,0));
  p.drawRect((leftClickX/8)*8+1,0,8,height());
  
  if (currentX != (int)leftClickX/8 || currentY != (int)leftClickY/20)
  {
    currentX = leftClickX/8 ;
    currentY = leftClickY/20;
    Window* q = (Window*) t->parentWidget()->topLevelWidget();
    q->updateFrame(currentY ,currentX);
    t->list->setSelected(  t->list->itemAt( QPoint(1, leftClickY-t->list->contentsY() ) ) ,1  );

  }


}


void timeRuler::mousePressEvent( QMouseEvent *e)
{
  TimeLine* t = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
  
  int i,j;
  i= (e->pos()).x()-t->table->contentsX();
  j= (e->pos()).y()-t->table->contentsY();
  
  if( !(i>=width()) && !(i<0) )
    leftClickX=i;
  if( !(j>=height()*layers()) && !(j<0) )
    leftClickY=j ;
  
  if (currentX != (int)leftClickX/8 || currentY != (int)leftClickY/20)
  {
    currentX = leftClickX/8 ;
    currentY = leftClickY/20;
    Window* q = (Window*) t->parentWidget()->topLevelWidget();
    q->updateFrame(currentY ,currentX);
    t->list->setSelected(  t->list->itemAt( QPoint(1, leftClickY-t->list->contentsY() ) ) ,1  );
  }

  update();
}

void timeRuler::mouseMoveEvent(QMouseEvent *e)
{
  TimeLine* t = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();

  int i,j;
  i= (e->pos()).x()-t->table->contentsX();
  j= (e->pos()).y()-t->table->contentsY();
  
  if( !(i>=width()) && !(i<0) )
    leftClickX=i;
  if( !(j>=height()*layers()) && !(j<0) )
    leftClickY=j ;

  update();
}
 


int timeRuler::frames()
{
  TimeLine* t = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
  return t->table->numCols();
}

int timeRuler::layers()
{
  TimeLine* t = (TimeLine*) parentWidget()->parentWidget()->parentWidget()->parentWidget();
  return t->table->numRows();
}


