/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <timelist.h>
#include <qheader.h>
#include <qpopupmenu.h>
#include <timeline.h>
#include <window.h>
#include <qlineedit.h>

#include "nameDialog.h"
#include "iostream"
using namespace std;

timeList::timeList( QWidget * parent, const char * name )
: QListView(parent,name)
{
    setHScrollBarMode(QScrollView::AlwaysOff);
    setVScrollBarMode(QScrollView::AlwaysOff);
    header()->setResizeEnabled(false);
    layers = 1;
    setSelectionMode(QListView::Single);

    timeListItem * item = new timeListItem( this, tr("Layer") + "001" );
    insertItem(item);
    setSelected(  itemAt( QPoint(1,1 )   )  ,1 );
    
    setSortOrder(Qt::Descending );
    header()->hide();
    setStaticBackground( 0 );
}


void timeList::contentsMousePressEvent(QMouseEvent *e)
{
  int x, y;
  x = (mapToGlobal (e->pos())).x()-contentsX();
  y = (mapToGlobal (e->pos())).y()-contentsY();
  
  int i, j;
  i= (e->pos()).x()-contentsX();
  j= (e->pos()).y()-contentsY();
  setSelected( itemAt( QPoint(i,j) ), 1 );
  if (e->button() == RightButton)
  {

    QPopupMenu* frame = new QPopupMenu (this);
    frame->insertItem (tr("Insert layer"),  this, SLOT(insertLayer()));
    frame->insertItem (tr("Remove layer"),  this, SLOT(removeLayer()));
    //frame->insertItem (tr("Clear capa"),   this, SLOT(clearLayer()));
    //frame->insertSeparator();

    //NOT SUPPORTED
    
    //frame->insertItem (tr("Cut"));
    //frame->insertItem (tr("Copy"));
    //frame->insertItem (tr("Paste"));
    //frame->insertSeparator();
    //frame->insertItem (tr("Properties"));
    frame->popup (QPoint(x,y));
    frame->exec ();
    frame->~QPopupMenu() ;
  }
  TimeLine* tl = (TimeLine*) parent(); timeTable* t = tl->table;
  int index = e->pos().y()/20;
  if (t->numRows() > index)
    {
      t->setCurrentCell( index, t->currentColumn());
      Window* w = (Window*) tl->parent()->parent()->parent();
      w->updateFrame(index, t->currentColumn());
    }

}


/*void timeList::nameChange()
{
  QString tmpString;
  nameDialog *dlg = new nameDialog( selectedItem()->text(0) );
  if ( dlg->exec() == QDialog::Accepted ) 
  {
     selectedItem()->setText(0, dlg->nameLine->text() );
  }

 delete dlg;
}*/


void timeList::insertLayer(int initialFrame)
{
  if (childCount() < 999 ) //max number of layers / numero maximo de capas 
  {
    TimeLine* tl = (TimeLine*) parent(); timeTable* t = tl->table;
    t->insertLayer(initialFrame);
    layers++;
    QString temporal;
    temporal = "";
    if (layers<100) temporal = "0";
    if (layers<10) temporal = "00";
    timeListItem* i = new timeListItem(this, tr("Layer")+ temporal + QString::number(layers) );
    insertItem(i);
    setCurrentItem(i);
    Window* w = (Window*) tl->parent()->parent()->parent();
    w->insertLayer();
    if (initialFrame != -1)
      w->updateFrame(0, initialFrame);
  } 
  setContentsPos(0,0);
}

void timeList::removeLayer(int index)
{
   if (index == -1) 
     index = selectedItem()->itemPos()/20; 
     
     
   if (isSelected(selectedItem()) && childCount()>1)
   {
     TimeLine* tl = (TimeLine*) parent();

     Window* w = (Window*) tl->parent()->parent()->parent();
     w->removeLayer(index);
     removeItem(selectedItem());
     timeTable* t = tl->table;
     t->removeLayer(index);
   }
   setSelected(  itemAt(QPoint(1,1) )  , 1    );
}

void timeList::clearLayer()
{
}

void timeList::viewportPaintEvent (  QPaintEvent * pe  )
{
  QScrollView::viewportPaintEvent ( pe );
  TimeLine* tl = (TimeLine*) parent();
  tl->tvs->somethingChanged(contentsY(), contentsHeight());
}


/*void timeList::updateFromEditor(int index)
{
  int j;
  j= 20*(childCount()-1-index)-contentsY();
  setSelected( itemAt( QPoint(2,j+5) ), 1 );
}
*/

//timeListItem


timeListItem::timeListItem( QListView * parent, const char * caption ): QListViewItem(parent, caption )
{
  setHeight ( height() +2);
}


void timeListItem::setHHeight(int hheight )
{
  setHeight ( hheight );
}




