/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "timeline.h"
#include "timescroll.h"
#include <qheader.h>
#include <qlistview.h>
#include <qtable.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include "window.h"

#include "iostream"
using namespace std;


TimeLine::TimeLine( QWidget* parent, const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{

   Window* q = (Window*) parentWidget()->topLevelWidget();
   frames = q->frames;
   tmpF = frames;
   
   list = new timeList( this, "list" );
   list->addColumn( tr( "Layer" ) );
   list->setGeometry( 2, 25, 100, 90 );
   
   scroll = new QScrollView(this, "scroll");
   scroll->setGeometry( 105, 3, 660, 130);

   layout = new QWidget();

   int s = tmpF*8;
   if (s<1200) s = 1200;
      ruler = new timeRuler( frames, layout, "ruler" );
   
   ruler->setGeometry( 0, 0, s, 20);

   table = new timeTable( 1, frames, layout, "table" );
   table->setGeometry( 0, 20, s, 90);
   
   layout->setGeometry( 0, 0, s, 110);
   scroll->addChild(layout);
   scroll->setVScrollBarMode(QScrollView::AlwaysOff);

   tvs = new timeVerticalScroll( 0, 50, this);
   tvs->setGeometry(width()-30, 3, 18, 112 );
   languageChange();
    
   connect( tvs, SIGNAL(valueChanged(int)),tvs, SLOT(updateListAndTable()));
   
}


TimeLine::~TimeLine()
{
}


void TimeLine::languageChange()
{
    setCaption( tr( "Time line" ) );
    list->header()->setLabel( 0, tr( "Layers" ) );
}





