/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "textitem.h"
#include "editor.h"
#include "window.h"



CanvasTextItem::CanvasTextItem(const QString str, QCanvas* canvas): QCanvasText(str, canvas)
{
  name = "";
  effect = 0;
  grouped = 0;
  button = 0;
  selectable = 0;
}

CanvasTextItem::CanvasTextItem( CanvasTextItem* tempItem, QCanvas* canvas): QCanvasText(tempItem->text(), canvas)
{
  move(tempItem->x(), tempItem->y());
  setFont(tempItem->font());
  setColor(tempItem->color());
  setZ(tempItem->z());
  show();
  effect = 0;
  grouped = 0;
  button = 0;
  name = "";
  selectable = tempItem->selectable;
}

QString CanvasTextItem::xml()
{
  QString s;
  s = "<item class=\"TextItem\" name=\""+name+"\" text=\"" +text()+ "\" x=\"" + QString::number( x() ) + "\" y=\"" + QString::number( y() ) + "\" z=\"" + QString::number( z() ) + "\" font=\"" + font().family() + "\" width=\"" + QString::number( boundingRect().width() ) + "\" height=\"" + QString::number( boundingRect().height() ) + "\" select=\""+QString::number(selectable)+"\" size=\"" + QString::number( font().pointSize() ) + "\" color=\"" + color().name()+ "\" layer=\""+ QString::number( (int) (z()/3000) )+"\" />";
  return s;
}

