/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TBOX_H
#define TBOX_H


#include <qtextedit.h> 
#include <qcanvas.h> 
#include <qfont.h> 

class NodeItem;
class TextBoxText;
class TextBoxBack;

class itemGroup;

class TextBox: QObject
{
public:
  TextBox (QCanvas*, QString, QFont);
  TextBox (TextBox*, QCanvas*);
  TextBoxBack* boxBack;
  TextBoxText* boxText;
  QString xml();
  NodeItem* node;
  QString name;
  bool editable;
  bool selectable;
  bool password;
  bool multiline;
  void setX(int);
  void setY(int);
  void setZ(int);
  void updateSizes();
  void moveBy(double, double);

};


class TextBoxText : public QCanvasText 
{
public:
   TextBoxText(QCanvas*);
   TextBox* box;
   int rtti () const { return 100;}
   itemGroup* group;
   int grouped;
protected:

};




class TextBoxBack : public QCanvasRectangle
{

public:
  TextBoxBack (QCanvas*);
  TextBox* box;
  int rtti () const { return 101;}
  itemGroup* group;
  int grouped;
  void showNodes();
  void resizeTo(double, double);
};


//void swftextfield->setbounds ( int width, int height )
// http://ming.sourceforge.net/docs/swftextfield.php?mode=cpp


#endif
