/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

 
#include "textbox.h"
#include "items.h"
#include "iostream"

using namespace std;

// class NodeItem;
 
TextBoxText::TextBoxText(QCanvas* canvas): QCanvasText(canvas)
{
}

 
TextBoxBack::TextBoxBack(QCanvas* canvas): QCanvasRectangle(canvas)
{
}

void TextBoxBack::showNodes()
{
  box->node = new NodeItem(x()+width(), y()+height(), canvas());
  return;
}

void TextBoxBack::resizeTo(double w, double h)
{
  int x=20,y=20;

  if (w > 20) x=(int)w;
  if (h > 20) y=(int)h;

  setSize(x,y);
}

TextBox::TextBox(QCanvas* canvas, QString string, QFont f)
{

  boxBack = new TextBoxBack(canvas);
  boxText = new TextBoxText(canvas);
  boxText->setFont(f);
  boxText->setText(string);
  boxText->box = this;
  boxText->show();

  boxBack->setPen(QColor(Qt::black));
  boxBack->setBrush(QColor(Qt::white));

  boxBack->box = this;
  boxBack->show();

  boxText->grouped = 0;
  boxBack->grouped = 0;
  boxBack->group = NULL;
  boxText->group = NULL;

  name = "";
  updateSizes();
}


TextBox::TextBox(TextBox* tboxTemp, QCanvas* canvas)
{
  TextBoxText* textTemp = tboxTemp->boxText;
  TextBoxBack* backTemp = tboxTemp->boxBack;

  boxBack = new TextBoxBack(canvas);
  boxText = new TextBoxText(canvas);
  boxText->setFont(textTemp->font());
  boxText->setText(textTemp->text());
  boxText->box = this;
  boxText->show();

  boxBack->setPen(backTemp->pen());
  boxBack->setBrush(backTemp->brush());
  boxBack->setSize(backTemp->width(), backTemp->height() );
  boxBack->box = this;
  boxBack->show();

  boxText->grouped = 0;
  boxBack->grouped = 0;
  boxBack->group = NULL;
  boxText->group = NULL;


  editable = tboxTemp->editable;
  selectable = tboxTemp->selectable;
  password = tboxTemp->password;
  multiline = tboxTemp->multiline;
  setX((int)backTemp->x());
  setY((int)backTemp->y());
  setZ((int)backTemp->z());

  QCanvasText* tempTextItem = (QCanvasText*) boxText;
  tempTextItem->setColor(textTemp->color());

  name = "";
  updateSizes();

}











QString TextBox::xml()
{
  QString s;
  s = "<item class=\"TextBox\" name=\""+name+"\" text=\"" +boxText->text()+ "\" x=\"" + QString::number( boxBack->x() ) + "\" y=\"" + QString::number( boxBack->y() ) + "\" z=\"" + QString::number( boxBack->z() ) + "\" font=\"" + boxText->font().family() + "\" size=\"" + QString::number( boxText-> font().pointSize() ) + "\" textcolor=\"" + boxText->color().name()+ "\" layer=\""+ QString::number( (int) (boxBack->z()/3000) )+"\" backcolor=\"" + boxBack->brush().color().name() + "\" width=\"" + QString::number( boxBack->width() ) +  "\" height=\"" + QString::number( boxBack->height() ) + "\" edit=\""+QString::number(editable)+"\" select=\""+QString::number(selectable)+"\" pass=\""+QString::number(password)+"\" multi=\""+QString::number(multiline)+"\"/>";
  return s;
}

void TextBox::setX(int x)
{
  boxBack->setX(x);
  boxText->setX(x+5);
}

void TextBox::setY(int y)
{
  boxBack->setY(y);
  boxText->setY(y+2);
}

void TextBox::setZ(int z)
{
  boxBack->setZ(z);
  boxText->setZ(z + 2);
}

void TextBox::updateSizes()
{
  int x = boxText->boundingRect().width() + 10;
  if (boxBack->width() > x) x = boxBack->width();
  int y = boxText->boundingRect().height()+1;
  if (boxBack->height() > y) y = boxBack->height();

  boxBack->setSize( x , y );
}

void TextBox::moveBy(double dx, double dy)
{
  boxText->moveBy(dx,dy);
  boxBack->moveBy(dx, dy);
}

