/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "regular.h"
#include "items.h"
#include "qpainter.h"

#include <math.h>
#include <iostream>
using namespace std;


Regular::Regular(QCanvas * canvas):QCanvasPolygonalItem(canvas)
{
  name = "";
  view = 1;
  effect = 0;
  grouped = 0;
  button = 0;
}

Regular::Regular(Regular* tempItem, QCanvas * canvas):QCanvasPolygonalItem(canvas)
{
  name = "";
  view = 1;
  setPen ( tempItem->pen() );
  setBrush ( tempItem->brush() );  
  p = tempItem->p ;
  ri =  tempItem->ri ;
  re =  tempItem->re ;
  di =  tempItem->di ;
  de = tempItem->de ; 
  star =  tempItem->star ;
  setX( tempItem->x() );
  setY( tempItem->y() );
  setZ( tempItem->z() );
  show();
  effect = 0;
  grouped = 0;
  button = 0;
}

Regular::~Regular()
{
}

QPointArray Regular::areaPoints() const
{
  QPointArray tempa;
  if(star)
  {
    tempa = QPointArray( p*2 );
    QPointArray tempInt = tempPoints(ri, di+(180/p));
    QPointArray tempExt = tempPoints(re, de);
    for (int i=0; i<(int)tempInt.count(); i++)
      tempa.setPoint(i*2+1, tempInt.at(i).x(), tempInt.at(i).y()  ); 
    for (int i=0; i<(int)tempExt.count(); i++)
      tempa.setPoint(i*2,tempExt.at(i).x(), tempExt.at(i).y()  ); 
  }
  else
  {
    tempa = QPointArray( p );
    tempa = tempPoints(re, de);
  }
return tempa;
}



QPointArray Regular::tempPoints(int radio, int desp) const
{
  QPointArray tempa = QPointArray( p );
  double angle;
  for (int i=0; i<p; i++)
  {
    angle = (double) (i+1)*360/p + desp;
    angle = angle/180*3.1416;
    tempa.setPoint(i, (int) (x()+radio*cos(angle)), (int) (y()+radio*sin(angle))  );  
  }
return tempa;
}


void Regular::drawShape ( QPainter & paint )
{
  if (view)
  paint.drawPolygon( areaPoints() );
}

QString Regular::xml()
{
  QString s;
  s = "<item name=\""+name+"\" class=\"Regular\" x=\"" + QString::number( x() ) + "\" y=\"" + QString::number( y() ) + "\" z=\"" + QString::number( z() ) +"\" p=\"" + QString::number( p ) + "\" di=\"" + QString::number( di ) +  "\" de=\"" + QString::number( de ) + "\" ri=\"" + QString::number( ri ) +  "\" re=\"" + QString::number( re ) + "\" border=\"" + pen().color().name() +  "\" color=\"" + brush().color().name() + "\" star=\"" + QString::number( star ) + "\" layer=\""+ QString::number((int) (z()/3000))+"\" />";
  return s;
}

void Regular::showNodes()
{
  NodeItem* nodes;
  if (!star)
  {
    double angle = ((double) de) /180*3.14159;
    nodes = new NodeItem(x()+re*cos(angle), y()+re*sin(angle), canvas());
    nodes->nodeRtti = 0;
  }
  if (star)
  {
    double angle = ((double) de)/180*3.14159;
    nodes = new NodeItem(x()+re*cos(angle), y()+re*sin(angle), canvas());
    nodes->nodeRtti = 0;
    
    angle = 360/p-di*2;
    angle = angle/360*3.1416;
    nodes = new NodeItem(x()+(ri*cos( angle )), y()-(ri*sin( angle )), canvas());
    nodes->nodeRtti = 1;
  }
  return;
}

void Regular::moveBy(double dx, double dy)
{
 QCanvasPolygonalItem::moveBy(dx,dy);
 canvas()->setAllChanged ();
 canvas()->update();
}


