/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef PROP_H
#define PROP_H
 
 #include <qwidget.h>
 #include <qbuttongroup.h>
 #include <qcombobox.h>
 #include <qtoolbutton.h>
 #include <qspinbox.h>
 #include <qcheckbox.h> 
 #include <qslider.h>
 #include <qpushbutton.h>
 #include <qtextedit.h>
 #include <qlabel.h>
 #include <qcanvas.h>
 #include <button.h>

//  class buttonCanvas;

class Properties : public QWidget
{
     Q_OBJECT


public:
     Properties( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
     QButtonGroup* buttonGroup1;
     QButtonGroup* buttonGroup2;
     QButtonGroup* buttonGroup3;
     QButtonGroup* buttonGroup4;
     QButtonGroup* buttonGroup5;
     QButtonGroup* buttonGroup6;
     QButtonGroup* buttonGroup7;
     QButtonGroup* buttonGroup8;
     QButtonGroup* buttonGroup9;
     QButtonGroup* buttonGroup10;
     QButtonGroup* buttonGroup11;
     QButtonGroup* buttonGroup12;
     QButtonGroup* buttonGroup13;
     QButtonGroup* buttonGroup14;
     QButtonGroup* buttonGroup15;
     QButtonGroup* buttonGroup16;
     QButtonGroup* buttonGroup17;
     QButtonGroup* buttonGroup18;

     QPushButton* toolButtonRegular;
     QPushButton* toolButtonStar;

     QSpinBox* spinP;

     QSlider* DI;

     QSpinBox* spinW;

     QSpinBox* spinDI;
     QSpinBox* spinDE;

     QSpinBox* imageX;
     QSpinBox* imageY;
     QCheckBox* imagePos;
     QSpinBox* imageW;
     QSpinBox* imageH;
     QComboBox* textFamily;
     QComboBox* textSize;
     QPushButton* newFont;
     QTextEdit* textEd;

     QCheckBox* checkEdit;
     QCheckBox* checkSelect;
     QCheckBox* checkPass;
     QCheckBox* checkMulti;

     QLabel* lab1;
     QLabel* lab2;
     QLabel* lab3;
     QLabel* lab4;

     QPushButton* buttonUp;
     QPushButton* buttonOver;
     QPushButton* buttonDown;
     QPushButton* buttonCancel;
     QPushButton* buttonBack;
     QPushButton* buttonAS;

     QPushButton* copy1;
     QPushButton* paste1;
     QPushButton* copy2;
     QPushButton* paste2;
     QPushButton* copy3;
     QPushButton* paste3;

     buttonCanvas* buffered;

     QCanvasItem* tmpButton;
     buttonASActions tmpAS;

public slots:

     void setTool(int tool = 0);
     void updateFont();
     void updateTextColor();
     void updateText();

     void updateTBoxProp();
     void setTBoxPropFromEditor();

     void setTextFromEditor();
     int TxtSize();
     void addFont();
     void buttonBackClicked();
     void buttonUpClicked();
     void buttonOverClicked();
     void buttonDownClicked();
     void buttonCancelClicked();
     void buttonASClicked();
     void setPolygonMessage();
     void setButtonMessage();

     void slotCopy1();
     void slotPaste1();
     void slotCopy2();
     void slotPaste2();
     void slotCopy3();
     void slotPaste3();

     void copiable(bool);
};


#endif
