/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "properties.h"
#include "window.h"
#include "qpushbutton.h"
#include "colors.h"
#include "qmessagebox.h"

#include "qfontdatabase.h"
#include "qcheckbox.h"
#include "qlabel.h"
#include "fontDialog.h"
#include "qdir.h"
#include "asDialog.h"
#include "textbox.h"

#include <iostream>
using namespace std;

Properties::Properties( QWidget* parent, const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
  Window* q = (Window*) parentWidget()->topLevelWidget();

  buttonGroup1 = new QButtonGroup(this, "buttonGroup1");
  buttonGroup1->setFrameShape(QFrame::NoFrame);
  buttonGroup1->setTitle( trUtf8( "Selection" ) );
  buttonGroup1->setGeometry(10,10,500,200);
  buttonGroup1->show();

  buttonGroup2 = new QButtonGroup(this, "buttonGroup2");
  buttonGroup2->setFrameShape(QFrame::NoFrame);
  buttonGroup2->setTitle( trUtf8( "Line") );
  buttonGroup2->setGeometry(10,10,800,70);
  buttonGroup2->show();

  buttonGroup3 = new QButtonGroup(this, "buttonGroup3");
  buttonGroup3->setFrameShape(QFrame::NoFrame);
  buttonGroup3->setTitle( trUtf8( "Bezier curves" ) );
  buttonGroup3->setGeometry(10,10,800,70);
  buttonGroup3->show();



//TEXT////////////////////////////////////////////////////////////////////////////////////////


  buttonGroup4 = new QButtonGroup(this, "buttonGroup4");
  buttonGroup4->setFrameShape(QFrame::NoFrame);
  buttonGroup4->setTitle( trUtf8( "Text" ) );
  buttonGroup4->setGeometry(10,10,800,100);
  buttonGroup4->show();

  textFamily = new QComboBox( buttonGroup4, "textFamily");
  textFamily->setGeometry(20,20,170,30);
  QFontDatabase fdb;
  QStringList fontlist = fdb.families();
  QDir qf;
  qf = qf.home().absPath() + "/.qflash";
  
  if (access ( qf.absPath()+"/fonts", F_OK ))
    system("mkdir "+qf.absPath()+"/fonts");
  
  textFamily->insertItem( "default" );
  for ( QStringList::Iterator it = fontlist.begin(); it != fontlist.end(); ++it )
  {
     if ((!access ( "/usr/share/libming/fonts/"+*it+".fdb", F_OK )) || ( !access ( qf.absPath()+"/fonts/"+*it+ ".fdb", F_OK ) ) )
       textFamily->insertItem(  *it );
  }
  textSize = new QComboBox( buttonGroup4, "textSize");
  textSize->setGeometry(200,20,60,30);
  updateFont();
  
  newFont = new QPushButton( trUtf8("Add font"), buttonGroup4, "toolButtonR" );
  newFont->setGeometry(20,55,115,30);

  textEd = new QTextEdit(buttonGroup4, "textEd");
  textEd->setText(trUtf8("Hello world!"));
  textEd->setGeometry(280,10,280,70);  
  textEd->setVScrollBarMode(QScrollView::AlwaysOn );
  textEd->show();
  
  
//this commented lines will support bold, italics and underlined fonts

/*
QCheckBox* text1 = new QCheckBox("Negrita", buttonGroup4, "text1");
text1->setGeometry(270,20,90,30);
QCheckBox* text2 = new QCheckBox("Cursiva", buttonGroup4, "text2");
text2->setGeometry(270,50,90,30);
QCheckBox* text3 = new QCheckBox("Tachado", buttonGroup4, "text3");
text3->setGeometry(350,20,90,30);
QCheckBox* text4 = new QCheckBox("Subrayado", buttonGroup4, "text4");
text4->setGeometry(350,50,90,30);
*/


  connect( textFamily, SIGNAL(activated(int)),this,SLOT(updateFont()));
  connect( newFont, SIGNAL(clicked()),this,SLOT(addFont()));
  
  connect( textFamily, SIGNAL(activated(int)),this,SLOT(updateText()));
  connect( textSize, SIGNAL(activated(int)),this,SLOT(updateText()));
  connect( textEd, SIGNAL(textChanged()),this,SLOT(updateText()));
  connect( (Colors*) q->colors, SIGNAL(colorChanged()),this,SLOT(updateTextColor()));
 



//RUBBER//////////////////////////////////////////////////////////////////////////////////////

  buttonGroup5 = new QButtonGroup(this, "buttonGroup5");
  buttonGroup5->setFrameShape(QFrame::NoFrame);
  buttonGroup5->setTitle( trUtf8( "Remove" ) );
  buttonGroup5->setGeometry(10,10,800,70);
  buttonGroup5->show();

//POLYGONS//////////////////////////////////////////////////////////////////////////////////

  buttonGroup6 = new QButtonGroup(this, "buttonGroup6");
  buttonGroup6->setFrameShape(QFrame::NoFrame);
  buttonGroup6->setTitle( trUtf8( "Polygons" ) );
  buttonGroup6->setGeometry(10,10,800,90);
  buttonGroup6->show();

  toolButtonRegular = new QPushButton( buttonGroup6, "toolButtonRegular" );
  toolButtonRegular->setGeometry( QRect( 100, 5, 140, 31 ) );
  toolButtonRegular->setToggleButton( true );
  toolButtonRegular->setText( trUtf8( "Regular polygon" ) );

  toolButtonStar = new QPushButton( buttonGroup6, "toolButtonStar" );
  toolButtonStar->setGeometry( QRect( 100, 40, 140, 31 ) );
  toolButtonStar->setToggleButton( true );
  toolButtonStar->setText( trUtf8( "Star") );
 
  QLabel* labV= new QLabel(trUtf8("Edges"), buttonGroup6, "labW");
  labV->setGeometry( QRect( 270, 20, 120, 20));

  spinP = new QSpinBox(3,8000,1,buttonGroup6, "spinP");
  spinP->setGeometry( QRect( 270, 50, 50, 20 ) );
  spinP->setValue(5);

  connect( toolButtonRegular, SIGNAL(released()),this,SLOT(setPolygonMessage()));
  connect( toolButtonStar, SIGNAL(released()),this,SLOT(setPolygonMessage()));


//CIRCLE///////////////////////////////////////////////////////////////////////////////////////////

  buttonGroup7 = new QButtonGroup(this, "buttonGroup7");
  buttonGroup7->setFrameShape(QFrame::NoFrame);
  buttonGroup7->setTitle( trUtf8( "Circle" ) );
  buttonGroup7->setGeometry(10,10,800,70);
  buttonGroup7->show();

  buttonGroup8 = new QButtonGroup(this, "buttonGroup8");
  buttonGroup8->setFrameShape(QFrame::NoFrame);
  buttonGroup8->setTitle( trUtf8( "Rectangle" ) );
  buttonGroup8->setGeometry(10,10,800,70);
  buttonGroup8->show();

//BRUSH/////////////////////////////////////////////////////////////////////////////////////


  buttonGroup9 = new QButtonGroup(this, "buttonGroup9");
  buttonGroup9->setFrameShape(QFrame::NoFrame);
  buttonGroup9->setTitle( trUtf8( "Brush" ) );
  buttonGroup9->setGeometry(10,10,800,70);
  buttonGroup9->show();
  spinW = new QSpinBox(1,8000,1,buttonGroup9, "spinW");
  spinW->setGeometry( QRect( 110, 20, 50, 20 ) );
  QLabel* labW= new QLabel(trUtf8("Line width"), buttonGroup9, "labW");
  labW->setGeometry( QRect( 165, 20, 120, 20 ) );
  spinW->setValue(10);

//PENCIL//////////////////////////////////////////////////////////////////////////////

  buttonGroup10 = new QButtonGroup(this, "buttonGroup10");
  buttonGroup10->setFrameShape(QFrame::NoFrame);
  buttonGroup10->setTitle( trUtf8( "Pencil" ) );
  buttonGroup10->setGeometry(10,10,800,70);
  buttonGroup10->show();
  
  buttonGroup11 = new QButtonGroup(this, "buttonGroup11");
  buttonGroup11->setFrameShape(QFrame::NoFrame);
  buttonGroup11->setTitle( trUtf8( "Outline" ) );
  buttonGroup11->setGeometry(10,10,800,70);
  buttonGroup11->show();

  buttonGroup12 = new QButtonGroup(this, "buttonGroup12");
  buttonGroup12->setFrameShape(QFrame::NoFrame);
  buttonGroup12->setTitle( trUtf8( "Fill" ) );
  buttonGroup12->setGeometry(10,10,800,70);
  buttonGroup12->show();

  buttonGroup13 = new QButtonGroup(this, "buttonGroup13");
  buttonGroup13->setFrameShape(QFrame::NoFrame);
  buttonGroup13->setTitle( trUtf8( "Zoom" ) );
  buttonGroup13->setGeometry(10,10,800,70);
  buttonGroup13->show();

  buttonGroup14 = new QButtonGroup(this, "buttonGroup14");
  buttonGroup14->setFrameShape(QFrame::NoFrame);
  buttonGroup14->setTitle( trUtf8( "Move" ) );
  buttonGroup14->setGeometry(10,10,800,70);
  buttonGroup14->show();

//TEXTBOX//////////////////////////////////////////////////////////////////////////////////////

//  textEd->setGeometry(280,10,300,70);       IT IS NOT NEEDED BECAUSE IT IS THE SAME GROUP AS IN TEXT
  /*
  buttonGroup15 = new QButtonGroup(this, "buttonGroup15");
  buttonGroup15->setFrameShape(QFrame::NoFrame);
  buttonGroup15->setTitle( trUtf8( "Text Box") );
  buttonGroup15->setGeometry(10,10,800,70);
  buttonGroup15->show();
  */

  checkSelect = new QCheckBox( buttonGroup4, "checkSelect" );
  checkEdit = new QCheckBox( buttonGroup4, "checkEdit" );
  checkPass = new QCheckBox( buttonGroup4, "checkPass" );
  checkMulti = new QCheckBox( buttonGroup4, "checkMulti" );

  checkEdit->setGeometry(570,35,20,20);
  checkSelect->setGeometry(570,10,20,20);
  checkPass->setGeometry(570,60,20,20);
  checkMulti->setGeometry(675,10,20,20);

  checkEdit->setChecked(1);
  checkSelect->setChecked(1);
  checkPass->setChecked(0);
  checkMulti->setChecked(0);

  lab1 = new QLabel(trUtf8("Selectable"), buttonGroup4, "lab1" );
  lab1->setGeometry(590,10,85,20);
  lab1->show();
  lab2 = new QLabel(trUtf8("Editable"), buttonGroup4, "lab2" );
  lab2->setGeometry(590,35,85,20);
  lab3 = new QLabel(trUtf8("Password"), buttonGroup4, "lab2");
  lab3->setGeometry(590,60,85,20);
  lab4 = new QLabel(trUtf8("MultiLine"), buttonGroup4, "lab4");
  lab4->setGeometry(695,10,85,20);
  
  connect( checkEdit, SIGNAL(released()),this,SLOT(updateTBoxProp()));
  connect( checkPass, SIGNAL(released()),this,SLOT(updateTBoxProp()));
  connect( checkMulti, SIGNAL(released()),this,SLOT(updateTBoxProp()));
  connect( checkSelect, SIGNAL(released()),this,SLOT(updateTBoxProp()));
  
//MOVIE//////////////////////////////////////////////////////////////////////////////////////
  buttonGroup16 = new QButtonGroup(this, "buttonGroup16");
  buttonGroup16->setFrameShape(QFrame::NoFrame);
  buttonGroup16->setTitle( trUtf8( "Movie" ) );
  buttonGroup16->setGeometry(10,10,800,70);
  buttonGroup16->show();
  

  
//BUTTON/////////////////////////////////////////////////////////////////////////////

  buttonGroup17 = new QButtonGroup(this, "buttonGroup17");
  buttonGroup17->setFrameShape(QFrame::NoFrame);
  buttonGroup17->setTitle( trUtf8( "New button" ) );
  buttonGroup17->setGeometry(10,10,800,100);
  buttonGroup17->show();

  buttonUp = new QPushButton( trUtf8("Up"), buttonGroup17, "buttonUp" );
  buttonUp->setGeometry(80,15,115,20);
  buttonOver = new QPushButton( trUtf8("Over"), buttonGroup17, "buttonOver" );
  buttonOver->setGeometry(205,15,115,20);
  buttonDown = new QPushButton( trUtf8("Down"), buttonGroup17, "buttonDown" );
  buttonDown->setGeometry(330,15,115,20);
  
  
  copy1 = new QPushButton( trUtf8("copy"), buttonGroup17, "copy1");
  copy1->setGeometry(80,40,115,20);

  paste1 = new QPushButton( trUtf8("paste"), buttonGroup17, "paste1");
  paste1->setGeometry(80,65,115,20);
  
  copy2 = new QPushButton( trUtf8("copy"), buttonGroup17, "copy2");
  copy2->setGeometry(205,40,115,20);

  paste2 = new QPushButton( trUtf8("paste"), buttonGroup17, "paste2");
  paste2->setGeometry(205,65,115,20);
  
  copy3 = new QPushButton( trUtf8("copy"), buttonGroup17, "copy3");
  copy3->setGeometry(330,40,115,20);

  paste3 = new QPushButton( trUtf8("paste"), buttonGroup17, "paste3");
  paste3->setGeometry(330,65,115,20);



  buttonBack = new QPushButton( trUtf8("Save button and go back"), buttonGroup17, "buttonBack" );
  buttonBack->setGeometry(510,15,245,20);

  buttonCancel = new QPushButton( trUtf8("Go back without saving"), buttonGroup17, "buttonBack" );
  buttonCancel->setGeometry(510,40,245,20);

  buttonAS = new QPushButton( trUtf8("Add ActionScript"), buttonGroup17, "buttonAS" );
  buttonAS->setGeometry(510,65,245,20); 

  buttonUp->setEnabled(0);
  buttonOver->setEnabled(0);
  buttonDown->setEnabled(0);
  buttonBack->setEnabled(0);
  buttonCancel->setEnabled(0);
  buttonAS->setEnabled(0);

  paste1->setEnabled(0);
  paste2->setEnabled(0);
  paste3->setEnabled(0);
  copiable(0);
  
  connect( buttonCancel, SIGNAL(released()),this,SLOT(buttonCancelClicked()));
  connect( buttonBack, SIGNAL(released()),this,SLOT(buttonBackClicked()));
  connect( buttonAS, SIGNAL(released()),this,SLOT(buttonASClicked()));

  connect( buttonUp, SIGNAL(released()),this,SLOT(buttonUpClicked()));
  connect( buttonOver, SIGNAL(released()),this,SLOT(buttonOverClicked()));
  connect( buttonDown, SIGNAL(released()),this,SLOT(buttonDownClicked()));
  
  connect( copy1, SIGNAL(released()),this,SLOT(slotCopy1()));
  connect( copy2, SIGNAL(released()),this,SLOT(slotCopy2()));
  connect( copy3, SIGNAL(released()),this,SLOT(slotCopy3()));

  connect( paste1, SIGNAL(released()),this,SLOT(slotPaste1()));
  connect( paste2, SIGNAL(released()),this,SLOT(slotPaste2()));
  connect( paste3, SIGNAL(released()),this,SLOT(slotPaste3()));

//IMAGE////////////////////////////////////////////////////////////////////

  buttonGroup18 = new QButtonGroup(this, "buttonGroup18");
  buttonGroup18->setFrameShape(QFrame::NoFrame);
  buttonGroup18->setTitle( trUtf8( "Image" ) );
  buttonGroup18->setGeometry(10,10,800,70);
  buttonGroup18->show();

  imagePos = new QCheckBox(buttonGroup18, "imagePos");
  imagePos->setGeometry( QRect( 20, 20, 20, 20 ) );
  QLabel* labA= new QLabel(trUtf8("Defined position"), buttonGroup18, "labA");
  labA->setGeometry( QRect( 45, 20, 120, 20 ) );
  imagePos->setChecked(false);

  QLabel* labG= new QLabel(trUtf8("SVG image:"), buttonGroup18, "labG");
  labG->setGeometry( QRect( 345, 20, 120, 20 ) );

  imageX = new QSpinBox( -8000,20000,1,buttonGroup18, "imageX");
  imageX->setGeometry( QRect( 220, 20, 70, 20 ) );
  QLabel* labX= new QLabel("X:", buttonGroup18, "labX");
  labX->setGeometry( QRect( 185, 20, 30, 20 ) );
  imageX->setValue(0);

  imageY = new QSpinBox(-8000,20000,1,buttonGroup18, "imageY");
  imageY->setGeometry( QRect( 220, 50, 70, 20 ) );
  QLabel* labY= new QLabel("Y:", buttonGroup18, "labY");
  labY->setGeometry( QRect( 185, 50, 30, 20 ) );
  imageY->setValue(0);

  imageW = new QSpinBox( 0,20000,1,buttonGroup18, "imageW");
  imageW->setGeometry( QRect( 540, 20, 70, 20 ) );
  QLabel* labSW= new QLabel(trUtf8("Width:"), buttonGroup18, "labSW");
  labSW->setGeometry( QRect( 465, 20, 70, 20 ) );
  imageW->setValue(500);

  imageH = new QSpinBox ( 0,20000,1,buttonGroup18, "imageH");
  imageH->setGeometry( QRect( 540, 50, 70, 20 ) );
  QLabel* labH= new QLabel(trUtf8("Height:"), buttonGroup18, "labH");
  labH->setGeometry( QRect( 465, 50, 70, 20 ) );
  imageH->setValue(400);

}

void Properties::setTool(int tool)
{
  Window* q = (Window*) parentWidget()->topLevelWidget();
  buttonGroup1->hide();
  buttonGroup2->hide();
  buttonGroup3->hide();
  buttonGroup4->hide();
  buttonGroup5->hide();
  buttonGroup6->hide();
  buttonGroup7->hide();
  buttonGroup8->hide(); 
  buttonGroup9->hide();
  buttonGroup10->hide();
  buttonGroup11->hide();
  buttonGroup12->hide();
  buttonGroup13->hide();
  buttonGroup14->hide();
  //buttonGroup15->hide();
  buttonGroup16->hide();
  buttonGroup17->hide();
  buttonGroup18->hide();
  if ( tool == 4 || tool == 15 )
  {
    buttonGroup4->show();

    if (tool == 4)
    {
      checkEdit->hide();
      checkPass->hide();
      checkMulti->hide();

      lab2->hide();
      lab3->hide();
      lab4->hide();
      buttonGroup4->setTitle( trUtf8( "Text" ) );

    }
    if (tool == 15)
    {
      checkEdit->show();
      checkPass->show();
      checkMulti->show();

      lab2->show();
      lab3->show();
      lab4->show();
      buttonGroup4->setTitle( trUtf8( "Text field" ) );

    }

    q->statusBar->message( trUtf8("Select the properties you want and make a text item. Once it is created, you can select it to edit"));

    if (q->ed->editingButton)
         setButtonMessage();

    setTextFromEditor();
    return;
 }
 else
 {
    q->ed->hideNodes();
 }

 switch(q->getTool())
 {
  case 1: //select 
  {
    buttonGroup1->show();
    q->statusBar->message( trUtf8("Select, move and change the objects"));
    break;
  }
  case 2: //line
  {
    buttonGroup2->show();
    q->statusBar->message( trUtf8("Click and drag to draw a line"));
    break;
  }
  case 3: //bezier
  {  
    buttonGroup3->show();
    break;
  }
  case 4: //text
  { 
    buttonGroup4->show();
    checkEdit->hide();
    checkPass->hide();
    checkMulti->hide();

    lab2->hide();
    lab3->hide();
    lab4->hide();

    q->ed->choosen = NULL;
    q->ed->nodes();
    buttonGroup4->setTitle( trUtf8( "Text" ) );
    q->statusBar->message( trUtf8("Select the properties you want and make a text item. Once it is created, you can select it to edit"));
    break;
  }
  case 5: //rubber
  {
    buttonGroup5->show();
    q->statusBar->message( trUtf8("Click on the objects to remove them"));
    break;
  }
  case 6: //polygon
  {
    buttonGroup6->show();
    q->statusBar->message( trUtf8("Click to make points and double click to finish the polygon"));
    break;
  }
  case 7: //circle
  {
    buttonGroup7->show();
    q->statusBar->message( trUtf8("Click and drag to create a circle"));
    break;
  }
  case 8: //rectangle
  {
    buttonGroup8->show();
    q->statusBar->message( trUtf8("Click and drag to create a rectangle"));
    break;
  }
  case 9: //brush
  {
    buttonGroup9->show();
    q->statusBar->message( trUtf8("Click and move to draw"));
    break;
  }
  case 10: //pencil
  {
    buttonGroup10->show();
    q->statusBar->message( trUtf8("Click and move to draw"));

    break;
  }
  case 11: //inktool
  {
    buttonGroup11->show();
    q->statusBar->message( trUtf8("Change the line color clicking over the objects"));
    break;
  }
  case 12: //paintool
  {
    buttonGroup12->show();
    q->statusBar->message( trUtf8("Change the fill color clicking over the objects"));
    break;
  }
  case 13: //zoom
  {
    buttonGroup13->show();
    q->statusBar->message( trUtf8("Click with the left button to magnify and with the right button to diminish"));
    break;
  }
  case 14: //handmove
  {
    buttonGroup14->show();
    q->statusBar->message( trUtf8("Click and drag the picture"));
    break;
  }
  case 15: //textbox
  { 
    buttonGroup4->show();
    checkEdit->show();
    checkPass->show();
    checkMulti->show();
    buttonGroup4->setTitle( trUtf8( "Text field" ) );
    lab2->show();
    lab3->show();
    lab4->show();
    q->statusBar->message( trUtf8("Select the properties you want and make a text item. Once it is created, you can select it to edit"));
    break;
  }
  case 16: //movie
  {
    buttonGroup16->show();
    q->statusBar->message( trUtf8("Add a video file"));
    break;
  }
  case 17: //button
  {
    buttonGroup17->show();
    q->statusBar->message( trUtf8("Click to add a button"));
    break;
  }
  case 18: //image
  {
    buttonGroup18->show();
    q->statusBar->message( trUtf8("Click to add an image"));
    break;
  }

 }

  if (q->ed->editingButton)
    setButtonMessage();

}

void Properties::updateFont()
{
 
  QString size;
  size = textSize->currentText(); 
    
  textSize->clear();
  QFontDatabase fdb = QFontDatabase();
  QValueList<int> sizes = fdb.pointSizes( textFamily->currentText() );
  
  if (sizes.count() == 0)
  {
    sizes.append(6);
    sizes.append(7);
    sizes.append(8);
    sizes.append(10);
    sizes.append(12);
    sizes.append(14);
    sizes.append(16);
    sizes.append(18);
    sizes.append(20);
    sizes.append(22);
    sizes.append(24);
    sizes.append(28);   
    sizes.append(36);
    sizes.append(48);
    sizes.append(72);  

  }

  for( uint i = 0 ; (uint)i < sizes.count() ; i++ ) 
  {
    QString tmp;
    tmp.sprintf( "%i", sizes[i] );
    textSize->insertItem( tmp );
  }
  

  for (int i=0;i<textSize->count();i++)
  {
    if (size == textSize->text(i))
    {
      textSize->setCurrentItem(i);
      return;
    }
  }
  
  if (textSize->count()>=5)
     textSize->setCurrentItem(5);

/*if (family.bold()) text1.setEnabled()
if (family.italic())
if (family.underline())
if (family.strikeOut())*/

}



int Properties::TxtSize()
{
  return textSize->currentText().toInt();
}

void Properties::addFont()
{
  Window* q = (Window*) parentWidget()->topLevelWidget();

  QDir qf;
  qf = qf.home().absPath() + "/.qflash";
  
  fontDialog *dlg = new fontDialog(q);
  if ( dlg->exec() == QDialog::Accepted ) 
  {
    if ((!access ( "/usr/share/libming/fonts/"+dlg->fontCombo->currentText()+".fdb", F_OK )) || ( !access ( qf.absPath()+"/fonts/"+dlg->fontCombo->currentText()+ ".fdb", F_OK ) ) )
    {
       textFamily->insertItem (dlg->fontCombo->currentText(), 0);
       textFamily->setCurrentItem(0);      
    }
  }   
  delete dlg;
  updateFont();
}

void Properties::updateText()
{
  Window* q = (Window*) parentWidget()->topLevelWidget(); 

  if (q->ed->choosen != NULL && q->ed->textHighlight != NULL)
  if (q->ed->choosen->rtti() == QCanvasItem::Rtti_Text )
  {
    QCanvasText* tempTextItem = (QCanvasText*) q->ed->choosen;
    tempTextItem->setText( textEd->text() );
    QFont f = QFont(textFamily->currentText(), TxtSize());
    tempTextItem->setFont(f);
  }

  if (q->ed->choosen != NULL && q->ed->textHighlight != NULL)
  if (q->ed->choosen->rtti() == 100)
  {
    QCanvasText* tempTextItem = (QCanvasText*) q->ed->choosen;
    tempTextItem->setText( textEd->text() );
    QFont f = QFont(textFamily->currentText(), TxtSize());
    tempTextItem->setFont(f);
    TextBox* tmpB = ((TextBoxText*) q->ed->choosen)->box;
    tmpB->updateSizes();
  }
  q->ed->nodes();
  q->ed->canvas()->setAllChanged();
  q->ed->canvas()->update();
}

void Properties::updateTextColor()
{
  Window* q = (Window*) parentWidget()->topLevelWidget(); 

  if (q->ed->choosen != NULL && q->ed->textHighlight != NULL)
  if (q->ed->choosen->rtti() == QCanvasItem::Rtti_Text )
  {
    QCanvasText* tempTextItem = (QCanvasText*) q->ed->choosen;
    tempTextItem->setColor(q->colors->l);
  }

  if (q->ed->choosen != NULL && q->ed->textHighlight != NULL)

  if (q->ed->choosen->rtti() == 100)
  {
    QCanvasText* tempTextItem = (QCanvasText*) q->ed->choosen;
    tempTextItem->setColor(q->colors->l);
  }


  q->ed->canvas()->setAllChanged();
  q->ed->canvas()->update();
}

void Properties::updateTBoxProp()
{
  Window* q = (Window*) parentWidget()->topLevelWidget(); 


  if (q->ed->choosen == NULL) return;
  if (q->ed->choosen->rtti() == 100)
  {
    TextBoxText* tmpTxt = (TextBoxText*) q->ed->choosen;
    TextBox* tbox = tmpTxt->box;

    tbox->editable = checkEdit->isChecked();
    tbox->selectable = checkSelect->isChecked();
    tbox->password = checkPass->isChecked();
    tbox->multiline = checkMulti->isChecked();
 
  }
  return;
}

void Properties::setTBoxPropFromEditor()
{
  Window* q = (Window*) parentWidget()->topLevelWidget(); 

  if (q->ed->choosen == NULL) return;

  if (q->ed->choosen->rtti() == 100)
  {
    TextBoxText* tmpTxt = (TextBoxText*) q->ed->choosen;
    TextBox* tbox = tmpTxt->box;

    checkEdit->setChecked( tbox->editable );
    checkSelect->setChecked( tbox->selectable );
    checkPass->setChecked( tbox->password );
    checkMulti->setChecked( tbox->multiline );

  }
  return;
}


void Properties::setTextFromEditor()
{

    Window* q = (Window*) parentWidget()->topLevelWidget();
    if (!q->ed->text)
       return;
    QString family;
    family = q->ed->text->font().family();
    for (int i=0;i<textFamily->count();i++)
    {

      if (family == textFamily->text(i))
      {
        textFamily->setCurrentItem(i);
        break;
      }
    }

    checkSelect->setChecked( q->ed->text->selectable );

    QString size;
    size = QString::number(q->ed->text->font().pointSize());
    for (int i=0;i<textSize->count();i++)
    {

      if (size == textSize->text(i))
      {
        textSize->setCurrentItem(i);
        break;
      }
    }

    setTBoxPropFromEditor();
    //THIS MUST BE THE LAST!!!!!!
    textEd->setText( q->ed->text->text()   );

}



void Properties::buttonUpClicked()
{
    Window* q = (Window*) parentWidget()->topLevelWidget();
//     q->tools->toolButton1->setOn(1);
    setTool();
    q->ed->setCanvas( (QCanvas*) q->ed->button->canvasUp );
}

void Properties::buttonOverClicked()
{
    Window* q = (Window*) parentWidget()->topLevelWidget();
//     q->tools->toolButton1->setOn(1);
    setTool();
    q->ed->setCanvas( (QCanvas*) q->ed->button->canvasOver );

}

void Properties::buttonDownClicked()
{
    Window* q = (Window*) parentWidget()->topLevelWidget();
//     q->tools->toolButton1->setOn(1);
    setTool();
    q->ed->setCanvas( (QCanvas*) q->ed->button->canvasDown );

}

void Properties::buttonBackClicked()
{
  Window* q = (Window*) parentWidget()->topLevelWidget();
  QCanvasItemList l1 = q->ed->filterSelection(q->ed->button->canvasUp->allItems());
  QCanvasItemList l2 = q->ed->filterSelection(q->ed->button->canvasOver->allItems());
  QCanvasItemList l3 = q->ed->filterSelection(q->ed->button->canvasDown->allItems());

  if (l1.count() == 0)
  {
      QMessageBox* msg = new QMessageBox ( trUtf8("Warning"), trUtf8("The button is empty in \"up position\". You can't save it"), QMessageBox::Warning, QMessageBox::Ok | QMessageBox::Default, 0, 0);
      msg->exec();
      return;
  }

  if (l2.count() == 0 || l3.count() == 0)
  {
      QMessageBox* msg = new QMessageBox ( trUtf8("Warning"), trUtf8("The button is empty in at least one position.\n"
      "¿Do you want to continue?"), QMessageBox::Warning, QMessageBox::Yes | QMessageBox::Default, QMessageBox::No  | QMessageBox::Escape, 0);
      if ( msg->exec() == QMessageBox::No )
      return;
  }

  if (tmpButton != NULL)
    q->ed->deleteShape(tmpButton);
  QCanvasItemList newList = q->copyFrameForButton(q->ed->button->canvasUp , q->ed->button->canvasButton);
  q->tools->toolButton1->setOn(1);
  setTool();
  q->startButtonEdit( 0 );
  copiable(FALSE);
  paste1->setEnabled(0);
  paste2->setEnabled(0);
  paste3->setEnabled(0);
  q->ed->setCanvas((QCanvas*) q->ed->button->canvasButton);
  q->ed->multiSelect = newList;
  itemGroup* tmpGroup = q->ed->group( q->ed->button );
  if (tmpGroup == NULL) return;
  tmpGroup->isButton = 1;
  tmpGroup->buttonGroup = q->ed->button;
  q->ed->button->actions = tmpAS;

}

void Properties::buttonCancelClicked()
{
  Window* q = (Window*) parentWidget()->topLevelWidget();

  QCanvasItemList l1 = q->ed->filterSelection(q->ed->button->canvasUp->allItems());
  QCanvasItemList l2 = q->ed->filterSelection(q->ed->button->canvasOver->allItems());
  QCanvasItemList l3 = q->ed->filterSelection(q->ed->button->canvasDown->allItems());
  if (l1.count() != 0 || l2.count() != 0 || l3.count() != 0)
  {
      QMessageBox* msg = new QMessageBox ( trUtf8("Warning"), trUtf8("You will lose your work\n¿Do you want to continue?"), QMessageBox::Warning, QMessageBox::Yes | QMessageBox::Default, QMessageBox::No  | QMessageBox::Escape, 0);
      if ( msg->exec() == QMessageBox::No )
      return;
  }

  q->tools->toolButton1->setOn(1);
  setTool();
  q->startButtonEdit( 0 );
  copiable(FALSE);
  paste1->setEnabled(0);
  paste2->setEnabled(0);
  paste3->setEnabled(0);

  q->ed->setCanvas((QCanvas*) q->ed->button->canvasButton);


}

 
void Properties::slotCopy1()
{
  paste1->setEnabled(0);
  paste2->setEnabled(1);
  paste3->setEnabled(1);
  Window* q = (Window*) parentWidget()->topLevelWidget();
  buffered = q->ed->button->canvasUp; 
}

void Properties::slotPaste1()
{
  paste1->setEnabled(0);
  paste2->setEnabled(0);
  paste3->setEnabled(0);
  Window* q = (Window*) parentWidget()->topLevelWidget();
  q->copyFrameForButton( buffered, q->ed->button->canvasUp); 
}

void Properties::slotCopy2()
{
  paste1->setEnabled(1);
  paste2->setEnabled(0);
  paste3->setEnabled(1);
  Window* q = (Window*) parentWidget()->topLevelWidget();
  buffered = q->ed->button->canvasOver; 

}

void Properties::slotPaste2()
{
  paste1->setEnabled(0);
  paste2->setEnabled(0);
  paste3->setEnabled(0);
  Window* q = (Window*) parentWidget()->topLevelWidget();
  q->copyFrameForButton( buffered, q->ed->button->canvasOver); 

}

void Properties::slotCopy3()
{
  paste1->setEnabled(1);
  paste2->setEnabled(1);
  paste3->setEnabled(0);
  Window* q = (Window*) parentWidget()->topLevelWidget();
  buffered = q->ed->button->canvasDown; 

}

void Properties::slotPaste3()
{
  paste1->setEnabled(0);
  paste2->setEnabled(0);
  paste3->setEnabled(0);
  Window* q = (Window*) parentWidget()->topLevelWidget();
  q->copyFrameForButton( buffered, q->ed->button->canvasDown); 

}

void Properties::copiable(bool on)
{
  copy1->setEnabled(on);
  copy2->setEnabled(on);
  copy3->setEnabled(on);
}


void Properties::buttonASClicked()
{
   Window* q = (Window*) parentWidget()->topLevelWidget();
   q->ed->updateNames();
   asDialog *dlg = new asDialog( tmpAS, q->ed->names );
   if ( dlg->exec() == QDialog::Accepted ) 
   {
     tmpAS = dlg->actions;
   }
   else
      return;

  delete dlg;

}

void Properties::setPolygonMessage()
{
  Window* q = (Window*) parentWidget()->topLevelWidget();

  if (toolButtonRegular->isOn() ||  toolButtonStar->isOn() )
  {
    q->statusBar->message( trUtf8(  "Click and drag to make a regular polygon. Then, move the red points to edit it" ));
  }
  else
    q->statusBar->message( trUtf8("Click to make points and double click to finish the polygon"));

}

void Properties::setButtonMessage()
{
    Window* q = (Window*) parentWidget()->topLevelWidget();
    q->statusBar->message( trUtf8( "Click on the \"Button\" tool to save your work or go back without saving" ));
    q->lineEdit->setEnabled(FALSE);
    q->lineLabel->setEnabled(FALSE);
}


