/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <qapplication.h>
#include <qmainwindow.h>
#include <qlabel.h>
#include <qdockwindow.h>
#include <qtextedit.h>
#include <qsettings.h>
#include <qtextcodec.h>
#include <qregexp.h>
#include <qdir.h>

#include "window.h"
#include "tools.h"
#include "qfile.h"
#include "colors.h"

#include "logo.xpm"
#include "splash.xpm"


#include <qsplashscreen.h>
#include <fstream>
#include <iostream>
using namespace std;


int main( int argc, char **argv )
{
    QApplication app( argc, argv );


    
    QString Lang;
    QTranslator translator( 0 );
        
    QString loc = QTextCodec::locale();
     if(loc.find( QRegExp("es"), 0 ) != -1)    //Spanish language
      Lang = "/usr/share/qflash/translations/es.qm";
 
    if(loc.find( QRegExp("ca"), 0 ) != -1)   // Catalan language
      Lang = "/usr/share/qflash/translations/ca.qm";
     
    QDir qf;
    qf = qf.home().absPath() + "/.qflash";
    if ( !qf.exists() )
      system("mkdir "+ qf.absPath() );


    QFile file(qf.absPath()+"/lang.cnf"); // then tries to load language from a config file
    
    if (!file.open( IO_ReadOnly ))
      translator.load(Lang);
    else
    { 
      QTextStream stream( &file );
      stream >> Lang;
      file.close();
      translator.load(Lang);
    }
   
    app.installTranslator( &translator );

    system ("rm -rf " +qf.absPath()+ "/qflashtmp"); //before this should go a recovery system
    system ("mkdir "  +qf.absPath()+ "/qflashtmp");
    
    QPixmap pixmap( splash_xpm );
    QSplashScreen *splash = new QSplashScreen( pixmap, Qt::WStyle_StaysOnTop );
    
    if (argc < 2)
    {
      splash->show();
      splash->raise();
    }
    
    Window main( argc, argv );   
    main.setIcon (QPixmap (logo_xpm));

    main.resize(800,650);
    main.show();
    if (argc < 2)
      sleep(2);
    splash->finish((QWidget*) &main);
    QObject::connect( qApp, SIGNAL(lastWindowClosed()), qApp, SLOT(quit()) );
    return app.exec();
    
}
