/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "langDialog.h"

#include <qvariant.h>
#include <qurl.h>

#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qfiledialog.h>
#include "menuimages/open.xpm"


langDialog::langDialog( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{


    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setGeometry( QRect( 130, 280, 110, 31 ) );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setGeometry( QRect( 260, 280, 121, 31 ) );

    checkFile = new QCheckBox( this, "checkFile" );
    checkFile->setGeometry( QRect( 280, 100, 130, 30 ) );

    lineFile = new QLineEdit( this, "lineFile" );
    lineFile->setEnabled( FALSE );
    lineFile->setGeometry( QRect( 280, 150, 191, 31 ) );

    buttonFile = new QPushButton( this, "buttonFile" );
    buttonFile->setEnabled( FALSE );
    buttonFile->setGeometry( QRect( 320, 190, 31, 31 ) );
    buttonFile->setIconSet( QIconSet( QPixmap (( const char** ) open_xpm)));

    textLabel1 = new QLabel( this, "textLabel1" );
    textLabel1->setGeometry( QRect( 30, 20, 436, 40 ) );

    listLang = new QListBox( this, "listLang" );
    listLang->setGeometry( QRect( 50, 80, 140, 140 ) );
    languageChange();
    resize( QSize(521, 353).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
    
    
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( buttonFile, SIGNAL( clicked() ), this, SLOT( seekFile() ) );

    connect( checkFile, SIGNAL( clicked() ), this, SLOT( file_list() ) );

    
    status = 0;
        
}


langDialog::~langDialog()
{
}

void langDialog::languageChange()
{
    setCaption( tr( "Language" ) );
    buttonOk->setText( tr( "Ok" ) );
    buttonCancel->setText( tr( "Cancel" ) );
    checkFile->setText( tr( "From file" ) );
    textLabel1->setText( tr( "Select your language or a translation file" ) );
    listLang->clear();
    listLang->insertItem(  "Catalan"  );
    listLang->insertItem(  "Spanish" );
    listLang->insertItem(  "English" );
}

void langDialog::seekFile()
{
   QUrl fileurl =  QFileDialog::getOpenFileName( "translations/", "QT translation files (*.qm)", this, "open file dialog", tr("Choose a file"));
   lineFile->setText(fileurl.toString(0,0));
   lang = fileurl.fileName();
}

void langDialog::file_list()
{
   if (!status)
   {
     buttonFile->setEnabled(1);
     lineFile->setEnabled(1);
     status = 1;
   }
   else
   {
     buttonFile->setEnabled(0);
     lineFile->setEnabled(0);
     status = 0;
   }

}



