/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ITEMS_H
#define ITEMS_H
 
#include <textbox.h>
#include <regular.h>
#include <textitem.h>
#include <button.h>

#include <itemgroup.h>

#include <qcanvas.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qstring.h>


//  CONTROL ITEMS ///////////////////////////////////////////////////


class NodeItem : public QCanvasEllipse
{
public:
    NodeItem( double , double, QCanvas*);
    void moveBy(double dx, double dy);
    int rtti () const { return 666;}
    int nodeRtti;
};

class adjustItem: public QCanvasRectangle
{
public:
     adjustItem( int, int, QCanvas*);
     int rtti () const { return 6969;}

};

class adjustText: public QCanvasText
{
public:
     adjustText(QString, QCanvas*);
     int rtti () const { return 6969;}

};

class CanvasItem : public QCanvasRectangle
{
public:
    CanvasItem ( int, int, int, int, QCanvas*);
    int rtti () const { return 6666;}
    adjustItem* adjust;
};


class textHighlightItem: public QCanvasRectangle
{
public:
    int rtti () const { return 668;}
    textHighlightItem(QRect&, QCanvas*);
};


class groupLineItem: public QCanvasLine
{
public:
  groupLineItem ( QCanvas* );
  int rtti () const { return 675;}
};

class buttonCanvasLineItem: public QCanvasLine
{
public:
  buttonCanvasLineItem ( QCanvas* );
  int rtti () const { return 670;}
};
// CANVAS ITEMS ///////////////////////////////////////////////////////

class RectItem : public QCanvasRectangle
{

public:
  RectItem ( int, int, int, int, QCanvas*);
  RectItem ( RectItem*, QCanvas*);
  QString xml();
  void showNodes();
  bool effect;
  bool grouped;
  bool button;
  QString name;
  itemGroup* group;
};

class OvalItem : public QCanvasEllipse
{
public:
  OvalItem ( int, int, QCanvas*);
  OvalItem ( OvalItem*, QCanvas*);
  void setPen ( QPen );
  QPen pen;
  QString xml();
  void showNodes();
  bool effect;
  bool grouped;
  bool button;
  QString name;
  itemGroup* group;

protected:
   void drawShape ( QPainter & );
};

class Polygon : public QCanvasPolygon
{
public:
  Polygon(QCanvas*);
  Polygon( Polygon*, QCanvas*, int dx = 0, int dy = 0);
  void setPen ( QPen );
  QPen pen;
  QString xml();
  void showNodes();
  QPointArray polyline;
  void moveBy(double dx, double dy);
  bool effect;
  bool grouped;
  bool button;
  QString name;
  itemGroup* group;

protected:
  
  void drawShape ( QPainter & );
};


class LineItem : public QCanvasLine 
{
public:
  LineItem ( QCanvas* );
  LineItem ( LineItem*, QCanvas*);
  QString xml();
  void showNodes();
  bool effect;
  bool grouped;
  bool button;
  QString name;
  itemGroup* group;
};


class ImageItem: public QCanvasRectangle
{
public:
  ImageItem( QImage img, QCanvas *canvas );
  ImageItem( ImageItem*, QCanvas *canvas );

  bool hit( const QPoint&) const;
  int rtti () const { return 86;}
  QString xml();
  void showNodes();
  QImage image;
  QPixmap pixmap;
  QString fileName; //to know what image is in file.qfp
  double sw;  //used in scale
  double sh;  //used in scale
  bool mirrorH;
  bool mirrorV;
  bool effect;
  bool grouped;
  bool button;
  QString name;
  itemGroup* group;

protected:
  void drawShape( QPainter & );

};


class BrushItem : public QCanvasPolygonalItem 
{
public: 
  BrushItem(QCanvas * canvas);
  BrushItem(BrushItem*, QCanvas * canvas, int dx = 0, int dy = 0);
  void moveBy(double dx, double dy);
  QPointArray polyline;
  QPointArray areaPoints() const;
  int width;
  QString xml();
  int rtti () const { return 88;}
  void showNodes();
  bool effect;
  int view;
  bool grouped;
  bool button;
  QString name;
  itemGroup* group;

protected:
  void drawShape ( QPainter & p );
};




#endif
