/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "itemgroup.h"
#include "items.h"
#include <iostream>
#include "editor.h"

using namespace std;


 
itemGroup::itemGroup(QCanvas* tmp)
{
  canvas = tmp;
  line1 = NULL;
  isButton = 0;
  buttonGroup = NULL;
  imagelist = "";

}



QString itemGroup::xml(Editor* ed)
{
  QString s;
  imagelist.clear();

  s = "<group>\n";
  QCanvasItem* moving;
  items = ed->sortByZ(items);
  for (QCanvasItemList::Iterator it = items.begin(); it != items.end(); it++)  
  {
    moving = (QCanvasItem*) *it;



    switch (moving->rtti())
    {

            case QCanvasItem::Rtti_Rectangle:
            {
               RectItem* rec;
               rec = (RectItem*) moving;
               s += "\t\t\t" +rec->xml()+ "\n";
               break;
            }
            case QCanvasItem::Rtti_Ellipse:
            {
               OvalItem* eli;
               eli = (OvalItem*) moving;
               s += "\t\t\t" +eli->xml()+ "\n";
               break;
            }
            case QCanvasItem::Rtti_Line:
            {
               LineItem* lin;
               lin = (LineItem*) moving;
               s += "\t\t\t" +lin->xml()+ "\n";
               break;
            }
            case QCanvasItem::Rtti_Polygon:
            {
               Polygon* pol;
               pol = (Polygon*) moving;
               s += "\t\t\t" +pol->xml()+ "\n";
               break;
            }
            case QCanvasItem::Rtti_Text:
            {
               CanvasTextItem* text;
               text = (CanvasTextItem*) moving;
               s += "\t\t\t" +text->xml()+ "\n";
               break;
            }
            case 86:
            {
               ImageItem* ima;
               ima = (ImageItem*) moving;
               s += "\t\t\t" +ima->xml()+ "\n";
               imagelist.append(ima->fileName);
               break;
            }
            case 87:
            {
//                PencilItem* pen;
//                pen = (PencilItem*) moving;
//                if (pen->view)
//                     s += "\t\t\t" +pen->xml()+ "\n";
                break;
            }
            case 88:
            {
               BrushItem* bru;
               bru = (BrushItem*) moving;
               if (bru->view ) //Qflash crashed when a brushitemwas deleted so they are only hidden. View property states if it is shown or not
                   s += "\t\t\t" +bru->xml()+ "\n";
               break;
            }
            case 89:
            {
               Regular* regu;
               regu = (Regular*) moving;
               if (regu->view) 
                  s += "\t\t\t" +regu->xml()+ "\n";
               break;
            }

    }


  }
  s+= "\t\t</group> \n";
  return s;

}


void itemGroup::updatePoints()
{
  startx=20000;
  starty=20000;
  endx=0;
  endy=0;

  int tempstartx=0;
  int tempstarty=0;
  int tempendx=0;
  int tempendy=0;

  QCanvasItem* tempItem;
  
  for (QCanvasItemList::Iterator it = items.begin(); it != items.end(); it++)  
  { 
    tempItem = (QCanvasItem*) *it;
    tempstartx = tempItem->boundingRect().x();
    tempstarty = tempItem->boundingRect().y();
    tempendx = tempItem->boundingRect().x() + tempItem->boundingRect().width();
    tempendy = tempItem->boundingRect().y() + tempItem->boundingRect().height();

  if ( tempstartx < startx )
    startx = tempstartx;
  if ( tempstarty < starty )
    starty = tempstarty;
  if ( tempendx < startx )
    startx = tempendx;
  if ( tempendy < starty )
    starty = tempendy;
       
     
  if ( tempendx > endx )
    endx = tempendx;
  if ( tempendy > endy )
    endy = tempendy;
  if ( tempstartx > endx )
    endx = tempstartx;
  if ( tempstarty > endy )
    endy = tempstarty;
  
  }
  if (startx == 20000) startx = tempstartx;
  if (starty == 20000) starty = tempstarty;
  
  
  startx = startx -10;
  starty = starty -10;
  endx = endx +10;
  endy = endy +10;


}


void itemGroup::showNodes()
{

 updatePoints();

 if (line1==NULL)
 {
   line1= new groupLineItem(canvas);
   line2= new groupLineItem(canvas);
   line3= new groupLineItem(canvas);
   line4= new groupLineItem(canvas);

 }

 line1->setPoints(startx, starty, endx, starty);
 line2->setPoints(startx, starty, startx, endy);
 line3->setPoints(startx, endy, endx, endy);
 line4->setPoints(endx, starty, endx, endy);
 QColor c= Qt::red;
 line1->setPen(c);
 line2->setPen(c);
 line3->setPen(c);
 line4->setPen(c);

 line1->show();
 line2->show();
 line3->show();
 line4->show();

}

void itemGroup::hideNodes()
{
  if (line1==NULL)
  {
    return;
  }
  line1->hide(); 
  line2->hide(); 
  line3->hide();
  line4->hide();
  delete line1;
  delete line2;
  delete line3;
  delete line4;
  
  line1 = NULL;  
}

void itemGroup::moveBy(double dx, double dy)
{
  QCanvasItem* tempItem;
  
  for (QCanvasItemList::Iterator it = items.begin(); it != items.end(); it++)  
  { 
    tempItem = (QCanvasItem*) *it;
    tempItem->moveBy(dx , dy );
  }
  if (line1 != NULL)
  {
    line1->moveBy(dx, dy);
    line2->moveBy(dx, dy);
    line3->moveBy(dx, dy);
    line4->moveBy(dx, dy);  
  }
  startx = (int) (startx + dx);
  endx = (int) (endx + dx);
  starty = (int) (starty + dy);
  endy = (int) (endy + dy);
  
}
    


    /*switch (tempItem->rtti())
    {
       case QCanvasItem::Rtti_Rectangle:
       {
         RectItem* selected;
         selected = (RectItem*) moving; 
         tempstartx = selected->x();
         tempstarty = selected->y();
         tempendx = selected->x() + selected->width();
         tempendy = selected->x() + selected->height();
         break;
       }
       case QCanvasItem::Rtti_Ellipse:
       {
         OvalItem* selected;
         selected = (OvalItem*) moving; 
         tempstartx = selected->x();
         tempstarty = selected->y();
         tempendx = selected->x() + selected->width();
         tempendy = selected->x() + selected->height(); 
         break;
       }
       
       case QCanvasItem::Rtti_Line:
       {
           LineItem* selected;
           selected = (LineItem*) moving; 
           tempstartx = selected->startPoint().x();
           tempstarty = selected->startPoint().y();
           tempendx = selected->endPoint().x();
           tempendy = selected->endPoint().y(); 
           break;
       }
       case QCanvasItem::Rtti_Polygon:
       {
           Polygon* selected;
           selected = (Polygon*) moving;
           tempstartx = selected->boundingRect().x();
           tempstarty = selected->boundingRect().y();
           tempendx = selected->boundingRect().x() + selected->boundingRect().width();
           tempendy = selected->boundingRect().y() + selected->boundingRect().height();
           break;
       }
       case QCanvasItem::Rtti_Text:
       {
           CanvasTextItem* selected;
           selected = (CanvasTextItem*) moving;
           tempstartx = selected->boundingRect().x();
           tempstarty = selected->boundingRect().y();
           tempendx = selected->boundingRect().x() + selected->boundingRect().width();
           tempendy = selected->boundingRect().y() + selected->boundingRect().height();
           break;
       }
       case 86:
       {
           ImageItem* selected;
           selected = (ImageItem*) moving; 
           tempstartx = selected->x();
           tempstarty = selected->y();
           tempendx = selected->x() + selected->width();
           tempendy = selected->x() + selected->height();
           break;
       }
       case 87:
       {
            PencilItem* selected;
            selected = (PencilItem*) moving;
            tempstartx = selected->boundingRect().x();
            tempstarty = selected->boundingRect().y();
            tempendx = selected->boundingRect().x() + selected->boundingRect().width();
            tempendy = selected->boundingRect().y() + selected->boundingRect().height(); 
            break;
       }
       case 88:
       {
            BrushItem* selected;
            selected = (BrushItem*) moving;
            tempstartx = selected->boundingRect().x();
            tempstarty = selected->boundingRect().y();
            tempendx = selected->boundingRect().x() + selected->boundingRect().width();
            tempendy = selected->boundingRect().y() + selected->boundingRect().height();
            break;
       }
       case 89:
       {   
            Regular* selected;
            selected = (Regular*) moving;
            tempstartx = selected->boundingRect().x();
            tempstarty = selected->boundingRect().y();
            tempendx = selected->boundingRect().x() + selected->boundingRect().width();
            tempendy = selected->boundingRect().y() + selected->boundingRect().height();
            break;
       }

    }*/


