/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "fontDialog.h"

#include <qvariant.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qfontdatabase.h>
#include <qstringlist.h>
#include <qurl.h>
#include <qdir.h>
#include <qfiledialog.h>
#include <window.h>
#include <qmessagebox.h>

#include <iostream>
using namespace std;

#include "menuimages/open.xpm"


fontDialog::fontDialog(Window* wind)
    : QDialog(  )
{
    parent = wind;

    textLabel1 = new QLabel( this, "textLabel1" );
    textLabel1->setGeometry( QRect( 30, 80, 200, 20 ) );

    pushButton1 = new QPushButton( this, "pushButton1" );
    pushButton1->setGeometry( QRect( 230, 110, 31, 31 ) );
    pushButton1->setIconSet( QIconSet( QPixmap (( const char** ) open_xpm)));

    lineFile = new QLineEdit( this, "lineFile" );
    lineFile->setGeometry( QRect( 30, 110, 191, 30 ) );

    fontCombo = new QComboBox( FALSE, this, "fontCombo" );
    fontCombo->setGeometry( QRect( 30, 240, 151, 30 ) );

    
    QFontDatabase fdb;
    QStringList fontlist = fdb.families();

    QDir qf;
    qf = qf.home().absPath() + "/.qflash";

    for ( QStringList::Iterator it = fontlist.begin(); it != fontlist.end(); ++it )
    {
       if ( (access ( "/usr/share/libming/fonts/"+*it+".fdb", F_OK )) && (access ( qf.absPath()+"/fonts/"+*it+ ".fdb", F_OK )) )
        fontCombo->insertItem(  *it );
    }

    textLabel2 = new QLabel( this, "textLabel2" );
    textLabel2->setGeometry( QRect( 30, 190, 180, 31 ) );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setGeometry( QRect( 200, 370, 110, 31 ) );

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setGeometry( QRect( 50, 370, 110, 31 ) );
    languageChange();
    resize( QSize(340, 481).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
    
    connect( pushButton1, SIGNAL( clicked() ), this, SLOT( chooseFile() ) );
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( okClick() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );

}

fontDialog::~fontDialog()
{
}

void fontDialog::languageChange()
{
    setCaption( trUtf8( "New font" ) );
    textLabel1->setText( tr( "Font file" ) );
    textLabel2->setText( tr( "Link with" ) );
    buttonCancel->setText( tr( "Cancel" ) );
    buttonOk->setText( tr( "Ok" ) );
}




void fontDialog::okClick()
{
 QDir qf;
 qf = qf.home().absPath() + "/.qflash";

 if (!access ( lineFile->text(), F_OK ))
 {

    if (lineFile->text().endsWith(".fdb"))
    {
      system( "cp \""+lineFile->text()+"\" \""+qf.absPath()+"/fonts/"+ fontCombo->currentText() +".fdb\"");
    }
 
    if (lineFile->text().endsWith(".ttf")) 
    {

       if (access ( parent->TTF2FFTPATH, F_OK ))
       {
         QMessageBox* msg = new QMessageBox ( tr("Error"), trUtf8("Configure ttf2fft path before adding a .ttf font"), QMessageBox::Critical, QMessageBox::Ok | QMessageBox::Default, 0, 0);
         msg->exec();
         return;
       }
       if (access ( parent->UTILSPATH, F_OK ))
       {
         QMessageBox* msg = new QMessageBox ( tr("Error"), trUtf8("Configure mingutils path before adding a .ttf or .fft font"), QMessageBox::Critical, QMessageBox::Ok | QMessageBox::Default, 0, 0);
         msg->exec();
         return;
       }
       system( "rm -rf "+qf.absPath()+"/tmpfont");
       system( "mkdir "+qf.absPath()+"/tmpfont");
       system( "cp \""+lineFile->text()+"\" \""+qf.absPath()+"/tmpfont/"+ fontCombo->currentText() +".fdb\"");
       system( parent->TTF2FFTPATH+" \""+qf.absPath()+"/tmpfont/"+ fontCombo->currentText() +".fdb\""+" -o \""+qf.absPath()+"/tmpfont/"+ fontCombo->currentText() +".fft\"" );

       system( "cd \""+qf.absPath()+"/tmpfont/" "\" && "+parent->UTILSPATH+"makefdb \""+ fontCombo->currentText() +".fft\"" );
       system( "cd \""+qf.absPath()+"/tmpfont/" "\" && cp *.fdb \""+ qf.absPath() +"/fonts/"+ fontCombo->currentText() +".fdb\"");
    }

    if (lineFile->text().endsWith(".fft"))
    {
       if (access ( parent->UTILSPATH, F_OK ))
       {
         QMessageBox* msg = new QMessageBox ( tr("Error"), trUtf8("Configure mingutils path before adding a .ttf or .fft font"), QMessageBox::Critical, QMessageBox::Ok | QMessageBox::Default, 0, 0);
         msg->exec();
         return;
       }
       system( "rm -rf "+qf.absPath()+"/tmpfont");
       system( "mkdir "+qf.absPath()+"/tmpfont");
       system( "cp \""+lineFile->text()+"\" \""+qf.absPath()+"/tmpfont/"+ fontCombo->currentText() +".fft\"" );
       system( "cd \""+qf.absPath()+"/tmpfont/" "\" && "+parent->UTILSPATH+"makefdb \""+ fontCombo->currentText() +".fft\"" );
       system( "cd \""+qf.absPath()+"/tmpfont/" "\" && cp *.fdb \""+ qf.absPath() +"/fonts/"+ fontCombo->currentText() +".fdb\"");

    }

 accept();
 }
}

void fontDialog::chooseFile()
{
   QUrl fileurl =  QFileDialog::getOpenFileName( "", tr("Fonts") +" (*.fdb *.ttf *.fft)", this, "open file dialog", tr("Choose a file"));

   lineFile->setText(fileurl.toString(0,0));

}

