/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "exportDialog.h"

#include <qvariant.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "menuimages/open.xpm"

ExpDialog::ExpDialog(int framtemp, int rate, QString mp3url, QString swfurl)
    : QDialog()
{
    setName( "ExpDialog" );
 
    
    frames = framtemp;
    
    textLabel4 = new QLabel( this, "textLabel4" );
    textLabel4->setGeometry( QRect( 40, 140, 150, 20 ) );

    textLabel5 = new QLabel( this, "textLabel5" );
    textLabel5->setGeometry( QRect( 40, 230, 110, 20 ) );

    lineMp3 = new QLineEdit( this, "lineMp3" );
    lineMp3->setGeometry( QRect( 120, 170, 290, 30 ) );

    lineSwf = new QLineEdit( this, "lineSwf" );
    lineSwf->setGeometry( QRect( 120, 260, 291, 31 ) );

    lineSwf->setText(swfurl);
    lineMp3->setText(mp3url);

    
    
    chooseFile = new QPushButton( this, "chooseFile" );
    chooseFile->setGeometry( QRect( 420, 260, 31, 31 ) );
    chooseFile->setIconSet( QIconSet( QPixmap (( const char** ) open_xpm)));

    textLabel2 = new QLabel( this, "textLabel2" );
    textLabel2->setGeometry( QRect( 200, 70, 130, 20 ) );

    textLabel1 = new QLabel( this, "textLabel1" );
    textLabel1->setGeometry( QRect( 40, 70, 80, 20 ) );

    spinRate = new QSpinBox( this, "spinRate" );
    spinRate->setGeometry( QRect( 130, 60, 51, 31 ) );

    spinRate->setValue(rate);
    
    chooseMp3 = new QPushButton( this, "chooseMp3" );
    chooseMp3->setGeometry( QRect( 420, 170, 30, 30 ) );
    chooseMp3->setIconSet( QIconSet( QPixmap (( const char** ) open_xpm)));

    textLabel3 = new QLabel( this, "textLabel3" );
    textLabel3->setGeometry( QRect( 300, 70, 190, 20 ) );
    
    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setGeometry( QRect( 200, 310 , 80, 31 ) );
    buttonOk->setFocus();

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setGeometry( QRect( 320, 310, 80, 31 ) );
    
    
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( chooseMp3, SIGNAL( clicked() ), this, SLOT( seekmp3() ) );
    connect( chooseFile, SIGNAL( clicked() ), this, SLOT( seekfile() ) );
    connect( spinRate, SIGNAL( valueChanged(int) ), this, SLOT( calculeRate() ) );

    
    
    languageChange();
    resize( QSize(498, 380).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
}

ExpDialog::~ExpDialog()
{
}

void ExpDialog::languageChange()
{
    setCaption( tr( "Saving..." ) );
    textLabel4->setText( tr( "MP3 background sound" ) );
    textLabel5->setText( tr( "Export to file" ) );
    buttonOk->setText( tr( "Ok" ) );
    buttonCancel->setText( tr( "Cancel" ) );
    textLabel2->setText( tr( "frames/second" ) );
    textLabel1->setText( QString::number(frames) + " " + tr( "Frames at" ) );
    textLabel3->setText( "= "+ QString::number((double)frames/spinRate->value()) +" " + tr( "seconds" ) );
}

void ExpDialog::seekfile()
{
  
  QString fileurl =  QFileDialog::getSaveFileName( "", "Macromedia Flash Swf (*.swf)", this, "open file dialog", tr("Choose a file"));
  if (!fileurl.endsWith(".swf")) fileurl += ".swf";
  lineSwf->setText(fileurl);

}

void ExpDialog::seekmp3()
{
   QString mp3url =  QFileDialog::getOpenFileName( "", "MP3 (*.mp3)", this, "open file dialog", tr("Choose a file"));
   lineMp3->setText(mp3url);
}

void ExpDialog::calculeRate()
{
    textLabel3->setText( "= "+ QString::number((double)frames/spinRate->value()) +" "+tr( "seconds" ) );
}


