/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <editor.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qwmatrix.h>

#include <math.h>
#include <iostream>
using namespace std;

void Editor::nodeChanged(double dx, double dy)
{

  NodeItem* tmp; // the clicked nodeitem
  tmp = (NodeItem*) moving;
  switch (choosen->rtti())
  {
    case QCanvasItem::Rtti_Ellipse:
    {
        OvalItem* tmpch = (OvalItem*) choosen; //item choosen converted to suitable class
        if (tmp1 == 0) tmp1 = tmpch->height();
        if (tmp2 == 0) tmp2 = tmpch->width();

        if (tmp->nodeRtti == 0)
        {
          tmpch->setSize(tmpch->width(), (int) abs( (int)(2*dy - tmp1)) );
          tmp->move(tmpch->x(),tmpch->y()- tmpch->height()/2);
          lookNode(2)->move(tmpch->x(),tmpch->y()+tmpch->height()/2);
        }

        if (tmp->nodeRtti == 2)
        {
          tmpch->setSize(tmpch->width(), (int) abs( (int)(2*dy + tmp1)) );
          lookNode(0)->move(tmpch->x(),tmpch->y()- tmpch->height()/2);
          tmp->move(tmpch->x(),tmpch->y()+tmpch->height()/2);
        }

        if (tmp->nodeRtti == 1)
        {
          tmpch->setSize((int) abs((int)(2*dx + tmp2)), tmpch->height() );
          tmp->move(tmpch->x()+ tmpch->width()/2, tmpch->y());
          lookNode(3)->move(tmpch->x()- tmpch->width()/2, tmpch->y());
        }

        if (tmp->nodeRtti == 3)
        {
          tmpch->setSize((int) abs( (int)(- 2*dx + tmp2)), tmpch->height() );
          lookNode(1)->move(tmpch->x() + tmpch->width()/2, tmpch->y());
          tmp->move(tmpch->x()- tmpch->width()/2, tmpch->y());
        }
    break;
    }
    case QCanvasItem::Rtti_Rectangle:
    {
        RectItem* tmpch = (RectItem*) choosen; //item choosen converted to suitable class
        if (tmp1 == 0) tmp1 = tmpch->height();
        if (tmp2 == 0) tmp2 = tmpch->width();

        if (tmp->nodeRtti == 0)
        {
          tmpch->moveBy(dx, dy );
          tmpch->setSize((int) (tmpch->width() - dx), (int) (tmpch->height() - dy) );

          lookNode(0)->move(tmpch->x(), tmpch->y());
          lookNode(1)->move(tmpch->x() + tmpch->width(), tmpch->y());
          lookNode(3)->move(tmpch->x(), tmpch->y() + tmpch->height() );

          ceny = (int) dy + ceny;
          cenx = (int) dx + cenx;
        }

        if (tmp->nodeRtti == 1)
        {
          tmpch->moveBy( 0, dy );
          tmpch->setSize( (int) (tmp2 + dx) , (int) (tmpch->height() - dy) );

          lookNode(0)->move(tmpch->x(), tmpch->y());
          lookNode(1)->move(tmpch->x() + tmpch->width(), tmpch->y());
          lookNode(2)->move(tmpch->x() + tmpch->width() , tmpch->y() + tmpch->height());

          ceny =(int) dy + ceny;
        }


        if (tmp->nodeRtti == 2)
        {
          tmpch->setSize((int) (tmp2 + dx) , (int) (tmp1 + dy) );
 
          lookNode(1)->move(tmpch->x() + tmpch->width(), tmpch->y());
          lookNode(2)->move(tmpch->x() + tmpch->width() , tmpch->y() + tmpch->height());
          lookNode(3)->move(tmpch->x(), tmpch->y() + tmpch->height() );
        }

        if (tmp->nodeRtti == 3)
        {
          tmpch->moveBy( dx, 0 );
          tmpch->setSize( (int) (tmpch->width() - dx) ,(int) (tmp1 + dy ));

          lookNode(0)->move(tmpch->x(), tmpch->y());
          lookNode(2)->move(tmpch->x() + tmpch->width() , tmpch->y() + tmpch->height());
          lookNode(3)->move(tmpch->x(), tmpch->y() + tmpch->height() );

          cenx = (int) dx + cenx;
        }

  break;
  }
  case QCanvasItem::Rtti_Line:
  {
        LineItem* tmpch = (LineItem*) choosen; //item choosen converted to suitable class
 
        if (tmp->nodeRtti == 0)
        {
          tmpch->setPoints ((int) (tmpch->startPoint().x() +dx), (int) (tmpch->startPoint().y() +dy), tmpch->endPoint().x() , tmpch->endPoint().y());

          lookNode(0)->moveBy(dx, dy );

          cenx = (int) dx + cenx;
          ceny = (int) dy + ceny;

        }

        if (tmp->nodeRtti == 1)
        {
          tmpch->setPoints (tmpch->startPoint().x(), tmpch->startPoint().y(),(int) (tmpch->endPoint().x() + dx) , (int) (tmpch->endPoint().y() + dy) );

          lookNode(1)->moveBy(dx, dy );

          cenx = (int) dx + cenx;
          ceny = (int) dy + ceny;
        }

  break;
  }

  case 86:
  {
        ImageItem* tmpch = (ImageItem*) choosen; //item choosen converted to suitable class
        if (tmp1 == 0) tmp1 = tmpch->height();
        if (tmp2 == 0) tmp2 = tmpch->width();
        
        if (tmp->nodeRtti == 0)
        {
          tmpch->moveBy(dx, dy );
          tmpch->setSize((int) (tmpch->width() - dx), (int) (tmpch->height() - dy) );

          lookNode(0)->move(tmpch->x(), tmpch->y());
          lookNode(1)->move(tmpch->x() + tmpch->width(), tmpch->y());
          lookNode(3)->move(tmpch->x(), tmpch->y() + tmpch->height() );

          ceny = (int) dy + ceny;
          cenx = (int) dx + cenx;
        }

        if (tmp->nodeRtti == 1)
        {
          tmpch->moveBy( 0, dy );
          tmpch->setSize( (int) (tmp2 + dx) , (int) (tmpch->height() - dy) );
 
          lookNode(0)->move(tmpch->x(), tmpch->y());
          lookNode(1)->move(tmpch->x() + tmpch->width(), tmpch->y());
          lookNode(2)->move(tmpch->x() + tmpch->width() , tmpch->y() + tmpch->height());

          ceny = (int) dy + ceny;
        }

        if (tmp->nodeRtti == 2)
        {

          tmpch->setSize( (int) (tmp2 + dx) , (int) (tmp1 + dy) );
          
          lookNode(1)->move(tmpch->x() + tmpch->width(), tmpch->y());
          lookNode(2)->move(tmpch->x() + tmpch->width() , tmpch->y() + tmpch->height());
          lookNode(3)->move(tmpch->x(), tmpch->y() + tmpch->height() );

        }

        if (tmp->nodeRtti == 3)
        {
          tmpch->moveBy( dx, 0 );
          tmpch->setSize( (int) (tmpch->width() - dx) , (int) (tmp1 + dy) );

          lookNode(0)->move(tmpch->x(), tmpch->y());
          lookNode(2)->move(tmpch->x() + tmpch->width() , tmpch->y() + tmpch->height());
          lookNode(3)->move(tmpch->x(), tmpch->y() + tmpch->height() );

          cenx = (int) dx + cenx;
        }
        
        if ((double) tmpch->width()/tmpch->image.width() != 0 && tmpch->sw != 0 ) tmpch->sw = (double) tmpch->width()/tmpch->image.width();
        if ((double) tmpch->height()/tmpch->image.height() != 0 && tmpch->sh != 0 ) tmpch->sh = (double) tmpch->height()/tmpch->image.height();

        NodeItem* tn0 = lookNode(0);
        NodeItem* tn1 = lookNode(1);
        NodeItem* tn2 = lookNode(2);
        NodeItem* tn3 = lookNode(3);

        if (tn1->x() - tn0->x() < 0 || tn2->x() - tn3->x() < 0 )
           tmpch->mirrorH = 1;
        else
           tmpch->mirrorH = 0;

        if (tn3->y() - tn0->y() < 0 || tn2->y() - tn1->y() < 0 )
           tmpch->mirrorV = 1;
        else
           tmpch->mirrorV = 0;

   break;
   }


   case 87:
   {
//       PencilItem* tmpch = (PencilItem*) choosen; //item choosen converted to suitable class
//       tmp->moveBy(dx, dy);
//       cenx = (int) dx + cenx;
//       ceny = (int) dy + ceny;
//       tmpch->polyline.at( tmp->nodeRtti ) = ( QPoint( (int) (tmpch->polyline.at( tmp->nodeRtti ).x() + dx ) , (int) (tmpch->polyline.at( tmp->nodeRtti).y() + dy) ) );
   break;
   }
   
   case 88:
   {
     BrushItem* tmpch = (BrushItem*) choosen; //item choosen converted to suitable class
     tmp->moveBy(dx, dy);
     cenx = (int) dx + cenx;
     ceny = (int) dy + ceny;
      
     tmpch->polyline.at( tmp->nodeRtti ) = ( QPoint( (int) (tmpch->polyline.at( tmp->nodeRtti ).x() + dx ) , (int) (tmpch->polyline.at( tmp->nodeRtti).y() + dy) ) );

     break;
   }
   
   case 89:
   {
    Regular* tmpch = (Regular*) choosen;
    if (tmpch->star)
    {
       if ( tmp->nodeRtti == 1)  //node far from the center
       {
          tmp->moveBy(dx, dy);
          tmpch->ri = (int) abs( (int)(sqrt(  (lookNode(1)->x() - tmpch->x()) * (lookNode(1)->x() - tmpch->x())   + (lookNode(1)->y() - tmpch->y()) * (lookNode(1)->y() - tmpch->y())   )  ));
           int ajuste = 180/tmpch->p;
           int quartian = 0;
           if ( lookNode(1)->x() - tmpch->x() < 0)
              quartian += 2;
           if ( lookNode(1)->y() - tmpch->y()  < 0 )
              quartian +=1;

           if (quartian == 0)
              tmpch->di = ajuste + (int) abs((int)( atan((lookNode(1)->y() - tmpch->y()) /   (lookNode(1)->x() - tmpch->x())) *(180/3.1416) ) );

           if (quartian == 1)
              tmpch->di =  ajuste + (int) -abs((int)( atan((lookNode(1)->y() - tmpch->y()) /   (lookNode(1)->x() - tmpch->x())) *(180/3.1416) ) );

           if (quartian == 2)
              tmpch->di =  ajuste +  180- (int) abs((int)( atan((lookNode(1)->y() - tmpch->y()) /   (lookNode(1)->x() - tmpch->x())) *(180/3.1416) ) );

           if (quartian == 3)
              tmpch->di =  ajuste +  180+ (int) abs((int)( atan( (lookNode(1)->y() - tmpch->y()) /   (lookNode(1)->x() - tmpch->x())) *(180/3.1416) ) );
       
       }
       if ( tmp->nodeRtti ==0 ) // node close to the center
       {
            tmp->moveBy(dx, dy);
            tmpch->re = (int) abs((int)( sqrt(   (lookNode(0)->x() - tmpch->x()) * (lookNode(0)->x() - tmpch->x())   + (lookNode(0)->y() - tmpch->y()) * (lookNode(0)->y() - tmpch->y())   )  ));

           int quartian = 0;
           if ( lookNode(0)->x() - tmpch->x() < 0)
              quartian += 2;
           if ( lookNode(0)->y() - tmpch->y()  < 0 )
              quartian +=1;

           if (quartian == 0)
              tmpch->de = (int)  abs((int)( atan((lookNode(0)->y() - tmpch->y()) /   (lookNode(0)->x() - tmpch->x())) *(180/3.1416) ) );

           if (quartian == 1)
              tmpch->de = (int) -abs((int)( atan((lookNode(0)->y() - tmpch->y()) /   (lookNode(0)->x() - tmpch->x())) *(180/3.1416) ) );

           if (quartian == 2)
              tmpch->de = 180- (int) abs((int)( atan((lookNode(0)->y() - tmpch->y()) /   (lookNode(0)->x() - tmpch->x())) *(180/3.1416) ) );

           if (quartian == 3)
              tmpch->de = 180+ (int) abs((int)( atan( (lookNode(0)->y() - tmpch->y()) /   (lookNode(0)->x() - tmpch->x())) *(180/3.1416) ) );
       
       
       }
       cenx = (int) dx + cenx;
       ceny = (int) dy + ceny;
    }
    
    if (!tmpch->star)
    {
       tmp->moveBy(dx, dy);
       tmpch->re = (int) abs((int)( sqrt(   (lookNode(0)->x() - tmpch->x()) * (lookNode(0)->x() - tmpch->x())   + (lookNode(0)->y() - tmpch->y()) * (lookNode(0)->y() - tmpch->y())   )  ));

       int quartian = 0;
       if ( lookNode(0)->x() - tmpch->x() < 0)
         quartian += 2;
       if ( lookNode(0)->y() - tmpch->y()  < 0 )
         quartian +=1;

       if (quartian == 0)
           tmpch->de = (int) abs((int)( atan((lookNode(0)->y() - tmpch->y()) /   (lookNode(0)->x() - tmpch->x())) *(180/3.1416) )) ;

       if (quartian == 1)
           tmpch->de =  (int) -abs((int)( atan((lookNode(0)->y() - tmpch->y()) /   (lookNode(0)->x() - tmpch->x())) *(180/3.1416) ) );

       if (quartian == 2)
           tmpch->de = 180- (int)abs((int)( atan((lookNode(0)->y() - tmpch->y()) /   (lookNode(0)->x() - tmpch->x())) *(180/3.1416) ) );

       if (quartian == 3)
           tmpch->de = 180+ (int) abs((int)( atan( (lookNode(0)->y() - tmpch->y()) /   (lookNode(0)->x() - tmpch->x())) *(180/3.1416) ) );

      /* cout <<  quartian  << endl;
       cout << tmpch->de << endl;
       cout << "   " << atan( (lookNode(0)->y() - tmpch->y()) /   (lookNode(0)->x() - tmpch->x())) << endl;
      */

       cenx = (int) dx + cenx;
       ceny = (int) dy + ceny;
    }
   break;
   }

   case QCanvasItem::Rtti_Polygon:
   {
      Polygon* tmpch = (Polygon*) choosen; //item choosen converted to suitable class
      
      tmp->moveBy(dx, dy);
      cenx = (int) dx + cenx;
      ceny = (int) dy + ceny;
      
      tmpch->polyline.at( tmp->nodeRtti ) = ( QPoint( (int) (tmpch->polyline.at( tmp->nodeRtti ).x() + dx) , (int) (tmpch->polyline.at( tmp->nodeRtti).y() + dy) ) );
      tmpch->setPoints(tmpch->polyline);
      break;
   } 

   case 101:
   {
      TextBoxBack* tmpch = (TextBoxBack*) choosen; //item choosen converted to suitable class
      if (tmp1 == 0) tmp1 = tmpch->height();
      if (tmp2 == 0) tmp2 = tmpch->width();
      tmpch->resizeTo( (tmp2 + dx) ,  (tmp1 + dy) );
      tmp->move(tmpch->x() + tmpch->width() , tmpch->y() + tmpch->height());
      break;
    }

   }

}



NodeItem* Editor::lookNode(int num)
{
   QCanvasItemList l = canvas ()->allItems(); 
   for (QCanvasItemList::Iterator it = l.begin () ;it != l.end(); it++)
   {
      QCanvasItem* tmp = (QCanvasItem*) *it;
      if (tmp->rtti() == 666)
      {
        NodeItem* tmpnode = (NodeItem*) tmp;
        if (tmpnode->nodeRtti == num) return tmpnode;
      }
  }
  return NULL;
}



/*
        moving->rtti () == QCanvasItem::Rtti_Polygon || moving->rtti () == QCanvasItem::Rtti_PolygonalItem ||
         moving->rtti () == QCanvasItem::Rtti_Spline  || moving->rtti () == QCanvasItem::Rtti_Text || moving->rtti () == 86 || moving->rtti () == 87 || moving->rtti () == 88 || moving->rtti () == 89)
*/



