/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "editor.h"
#include "window.h"
#include "asDialog.h"
#include "nameDialog.h"

#include <qmessagebox.h>
#include <qcanvas.h>
#include <qpainter.h>
#include <qmainwindow.h>
#include <qdockwindow.h>
#include <qfiledialog.h>
#include <qxml.h>
#include <qlineedit.h>

#include <qstring.h>
#include <qpicture.h>
#include <qrect.h>

#include "images/paint_bucket_tool.xpm"
#include "images/ink_bottle_tool.xpm"
#include "images/eraser_tool.xpm"

#include <math.h>
#include <iostream>
using namespace std;

Editor::Editor(QCanvas* c, QWidget* parent) : QCanvasView(c , parent)
{
  paintbucketCursor = QCursor (QPixmap ((const char **) paint_bucket_tool_xpm), 12, 26);
  inkbottleCursor = QCursor (QPixmap ((const char **) ink_bottle_tool_xpm), 10, 24);
  eraserCursor = QCursor (QPixmap ((const char **) eraser_tool_xpm), 1, 11);

  pol = 0;
  setContentsPos(75,130);
  canvas()->setAllChanged();
  canvas()->update();
  text = NULL;
  choosen = NULL;
  buffered = NULL;
  moving = NULL;
  tmp1 = 0; 
  tmp2 = 0;
  zoom = 0;
  textHighlight = NULL;
  line1 = NULL;
  multiSelect.clear();
  draggingAdjustItem = 0;
  editingButton = 0;
  button = NULL;
  animAction = animationASActions();

}




void Editor::contentsMousePressEvent(QMouseEvent* e)
{
  QPoint p = QPoint(inverseWorldMatrix().map(e->pos()));
  cenx = p.x();
  ceny = p.y();
  origX = cenx;
  origY = ceny;
  if (e->button() == LeftButton) 
  {
    Window * q = (Window*) parentWidget();
    if (q->getTool() != 1 )
      multiSelect.clear();

    if(q->getTool() != 6) 
    {
      pol = 0;
      canvas ()->setAllChanged ();
      canvas()->update();
    }

  switch(q->getTool())
  {


  case 1: //move tool
  {
    moving = NULL;

    QCanvasItemList l = canvas ()->collisions (p); 
    if (l.isEmpty()) 
    {
       choosen = NULL;
       moving = NULL;
       multiSelect.clear();  
       hideNodes();
       canvas()->setAllChanged();
       canvas()->update();
       break;
    }
    QCanvasItemList::Iterator it = l.begin();
    moving = (QCanvasItem*) *it;

    if (moving->rtti() == 666)
      break;

    if (moving->rtti() == 6969 ) //black square in the left bottom corner
    {
      multiSelect.clear();
      draggingAdjustItem = 1;
      if (editingButton) break;
      ((Canvas*) canvas())->adjustSizeText->setText( tr("Drag") );
      ((Canvas*) canvas())->adjustSizeText->move( p.x()+10, p.y()-10 );
      ((Canvas*) canvas())->adjustSizeText->show();
      canvas()->setAllChanged();
      canvas()->update();
      break;
    }
    if (moving->rtti() == 6666)
    {
       choosen = NULL;
       moving = NULL; 
       multiSelect.clear();
       hideNodes();
       canvas()->setAllChanged();
       canvas()->update();
       break;
    }
    if (isValid(moving))
    {
       choosen = moving;
       q->updateStatusBar();
    }
    if (choosen != NULL)
    if ((choosen->rtti() == QCanvasItem::Rtti_Text || choosen->rtti() == 100) && multiSelect.count() < 2 )
    {
        text = (CanvasTextItem*) choosen;
        q->prop->setTool(4);
        if (choosen->rtti() == 100)
           q->prop->setTool(15);
        multiSelect.clear();
        nodes();
    }
    else
    {
        q->prop->setTool(1);
    }

    if(getGroup(moving) != NULL)
      multiSelect = getGroup(moving)->items;

    if(isValid(moving) && multiSelect.contains(moving))
    {
      nodes();
      break;
    }
    if (isValid(moving) && !multiSelect.contains(moving))
    {
      multiSelect.clear();
      nodes();
      break;
    }

    break;

 }
 
 
 
 case 2: //line
 {
   line = new LineItem( canvas());
   line->setPen (q->colors->l);
   line->setPoints(cenx,ceny,cenx, ceny);
   line->setZ( getZ() );
   choosen = line;
   break;
 }
 
 case 3: //bezier
 {
   break;
 }
 case 4: //text
 {
    text = new CanvasTextItem( q->prop->textEd->text() ,  canvas() );
    QFont f = QFont(q->prop->textFamily->currentText(), q->prop->TxtSize());
    text->setFont(f);
    text->move(cenx, ceny);
    text->setColor(q->colors->l);
    text->setZ( getZ() );
    text->selectable = q->prop->checkSelect->isChecked();
    text->show();
    moving = text;
    choosen = text;
    nodes();
    break;
 }
 
 case 5: //rubber
 {
   hideNodes();
   QCanvasItemList l = canvas ()->collisions (p); 
   if (l.isEmpty()) break;
   QCanvasItemList::Iterator it = l.begin ();
   moving = (QCanvasItem*) *it;
   deleteShape(moving);
  break;
 }
 
 case 6: //polygon
 {
   if(q->prop->toolButtonRegular->isOn() == 0 && q->prop->toolButtonStar->isOn() == 0)
   {
      if( pol == 0 ) //inicio
      {
        points.clear();
        QPoint *pt = new QPoint ((e->pos ()));
        poly = new Polygon(canvas());
        points.append(pt);
        poly->setZ( getZ() );
        pol = 1;
        eo = e->pos();
        QPainter p1 (viewport ());
        p1.drawPoint(contentsToViewport(eo));
      }
      else //nuevos puntos
      {
        QPoint *pt = new QPoint ((e->pos ()));
        points.append(pt);
        QPainter p1 (viewport ());
        p1.drawLine( contentsToViewport(eo).x(), contentsToViewport(eo).y() , contentsToViewport(e->pos()).x(), contentsToViewport(e->pos()).y());
        eo = e->pos();
      }
  }
 
  if((q->prop->toolButtonRegular->isOn() == 1 || q->prop->toolButtonStar->isOn() == 1))  // it creates a regular polygon
  {
    regu = new Regular( canvas() );
    regu->setPen (q->colors->l);
    regu->setBrush (q->colors->r);  
    regu->p = q->prop->spinP->value() ;
    regu->ri = 1;
    regu->re = 1;
    regu->di = 0;
    regu->de = 0;
    if (q->prop->toolButtonStar->isOn() == 1)
       regu->star = 1;
    else
       regu->star = 0;
    regu->setX( cenx );
    regu->setY( ceny );
    regu->setZ( getZ() );
    regu->show();
  }       
 break;
 }
 
 case 7: //circle
 {
    oval = new OvalItem ( 1, 1 , canvas ());
    oval->setX( cenx );
    oval->setY( ceny );
    oval->setBrush (q->colors->r);
    oval->setZ( getZ()  );
    oval->show ();
    oval->pen = q->colors->l;
    choosen = oval;
    break;
 }
 
 case 8://rectngle
 {
    rect = new RectItem(cenx,ceny, 1, 1, canvas ());
    rect->setPen (q->colors->l);
    rect->setBrush (q->colors->r);
    rect->setZ( getZ() );
    rect->show ();
    choosen = rect;
    break;
 }
 
 case 9: //brush
 {
   points.clear();
   pt = new QPoint ((e->pos ()));
   eo = e->pos();
   points.append(pt);
   brush = new BrushItem(canvas ());
   brush->width = q->prop->spinW->value();
   brush->setPen ( QPen(q->colors->l, brush->width,Qt::SolidLine, Qt::RoundCap, Qt::RoundJoin  ));
   brush->setZ ( getZ() );
   choosen = brush;
   break;
 }
 
 case 10: //pencil
 {
   points.clear();
   pt = new QPoint ((e->pos ()));
   eo = e->pos();
   points.append (pt);
   break;
 }
 
 case 11: //inktool -bordes- 
 {
   QCanvasItemList l = canvas ()->collisions (p); 
   if (l.isEmpty()) break;
   QCanvasItemList::Iterator it = l.begin ();
   moving = (QCanvasItem*) *it;
   
   if (isValid(moving) && moving->rtti() != 100 && moving->rtti() != QCanvasItem::Rtti_Text )
    ((QCanvasPolygonalItem*) moving)->setPen( QPen(q->colors->l, 1,Qt::SolidLine, Qt::RoundCap, Qt::RoundJoin  ));
   
   canvas()->setAllChanged ();
   canvas()->update();
   break;
 }
 
 case 12: //paintool -relleno-
 {
   QCanvasItemList l = canvas ()->collisions (p); 
   if (l.isEmpty()) break;
   QCanvasItemList::Iterator it = l.begin ();
   moving = (QCanvasItem*) *it;
   
   if (isValid(moving) && moving->rtti() != 100 && moving->rtti() != QCanvasItem::Rtti_Text )
     ((QCanvasPolygonalItem*) moving)->setBrush (q->colors->r);
   
   canvas()->setAllChanged ();
   canvas()->update();
   break;
 }
 
 case 13: //zoom
 { 
   if (zoom<7) //it is done to limit the zoom. Otherwise it would crash at high levels
   {
     QWMatrix m = worldMatrix ();
     m.scale (2, 2);
     setWorldMatrix (m);
     setContentsPos( (e->x()) *2 - width()/2, (e->y()) *2 - height()/2);
     zoom++;
   }
   break;
 }
 
 case 14: //handmove
 break;
 case 15: //textbox
 {
   QFont f = QFont(q->prop->textFamily->currentText(), q->prop->TxtSize());
   tbox = new TextBox(canvas(),  q->prop->textEd->text(), f);
   tbox->editable = q->prop->checkEdit->isChecked();
   tbox->selectable = q->prop->checkSelect->isChecked();
   tbox->password = q->prop->checkPass->isChecked();
   tbox->multiline = q->prop->checkMulti->isChecked();
   tbox->setX(cenx);
   tbox->setY(ceny);
   tbox->setZ(getZ());

     Canvas* tmp = (Canvas*) canvas();
     tmp->z += 2;

   QCanvasText* tempTextItem = (QCanvasText*) tbox->boxText;
   tempTextItem->setColor(q->colors->l);
   moving = tbox->boxText;
   choosen = tbox->boxText;
   nodes();
   canvas()->setAllChanged();
   canvas()->update();
   break;
 }
 case 16: //movie
 break;
 case 17: //button
 {
   if (editingButton) break;

   QCanvasItemList l = canvas ()->collisions (p);
   if (!l.isEmpty())
   {
     QCanvasItemList::Iterator it = l.begin();
     moving = (QCanvasItem*) *it;

     if (moving != NULL)
      if(getButton(moving) != NULL)
      {
        button = getButton(moving);
        q->prop->tmpButton = moving;
        setCanvas( (QCanvas*) button->canvasUp);
        moveAllButtonCanvas( button );
        q->startButtonEdit(1);
        q->prop->tmpAS = button->actions.copy();
        break;
      }
   }
   button = new ButtonItem(); 
   button->canvasButton = (Canvas*) canvas();
   setCanvas( (QCanvas*) button->canvasUp);
   q->startButtonEdit(1);
   q->prop->tmpButton = NULL;
   q->prop->tmpAS = buttonASActions();
   break;
 }
 case 18: //image
 {
   QDir qf;
   qf = qf.home().absPath() + "/.qflash";


   QUrl file_image;
   QImage image;
   QString format;
   int fn;
   for (fn = 0 ; fn < 100000 ; fn++)
   {
     QFile fil( qf.absPath()+"/qflashtmp/"+QString::number( fn )+".png");   
     QFile fil2( qf.absPath()+"/qflashtmp/"+QString::number( fn )+".xpm");     
     QFile fil3( qf.absPath()+"/qflashtmp/"+QString::number( fn )+".gif");     
     QFile fil4( qf.absPath()+"/qflashtmp/"+QString::number( fn )+".jpg");     

     if ( !fil.open( IO_ReadOnly ) && !fil2.open( IO_ReadOnly ) && !fil3.open( IO_ReadOnly ) && !fil4.open( IO_ReadOnly ) ) //if there is not a file with this number as name, this will be the name of the image
     break;
   }   
   file_image = QFileDialog::getOpenFileName(
                    "",
                    tr("Images")+ "( *.png *.svg *.xpm *.jpg *.gif )",
                    this,
                    "open file dialog",
                    tr("Choose a file") );

  QString tmptmp = file_image.toString(0,0);
  if (tmptmp != "")
  {  
     if ( tmptmp.endsWith( ".svg" ) ) 
     {
        if (access(q->KSVGPATH, F_OK))
          {
          QMessageBox* msg = new QMessageBox ( tr("Error"), tr("Configure ksvgtopng path before adding a svg file"), QMessageBox::Critical, QMessageBox::Ok, 0, 0);
          msg->exec();
          return;    
          }
        format = ".png";
        system( q->KSVGPATH + " "+QString::number( q->prop->imageW->value() )+" "+QString::number( q->prop->imageH->value() )+" \""+file_image.toString(0,0)+"\" "+qf.absPath()+"/qflashtmp/"+QString::number( fn )+format);
        file_image  = QUrl( qf.absPath()+"/qflashtmp/"+QString::number( fn )+format );
    }
    else
    {
      if (tmptmp.endsWith(".png")) format = ".png";
      if (tmptmp.endsWith(".xpm")) format = ".xpm";
      if (tmptmp.endsWith(".jpg")) format = ".jpg";
      if (tmptmp.endsWith(".gif")) format = ".gif";
      system("cp \"" +file_image.toString(0,0)+ "\" "+qf.absPath()+"/qflashtmp/" + QString::number( fn )+format );
      file_image  = QUrl( qf.absPath()+"/qflashtmp/"+QString::number( fn )+format );
    }

    image.load( file_image.toString(0,0));

    ImageItem* i = new ImageItem(image , canvas());
    i->fileName =  "qflashtmp/"+QString::number( fn )+format;
    if (q->prop->imagePos->isChecked())
       i->move( q->prop->imageX->value() + 150 , q->prop->imageY->value() + 150 );    
    else
       i->move(cenx - image.width()/2 , ceny - image.height()/2 );
    i->setZ( getZ() );
    i->show();
    choosen = i;
    moving = i;
    nodes();
    canvas()->setAllChanged ();
    canvas()->update ();

   } 
   break;
  }

 }//end of switch

}//end of 






 if (e->button() == RightButton)
 {
    Window * q = (Window*) parentWidget();
    rightButton = 1;
    if (q->getTool()==13 && zoom > -4) //zoom
    {
      QWMatrix m = worldMatrix ();
      m.scale (0.5, 0.5);
      setWorldMatrix (m);
      setContentsPos( (e->x()) /2 - width() /2, (e->y()) /2  - height() /2);
      zoom--;
      return;
    }

    if ((line1 !=NULL) || draggingAdjustItem )
    return;

    // the same in left button -start- //////////////////////////////////

    QCanvasItemList l = canvas ()->collisions (p); 

    if (l.isEmpty()) 
    {
       choosen = NULL;
       moving = NULL;
       multiSelect.clear();  
       hideNodes();
       canvas()->setAllChanged();
       canvas()->update();

    }
    else
    {
      QCanvasItemList::Iterator it = l.begin();
      moving = (QCanvasItem*) *it; 

//      if (moving->rtti() == 6666 || moving->rtti() == 670 ) //canvasitem (white square)
     if (!isValid(moving))
     {

        hideNodes();
        choosen = NULL;
        moving = NULL;
        multiSelect.clear();

        QPopupMenu* frame = new QPopupMenu (this);
        frame->insertItem (tr("Paste"),this,SLOT(paste()));
        if( !editingButton)
        frame->insertItem (trUtf8("Add ActionScript"), this, SLOT(addAS()));
        QPoint tmpP = contentsToViewport(mapToGlobal(e->pos()));
        frame->popup (QPoint(tmpP.x()+4, tmpP.y()+4));
        frame->exec ();
        frame->~QPopupMenu() ;
        rightButton = 0;

        return;

      }
      if (isValid(moving))
      choosen = moving;

     if ((choosen->rtti() == QCanvasItem::Rtti_Text || choosen->rtti() == 100) && multiSelect.count() < 2 )
     {

         text = (CanvasTextItem*) choosen;
         q->prop->setTool(4);
         if (choosen->rtti() == 100)
           q->prop->setTool(15);
         multiSelect.clear();
         nodes();

      }
     if(getGroup(moving) != NULL)
     {
       QCanvasItemList tmplist = getGroup(moving)->items;
       multiSelect = multiSelect + tmplist;
     }
     if(isValid(moving) && multiSelect.contains(moving))
     {
       nodes();
     }
     if (isValid(moving) && !multiSelect.contains(moving))
     {
       multiSelect.clear();
       nodes();
     }
    }
     // the same in left button -stop-  /////////////////////////////////////////////////////////

    if(!l.isEmpty())
    {

      QPopupMenu* frame = new QPopupMenu (this);
      frame->insertItem (tr("Bring forward"),this,SLOT(itemUp()));
      frame->insertItem (tr("Bring backward"),this,SLOT(itemDown()));
      frame->insertSeparator();
      frame->insertItem (tr("Cut"),this,SLOT(cut()));
      frame->insertItem (tr("Copy"),this,SLOT(copy()));
      frame->insertItem (tr("Paste"),this,SLOT(paste()));
      frame->insertItem (tr("Remove"), this, SLOT(menuDelete()));
      frame->insertSeparator();
      frame->insertItem (tr("Change name (for ActionScript)"), this, SLOT(nameChange()));

      if (!editingButton)
      {
        frame->insertSeparator();
        frame->insertItem (trUtf8("Group"), this, SLOT(group()));
        frame->insertItem (trUtf8("Ungroup"), this, SLOT(ungroup()));
      }
      /*frame->insertItem (trUtf8("Add effect"), this, SLOT(addEffect()));
      frame->insertItem (tr("Rotate clockwise"),this,SLOT(rotate()));
      frame->insertItem (tr("Rotate anticlockwise"),this,SLOT(unrotate()));
      frame->insertSeparator();
      frame->insertItem (tr("Properties"));
      */
      frame->popup (contentsToViewport(mapToGlobal(e->pos())));
      frame->exec ();
      frame->~QPopupMenu() ;
      rightButton = 0;

    }
    else
    {
      hideNodes();
      choosen = NULL;
      moving = NULL;
      multiSelect.clear();
      QPopupMenu* frame = new QPopupMenu (this);
      frame->insertItem (tr("Paste"),this,SLOT(paste()));
      if( !editingButton)
      frame->insertItem (trUtf8("Add ActionScript"), this, SLOT(addAS()));
      QPoint tmpP = contentsToViewport(mapToGlobal(e->pos()));
      frame->popup (QPoint(tmpP.x()+4, tmpP.y()+4));
      frame->exec ();
      frame->~QPopupMenu() ;
      rightButton = 0;
    }

  }


}



void Editor::contentsMouseMoveEvent(QMouseEvent* e)
{

  if (rightButton) return;

  QPoint p = QPoint(inverseWorldMatrix().map(e->pos()));
  movx = p.x();
  movy = p.y();

  if (1)
 {
   Window * q = (Window*) parentWidget();
   
   switch(q->getTool())
    {
    case 1: //select
    {
      if (moving != NULL)
      {
	if (moving->rtti() == 6666 || moving->rtti() == 670 )
        {
	  moving = NULL;
	  multiSelect.clear();
	}
	else
	{ 
	  if (moving->rtti() != 666)
            multiSelect = filterSelection(multiSelect);
        }
      }

      if (moving == NULL && multiSelect.isEmpty()) // select many objects
      {
	 if(line1==NULL)
         {
	   line1= new QCanvasLine(canvas());
           line2= new QCanvasLine(canvas());  
           line3= new QCanvasLine(canvas());     
           line4= new QCanvasLine(canvas());
           line1->setZ(20000);
           line2->setZ(20000);
           line3->setZ(20000);
           line4->setZ(20000);  

           QColor c= Qt::green;

           line1->setPen(c);
           line2->setPen(c);
           line3->setPen(c);
           line4->setPen(c);

         }
       line1->setPoints(cenx, ceny, movx, ceny);
       line2->setPoints(cenx, ceny, cenx, movy);
       line3->setPoints(cenx, movy, movx, movy);
       line4->setPoints(movx, ceny, movx, movy);

       line1->show();
       line2->show();
       line3->show();
       line4->show();
       canvas()->setAllChanged();
       canvas()->update ();
       break;
    }

    if (moving != NULL && multiSelect.isEmpty())
    {


      if ( moving->rtti() == 6969 )
      {
         Window * q = (Window*) parentWidget();
         q->changeAdjusts(p.x()-3, p.y()-3 );
         int horizontal = (int) moving->x() -150;
         if (horizontal < 7) horizontal = 7;
         int vertical  = (int) moving->y() -150;
         if (vertical < 7) vertical = 7;
         q->h = horizontal-4;
         q->v = vertical-4;

         if (!editingButton)
         {
           ((Canvas*) canvas())->adjustSizeText->setText( QString::number( q->h) + "x" + QString::number( q->v) );
           ((Canvas*) canvas())->adjustSizeText->move( p.x(), p.y() + 15);
           ((Canvas*) canvas())->adjustSizeText->show();
         }
         updateAll();
         break;
      }
    break;
    }
    if (!multiSelect.isEmpty())
    {

      if ( multiSelect.count() != 1 )
        hideNodes();
      if ((moving->rtti() == 666) && (multiSelect.count() != 1))
      break;
 
      QCanvasItem* tempItem;
      for (QCanvasItemList::Iterator it = multiSelect.begin(); it != multiSelect.end(); it++)  
      { 
        tempItem = (QCanvasItem*) *it;
        if ( isValid(tempItem) && ((moving->rtti() != 666) ))
        {
           if (!moveGroup(tempItem)) //returns 0 if it doesn't belong to a group
           {
             if (getTextBox(tempItem) != NULL)
             {
                 getTextBox(tempItem)->moveBy(movx - cenx , movy - ceny );
                 moveNodes(movx - cenx , movy - ceny );
             }
             else
             {
               tempItem->moveBy(movx - cenx , movy - ceny );
               moveNodes(movx - cenx , movy - ceny );
             }
           }

        }

        if ((moving->rtti() == 666) && (multiSelect.count() == 1))
        {
          nodeChanged(movx - cenx, movy - ceny);
          canvas()->setAllChanged();
          canvas()->update();
          return;
        }
      }
 
      cenx = movx;
      ceny = movy;
    }
   
   canvas()->setAllChanged();
   canvas()->update();
   break;
  }
 case 2: //line
 {
  line->setPoints(cenx,ceny,movx, movy);
  moving = (QCanvasItem*) line;
  nodes();
  canvas()->setAllChanged();
  canvas()->update ();
 break;
 }
 
 case 3: //bezier
 {
 }
 case 4: //text
 break;
 case 5: //rubber
 break;
 
 case 6: //polygon
 {
   if(q->prop->toolButtonRegular->isOn() == 0 && q->prop->toolButtonStar->isOn() == 0 )
   {
     break;
   }
   else
   {
       regu->ri = (int) sqrt(  (abs(movx - cenx)*0.4)*(abs(movx - cenx)*0.4)   +   (abs(movy - ceny)*0.4)*(abs(movy - ceny)*0.4))        ;
       regu->re = (int) 1.5*sqrt(  (abs(movx - cenx)*0.4)*(abs(movx - cenx))   +   (abs(movy - ceny)*0.4)*(abs(movy - ceny)));
       regu->show();
       canvas()->setAllChanged();
       canvas()->update();
   }
 break;
 }
 
 case 7: //circle
 {
  oval->setSize( (int)2.85 * abs(movx - cenx), (int)2.85 * abs(movy - ceny) );
  moving = (QCanvasItem*) oval;
  nodes();
  canvas()->setAllChanged();
  canvas()->update ();
  break;
 }
 
 case 8: //rectngle
 {
  rect->setSize(movx - cenx, movy - ceny);
  moving = (QCanvasItem*) rect;
  nodes();
  canvas()->setAllChanged();
  canvas()->update ();
  break;
 }
 
 case 9: //brush
 {
   if (sqrt( (double) (eo.x()-e->pos().x())*(eo.x()-e->pos().x()) + (eo.y()-e->pos().y())*(eo.y()-e->pos().y()) ) > 6 )
   {
     QPainter p1 (viewport());
     p1.drawLine( contentsToViewport(eo).x(), contentsToViewport(eo).y() ,  contentsToViewport(e->pos()).x(), contentsToViewport(e->pos()).y());
     pt = new QPoint ((e->pos ()));
     eo = e->pos();
     points.append (pt);
   }
 break;
 }
 
 case 10: //pencil
 {
   if (sqrt( (double) (eo.x()-e->pos().x())*(eo.x()-e->pos().x()) + (eo.y()-e->pos().y())*(eo.y()-e->pos().y()) ) > 6 )
   {
    QPainter p1 (viewport ());
    p1.drawLine( contentsToViewport(eo).x(), contentsToViewport(eo).y() , contentsToViewport(e->pos()).x(), contentsToViewport(e->pos()).y());
    pt = new QPoint ((e->pos ()));
    eo = e->pos();
    points.append (pt);
   }
 break;
 }
 
 case 11: //inktool -bordes- 
 break;
 
 case 12: //paintool -relleno-
 {
 break;
 }
 
 case 13: //zoom
 break;
 
 case 14: //handmove
 { 
  int x = -(movx - cenx), y = -(movy - ceny);
  scrollBy (x, y);
  break;
 }
 
 case 15: //textbox
 break;
 
 case 16: //movie
 break;
 
 case 17: //button
 break;
 
 case 18: //image
 break;
 }
}
}


void Editor::contentsMouseReleaseEvent(QMouseEvent* e)
{

  QPoint p = QPoint(inverseWorldMatrix().map(e->pos()));

  if (!editingButton)
  ((Canvas*) canvas())->adjustSizeText->hide();

  if (e->button () == LeftButton) 
  {
      draggingAdjustItem = 0;

    Window * q = (Window*) parentWidget();
    switch(q->getTool())
    {


 case 1://select
 {
   tmp1 = 0;
   tmp2 = 0;
   
   QPoint start, end;

   if (multiSelect.count()>1)
   {
     nodes();
     break;
   }
   q->update();

     //new action for undo function
    /* if (moving != NULL)
     if ((moving->rtti() == 666) && (multiSelect.count() == 1))
     {   
       action* tmpAction = new action();
       QCanvasItemList l;
       l.append(moving);
       tmpAction->target = l;
       tmpAction->definition = 3;

       cout  << p.x() << "now" << endl;
       cout << origX << " orig" << endl;
       cout << p.x() - origX << endl;
       cout << (const int* )p.x() - origX << endl;

       tmpAction->data1 = p.x() - origX;
       tmpAction->data2 = p.y() - origY;
       
       undoActionList->actions.append(tmpAction);
       break;

         
//      action->target = multiSelect;

   }*/
   
   if(line1!=NULL)
   { 
     start = line1->startPoint();
     end = line4->endPoint();
     delete line1;
     delete line2;
     delete line3;
     delete line4;
     line1 = NULL;
   }
   else break;
   
   QCanvasItemList list = canvas()->collisions(QRect(start, end));
   list = filterSelection( list );
   if (list.isEmpty())
   {
     choosen = NULL;
     multiSelect.clear();
     nodes();
     canvas()->setAllChanged();
     canvas()->update();
     break;
   }
   multiSelect = filterSelection(list);
   if (multiSelect.count() == 1)
    choosen = *multiSelect.at(0);
   nodes();
   Window * q = (Window*) parentWidget();
   q->update();
   break; 
 }
 
 case 2: //line
 break;
 
 case 3: //bezier
 {
  break;
 }
 
 case 4: //text
 break;
 
 case 5: //rubber
 break;
 
 case 6: //polygon
 {
    if ( q->prop->toolButtonRegular->isOn() == 1|| q->prop->toolButtonStar->isOn() == 1)
    {

    reguEnd = new Regular( canvas() );
    reguEnd->setPen (q->colors->l);
    reguEnd->setBrush (q->colors->r);  
    reguEnd->p = regu->p ;
    reguEnd->ri = regu->ri;
    reguEnd->re = regu->re;
    reguEnd->di = regu->di;
    reguEnd->de = regu->de;
    reguEnd->star = regu->star;
    reguEnd->setX( cenx );
    reguEnd->setY( ceny );
    reguEnd->setZ( getZ() );
    reguEnd->show();
    regu->hide();
    moving =  reguEnd;
    choosen = reguEnd;
    nodes();
    delete regu;
    canvas()->setAllChanged();
    canvas()->update();
    break;
    }
  break;
  }

 case 7: //circle
 break;
 case 8: //rectngle
 break;
 
 case 9: //brush
 {
   pa = QPointArray (points.count ());
   int i = 0;
   for (QPoint * it = points.first (); it; it = points.next ())
   {
     pa[i] = (*it);
     i++;
   }
   brush->polyline = pa;
   brush->show();
   choosen = brush;
   moving = brush;
   nodes();
   canvas()->setAllChanged();
   canvas()->update();
   break ;
 }
  
 case 10: //pencil
 {
    pa = QPointArray (points.count ());
    int i = 0;
    for (QPoint * it = points.first (); it; it = points.next ())
    {
       pa[i] = (*it);
       i++;
    }
    poly = new Polygon(canvas());
    poly->polyline = pa;
    poly->setPoints(pa);
    poly->setZ( getZ() );
    poly->setPen(q->colors->l);
    poly->setBrush (q->colors->r);
    poly->show();
    choosen = poly;
    moving = poly;
    nodes();
    canvas ()->setAllChanged ();
    canvas()->update();
    pol = 0;
    break;

 }
 
 case 11: //inktool -bordes- 
 break;
 
 case 12: //paintool -relleno-
 break;
 
 case 13: //zoom
 break;
 
 case 14: //handmove
 break;
 
 case 15: //textbox
 break;
 
 case 16: //movie
 break;
 
 case 17: //button
 break;
 
 case 18: //image
 break; 
 }

}

  if (e->button () == RightButton) 
   rightButton = 0;







}


void Editor::contentsMouseDoubleClickEvent(QMouseEvent* e)
{             
QPoint p = QPoint(inverseWorldMatrix().map(e->pos()));

if (e->button () == LeftButton) { Window * q = (Window*) parentWidget();
switch(q->getTool())
 {
  
 case 1:
 {
  if (moving == NULL) break;
  if ( moving->rtti() == 6969 )
      {
         Window * q = (Window*) parentWidget();
         q->editProp();
         break;
      }
  break;
 }
  
  
 case 6: //polygon
 {
  if((q->prop->toolButtonRegular->isOn() == 1 || q->prop->toolButtonStar->isOn() == 1))  // it creates a regular polygon
  {
    regu = new Regular( canvas() );
    regu->setPen (q->colors->l);
    regu->setBrush (q->colors->r);  
    regu->p = q->prop->spinP->value() ;
    regu->ri = 100;
    regu->re = 100;
    regu->di = 0;
    regu->de = 0;
    if (q->prop->toolButtonStar->isOn() == 1)
       regu->star = 1;
    else
       regu->star = 0;
    regu->setX( cenx );
    regu->setY( ceny );
    regu->setZ( getZ() );
    regu->show();
    return;
  }


     pa = QPointArray (points.count ());
     int i = 0;
     for (QPoint * it = points.first (); it; it = points.next ())
     {
        pa[i] = (*it);
        i++;
     }
     poly->polyline = pa;
     poly->setPoints(pa);
     poly->setPen(q->colors->l);
     poly->setBrush (q->colors->r);
     poly->show();
     choosen = poly;
     moving = (QCanvasItem*) poly;
     nodes();
     canvas ()->setAllChanged ();
     canvas()->update();
     pol = 0;
     break;

 }
 }
}
}


void Editor::enterEvent (QEvent*)
{
Window * q = (Window*) parentWidget();
switch(q->getTool())
{
 case 1: //select
 break; 
 
 case 2: //line
 break;
 
 case 3: //bezier
 break;
 
 case 4: //text
 break;
 
 case 5: //rubber
 {
   setCursor (eraserCursor);
   break;
 }
 case 6: //polygon
 break;
 
 case 7: //circle
 {
   setCursor (Qt::CrossCursor);
   break;
 }
 
 case 8: //rectngle
 {
   setCursor (Qt::CrossCursor);
   break;
 }
 
 case 9: //brush
 break;
 
 case 10: //pencil
 break;
 
 case 11: //inktool -bordes- 
 {
   setCursor (inkbottleCursor);
   break;
 }
 
 case 12: //paintool -relleno-
 {
   setCursor (paintbucketCursor);
   break;
 }
 
 case 13: //zoom
 break;
 
 case 14: //handmove
 break;
 
 case 15: //textbox
 break;
 
 case 16: //movie
 break;
 
 case 17: //button
 {
   setCursor( Qt::PointingHandCursor );
   break;
 }
 case 18: //image
 break;

}
}


void Editor::leaveEvent (QEvent*)
{
  setCursor (Qt::ArrowCursor);
}


void Editor::updateAll()
{
  Window * q = (Window*) parentWidget();
  for (int i=0; i<q->frames; i++)
  {
    q->can.at(i)->back->setBrush(q->c);
    q->can.at(i)->back->setSize(q->h, q->v);
  }  
  canvas()->update();

}


void Editor::hideNodes()
{
    Window * q = (Window*) parentWidget();
      q->updateStatusBar();

    if (moving != NULL)
       if (!isValid(moving) && moving->rtti() != 670 )//&& moving->rtti() != 6666 )//(moving->rtti() == 666 || moving->rtti() == 668 || moving->rtti() == 6969 )
         return;
    if (textHighlight != NULL)
    {
       textHighlight->hide();
       delete textHighlight;
       textHighlight = NULL;
    }
    QCanvasItem* tmp;
    QCanvasItemList l = canvas ()->allItems(); 
    QCanvasItemList filtered;
    if (l.isEmpty()) return;
    for(QCanvasItemList::Iterator it = l.begin(); it != l.end(); it++)
    {
      tmp = (QCanvasItem*) *it;
      if (tmp->rtti() == 666 || tmp->rtti() == 668 || isValid(tmp))
         filtered.append(tmp);
    }
    if (filtered.isEmpty()) return;
    for(QCanvasItemList::Iterator it = filtered.begin(); it != filtered.end(); it++)
    {
      tmp = (QCanvasItem*) *it;
      if (tmp->rtti() == 666) 
      {
        tmp->hide();
        delete tmp;
        tmp = NULL;
      }
      if (tmp != NULL)
      {
        if(tmp->rtti() == 668)
        {
         tmp->hide();
         delete tmp;
        }
        else
        {
          if (getGroup(tmp) != NULL)
          { 
            getGroup(tmp)->hideNodes();
          }
        }
      }
    }
    canvas()->setAllChanged();
    canvas()->update();
}


void Editor::moveNodes(double dx, double dy)
{

    QCanvasItem* tmp;
    QCanvasItemList l = canvas ()->allItems(); 
    if (l.isEmpty()) return;
    
    for( QCanvasItemList::Iterator it = l.begin(); it != l.end(); it++)
    {
       tmp = (QCanvasItem*) *it;
       if (tmp->rtti() == 666 || tmp->rtti() == 668 ) 
       {
         tmp->moveBy(dx, dy);
       }
    }
}

void Editor::nodes()
{
  Window * q = (Window*) parentWidget();
    q->updateStatusBar();

  hideNodes();
  if (choosen == NULL && multiSelect.isEmpty())
     return;
     
  if (choosen != NULL && multiSelect.isEmpty())
     multiSelect.append(choosen);

  for( QCanvasItemList::Iterator it = multiSelect.begin(); it != multiSelect.end(); it++)
  {
    moving = (QCanvasItem*) *it;
    if (getGroup(moving) != NULL)
      {
        ((itemGroup*)getGroup(moving))->showNodes();
      }
    else
    switch (moving->rtti())
    {
     
      case QCanvasItem::Rtti_Rectangle:
      {
         RectItem* selected;
         selected = (RectItem*) moving;
         selected->showNodes();
         break;
      }
      
      case QCanvasItem::Rtti_Ellipse:
      {
         OvalItem* selected;
         selected = (OvalItem*) moving;
         selected->showNodes();
         break;
      }
      
      case QCanvasItem::Rtti_Line:
      {
         LineItem* selected;
         selected = (LineItem*) moving;
         selected->showNodes();
         break;
      }
      
      case QCanvasItem::Rtti_Polygon:
      {
         Polygon* selected;
         selected = (Polygon*) moving;
         selected->showNodes();
         break;
      }
      
      case QCanvasItem::Rtti_Text:
      {
         CanvasTextItem* selected;
         selected = (CanvasTextItem*) moving;
         QRect highlight = selected->boundingRect();
         textHighlight = new textHighlightItem( highlight, canvas() );
         textHighlight->setZ(moving->z()-1);
         textHighlight->show();
         break;
      }
            
      case 86:
      {
         ImageItem* selected;
         selected = (ImageItem*) moving;
         selected->showNodes();
         break;
      }
      
      case 87:
      {
//          PencilItem* selected;
//          selected = (PencilItem*) moving;
//          selected->showNodes();
         break;
      }
      
      case 88:
      {
         BrushItem* selected;
         selected = (BrushItem*) moving;
         selected->showNodes();
         break;
      }
            
      case 89:
      {
         Regular* selected;
         selected = (Regular*) moving;
         selected->showNodes();
         break;
      }
      case 100:
      {
         CanvasTextItem* selected;
         selected = (CanvasTextItem*) moving;
         QRect highlight = selected->boundingRect();
         textHighlight = new textHighlightItem( highlight, canvas() );
         textHighlight->setZ(moving->z()-1);
         textHighlight->show();
         break;
      }
      case 101:
      {
         TextBoxBack* selected;
         selected = (TextBoxBack*) moving;
         selected->showNodes();
         break;
      }

      default:
        break;
    } 
 }
  canvas()->setAllChanged();
  canvas()->update();


}






void Editor::copy()
{
  hideNodes();
  if (choosen == NULL) return;
  buffered = choosen;
  cutt = 0;
}

void Editor::cut()
{
  hideNodes();
  if (choosen == NULL) return;
  buffered = choosen;
  if (getGroup(buffered) != NULL)
    for (QCanvasItemList::Iterator it = getGroup(buffered)->items.begin(); it != getGroup(buffered)->items.end(); it++)  
    {
      moving = *it;
      moving->hide();
    }
  buffered->hide();
  canvas()->setAllChanged();
  canvas()->update(); 
  cutt = 1;
}



void Editor::paste(bool window)
{
  multiSelect.clear();
  hideNodes();
  QPtrList<QPoint> pointArray;
  
  if (buffered != NULL)
  {
    QCanvasItemList tempList; 
    
    
    if (getGroup(buffered) != NULL )
    {
      int relativeX;
      int relativeY;
      relativeX = (int) buffered->x();
      relativeY = (int) buffered->y();
      
      if (buffered->rtti() == QCanvasItem::Rtti_Line)
      { 
        LineItem* tmpLine = (LineItem*) buffered;
        relativeX = tmpLine->startPoint().x();
        relativeY = tmpLine->startPoint().y();
      }
      
      if (buffered->rtti() == QCanvasItem::Rtti_Polygon)
      { 
        Polygon* tmpPol = (Polygon*) buffered;
        relativeX = tmpPol->points().at(0).x();
        relativeY = tmpPol->points().at(0).y();
      }
      if(buffered->rtti() == 87)
      {
//         PencilItem* tmpPen = (PencilItem*) buffered;
//         relativeX = tmpPen->polyline.at(0).x();
//         relativeY = tmpPen->polyline.at(0).y();
      }
      if(buffered->rtti() == 88)
      {
        BrushItem* tmpBru = (BrushItem*) buffered;
        relativeX = tmpBru->polyline.at(0).x();
        relativeY = tmpBru->polyline.at(0).y();
      }

      if (window)
      {
        cenx = relativeX;
        ceny = relativeY;
      }
      tempList = getGroup(buffered)->items;
      for (QCanvasItemList::Iterator it = tempList.begin(); it != tempList.end(); it++)  
      {
        moving = *it;
        QPoint* tmpPoint;
        switch(moving->rtti())
        {
          case QCanvasItem::Rtti_Line:
          {
            LineItem* tmpLine = (LineItem*) moving;
            tmpPoint = new QPoint(tmpLine->startPoint().x() - relativeX, tmpLine->startPoint().y() - relativeY );
            break;
          } 
          case QCanvasItem::Rtti_Polygon:
          {
            Polygon* tmpPol = (Polygon*) moving;
            tmpPoint = new QPoint(tmpPol->points().at(0).x() - relativeX, tmpPol->points().at(0).y() - relativeY );
            break;
          }
          case 87:
          {
//             PencilItem* tmpPen = (PencilItem*) moving;
//             tmpPoint = new QPoint(tmpPen->polyline.at(0).x() - relativeX, tmpPen->polyline.at(0).y() - relativeY );
            break;
          }
          case 88:
          {
            BrushItem* tmpBru = (BrushItem*) moving;
            tmpPoint = new QPoint(tmpBru->polyline.at(0).x() - relativeX, tmpBru->polyline.at(0).y() - relativeY );

            break;
          }
          default:
          {
            tmpPoint = new QPoint((int) moving->x() - relativeX, (int) moving->y() - relativeY );
          }
        }
        pointArray.append(tmpPoint);
      }

    }

    else
      tempList.append(buffered);
    for (QCanvasItemList::Iterator it = tempList.begin(); it != tempList.end(); it++)
    {
      QCanvasItem* tempItem = *it;
      if (getTextBox(tempItem) != NULL)
      {
         Window * q = (Window*) parentWidget();
         int zDifference = (q->layer - ((int) (tempItem->z()/3000)))*3000;
         TextBox* textb = new TextBox(getTextBox(tempItem), canvas() );
         textb->setX(cenx);
         textb->setY(ceny);
         textb->setZ((int)textb->boxBack->z() + zDifference);

      }
      else
      {
        Window * q = (Window*) parentWidget();
        int zDifference = (q->layer - ((int) (tempItem->z()/3000)))*3000;
        QCanvasItem* temp = copyItem(*it);
        temp->setZ( temp->z() + zDifference);
        if (getGroup(buffered) != NULL)
           multiSelect.append(temp);
        if (temp!=NULL)
        {

            if (temp->rtti() == QCanvasItem::Rtti_Rectangle || temp->rtti() == QCanvasItem::Rtti_Ellipse || temp->rtti() == 86 || temp->rtti() == 89 || temp->rtti() == QCanvasItem::Rtti_Text)
            {
                temp->setX(cenx);
                temp->setY(ceny);
            }

            if (temp->rtti() == QCanvasItem::Rtti_Line )
            {
              LineItem* tempLine = (LineItem*) temp;
              temp->moveBy(cenx - tempLine->startPoint().x(), ceny - tempLine->startPoint().y());
            }


          }

      }

    }

    if (!pointArray.isEmpty())
    {
      int i = 0;

      for (QCanvasItemList::Iterator it = multiSelect.begin(); it != multiSelect.end(); it++)  
      {
        moving = *it;
        switch(moving->rtti())
        {
          default:
          {
            moving->moveBy( pointArray.at(i)->x(), pointArray.at(i)->y());
          }
        }
      i++;
      }
    }
    
    if ( (multiSelect.count() > 1) || ( getButton(buffered) != NULL  ) )
    {
      if (getButton(buffered) == NULL)
        group();
      else
      {
        Window * q = (Window*) parentWidget();
        ButtonItem* newButton = new ButtonItem(getButton(buffered), q);
        newButton->dx += cenx - buffered->x();
        newButton->dy += ceny - buffered->y();
        group(newButton);
      }
    }
    if (cutt)
      deleteShape(buffered);

  }
  moving = NULL;

  canvas()->setAllChanged();
  canvas()->update();
}


QCanvasItem* Editor::copyItem(QCanvasItem* tempItem)
{
   switch (tempItem->rtti())
       {
       
       case QCanvasItem::Rtti_Rectangle:
       {
            RectItem* item = new RectItem( (RectItem*) tempItem, canvas());
            return item;
       }
       case QCanvasItem::Rtti_Ellipse:
       {
            OvalItem* item = new OvalItem( (OvalItem*) tempItem, canvas());
            return item;
       }
       case QCanvasItem::Rtti_Line:
       {
            LineItem* item = new LineItem( (LineItem*) tempItem, canvas());
            return item;
       }
       case QCanvasItem::Rtti_Polygon:
       {
            Polygon* tempPol = (Polygon*) tempItem;    
            Polygon* item = new Polygon( (Polygon*) tempItem, canvas(), cenx- tempPol->polyline.at(0).x(), ceny- tempPol->polyline.at(0).y());
            return item;
       }
       case QCanvasItem::Rtti_Text:
       {
            CanvasTextItem* item = new CanvasTextItem( (CanvasTextItem*) tempItem, canvas());
            return item;
       }
       case 86:
       {
            ImageItem* item = new ImageItem( (ImageItem*) tempItem, canvas());
            return item;
       }
       case 87:
       {
//             PencilItem* tempPol = (PencilItem*) tempItem;
//             PencilItem* item = new PencilItem( (PencilItem*) tempItem, canvas(), cenx - tempPol->polyline.at(0).x()
// , ceny - tempPol->polyline.at(0).y() );
//             return item;
       }
       case 88:
       {
            BrushItem* tempPol = (BrushItem*) tempItem;
            BrushItem* item = new BrushItem( (BrushItem*) tempItem, canvas(), cenx - tempPol->polyline.at(0).x(), ceny - tempPol->polyline.at(0).y() );
            return item;
       }
       case 89:
       {
            Regular* item = new Regular( (Regular*) tempItem, canvas());
            return item;
       }
       default:
         break;
     }
  //if nothing has been returned yet
  return NULL;
}

void Editor::itemDown()
{
  if (choosen == NULL) return;
  if (isValid(choosen))
  {
    Window * q = (Window*) parentWidget();
    choosen->setZ(10+q->layer*3000);
    canvas()->setAllChanged();
    canvas()->update();
  }
}

void Editor::itemUp()
{
  if (choosen == NULL) return;
  if (isValid(choosen))
  {
    choosen->setZ(getZ());
    canvas()->setAllChanged();
    canvas()->update();
  }
}

void Editor::deleteShape(QCanvasItem* shape)
{
   hideNodes();
   canvas()->setAllChanged();

   if (!isValid(shape)) return;

   if (getTextBox(shape) != NULL)
   {
     TextBox* tmpBox = getTextBox(shape);
     tmpBox->boxText->hide();
     tmpBox->boxBack->hide();

     delete tmpBox->boxText;
     delete tmpBox->boxBack;


     buffered = NULL;
     moving = NULL;
     choosen = NULL;
     multiSelect.clear();
     canvas ()->setAllChanged ();
     canvas()->update();
     return;
   }

   QCanvasItemList tempList;
   if (getGroup(shape) != NULL)
        tempList = getGroup(shape)->items;
   else
      tempList.append(shape);

   for (QCanvasItemList::Iterator it = tempList.begin(); it != tempList.end(); it++)  
   {
     moving = *it;
     moving->hide();


     if (moving->rtti () != 88 && moving->rtti () != 87 && moving->rtti () != 89)
     {
       delete moving;
     }
     else
     {
       if (moving->rtti () == 87)
       {
//          PencilItem* tmppenc = (PencilItem*) moving;
//
//          tmppenc->grouped = 0;
//          tmppenc->group = NULL;
//          tmppenc->view = 0;
       }
       if (moving->rtti () == 88)
       {
         BrushItem* tmpbrush = (BrushItem*) moving;
         tmpbrush->grouped = 0;
         tmpbrush->group = NULL;
         tmpbrush->view = 0;
       }
       if (moving->rtti() == 89)
       {
         Regular* tmpreg = (Regular*) shape;
         tmpreg->grouped = 0;
         tmpreg->group = NULL;
         tmpreg->view = 0;
       }
       setName("", moving);
     }
   }

   buffered = NULL;
   moving = NULL;
   choosen = NULL;
   multiSelect.clear();
   canvas ()->setAllChanged ();
   canvas()->update();
}

void Editor::menuDelete()
{
  deleteShape( moving ); 
}

int Editor::getZ()
{
  Window * q = (Window*) parentWidget();
  
  if (!editingButton)
  { 
    Canvas* tmpCanvas = (Canvas*) canvas();
    tmpCanvas->z = tmpCanvas->z + 1;
    return (int) (tmpCanvas->z + q->layer*3000);
  }
  else
  { 
    Canvas* tmpCanvas = (Canvas*) button->canvasButton;
    tmpCanvas->z = tmpCanvas->z + 1;
    return (int) (tmpCanvas->z + q->layer*3000);
  }
}


void Editor::addAS(int frame)
{
  Window * q = (Window*) parentWidget();

  if (frame == -1 ) frame = q->currentFrame;
  updateNames();
  asDialog *dlg = new asDialog(animAction, frame, names);
  if ( dlg->exec() == QDialog::Accepted ) 
  {
    animAction = dlg->aActions;
  }
  else
    return;

  delete dlg;

}
 
int Editor::addEffect()
{
   moving = choosen;
   if (!isValid(choosen)) return 0;
    
 QCanvasItem* tempItem = moving;
   
 switch (moving->rtti())
 {



       case QCanvasItem::Rtti_Rectangle:
       {
            RectItem* tmp = (RectItem*) moving;
            if (tmp->effect == 1) return 0;
            prepareEffect();
            RectItem* item = new RectItem( (RectItem*) tempItem, canvas());
            item->effect = 1;
            deleteShape(tmp);
            item->setZ(getZ());
            break;
       }
       case QCanvasItem::Rtti_Ellipse:
       {
            OvalItem* tmp = (OvalItem*) moving;
            if (tmp->effect == 1) return 0;
            prepareEffect();
            OvalItem* item = new OvalItem( (OvalItem*) tempItem, canvas());
            item->effect = 1;
            deleteShape(tmp);
            item->setZ(getZ());
            break;
       }
       case QCanvasItem::Rtti_Line:
       {
            LineItem* tmp = (LineItem*) moving;
            if (tmp->effect == 1) return 0;
            prepareEffect();
            LineItem* item = new LineItem( (LineItem*) tempItem, canvas());
            item->effect = 1;
            deleteShape(tmp);
            item->setZ(getZ());
            break;
       }
       case QCanvasItem::Rtti_Polygon:
       {
            Polygon* tmp = (Polygon*) moving;
            if (tmp->effect == 1) return 0;
            prepareEffect();
//             Polygon* tempPol = (Polygon*) moving;     
            Polygon* item = new Polygon( (Polygon*) tempItem, canvas());
            item->effect = 1;
            deleteShape(tmp);
            item->setZ(getZ());
            break;
       }
       case QCanvasItem::Rtti_Text:
       {
            CanvasTextItem* tmp = (CanvasTextItem*) moving;
            if (tmp->effect == 1) return 0;
            prepareEffect();
            CanvasTextItem* item = new CanvasTextItem( (CanvasTextItem*) tempItem, canvas());
            item->effect = 1;
            deleteShape(tmp);
            item->setZ(getZ());
            break;
       }
       case 86:
       {
            ImageItem* tmp = (ImageItem*) moving;
            if (tmp->effect == 1) return 0;
            prepareEffect();
            ImageItem* item = new ImageItem( (ImageItem*) tempItem, canvas());
            item->effect = 1;
            deleteShape(tmp);
            item->setZ(getZ());
            break;
       }
       case 87:
       {
//             PencilItem* tmp = (PencilItem*) moving;
//             if (tmp->effect == 1) return 0;
//             prepareEffect();
//             PencilItem* item = new PencilItem( (PencilItem*) tempItem, canvas());
//             item->effect = 1;
//             deleteShape(tmp);
//             item->setZ(getZ());
            break;
       }
       case 88:
       {
            BrushItem* tmp = (BrushItem*) moving;
            if (tmp->effect == 1) return 0;
            prepareEffect();
            BrushItem* item = new BrushItem( (BrushItem*) tempItem, canvas());
            item->effect = 1;
            deleteShape(tmp);
            item->setZ(getZ());
            break;
       }
       case 89:
       {
            Regular* tmp = (Regular*) moving;
            if (tmp->effect == 1) return 0;
            prepareEffect();
            Regular* item = new Regular( (Regular*) tempItem, canvas());
            item->effect = 1;
            deleteShape(tmp);
            item->setZ(getZ());
            break;
       }

  }
 
 moving = NULL;
 choosen = NULL;
 
 return 1;

}

void Editor::prepareEffect()
{  
  Window * q = (Window*) parentWidget();
  q->time->list->insertLayer( q->currentFrame );
  hideNodes();
  cutt = 1;
  setCanvas( q->can.at(q->currentFrame) );
  q->layer = q->maxlayer;
  q->time->list->setSelected( q->time->list->itemAt( QPoint(1,1) ), 1 );
  //paste();
   
}

bool Editor::isValid(QCanvasItem* tempItem)
{
  if(tempItem->rtti() == QCanvasItem::Rtti_Ellipse || tempItem->rtti () == QCanvasItem::Rtti_Line || tempItem->rtti () == QCanvasItem::Rtti_Polygon || tempItem->rtti () == QCanvasItem::Rtti_PolygonalItem || tempItem->rtti () == QCanvasItem::Rtti_Rectangle || tempItem->rtti () == QCanvasItem::Rtti_Spline  || tempItem->rtti () == QCanvasItem::Rtti_Text || tempItem->rtti () == 86 || tempItem->rtti () == 87 || tempItem->rtti () == 88 || tempItem->rtti () == 89 || tempItem->rtti () == 100 || tempItem->rtti () == 101 )
  return 1;

  return 0;
}

itemGroup* Editor::group(ButtonItem* tmpButton)
{

  moving = NULL;
  itemGroup* tmpGroup = new itemGroup(canvas());
  QCanvasItemList newSelect;
  multiSelect = filterSelection(multiSelect);
  for (QCanvasItemList::Iterator it = multiSelect.begin(); it != multiSelect.end(); it++)  
  { 
    moving = *it;
    if (getGroup(moving) != NULL)
    {
      if (getButton(moving) == NULL)
      {
        QCanvasItemList tmplist = getGroup(moving)->items;
        newSelect = newSelect + tmplist;
        getGroup(moving)->hideNodes();
      }
    }
    else
     if ( getTextBox(moving) == NULL ) 
      newSelect.append(moving);
  }
  if ((newSelect.count() < 2) && (tmpButton == NULL))  return NULL;
  if (newSelect.count() < 1)  return NULL;


  tmpGroup->items = newSelect;

  if (tmpButton != NULL)
    tmpGroup->buttonGroup = tmpButton;

  for (QCanvasItemList::Iterator it = newSelect.begin(); it != newSelect.end(); it++)  
  {
    moving = *it;
    switch (moving->rtti())
    {

       case QCanvasItem::Rtti_Rectangle:
       {
            RectItem* tmp = (RectItem*) moving;
            tmp->grouped = 1;
            tmp->group = tmpGroup;
            if (tmpButton != NULL)
              tmp->button = 1;
            //item->setZ(getZ());
            break;
       }
       case QCanvasItem::Rtti_Ellipse:
       {
            OvalItem* tmp = (OvalItem*) moving;
            tmp->grouped = 1;
            tmp->group = tmpGroup;
            if (tmpButton != NULL)
              tmp->button = 1;
            //item->setZ(getZ());
            break;
       }
       case QCanvasItem::Rtti_Line:
       {
            LineItem* tmp = (LineItem*) moving;
            tmp->grouped = 1;
            tmp->group = tmpGroup;
            if (tmpButton != NULL)
              tmp->button = 1;
	    //item->setZ(getZ());
            break;
       }
       case QCanvasItem::Rtti_Polygon:
       {
            Polygon* tmp = (Polygon*) moving;
            tmp->grouped = 1;
            tmp->group = tmpGroup;
            if (tmpButton != NULL)
              tmp->button = 1;
	    //item->setZ(getZ());
            break;
       }
       case QCanvasItem::Rtti_Text:
       {
            CanvasTextItem* tmp = (CanvasTextItem*) moving;
            tmp->grouped = 1;
            tmp->group = tmpGroup;
            if (tmpButton != NULL)
              tmp->button = 1;
	    //item->setZ(getZ());
            break;
       }
       case 86:
       {
            ImageItem* tmp = (ImageItem*) moving;
            tmp->grouped = 1;
            tmp->group = tmpGroup;
            if (tmpButton != NULL)
              tmp->button = 1;
	    //item->setZ(getZ());
            break;
       }
       case 87:
       {
//             PencilItem* tmp = (PencilItem*) moving;
//             tmp->grouped = 1;
//             tmp->group = tmpGroup;
//             if (tmpButton != NULL)
//               tmp->button = 1;
	    //item->setZ(getZ());
            break;
       }
       case 88:
       {
            BrushItem* tmp = (BrushItem*) moving;
            tmp->grouped = 1;
            tmp->group = tmpGroup;
            if (tmpButton != NULL)
              tmp->button = 1;
	    //item->setZ(getZ());
            break;
       }
       case 89:
       {
            Regular* tmp = (Regular*) moving;
            tmp->grouped = 1;
            tmp->group = tmpGroup;
            if (tmpButton != NULL)
              tmp->button = 1;
	    //item->setZ(getZ());
            break;
       }
       case 100:
       {
            TextBoxText* tmp = (TextBoxText*) moving;
            tmp->grouped = 1;
            tmp->group = tmpGroup;
//             if (tmpButton != NULL)
//               tmp->button = 1;
	    //item->setZ(getZ());
            break;
       }
       case 101:
       {
            TextBoxBack* tmp = (TextBoxBack*) moving;
            tmp->grouped = 1;
            tmp->group = tmpGroup;
//             if (tmpButton != NULL)
//               tmp->button = 1;
	    //item->setZ(getZ());
            break;
       }
    }
  
  }
  tmpGroup->updatePoints();
  hideNodes();

  multiSelect.clear();
  multiSelect.append(moving);
 
  nodes();

  canvas()->setAllChanged();
  canvas()->update();

  return tmpGroup;
}

void Editor::ungroup()
{
  if (multiSelect.isEmpty() || editingButton ) return;
  QCanvasItemList::Iterator it = multiSelect.begin();
  moving = *it;
  itemGroup* tmpGroup = getGroup(moving);
  if (tmpGroup == NULL || getButton(moving) != NULL ) return;
  
  for (QCanvasItemList::Iterator it = tmpGroup->items.begin(); it != tmpGroup->items.end(); it++)  
  { 
    moving = *it;
    switch (moving->rtti())
    {

       case QCanvasItem::Rtti_Rectangle:
       {
            RectItem* tmp = (RectItem*) moving;
            tmp->grouped = 0;
            break;
       }
       case QCanvasItem::Rtti_Ellipse:
       {
            OvalItem* tmp = (OvalItem*) moving;
            tmp->grouped = 0;
            //item->setZ(getZ());
            break;
       }
       case QCanvasItem::Rtti_Line:
       {
            LineItem* tmp = (LineItem*) moving;
            tmp->grouped = 0;
            //item->setZ(getZ());
            break;
       }
       case QCanvasItem::Rtti_Polygon:
       {
            Polygon* tmp = (Polygon*) moving;
            tmp->grouped = 0;
            //item->setZ(getZ());
            break;
       }
       case QCanvasItem::Rtti_Text:
       {
            CanvasTextItem* tmp = (CanvasTextItem*) moving;
            tmp->grouped = 0;
            //item->setZ(getZ());
            break;
       }
       case 86:
       {
            ImageItem* tmp = (ImageItem*) moving;
            tmp->grouped = 0;
            //item->setZ(getZ());
            break;
       }
       case 87:
       {
//             PencilItem* tmp = (PencilItem*) moving;
//             tmp->grouped = 0;
            //item->setZ(getZ());
            break;
       }
       case 88:
       {
            BrushItem* tmp = (BrushItem*) moving;
            tmp->grouped = 0;
            //item->setZ(getZ());
            break;
       }
       case 89:
       {
            Regular* tmp = (Regular*) moving;
            tmp->grouped = 0;
            //item->setZ(getZ());
            break;
       }

    }
  
  }
  tmpGroup->hideNodes();
  canvas()->setAllChanged();
  canvas()->update();
  delete tmpGroup;
}

int Editor::moveGroup(QCanvasItem* tempItem)
{
  double dx = movx - cenx;
  double dy = movy - ceny;


  if (getGroup(tempItem) == NULL) return 0;
  getGroup(tempItem)->moveBy(dx, dy);
  if (getButton(tempItem) != NULL)
  {
    getButton(tempItem)->dx += dx;
    getButton(tempItem)->dy += dy;
  }
  return 1;
}


QCanvasItemList Editor::filterSelection(QCanvasItemList tempList)
{
  QCanvasItemList newList;
  QPtrList<TextBox> boxes;
  QPtrList<itemGroup> groups;
  itemGroup* tmpGroup;

  for (QCanvasItemList::Iterator it = tempList.begin(); it != tempList.end(); it++)  
  {
    moving = *it;
    if (isValid(moving))
    {
       tmpGroup = getGroup(moving);
       if (tmpGroup == NULL && !newList.contains(moving))
       {
         if(getTextBox(moving) != NULL)
         {
           if ( !boxes.contains(getTextBox(moving)))
           {
              newList.append(moving);
              boxes.append(getTextBox(moving));
           }
         }
         else
         newList.append(moving);
       }
       else 
       if (!groups.containsRef(tmpGroup) && !newList.contains(moving))
       {
         groups.append(tmpGroup);
         newList.append(moving);
       }
    }
  }

  return newList;
}



itemGroup* Editor::getGroup(QCanvasItem* tempItem)
{

  switch (tempItem->rtti())
  {
       case QCanvasItem::Rtti_Rectangle:
       {
            RectItem* tmp = (RectItem*) tempItem;
            if (!tmp->grouped) return NULL;
            return tmp->group;
            break;
       }
       case QCanvasItem::Rtti_Ellipse:
       {
            OvalItem* tmp = (OvalItem*) tempItem;
            if (!tmp->grouped) return NULL;
            return tmp->group;
            break;
       }
       case QCanvasItem::Rtti_Line:
       {
            LineItem* tmp = (LineItem*) tempItem;
            if (!tmp->grouped) return NULL;
            return tmp->group;
            break;
       }
       case QCanvasItem::Rtti_Polygon:
       {
            Polygon* tmp = (Polygon*) tempItem;
            if (!tmp->grouped) return NULL;
            return tmp->group;
            break;
       }
       case QCanvasItem::Rtti_Text:
       {
            CanvasTextItem* tmp = (CanvasTextItem*) tempItem;
            if (!tmp->grouped) return NULL;
            return tmp->group;
            break;
       }
       case 86:
       {
            ImageItem* tmp = (ImageItem*) tempItem;
            if (!tmp->grouped) return NULL;
            return tmp->group;
            break;
       }
       case 87:
       {
//             PencilItem* tmp = (PencilItem*) tempItem;
//             if (!tmp->grouped) return NULL;
//             return tmp->group;
            break;
       }
       case 88:
       {
            BrushItem* tmp = (BrushItem*) tempItem;
            if (!tmp->grouped) return NULL;
            return tmp->group;
            break;
       }
       case 89:
       {
            Regular* tmp = (Regular*) tempItem;
            if (!tmp->grouped) return NULL;
            return tmp->group;
            break;
       }

       case 100:
       {
            TextBoxText* tmp = (TextBoxText*) tempItem;
            if (!tmp->grouped) return NULL;
            return tmp->group;
            break;
       }
       case 101:
       {
            TextBoxBack* tmp = (TextBoxBack*) tempItem;
            if (!tmp->grouped) return NULL;
            return tmp->group;
            break;
       }

    }
    return NULL;
}


ButtonItem* Editor::getButton(QCanvasItem* tempItem)
{

  switch (tempItem->rtti())
  {
       case QCanvasItem::Rtti_Rectangle:
       {
            RectItem* tmp = (RectItem*) tempItem;
            if (tmp->button == 0) return NULL;
            return tmp->group->buttonGroup;
            break;
       }
       case QCanvasItem::Rtti_Ellipse:
       {
            OvalItem* tmp = (OvalItem*) tempItem;
            if (tmp->button == 0) return NULL;
            return tmp->group->buttonGroup;
            break;
       }
       case QCanvasItem::Rtti_Line:
       {
            LineItem* tmp = (LineItem*) tempItem;
            if (tmp->button == 0) return NULL;
            return tmp->group->buttonGroup;
            break;
       }
       case QCanvasItem::Rtti_Polygon:
       {
            Polygon* tmp = (Polygon*) tempItem;
            if (tmp->button == 0) return NULL;
            return tmp->group->buttonGroup;
            break;
       }
       case QCanvasItem::Rtti_Text:
       {
            CanvasTextItem* tmp = (CanvasTextItem*) tempItem;
            if (tmp->button == 0) return NULL;
            return tmp->group->buttonGroup;
            break;
       }
       case 86:
       {
            ImageItem* tmp = (ImageItem*) tempItem;
            if (tmp->button == 0) return NULL;
            return tmp->group->buttonGroup;
            break;
       }
       case 87:
       {
//             PencilItem* tmp = (PencilItem*) tempItem;
//             if (tmp->button == 0) return NULL;
//             return tmp->group->buttonGroup;
            break;
       }
       case 88:
       {
            BrushItem* tmp = (BrushItem*) tempItem;
            if (tmp->button == 0) return NULL;
            return tmp->group->buttonGroup;
            break;
       }
       case 89:
       {
            Regular* tmp = (Regular*) tempItem;
            if (tmp->button == 0) return NULL;
            return tmp->group->buttonGroup;
            break;
       }

    }
    return NULL;
}


void Editor::moveAllButtonCanvas( ButtonItem* button )
{
  double dx = button->dx;
  double dy = button->dy;

  QPtrList<buttonCanvas> tmpList;
  tmpList.append(button->canvasUp);
  tmpList.append(button->canvasOver);
  tmpList.append(button->canvasDown);


  for (int i=0; i<=2 ; i++)
  {
    QCanvasItemList items = tmpList.at(i)->allItems();
    items = filterSelection( items );
    QCanvasItem* tempItem;
    for (QCanvasItemList::Iterator it = items.begin(); it != items.end(); it++)  
    {
      tempItem = (QCanvasItem*) *it;
      tempItem->moveBy(dx , dy );
    }


   }

   button->dx = 0;
   button->dy = 0;

}

TextBox* Editor::getTextBox(QCanvasItem* tempItem)
{
  if (tempItem->rtti() != 100 && tempItem->rtti() != 101)
   return NULL;
  if (tempItem->rtti() == 100 )
  {
    TextBoxText* tmpT = (TextBoxText*) tempItem;
    return tmpT->box;
  }

  if (tempItem->rtti() == 101 )
  {
    TextBoxBack* tmpB = (TextBoxBack*) tempItem;
    return tmpB->box;
  }

  return NULL;
}


void Editor::nameChange()
{
  QString tmpName = getName();
  if (tmpName == NULL) return;

  nameDialog *dlg = new nameDialog( tmpName );
  if ( dlg->exec() == QDialog::Accepted ) 
  {
     setName(dlg->nameLine->text());
  }

 delete dlg;
}



QString Editor::getName(QCanvasItem* getItem)
{
  QCanvasItem* tempItem = getItem;
  if (getItem == NULL)
     tempItem = moving;
  if (tempItem == NULL)
     return NULL;

  if (getButton(tempItem) != NULL)
    return getButton(tempItem)->name;

  if (getTextBox(tempItem) != NULL)
   return getTextBox(tempItem)->name;

  switch (tempItem->rtti())
  {

       case QCanvasItem::Rtti_Rectangle:
       {
            RectItem* tmp = (RectItem*) tempItem;
            return tmp->name;
       }
       case QCanvasItem::Rtti_Ellipse:
       {
            OvalItem* tmp = (OvalItem*) tempItem;
            return tmp->name;
       }
       case QCanvasItem::Rtti_Line:
       {
            LineItem* tmp = (LineItem*) tempItem;
            return tmp->name;
       }
       case QCanvasItem::Rtti_Polygon:
       {
            Polygon* tmp = (Polygon*) tempItem;
            return tmp->name;
       }
       case QCanvasItem::Rtti_Text:
       {
            CanvasTextItem* tmp = (CanvasTextItem*) tempItem;
            return tmp->name;
       }
       case 86:
       {
            ImageItem* tmp = (ImageItem*) tempItem;
            return tmp->name;
       }
       case 87:
       {
//             PencilItem* tmp = (PencilItem*) tempItem;
//             return tmp->name;
       }
       case 88:
       {
            BrushItem* tmp = (BrushItem*) tempItem;
            return tmp->name;
       }
       case 89:
       {
            Regular* tmp = (Regular*) tempItem;
            return tmp->name;
       }

    }

  return NULL;
}


void Editor::setName(const QString& tmpName, QCanvasItem* getItem)
{
  QCanvasItem* tempItem = getItem;
  if (getItem == NULL)
     tempItem = choosen;
  if (tempItem == NULL)
     return;

  if (getButton(tempItem) != NULL)
  {
    getButton(tempItem)->name = tmpName;
    return;
  }
  if (getTextBox(tempItem) != NULL)
  {
    getTextBox(tempItem)->name = tmpName;
    return;
  }

  switch (tempItem->rtti())
  {

       case QCanvasItem::Rtti_Rectangle:
       {
            RectItem* tmp = (RectItem*) tempItem;
            tmp->name = tmpName;
            break;
       }
       case QCanvasItem::Rtti_Ellipse:
       {
            OvalItem* tmp = (OvalItem*) tempItem;
            tmp->name = tmpName;
            break;
       }
       case QCanvasItem::Rtti_Line:
       {
            LineItem* tmp = (LineItem*) tempItem;
            tmp->name = tmpName;
            break;
       }
       case QCanvasItem::Rtti_Polygon:
       {
            Polygon* tmp = (Polygon*) tempItem;
            tmp->name = tmpName;
            break;
       }
       case QCanvasItem::Rtti_Text:
       {
            CanvasTextItem* tmp = (CanvasTextItem*) tempItem;
            tmp->name = tmpName;
            break;
       }
       case 86:
       {
            ImageItem* tmp = (ImageItem*) tempItem;
            tmp->name = tmpName;
            break;
       }
       case 87:
       {
//             PencilItem* tmp = (PencilItem*) tempItem;
//             return tmp->name;
       }
       case 88:
       {
            BrushItem* tmp = (BrushItem*) tempItem;
            tmp->name = tmpName;
            break;
       }
       case 89:
       {
            Regular* tmp = (Regular*) tempItem;
            tmp->name = tmpName;
            break;
       }

    }


  return;
}

void Editor::updateNames()
{
  Window * q = (Window*) parentWidget();

  names.clear();
  QCanvasItem* tempItem;
  QCanvasItemList l;
  for (int a = 0; a < q->frames ; a++)
  {
     l = q->can.at(a)->allItems();
     for (QCanvasItemList::Iterator it = l.begin(); it != l.end(); it++)  
     {
       tempItem = (QCanvasItem*) *it;
       if (getName(tempItem) != "")
         names.append( getName(tempItem) );
     }
  }

}

QCanvasItemList Editor::sortByZ( QCanvasItemList list )
{
  int size = list.count();
  QCanvasItem* temp;
  QCanvasItem* first;
  QCanvasItem* second;

  for (int i=1; i<size; i++)
    for (int j=0; j<size-1; j++ )
    {
     QCanvasItemList::Iterator it = list.at(j);
     QCanvasItemList::Iterator at = list.at(j+1);

      first = (QCanvasItem*) *it;
      second = (QCanvasItem*) *at;

      if (first->z() < second->z())
      {
        temp = first;
        it = list.remove(it);
        it++;
        it = list.insert(it, temp);
      }

    }

  return list;
}
