/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 

#include "button.h"
#include "items.h"
#include "window.h"
#include "iostream"
using namespace std;



class buttonCanvasLineItem;
class CanvasItem;

ButtonItem::ButtonItem()
{

  canvasUp = new buttonCanvas();
  canvasOver = new buttonCanvas();
  canvasDown = new buttonCanvas();

  actions = buttonASActions();
  dx = 0;
  dy = 0;
  name = "";
  imagelist = "";

}

ButtonItem::ButtonItem( ButtonItem* tmpButton, Window* q)
{
  canvasUp = new buttonCanvas();
  canvasOver = new buttonCanvas();
  canvasDown = new buttonCanvas();

  canvasButton = (Canvas*) q->ed->canvas();
//   canvasButton = tmpButton->canvasButton;

  q->copyFrameForButton(tmpButton->canvasUp, canvasUp);
  q->copyFrameForButton(tmpButton->canvasOver, canvasOver);
  q->copyFrameForButton(tmpButton->canvasDown, canvasDown);
  name = "";
  actions = tmpButton->actions.copy();
  dx = tmpButton->dx;
  dy = tmpButton->dy;
  imagelist = "";
}


QString ButtonItem::imageList()
{
  return imagelist.join(" ");
}

buttonCanvas::buttonCanvas(): QCanvas(1000, 1000)
{
  this->setBackgroundColor(Qt::white);
  CanvasItem* can = new CanvasItem(0,0,1000,1000, this);
  can->setZ(2);
  for (int i = 0; i< 1000; i += 5)
  {
    buttonCanvasLineItem* tmpLine = new buttonCanvasLineItem( this );
    if (i%25 == 0)
    tmpLine->setPen(Qt::green);
    tmpLine->setPoints(i,0,i,1000);
    tmpLine->show();
  }

  for (int i = 0; i< 1000; i += 5)
  {

    buttonCanvasLineItem* tmpLine = new buttonCanvasLineItem( this );
    if (i%25 == 0)
    tmpLine->setPen(Qt::green);
    tmpLine->setPoints(0,i, 1000, i);
    tmpLine->show();
  }
}


buttonASActions::buttonASActions()
{
  actionDown = "";
  actionOver = "";
  actionOut = "";
  actionUp = "";
  actionUpOutside = "";
  actionDragOut = "";
  actionDragOver = "";
}

buttonASActions buttonASActions::copy()
{

  buttonASActions tmpActions;

  tmpActions.actionDown = actionDown;
  tmpActions.actionOver = actionOver;
  tmpActions.actionOut = actionOut;
  tmpActions.actionUp = actionUp;
  tmpActions.actionUpOutside = actionUpOutside;
  tmpActions.actionDragOut = actionDragOut;
  tmpActions.actionDragOver = actionDragOver;

  return tmpActions;

}

QString ButtonItem::xml(Editor* ed)
{
  imagelist.clear();
  QPtrList<buttonCanvas> canvasList;
  canvasList.append(canvasUp);
  canvasList.append(canvasOver);
  canvasList.append(canvasDown);

  QString s;
  QCanvasItem* tempItem;
  QCanvasItemList::Iterator it = canvasUp->allItems().begin();
  tempItem = (QCanvasItem*) *it;

  int layer = ((int) (tempItem->z()/3000));

  s = "<button name=\""+name+"\" layer=\"" +  QString::number(layer) + "\">\n";
  QCanvasItem* moving;

  for (int i=0; i<3;i++)
  {
    buttonCanvas* tmpCanvas = canvasList.at(i);
    QCanvasItemList items = tmpCanvas->allItems();
    items = ed->filterSelection( items );
    items = ed->sortByZ( items );
    for (QCanvasItemList::Iterator it = items.begin(); it != items.end(); it++)  
    {
      moving = (QCanvasItem*) *it;
      cout << "button moving " << moving->z() << endl;
    }
    cout << items.count() << endl;






    s += "\t\t<canvas id=\""+QString::number(i)+"\">\n";

    for (QCanvasItemList::Iterator it = items.begin(); it != items.end(); it++)  
    {
      moving = (QCanvasItem*) *it;
      switch (moving->rtti())
      {

            case QCanvasItem::Rtti_Rectangle:
            {
               RectItem* rec;
               rec = (RectItem*) moving;
               s += "\t\t\t" +rec->xml()+ "\n";
               break;
            }
            case QCanvasItem::Rtti_Ellipse:
            {
               OvalItem* eli;
               eli = (OvalItem*) moving;
               s += "\t\t\t" +eli->xml()+ "\n";
               break;
            }
            case QCanvasItem::Rtti_Line:
            {
               LineItem* lin;
               lin = (LineItem*) moving;
               s += "\t\t\t" +lin->xml()+ "\n";
               break;
            }
            case QCanvasItem::Rtti_Polygon:
            {
               Polygon* pol;
               pol = (Polygon*) moving;
               s += "\t\t\t" +pol->xml()+ "\n";
               break;
            }
            case QCanvasItem::Rtti_Text:
            {
               CanvasTextItem* text;
               text = (CanvasTextItem*) moving;
               s += "\t\t\t" +text->xml()+ "\n";
               break;
            }
            case 86:
            {
               ImageItem* ima;
               ima = (ImageItem*) moving;
               s += "\t\t\t" +ima->xml()+ "\n";
               imagelist.append(ima->fileName);
               break;
            }
            case 87:
            {
//                PencilItem* pen;
//                pen = (PencilItem*) moving;
//                if (pen->view)
//                     s += "\t\t\t" +pen->xml()+ "\n";
                break;
            }
            case 88:
            {
               BrushItem* bru;
               bru = (BrushItem*) moving;
               if (bru->view ) //Qflash crashed when a brushitemwas deleted so they are only hidden. View property states if it is shown or not
                   s += "\t\t\t" +bru->xml()+ "\n";
               break;
            }
            case 89:
            {
               Regular* regu;
               regu = (Regular*) moving;
               if (regu->view)
                  s += "\t\t\t" +regu->xml()+ "\n";
               break;
            }

      }


    }
  s += "\t\t</canvas>\n";
  }

  if (actions.actionOver != "")
    s+= "\t\t<action id=\"over\" code=\""+ actions.actionOver.replace( "\"", "&quot;" ).replace( "\n", "&new;" )+ "\" />\n";


  if (actions.actionOut != "")
    s+= "\t\t<action id=\"out\" code=\""+ actions.actionOut.replace( "\"", "&quot;" ).replace( "\n", "&new;" )+ "\" />\n";


  if (actions.actionUp != "")
    s+= "\t\t<action id=\"up\" code=\""+ actions.actionUp.replace( "\"", "&quot;" ).replace( "\n", "&new;" )+ "\" />\n";


  if (actions.actionUpOutside != "")
    s+= "\t\t<action id=\"upoutside\" code=\""+ actions.actionUpOutside.replace( "\"", "&quot;" ).replace( "\n", "&new;" )+ "\" />\n";


  if (actions.actionDown != "")
    s+= "\t\t<action id=\"down\" code=\""+ actions.actionDown.replace( "\"", "&quot;" ).replace( "\n", "&new;" )+ "\" />\n";


  if (actions.actionDragOut != "")
    s+= "\t\t<action id=\"dragout\" code=\""+ actions.actionDragOut.replace( "\"", "&quot;" ).replace( "\n", "&new;" )+ "\" />\n";


  if (actions.actionDragOver != "")
    s+= "\t\t<action id=\"dragover\" code=\""+ actions.actionDragOver.replace( "\"", "&quot;" ).replace( "\n", "&new;" )+ "\" />\n";


  s+= "\t\t</button> \n";
  return s;

}






