/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ASDIALOG_H
#define ASDIALOG_H

#include <qvariant.h>
#include <qdialog.h>
#include <button.h>
#include <qptrlist.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QComboBox;
class QListBox;
class QListBoxItem;
class QLabel;
class QTextEdit;
class QPushButton;

class animationASActions
{
 public:
  animationASActions();
  animationASActions copy();

  QPtrList<QString> actions;

};


class asDialog : public QDialog
{
    Q_OBJECT

public:

    asDialog( buttonASActions actions, QStringList objects );
    asDialog( animationASActions actions, int frame, QStringList objects);

    ~asDialog();

    QComboBox* comboTarget;
    QComboBox* comboAction;
    QListBox* listBox1;
    QLabel* textLabel1;
    QTextEdit* textEdit1;
    QComboBox* comboObject;
    QLabel* textLabel3;
    QPushButton* buttonOk;
    QPushButton* buttonCancel;
    int lastEdit;
    buttonASActions actions;
    animationASActions aActions;

public slots:

    void updateButton();
    void updateAnim();
    void saveTextAnim();
    void saveTextButton();
    void okButton();
    void okAnim();
    void addTextFromList();
    void addObjectFromList();

    void updateObjects( QStringList );
protected:

protected slots:
    virtual void languageChange();

};




#endif // ASDIALOG_H
