/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "asDialog.h"

#include <qvariant.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qtextedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qdeepcopy.h>


#include <iostream>
using namespace std;


/*
 *  Constructs a asDialog as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
asDialog::asDialog( buttonASActions tmpActions, QStringList objects )
    : QDialog( )
{

    actions = tmpActions;

    lastEdit = -1;
    comboTarget = new QComboBox( FALSE, this, "comboTarget" );
    comboTarget->setGeometry( QRect( 370, 40, 160, 30 ) );

    comboAction = new QComboBox( FALSE, this, "comboAction" );
    comboAction->setGeometry( QRect( 370, 40, 161, 31 ) );

    listBox1 = new QListBox( this, "listBox1" );
    listBox1->setGeometry( QRect( 20, 100, 160, 260 ) );

    textLabel1 = new QLabel( this, "textLabel1" );
    textLabel1->setGeometry( QRect( 10, 60, 150, 31 ) );

    textEdit1 = new QTextEdit( this, "textEdit1" );
    textEdit1->setGeometry( QRect( 200, 100, 330, 260 ) );

    comboObject = new QComboBox( FALSE, this, "comboObject" );
    comboObject->setGeometry( QRect( 20, 420, 161, 31 ) );

    textLabel3 = new QLabel( this, "textLabel3" );
    textLabel3->setGeometry( QRect( 20, 380, 161, 31 ) );

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setGeometry( QRect( 280, 430, 110, 31 ) );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setGeometry( QRect( 420, 430, 110, 31 ) );
    languageChange();

    updateObjects(objects);


    resize( QSize(553, 479).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( okButton() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );

    connect( comboAction, SIGNAL( activated(int) ), this, SLOT( updateButton() ) );
    connect( listBox1, SIGNAL( highlighted ( const QString &)), this, SLOT( addTextFromList() ) );
    connect( comboObject, SIGNAL( activated (int)), this, SLOT( addObjectFromList() ) );


    comboAction->show();
    comboTarget->hide();
    updateButton();


}


asDialog::asDialog( animationASActions tmpActions, int frame, QStringList objects )
    : QDialog( )
{

    aActions = tmpActions;
    lastEdit = -1;
    comboTarget = new QComboBox( FALSE, this, "comboTarget" );
    comboTarget->setGeometry( QRect( 370, 40, 160, 30 ) );

    comboAction = new QComboBox( FALSE, this, "comboAction" );
    comboAction->setGeometry( QRect( 370, 40, 161, 31 ) );


    listBox1 = new QListBox( this, "listBox1" );
    listBox1->setGeometry( QRect( 20, 100, 160, 260 ) );

    textLabel1 = new QLabel( this, "textLabel1" );
    textLabel1->setGeometry( QRect( 10, 60, 150, 31 ) );

    textEdit1 = new QTextEdit( this, "textEdit1" );
    textEdit1->setGeometry( QRect( 200, 100, 330, 260 ) );

    comboObject = new QComboBox( FALSE, this, "comboObject" );
    comboObject->setGeometry( QRect( 20, 420, 161, 31 ) );

    textLabel3 = new QLabel( this, "textLabel3" );
    textLabel3->setGeometry( QRect( 20, 380, 161, 31 ) );

    buttonOk = new QPushButton( this, "buttonOk" );
    buttonOk->setGeometry( QRect( 280, 430, 110, 31 ) );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setGeometry( QRect( 420, 430, 110, 31 ) );
    languageChange();

    updateObjects(objects);

    resize( QSize(553, 479).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( okAnim() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );

    connect( comboTarget, SIGNAL( activated(int) ), this, SLOT( updateAnim() ) );
    connect( listBox1, SIGNAL( highlighted ( const QString &)), this, SLOT( addTextFromList() ) );
    connect( comboObject, SIGNAL( activated (int)), this, SLOT( addObjectFromList() ) );


    comboTarget->show();
    comboAction->hide();

    for (int i=1; i< (int) aActions.actions.count(); i++)
    {
      comboTarget->insertItem( QString( "Frame " + QString::number( i )  ));
    }
    comboTarget->setCurrentItem(frame);
    updateAnim();

}

   

void asDialog::updateObjects( QStringList objects )
{

  for ( QStringList::Iterator it = objects.begin(); it != objects.end(); ++it )
  {
     comboObject->insertItem(*it);
  }
}



/*
 *  Destroys the object and frees any allocated resources
 */
asDialog::~asDialog()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void asDialog::languageChange()
{
    setCaption( tr( "ActionScript" ) );
    comboAction->clear();
    comboAction->insertItem( "MouseDown" );
    comboAction->insertItem( "MouseOver" );
    comboAction->insertItem( "MouseOut" );
    comboAction->insertItem( "MouseUp" );
    comboAction->insertItem( "MouseUpOutside" );
    comboAction->insertItem( "DragOut"  );
    comboAction->insertItem( "DragOver" );

    listBox1->clear();
    listBox1->insertItem( "gotoAndPlay()" );
    listBox1->insertItem( "gotoAndStop()" );
    listBox1->insertItem( "play()" );
    listBox1->insertItem( "stop()" );
    listBox1->insertItem( "prevFrame()" );
    listBox1->insertItem( "nextFrame()" );
    listBox1->insertItem( "getURL()" );
    textLabel1->setText( trUtf8( "Basic functions" ) );
    textLabel3->setText( tr( "Figures in the project" ) );
    buttonOk->setText( tr( "Ok" ) );
    buttonCancel->setText( tr( "Cancel" ) );
}

void asDialog::updateButton()
{
 saveTextButton();
 switch ( comboAction->currentItem() )
 {
   case 0:
    {
      textEdit1->setText(actions.actionDown);
      lastEdit = 0;
      break;
    }
   case 1:
    {
      textEdit1->setText(actions.actionOver);
      lastEdit = 1;
      break;
    }
   case 2:
    {
      textEdit1->setText(actions.actionOut);
      lastEdit = 2;
      break;
    }
   case 3:
    {
      textEdit1->setText(actions.actionUp);
      lastEdit = 3;
      break;
    }
   case 4:
    {
      textEdit1->setText(actions.actionUpOutside);
      lastEdit = 4;
      break;
    }
   case 5:
    {
      textEdit1->setText(actions.actionDragOut);
      lastEdit = 5;
      break;
    }
   case 6:
    {
      textEdit1->setText(actions.actionDragOver);
      lastEdit = 6;
      break;
    }

 }


}



void asDialog::updateAnim()
{
 saveTextAnim();

 QString tmp = (aActions.actions.at(comboTarget->currentItem()))->latin1();
 textEdit1->setText(tmp);
 lastEdit = comboTarget->currentItem();

}

void asDialog::saveTextAnim()
{
  if (lastEdit == -1)
    return;
  QString* tmp = new QString(textEdit1->text());
  aActions.actions.replace(lastEdit, tmp);

}

void asDialog::saveTextButton()
{
  if (lastEdit == -1)
   return;

  if (lastEdit == 0)
    actions.actionDown = textEdit1->text();
  if (lastEdit == 1)
    actions.actionOver = textEdit1->text();
  if (lastEdit == 2)
    actions.actionOut = textEdit1->text();
  if (lastEdit == 3)
    actions.actionUp = textEdit1->text();
  if (lastEdit == 4)
    actions.actionUpOutside = textEdit1->text();
  if (lastEdit == 5)
    actions.actionDragOut = textEdit1->text();
  if (lastEdit == 6)
    actions.actionDragOver = textEdit1->text();
}



void asDialog::okAnim()
{
  saveTextAnim();
  accept();
}


void asDialog::okButton()
{
  saveTextButton();
  accept();
}


void asDialog::addTextFromList()
{

  QString string = listBox1->currentText();
  int para, index;
  textEdit1->getCursorPosition ( &para, &index );
  textEdit1->insertParagraph ( string + ";", para +1 );

}

void asDialog::addObjectFromList()
{
  cout << "a" << endl;
  QString string = comboObject->currentText();
  int para, index;
  textEdit1->getCursorPosition ( &para, &index );
  textEdit1->insertParagraph ( string + ";", para +1 );
  cout << string << " b" << endl;
}




animationASActions::animationASActions()
{
  for (int i=0;i<500;i++)
  {
    QString* tmp = new QString("");
    actions.append(tmp);
  }
}

animationASActions animationASActions::copy()
{

  animationASActions tmpActions = animationASActions();
  for (int i=0; i<(int)this->actions.count();i++)
  {
    tmpActions.actions.append(  this->actions.at(i) );
  }


//   QDeepCopy<animationASActions> tmpActions = this;

  return tmpActions;

}
