/***************************************************************************
 *   Copyright (C) 2005 by Sergio Pérez                                    *
 *   qflash@etynos.org                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "about.h"

#include <qvariant.h>
#include <qtabwidget.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

static const unsigned char image0_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x67, 0x00, 0x00, 0x00, 0x67,
    0x08, 0x06, 0x00, 0x00, 0x00, 0x1d, 0x41, 0x5c, 0xf9, 0x00, 0x00, 0x20,
    0x00, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xed, 0x7d, 0x79, 0x74, 0x54,
    0x45, 0xda, 0xf7, 0xaf, 0xea, 0xde, 0xdb, 0x6b, 0xba, 0xd3, 0x9d, 0x7d,
    0x4f, 0x08, 0x59, 0x20, 0x31, 0x21, 0x91, 0x84, 0x1d, 0x04, 0x44, 0x11,
    0x05, 0xd1, 0x61, 0x13, 0x77, 0x07, 0xf1, 0x45, 0x45, 0x47, 0x8c, 0x3a,
    0x72, 0x3e, 0xc7, 0x41, 0x5f, 0x47, 0x61, 0x9c, 0xe8, 0xe0, 0x30, 0x0a,
    0x8a, 0x7e, 0x82, 0xa2, 0x38, 0xb2, 0x7c, 0x2e, 0xf8, 0x22, 0x42, 0xd8,
    0x65, 0x95, 0x10, 0x20, 0x81, 0x18, 0x20, 0x01, 0xb2, 0xef, 0x4b, 0x77,
    0xa7, 0xbb, 0xef, 0x52, 0xef, 0x1f, 0x21, 0x31, 0x49, 0x77, 0x20, 0x21,
    0x1b, 0xcc, 0x37, 0xbf, 0x73, 0xee, 0xc9, 0x49, 0xdf, 0xba, 0x55, 0xcf,
    0xbd, 0xbf, 0x7a, 0xaa, 0x9e, 0x7a, 0xaa, 0xea, 0x29, 0xe0, 0x3f, 0xb8,
    0x6e, 0xc1, 0xf5, 0x66, 0xe6, 0x94, 0xd2, 0x31, 0x94, 0xd2, 0x74, 0x42,
    0x88, 0x9a, 0x31, 0x76, 0x09, 0x80, 0xbd, 0x37, 0xcb, 0xfb, 0x77, 0x43,
    0x6f, 0x92, 0xa3, 0x0a, 0x0f, 0x0f, 0x5f, 0xfa, 0xde, 0x7b, 0xef, 0xcd,
    0x4a, 0x49, 0x49, 0x99, 0xae, 0x56, 0xab, 0x9f, 0xae, 0xad, 0xad, 0x4d,
    0x75, 0x38, 0x1c, 0xff, 0x21, 0xaa, 0x93, 0x20, 0xbd, 0x95, 0x31, 0xa5,
    0x34, 0x61, 0xce, 0x9c, 0x39, 0xfb, 0x16, 0x2e, 0x5c, 0x68, 0x04, 0x00,
    0x45, 0x51, 0x60, 0xb3, 0xd9, 0x70, 0xec, 0xd8, 0x31, 0x79, 0xeb, 0xd6,
    0xad, 0xe5, 0xfb, 0xf7, 0xef, 0x5f, 0x21, 0x49, 0xd2, 0x2a, 0x00, 0x55,
    0xbd, 0x25, 0xc3, 0x8d, 0x8e, 0xde, 0xd2, 0x1c, 0x12, 0x10, 0x10, 0xf0,
    0xe2, 0xbc, 0x79, 0xf3, 0xc6, 0xfb, 0xfa, 0xfa, 0x12, 0x00, 0x20, 0x84,
    0x40, 0xa5, 0x52, 0x21, 0x3c, 0x3c, 0x9c, 0x8e, 0x1b, 0x37, 0xce, 0x90,
    0x92, 0x92, 0x32, 0xc1, 0x6a, 0xb5, 0x3e, 0x5c, 0x58, 0x58, 0xa8, 0x51,
    0x14, 0x25, 0x07, 0x40, 0x63, 0x2f, 0xc9, 0x72, 0xc3, 0xa2, 0x57, 0xc8,
    0xe1, 0x38, 0x2e, 0x2c, 0x21, 0x21, 0x61, 0xd9, 0xec, 0xd9, 0xb3, 0xcd,
    0x94, 0x52, 0x77, 0xf7, 0x11, 0x10, 0x10, 0x40, 0x2e, 0x93, 0x34, 0xbe,
    0x15, 0x49, 0xa7, 0xf0, 0x9f, 0xe6, 0xae, 0x05, 0xbd, 0x42, 0x0e, 0xa5,
    0xd4, 0x5c, 0x5d, 0x5d, 0xed, 0xb5, 0x6b, 0xd7, 0x2e, 0x7b, 0x5e, 0x5e,
    0x9e, 0x57, 0x65, 0x65, 0xa5, 0xc0, 0xf3, 0x3c, 0xcc, 0x66, 0x33, 0x21,
    0xe4, 0xb7, 0x96, 0xb4, 0x99, 0xa4, 0xb1, 0x63, 0xc7, 0x1a, 0x86, 0x0e,
    0x1d, 0x3a, 0xbe, 0xb8, 0xb8, 0x78, 0x7a, 0x45, 0x45, 0xc5, 0x25, 0xc6,
    0x58, 0x1e, 0x00, 0xd6, 0x1b, 0xb2, 0xdd, 0x48, 0xe8, 0xb5, 0x3e, 0x07,
    0x00, 0x21, 0x84, 0xe8, 0x28, 0xa5, 0x9e, 0x1c, 0xc7, 0xc5, 0x9b, 0xcd,
    0xe6, 0xc9, 0x31, 0x31, 0x31, 0xd3, 0x27, 0x4c, 0x98, 0x30, 0x70, 0xd4,
    0xa8, 0x51, 0xc4, 0x60, 0x30, 0xb8, 0x3c, 0x60, 0xb5, 0x5a, 0xb1, 0x79,
    0xf3, 0xe6, 0xc6, 0xaf, 0xbf, 0xfe, 0xfa, 0xab, 0xca, 0xca, 0xca, 0x57,
    0x01, 0x5c, 0xea, 0x45, 0xf9, 0xae, 0x19, 0xd6, 0x34, 0xb3, 0x00, 0x20,
    0xdc, 0x21, 0xb1, 0x48, 0x9e, 0x22, 0x8c, 0xa3, 0x44, 0x0d, 0x40, 0x94,
    0x64, 0x66, 0x07, 0x50, 0xc0, 0x73, 0xe4, 0x0c, 0x80, 0x0a, 0x7d, 0x7a,
    0x4d, 0xb7, 0x2a, 0x58, 0x6f, 0x92, 0xd3, 0x1e, 0x94, 0xe3, 0x38, 0x1f,
    0x8d, 0x46, 0x33, 0x31, 0x30, 0x30, 0xf0, 0xa1, 0xd1, 0xa3, 0x47, 0x4f,
    0xbc, 0xe5, 0x96, 0x5b, 0xd4, 0x31, 0x31, 0x31, 0x6d, 0xb4, 0x49, 0x51,
    0x14, 0x9c, 0x3d, 0x7b, 0x96, 0x7d, 0xf2, 0xc9, 0x27, 0xf9, 0x07, 0x0f,
    0x1e, 0x7c, 0x5d, 0x14, 0xc5, 0x2f, 0x01, 0x38, 0xfb, 0x50, 0xce, 0x0e,
    0x61, 0x4d, 0x33, 0xeb, 0x65, 0x85, 0xdd, 0x7d, 0xb4, 0x54, 0x7e, 0xfa,
    0x40, 0x91, 0x14, 0x9d, 0x5b, 0x2d, 0x1b, 0x0a, 0xea, 0x14, 0x8d, 0x4d,
    0x64, 0x44, 0xe0, 0x08, 0xf4, 0x3c, 0x58, 0x94, 0x17, 0x67, 0x89, 0xf7,
    0xe1, 0x2c, 0x09, 0xbe, 0x5c, 0xf6, 0x10, 0x3f, 0xee, 0x0b, 0x9e, 0x62,
    0xab, 0xe1, 0x9d, 0xda, 0x92, 0x6b, 0x29, 0xaf, 0x2f, 0xc9, 0xf9, 0xad,
    0x50, 0x42, 0xb4, 0x94, 0xd2, 0x18, 0x3f, 0x3f, 0xbf, 0x87, 0xe2, 0xe3,
    0xe3, 0xef, 0x9b, 0x33, 0x67, 0x4e, 0x50, 0x5c, 0x5c, 0x5c, 0x1b, 0x59,
    0x1a, 0x1b, 0x1b, 0xf1, 0xe3, 0x8f, 0x3f, 0xda, 0xbf, 0xf8, 0xe2, 0x8b,
    0x6f, 0x8b, 0x8b, 0x8b, 0x17, 0x31, 0xc6, 0x8a, 0xfb, 0x43, 0xd6, 0x66,
    0xd4, 0x2f, 0x32, 0x8d, 0xfc, 0xa5, 0x54, 0x4e, 0x5f, 0x9d, 0xe5, 0xb8,
    0xf9, 0xc7, 0x7c, 0x51, 0x5d, 0xd5, 0xc8, 0x3a, 0x6c, 0x77, 0x39, 0x02,
    0x98, 0x35, 0x04, 0xc3, 0x82, 0x78, 0x71, 0x66, 0xac, 0x70, 0xe9, 0xf6,
    0x01, 0xc2, 0xc7, 0x46, 0x15, 0xf9, 0xd0, 0xf8, 0x6e, 0x6d, 0x65, 0x57,
    0xca, 0xec, 0x17, 0x72, 0x5a, 0x97, 0x4f, 0x29, 0x8d, 0xf0, 0xf1, 0xf1,
    0x79, 0x76, 0xec, 0xd8, 0xb1, 0x8f, 0xcc, 0x9c, 0x39, 0xd3, 0x14, 0x16,
    0x16, 0xd6, 0x22, 0x13, 0x63, 0x0c, 0x39, 0x39, 0x39, 0x6c, 0xc5, 0x8a,
    0x15, 0x47, 0x73, 0x72, 0x72, 0x9e, 0x92, 0x24, 0xe9, 0x17, 0xf4, 0x71,
    0x5f, 0x64, 0x4d, 0x33, 0x13, 0xab, 0xc8, 0x9e, 0xf8, 0x3c, 0xdb, 0xf1,
    0xfa, 0xdf, 0x0e, 0x39, 0x7c, 0x4b, 0x2c, 0x0a, 0xe9, 0x8a, 0x00, 0x1a,
    0x9e, 0x60, 0x5c, 0x28, 0x2f, 0x3d, 0x95, 0xac, 0x3e, 0x35, 0x3e, 0x8c,
    0xff, 0xb3, 0xc0, 0x91, 0xef, 0xf5, 0xe9, 0x35, 0x4a, 0x67, 0x9e, 0xed,
    0x55, 0x0f, 0x41, 0x67, 0xc0, 0x18, 0xab, 0xb5, 0x5a, 0xad, 0xdb, 0xcf,
    0x9c, 0x39, 0xf3, 0xc3, 0xe1, 0xc3, 0x87, 0x8d, 0xf5, 0xf5, 0xf5, 0x51,
    0x21, 0x21, 0x21, 0x82, 0x5e, 0xaf, 0x07, 0x21, 0x04, 0x7e, 0x7e, 0x7e,
    0x24, 0x25, 0x25, 0x25, 0xb8, 0xaa, 0xaa, 0x6a, 0x4a, 0x49, 0x49, 0x49,
    0x91, 0x24, 0x49, 0xb9, 0x00, 0x3a, 0xf5, 0x72, 0x3d, 0x81, 0x17, 0x86,
    0x69, 0xe6, 0xbd, 0x75, 0xd0, 0x9e, 0xbe, 0xec, 0xa0, 0xc3, 0xab, 0xc6,
    0xce, 0xba, 0x5c, 0x99, 0x25, 0x05, 0x38, 0x57, 0xab, 0xd0, 0xed, 0x05,
    0x62, 0x80, 0x5d, 0xc6, 0x1d, 0xb1, 0x5e, 0x9c, 0xee, 0xcd, 0x5b, 0x74,
    0x47, 0xdf, 0x3c, 0x60, 0xbf, 0x6a, 0x53, 0xdd, 0xef, 0xe4, 0x5c, 0x06,
    0x03, 0x50, 0x56, 0x57, 0x57, 0xf7, 0xfd, 0x89, 0x13, 0x27, 0xf6, 0x64,
    0x65, 0x65, 0x85, 0x9a, 0x4c, 0xa6, 0x88, 0xd0, 0xd0, 0x50, 0x42, 0x08,
    0x81, 0x87, 0x87, 0x07, 0x52, 0x53, 0x53, 0x3d, 0x09, 0x21, 0x77, 0x9c,
    0x3b, 0x77, 0x8e, 0x88, 0xa2, 0xf8, 0x0b, 0x63, 0x4c, 0xec, 0x6d, 0xa1,
    0x1a, 0x9e, 0x37, 0xdd, 0xfa, 0x41, 0xa6, 0xe3, 0xa3, 0xb7, 0x0f, 0xdb,
    0x3d, 0xed, 0x52, 0xf7, 0xf2, 0xb2, 0x49, 0xc0, 0xc1, 0x62, 0x49, 0x7b,
    0xbe, 0x56, 0x19, 0x95, 0xe0, 0xcb, 0x0d, 0x5c, 0x36, 0x41, 0xbb, 0x6b,
    0xe9, 0x41, 0xfb, 0x15, 0xc7, 0x76, 0xd7, 0x0b, 0x39, 0xcd, 0x90, 0x19,
    0x63, 0x17, 0xaa, 0xab, 0xab, 0xbf, 0x39, 0x76, 0xec, 0x58, 0x63, 0x5d,
    0x5d, 0x5d, 0x52, 0x54, 0x54, 0x94, 0x56, 0xab, 0xd5, 0x42, 0xa5, 0x52,
    0x21, 0x21, 0x21, 0x41, 0xed, 0xe7, 0xe7, 0x37, 0xfa, 0xdc, 0xb9, 0x73,
    0x21, 0x56, 0xab, 0x75, 0x0f, 0x63, 0xac, 0xd7, 0xc6, 0x44, 0xd6, 0x34,
    0xb3, 0xfe, 0x68, 0xa9, 0xfc, 0xc5, 0x33, 0xdb, 0x6d, 0x91, 0x96, 0x0e,
    0xea, 0xb8, 0x40, 0x81, 0x64, 0x7f, 0x8e, 0xcd, 0x1e, 0xa4, 0x12, 0x27,
    0x84, 0x09, 0xf6, 0x81, 0x26, 0xca, 0x3b, 0x65, 0xa0, 0xda, 0xce, 0xdc,
    0x36, 0x7d, 0x0a, 0x03, 0xf2, 0x6a, 0x14, 0x2e, 0xbb, 0x42, 0x8e, 0x4b,
    0x09, 0xe4, 0xe3, 0xde, 0x6e, 0x22, 0xc8, 0xd2, 0x91, 0x0c, 0xd7, 0x1b,
    0x39, 0x00, 0x00, 0xc6, 0x98, 0xa3, 0xb1, 0xb1, 0x71, 0x5f, 0x4e, 0x4e,
    0xce, 0x91, 0xbc, 0xbc, 0xbc, 0xc4, 0xa0, 0xa0, 0x20, 0x3f, 0x5f, 0x5f,
    0x5f, 0xc2, 0xf3, 0x3c, 0x06, 0x0e, 0x1c, 0xc8, 0x07, 0x06, 0x06, 0xde,
    0x94, 0x9b, 0x9b, 0x1b, 0x6c, 0xb1, 0x58, 0x76, 0xf7, 0x16, 0x41, 0x2f,
    0x8d, 0xd0, 0x2c, 0x58, 0xb4, 0xa3, 0xf1, 0xd1, 0x53, 0x15, 0xb2, 0xdb,
    0xa6, 0xcc, 0x5b, 0x4b, 0xf0, 0xca, 0x68, 0x6d, 0xd5, 0x1f, 0x87, 0x6b,
    0x56, 0xde, 0x1d, 0xad, 0x7a, 0x69, 0x44, 0x10, 0xff, 0xc1, 0xb4, 0x68,
    0xd5, 0x37, 0xe3, 0xc3, 0x78, 0xc9, 0x5f, 0x4f, 0x06, 0x5c, 0x6a, 0x50,
    0x34, 0x35, 0x76, 0x57, 0x8a, 0x18, 0x80, 0x4b, 0x0d, 0x0a, 0xcd, 0x2a,
    0x93, 0xa2, 0x86, 0x07, 0x09, 0x71, 0xe9, 0x13, 0xb5, 0x5b, 0xdf, 0xba,
    0x8a, 0x06, 0x5d, 0xb7, 0xe0, 0x79, 0x3e, 0x38, 0x28, 0x28, 0x68, 0xd5,
    0xa2, 0x45, 0x8b, 0x6c, 0x19, 0x19, 0x19, 0x6c, 0xff, 0xfe, 0xfd, 0x6c,
    0xdf, 0xbe, 0x7d, 0x6c, 0xd9, 0xb2, 0x65, 0x62, 0x78, 0x78, 0xf8, 0xa7,
    0x1c, 0xc7, 0x99, 0x7b, 0xba, 0x4c, 0x6b, 0x9a, 0x99, 0xff, 0xe9, 0x3e,
    0x8f, 0x93, 0x6a, 0x0e, 0x0c, 0x70, 0xbd, 0x3c, 0x04, 0xc2, 0x3e, 0xba,
    0x43, 0x77, 0xb1, 0xec, 0x19, 0xd3, 0x1d, 0xd6, 0x34, 0x33, 0xd7, 0xee,
    0x59, 0xa1, 0xe6, 0x39, 0xd3, 0x98, 0x9d, 0x73, 0x0d, 0x3f, 0xdc, 0x11,
    0x29, 0x88, 0x94, 0xb8, 0xcf, 0x83, 0x00, 0xec, 0x96, 0x30, 0x5e, 0x3a,
    0x3d, 0xdf, 0xf8, 0xa9, 0x35, 0xcd, 0xac, 0xeb, 0xe9, 0x77, 0xe8, 0x4b,
    0xa8, 0x8d, 0x46, 0xe3, 0x53, 0x0f, 0x3e, 0xf8, 0x60, 0xe5, 0xb6, 0x6d,
    0xdb, 0xda, 0x10, 0x14, 0x11, 0x11, 0xf1, 0x29, 0xc7, 0x71, 0x5e, 0x3d,
    0x59, 0x58, 0xdd, 0x22, 0xf3, 0x2d, 0x4f, 0xdf, 0xac, 0x16, 0xe1, 0xe6,
    0xa3, 0x02, 0x60, 0xcf, 0xa5, 0xa8, 0x6d, 0xc5, 0x0b, 0x4d, 0x73, 0xac,
    0x69, 0xe6, 0x0e, 0x0d, 0x84, 0xda, 0xe7, 0x4c, 0xde, 0x59, 0x8f, 0x19,
    0x57, 0xdd, 0x37, 0x58, 0x65, 0xe7, 0xa9, 0xfb, 0x7c, 0x28, 0x01, 0x9b,
    0x19, 0xab, 0x12, 0x2f, 0x3c, 0xe9, 0xb9, 0xe4, 0x4a, 0x79, 0x5d, 0xaf,
    0x30, 0x70, 0x1c, 0x97, 0x40, 0x08, 0x49, 0x00, 0x40, 0xb5, 0x5a, 0xed,
    0xec, 0x7b, 0xee, 0xb9, 0xe7, 0xd2, 0xf7, 0xdf, 0x7f, 0xdf, 0x5e, 0x83,
    0xd6, 0xf0, 0x3c, 0xdf, 0x63, 0x1a, 0x54, 0xb7, 0xc8, 0xbc, 0x34, 0xdc,
    0x48, 0xdd, 0x7e, 0xd0, 0x10, 0x03, 0x55, 0x0e, 0x3f, 0x6c, 0xd8, 0x58,
    0xbf, 0xc8, 0xa4, 0xbd, 0x5a, 0x3e, 0xb5, 0xcf, 0x99, 0x3c, 0x72, 0x9f,
    0x30, 0xfe, 0x75, 0xf6, 0x20, 0x95, 0x83, 0x74, 0x40, 0x34, 0x4f, 0xc1,
    0x5e, 0x1f, 0xab, 0xa9, 0xb1, 0x3c, 0x6f, 0x9a, 0xd0, 0x53, 0xf2, 0xf7,
    0x26, 0x34, 0x94, 0xd2, 0x5b, 0xc3, 0xc3, 0xc3, 0x57, 0xa4, 0xa6, 0xa6,
    0x1e, 0x98, 0x3e, 0x7d, 0x7a, 0x85, 0xc1, 0x60, 0xf8, 0xa0, 0xf9, 0x26,
    0xc7, 0x71, 0x93, 0x26, 0x4d, 0x9a, 0x94, 0xbb, 0x61, 0xc3, 0x86, 0x16,
    0x82, 0xde, 0x7c, 0xf3, 0x4d, 0x31, 0x20, 0x20, 0xe0, 0x5d, 0x42, 0x88,
    0xa6, 0x27, 0x04, 0x38, 0xf4, 0xb0, 0xf1, 0x40, 0x47, 0xb5, 0xfd, 0xf1,
    0x21, 0x6a, 0xb9, 0xf2, 0x59, 0xd3, 0x94, 0xce, 0xe6, 0x55, 0xb3, 0xc8,
    0x64, 0x38, 0xf6, 0xa8, 0xf1, 0xff, 0x4e, 0x08, 0xe3, 0x65, 0x77, 0xf9,
    0x01, 0x60, 0x3e, 0x5a, 0xc2, 0xb6, 0xcd, 0xf1, 0x38, 0x5e, 0xbf, 0xc8,
    0xe4, 0xdd, 0x13, 0xf2, 0xf7, 0x06, 0x54, 0x94, 0xd2, 0xf1, 0x51, 0x51,
    0x51, 0xff, 0x6f, 0xc1, 0x82, 0x05, 0xd6, 0xb5, 0x6b, 0xd7, 0x2a, 0x19,
    0x19, 0x19, 0x6c, 0xd3, 0xa6, 0x4d, 0x2c, 0x20, 0x20, 0x60, 0x65, 0xbb,
    0xb4, 0x29, 0xa3, 0x46, 0x8d, 0x3a, 0xf6, 0xf9, 0xe7, 0x9f, 0x2b, 0xfb,
    0xf7, 0xef, 0x67, 0x7b, 0xf7, 0xee, 0x65, 0x8b, 0x16, 0x2d, 0xb2, 0x19,
    0x8d, 0xc6, 0x85, 0xe8, 0xa6, 0x91, 0x63, 0x4d, 0x33, 0xf3, 0x1f, 0x4f,
    0xd1, 0x39, 0x48, 0x07, 0x7d, 0xc5, 0xa7, 0x77, 0xe9, 0x2e, 0xd4, 0x2d,
    0x32, 0xf9, 0x77, 0x25, 0xcf, 0xfa, 0x45, 0x26, 0xff, 0x1d, 0xf7, 0x19,
    0x76, 0x44, 0x78, 0xba, 0xd7, 0x46, 0x00, 0x6c, 0x74, 0x08, 0x2f, 0x15,
    0x3f, 0xed, 0xf9, 0x56, 0xeb, 0xe7, 0x5c, 0xfd, 0xf9, 0xfd, 0x00, 0x8e,
    0xe3, 0x06, 0x04, 0x05, 0x05, 0xad, 0x9e, 0x37, 0x6f, 0xde, 0x96, 0xa5,
    0x4b, 0x97, 0x4e, 0x7f, 0xe8, 0xa1, 0x87, 0x74, 0x03, 0x07, 0x0e, 0x24,
    0x6a, 0xb5, 0xba, 0xa3, 0x47, 0x8e, 0x1e, 0x3c, 0x78, 0xf0, 0xfe, 0xe5,
    0xcb, 0x97, 0x1f, 0x2b, 0x2c, 0x2c, 0x04, 0xa5, 0x14, 0xd3, 0xa6, 0x4d,
    0xd3, 0x4e, 0x9d, 0x3a, 0x75, 0x89, 0x4e, 0xa7, 0xbb, 0xa3, 0x9b, 0xe2,
    0xf8, 0x97, 0x58, 0x99, 0xc0, 0xdc, 0xd8, 0xc2, 0xde, 0x5a, 0x82, 0x24,
    0x7f, 0xfe, 0x00, 0x4f, 0x49, 0x75, 0x57, 0x32, 0x34, 0xbe, 0x5b, 0x5b,
    0x96, 0x1c, 0xc0, 0x2d, 0x7e, 0x66, 0xa8, 0xba, 0x42, 0xe8, 0xe0, 0x8b,
    0x1f, 0x2a, 0x96, 0xb8, 0x0d, 0xbf, 0x8a, 0x4f, 0xd4, 0x2d, 0x32, 0xc5,
    0x36, 0xff, 0xd6, 0xaf, 0xe4, 0x10, 0x42, 0xd4, 0x1a, 0x8d, 0xe6, 0xbe,
    0x91, 0x23, 0x47, 0x6e, 0xff, 0xcb, 0x5f, 0xfe, 0xf2, 0xe0, 0xa3, 0x8f,
    0x3e, 0xaa, 0x0b, 0x0c, 0x0c, 0xec, 0xd4, 0xb3, 0x8a, 0xa2, 0x9c, 0x39,
    0x72, 0xe4, 0xc8, 0xe3, 0x1f, 0x7c, 0xf0, 0xc1, 0x99, 0xca, 0xca, 0x4a,
    0xa8, 0xd5, 0x6a, 0x3c, 0xf8, 0xe0, 0x83, 0xde, 0x23, 0x47, 0x8e, 0x4c,
    0xa7, 0x94, 0x0e, 0xe9, 0x86, 0x58, 0x21, 0x25, 0x16, 0x45, 0x76, 0x77,
    0x63, 0xa8, 0x3f, 0xaf, 0x98, 0xd4, 0x64, 0x97, 0x3e, 0xbd, 0xa6, 0xcb,
    0x03, 0x60, 0x35, 0x47, 0x7e, 0xb9, 0x27, 0x46, 0xf5, 0xde, 0xc4, 0x70,
    0xc1, 0xad, 0x77, 0x43, 0x52, 0x80, 0xe5, 0x47, 0xec, 0xe6, 0x0a, 0x1b,
    0xfb, 0x3f, 0xcd, 0xc6, 0x41, 0xbf, 0x91, 0xc3, 0x71, 0x5c, 0x80, 0xbf,
    0xbf, 0xff, 0x7b, 0x8f, 0x3f, 0xfe, 0xf8, 0x9a, 0xd7, 0x5e, 0x7b, 0x2d,
    0x32, 0x26, 0x26, 0xe6, 0x5a, 0xac, 0x95, 0xe3, 0xbb, 0x77, 0xef, 0x5e,
    0xf0, 0xd1, 0x47, 0x1f, 0x5d, 0xa8, 0xaf, 0xaf, 0x87, 0xa7, 0xa7, 0x27,
    0x9e, 0x78, 0xe2, 0x89, 0xd8, 0xc4, 0xc4, 0xc4, 0xe5, 0x84, 0x90, 0xce,
    0xb1, 0xdc, 0x0e, 0x92, 0xc2, 0x42, 0x2f, 0x35, 0x28, 0x6e, 0x9b, 0xc6,
    0x68, 0x2f, 0x4a, 0xbc, 0xb5, 0x34, 0xf3, 0x5a, 0xf2, 0xd5, 0xa7, 0xd7,
    0xc8, 0x7e, 0x3a, 0xfa, 0xc9, 0x63, 0x89, 0xaa, 0x5c, 0x75, 0x07, 0x0d,
    0x6f, 0x7e, 0x9d, 0x42, 0x36, 0xe5, 0x3a, 0x67, 0xca, 0x0c, 0x51, 0x40,
    0xff, 0x90, 0x43, 0x79, 0x9e, 0x1f, 0x11, 0x1f, 0x1f, 0xff, 0xdd, 0xab,
    0xaf, 0xbe, 0x3a, 0x7f, 0xee, 0xdc, 0xb9, 0x2a, 0x8d, 0xe6, 0xda, 0xfb,
    0x71, 0xc6, 0xd8, 0xee, 0x6d, 0xdb, 0xb6, 0x3d, 0xf7, 0xe9, 0xa7, 0x9f,
    0x96, 0x37, 0x36, 0x36, 0x22, 0x24, 0x24, 0x04, 0xf3, 0xe6, 0xcd, 0x1b,
    0xeb, 0xe7, 0xe7, 0xf7, 0x0a, 0x00, 0xa1, 0x2b, 0x79, 0x59, 0xd3, 0xcc,
    0x90, 0x14, 0x84, 0x15, 0x35, 0x28, 0x6e, 0x2b, 0x4a, 0xa4, 0x89, 0xda,
    0x24, 0x85, 0x5d, 0xf3, 0x1c, 0x13, 0x25, 0x28, 0x19, 0x16, 0xc8, 0xaf,
    0x9a, 0xd0, 0x81, 0xf6, 0x28, 0x0c, 0x58, 0x97, 0xe3, 0xd4, 0x48, 0x32,
    0x7b, 0x08, 0xe8, 0x63, 0x72, 0x38, 0x8e, 0x13, 0x3c, 0x3c, 0x3c, 0x1e,
    0x9a, 0x3c, 0x79, 0xf2, 0x77, 0x6f, 0xbc, 0xf1, 0x46, 0xca, 0x90, 0x21,
    0x43, 0xae, 0xaa, 0x2d, 0xb2, 0x2c, 0x43, 0x14, 0xc5, 0x28, 0x00, 0x71,
    0x1d, 0xa5, 0x71, 0x3a, 0x9d, 0xdf, 0x6c, 0xd9, 0xb2, 0x65, 0xf1, 0x86,
    0x0d, 0x1b, 0x1a, 0x64, 0x59, 0xc6, 0x90, 0x21, 0x43, 0xe8, 0xb4, 0x69,
    0xd3, 0x1e, 0x52, 0xab, 0xd5, 0x77, 0x75, 0x55, 0x46, 0x35, 0x4f, 0x7c,
    0x4b, 0x2c, 0xee, 0xfd, 0xaa, 0x51, 0x66, 0xee, 0x2c, 0x47, 0x89, 0xb5,
    0xab, 0x79, 0x36, 0x43, 0x9f, 0x5e, 0xc3, 0xbc, 0xb5, 0x64, 0xf3, 0xb4,
    0x28, 0xa1, 0xac, 0xa3, 0x34, 0xd9, 0x95, 0x32, 0xf9, 0xb9, 0x48, 0x7a,
    0xc8, 0x9a, 0x66, 0xee, 0xa8, 0x7b, 0xea, 0x79, 0x10, 0x42, 0xf4, 0x26,
    0x93, 0xe9, 0xe5, 0x39, 0x73, 0xe6, 0x7c, 0xf0, 0xe2, 0x8b, 0x2f, 0xfa,
    0x78, 0x7b, 0x77, 0x6c, 0x35, 0x32, 0xc6, 0x50, 0x5f, 0x5f, 0x8f, 0x03,
    0x07, 0x0e, 0x48, 0x1f, 0x7e, 0xf8, 0x61, 0xa1, 0xc5, 0x62, 0x39, 0x03,
    0xa0, 0xe6, 0x0a, 0xd9, 0x33, 0x8b, 0xc5, 0xb2, 0x76, 0xe3, 0xc6, 0x8d,
    0xef, 0x1f, 0x3a, 0x74, 0x48, 0xe2, 0x38, 0x0e, 0xf7, 0xde, 0x7b, 0xaf,
    0x61, 0xc8, 0x90, 0x21, 0xaf, 0x11, 0x42, 0x42, 0xba, 0x24, 0x27, 0xa0,
    0xb7, 0xb8, 0xe9, 0x51, 0x08, 0x80, 0x50, 0x23, 0x2d, 0xe1, 0x08, 0x1c,
    0x5d, 0xc9, 0xaf, 0x3d, 0x78, 0x4a, 0x4a, 0x87, 0x05, 0xf2, 0x7b, 0xfd,
    0x74, 0xee, 0xeb, 0xa5, 0xa4, 0x00, 0x5b, 0xf3, 0xc5, 0x60, 0xc6, 0x70,
    0x33, 0xdf, 0x9d, 0x82, 0x3a, 0x0b, 0x42, 0x88, 0xb7, 0xbf, 0xbf, 0xff,
    0xd2, 0xc7, 0x1e, 0x7b, 0xec, 0xf7, 0x77, 0xdd, 0x75, 0x17, 0x6d, 0x3d,
    0xf3, 0xd9, 0x1a, 0x4e, 0xa7, 0x13, 0xc5, 0xc5, 0xc5, 0x6c, 0xe7, 0xce,
    0x9d, 0xf5, 0x07, 0x0e, 0x1c, 0x38, 0x91, 0x9b, 0x9b, 0xfb, 0x99, 0x2c,
    0xcb, 0xdf, 0x31, 0xc6, 0x4a, 0x3b, 0x51, 0x8c, 0x54, 0x5d, 0x5d, 0xfd,
    0xd7, 0x35, 0x6b, 0xd6, 0xa4, 0x84, 0x87, 0x87, 0xdf, 0x1a, 0x1c, 0x1c,
    0x8c, 0x87, 0x1f, 0x7e, 0x38, 0xa1, 0xa0, 0xa0, 0x60, 0x71, 0x79, 0x79,
    0xf9, 0x1f, 0x00, 0x74, 0xd6, 0xaf, 0xac, 0x72, 0xca, 0xae, 0xa6, 0x9a,
    0x41, 0x45, 0xa0, 0xe1, 0x49, 0x0d, 0x80, 0x6e, 0x79, 0xc3, 0xf5, 0xe9,
    0x35, 0xce, 0x0b, 0x4f, 0x7a, 0x6e, 0x4f, 0xf2, 0xe7, 0x67, 0x6e, 0xcb,
    0x17, 0xdd, 0x2a, 0xc7, 0xa1, 0x62, 0x49, 0x90, 0x14, 0x36, 0xa2, 0xd7,
    0xc9, 0x11, 0x04, 0x21, 0x24, 0x34, 0x34, 0xf4, 0xa3, 0x67, 0x9f, 0x7d,
    0xf6, 0x8e, 0xd4, 0xd4, 0x54, 0xb7, 0x69, 0xea, 0xeb, 0xeb, 0x71, 0xe4,
    0xc8, 0x11, 0xe7, 0xce, 0x9d, 0x3b, 0xcb, 0x0e, 0x1d, 0x3a, 0xb4, 0xde,
    0xe1, 0x70, 0x6c, 0x90, 0x65, 0xf9, 0x28, 0xba, 0x38, 0x6f, 0x23, 0xcb,
    0x72, 0xf5, 0xa9, 0x53, 0xa7, 0x5e, 0x5c, 0xb3, 0x66, 0xcd, 0x37, 0xcf,
    0x3f, 0xff, 0x7c, 0x68, 0x62, 0x62, 0x22, 0xb9, 0xfb, 0xee, 0xbb, 0x1f,
    0x5e, 0xbb, 0x76, 0xed, 0x36, 0xa7, 0xd3, 0xf9, 0x4d, 0x27, 0xb2, 0x20,
    0x8c, 0x41, 0xed, 0x74, 0x63, 0xab, 0x79, 0x6b, 0x09, 0xc0, 0x58, 0x15,
    0x00, 0xb7, 0x96, 0x5c, 0x57, 0xe0, 0xa5, 0xa5, 0xa7, 0x83, 0x0d, 0xb4,
    0xa5, 0x86, 0x72, 0x04, 0xa0, 0x97, 0x2f, 0x8e, 0x12, 0x5c, 0xa8, 0x53,
    0x20, 0x33, 0x0c, 0xed, 0x55, 0x72, 0xd4, 0x6a, 0x75, 0xc4, 0x80, 0x01,
    0x03, 0xd6, 0x2e, 0x5e, 0xbc, 0x78, 0x4c, 0x54, 0x54, 0x94, 0xcb, 0x7d,
    0x59, 0x96, 0x71, 0xf8, 0xf0, 0x61, 0xe9, 0xfd, 0xf7, 0xdf, 0x3f, 0x54,
    0x50, 0x50, 0xb0, 0x42, 0x51, 0x94, 0x2d, 0x00, 0x1a, 0xba, 0x59, 0x6c,
    0xe6, 0x9e, 0x3d, 0x7b, 0x96, 0xc4, 0xc4, 0xc4, 0xbc, 0x3f, 0x63, 0xc6,
    0x0c, 0xf5, 0xef, 0x7e, 0xf7, 0x3b, 0x8f, 0xe3, 0xc7, 0x8f, 0xbf, 0xfe,
    0xcb, 0x2f, 0xbf, 0x1c, 0x60, 0x8c, 0x95, 0x5f, 0xed, 0x61, 0x51, 0x61,
    0x82, 0x3b, 0x77, 0xbf, 0x97, 0x96, 0x80, 0x10, 0x52, 0xae, 0x4f, 0xbf,
    0x52, 0xeb, 0xda, 0x39, 0x28, 0x8c, 0x15, 0xfe, 0x2e, 0x5a, 0xa8, 0x0e,
    0x37, 0x52, 0x4e, 0x27, 0x00, 0x7a, 0x81, 0x30, 0x9d, 0x40, 0x14, 0x35,
    0x85, 0x43, 0xe0, 0x60, 0xd5, 0x09, 0xa4, 0x9e, 0x01, 0xce, 0x5e, 0x23,
    0x47, 0xad, 0x56, 0x47, 0xc7, 0xc4, 0xc4, 0x7c, 0xb1, 0x78, 0xf1, 0xe2,
    0xa1, 0xe1, 0xe1, 0xe1, 0x2e, 0xed, 0x58, 0x43, 0x43, 0x03, 0xd6, 0xae,
    0x5d, 0x6b, 0xdd, 0xb8, 0x71, 0xe3, 0xdb, 0x0e, 0x87, 0x63, 0x19, 0x7a,
    0x70, 0xbd, 0x5a, 0x43, 0x43, 0xc3, 0xba, 0xf5, 0xeb, 0xd7, 0x8f, 0x88,
    0x8d, 0x8d, 0x9d, 0x97, 0x90, 0x90, 0x40, 0xef, 0xbf, 0xff, 0xfe, 0xf8,
    0x9c, 0x9c, 0x9c, 0x79, 0x36, 0x9b, 0xed, 0xad, 0xab, 0x3d, 0xeb, 0x90,
    0xdc, 0x5b, 0x78, 0x3e, 0x5a, 0xaa, 0x78, 0x08, 0x28, 0xea, 0x09, 0xf9,
    0x78, 0x4a, 0x8a, 0x26, 0x46, 0x08, 0xe3, 0x27, 0x46, 0x08, 0x4e, 0x00,
    0x56, 0x00, 0x16, 0x00, 0x56, 0x7d, 0x7a, 0x4d, 0x9b, 0xa6, 0xb7, 0x57,
    0xc8, 0x51, 0xa9, 0x54, 0x83, 0xe3, 0xe2, 0xe2, 0xbe, 0x5a, 0xbc, 0x78,
    0xf1, 0x4d, 0xc1, 0xc1, 0xc1, 0x6d, 0x88, 0x61, 0x8c, 0x21, 0x37, 0x37,
    0x97, 0xfd, 0xfd, 0xef, 0x7f, 0x3f, 0x75, 0xfa, 0xf4, 0xe9, 0xa7, 0x24,
    0x49, 0xda, 0xd7, 0x0b, 0x22, 0x38, 0xca, 0xcb, 0xcb, 0xdf, 0x58, 0xb7,
    0x6e, 0xdd, 0xf8, 0x25, 0x4b, 0x96, 0x44, 0x27, 0x25, 0x25, 0x71, 0x63,
    0xc6, 0x8c, 0x59, 0xb0, 0x6d, 0xdb, 0xb6, 0x2f, 0x00, 0x5c, 0xb8, 0xd2,
    0x83, 0x76, 0x89, 0xa9, 0xdc, 0xad, 0x52, 0xf0, 0xd6, 0x12, 0xa6, 0x13,
    0xc8, 0x35, 0xad, 0xa2, 0x69, 0x8f, 0xcb, 0x83, 0xd8, 0x53, 0x57, 0x4b,
    0xd7, 0xe3, 0xd6, 0x9a, 0x20, 0x08, 0x03, 0xe3, 0xe3, 0xe3, 0xd7, 0xff,
    0xe9, 0x4f, 0x7f, 0x72, 0x21, 0x46, 0x96, 0x65, 0x64, 0x64, 0x64, 0x88,
    0x2f, 0xbd, 0xf4, 0xd2, 0x86, 0x93, 0x27, 0x4f, 0x8e, 0xeb, 0x25, 0x62,
    0x9a, 0xcb, 0xba, 0x78, 0xfc, 0xf8, 0xf1, 0xb7, 0x77, 0xec, 0xd8, 0x21,
    0xab, 0xd5, 0x6a, 0xcc, 0x9c, 0x39, 0x33, 0xf4, 0xb2, 0xef, 0xed, 0x8a,
    0xb0, 0xcb, 0x70, 0xeb, 0x33, 0xf2, 0xd2, 0x12, 0x4e, 0xc3, 0x93, 0x0e,
    0x4d, 0xe0, 0xde, 0x40, 0x8f, 0x92, 0x23, 0x08, 0x42, 0x70, 0x74, 0x74,
    0xf4, 0xe7, 0x2f, 0xbf, 0xfc, 0x72, 0x82, 0xbf, 0xbf, 0x7f, 0x1b, 0x62,
    0x9c, 0x4e, 0x27, 0x3e, 0xfb, 0xec, 0x33, 0xfb, 0x1b, 0x6f, 0xbc, 0xf1,
    0x56, 0x55, 0x55, 0xd5, 0xfd, 0x00, 0x6a, 0x7b, 0xb2, 0x6c, 0x77, 0xb0,
    0x58, 0x2c, 0x5f, 0x6d, 0xda, 0xb4, 0x69, 0x6f, 0x55, 0x55, 0x15, 0x62,
    0x63, 0x63, 0xc9, 0xad, 0xb7, 0xde, 0xfa, 0x08, 0xa5, 0xb4, 0xc3, 0xf1,
    0x12, 0x00, 0x34, 0x4a, 0xcc, 0x2d, 0x39, 0x7e, 0x3a, 0xca, 0x18, 0x70,
    0xd5, 0x3e, 0xab, 0x27, 0xd1, 0x63, 0xe4, 0x70, 0x1c, 0xe7, 0x13, 0x1a,
    0x1a, 0xba, 0x66, 0xf1, 0xe2, 0xc5, 0xc3, 0x43, 0x42, 0x42, 0xda, 0x10,
    0x63, 0xb1, 0x58, 0xb0, 0x6c, 0xd9, 0xb2, 0x9a, 0xd5, 0xab, 0x57, 0x3f,
    0xe2, 0x74, 0x3a, 0xff, 0x8c, 0xce, 0x9b, 0xb5, 0xdd, 0x02, 0x63, 0xac,
    0x3e, 0x2f, 0x2f, 0xef, 0xf5, 0x8d, 0x1b, 0x37, 0x36, 0xf2, 0x3c, 0x8f,
    0x99, 0x33, 0x67, 0xfa, 0x7a, 0x79, 0x79, 0xbd, 0x70, 0xa5, 0x67, 0xec,
    0x12, 0x73, 0xeb, 0xae, 0x30, 0xa9, 0x49, 0x83, 0x5d, 0x62, 0xdd, 0x1a,
    0xe3, 0x74, 0x15, 0x3d, 0x45, 0x8e, 0x21, 0x30, 0x30, 0x70, 0xd5, 0xe2,
    0xc5, 0x8b, 0x27, 0x46, 0x46, 0x46, 0xb6, 0x21, 0xa6, 0xae, 0xae, 0x0e,
    0xaf, 0xbf, 0xfe, 0x7a, 0xe1, 0xf6, 0xed, 0xdb, 0xa7, 0x30, 0xc6, 0xfe,
    0xd5, 0x43, 0xe5, 0x75, 0x1a, 0xb2, 0x2c, 0xef, 0xfb, 0xf1, 0xc7, 0x1f,
    0xbf, 0xf8, 0xf5, 0xd7, 0x5f, 0x59, 0x58, 0x58, 0x18, 0xa6, 0x4c, 0x99,
    0x32, 0x83, 0xe7, 0xf9, 0x61, 0x1d, 0x24, 0x27, 0x8d, 0x12, 0xdc, 0x92,
    0xe3, 0xad, 0x25, 0xe5, 0x02, 0xed, 0xde, 0x18, 0xa7, 0xab, 0xe8, 0x09,
    0x72, 0x78, 0x6f, 0x6f, 0xef, 0xd7, 0x16, 0x2e, 0x5c, 0x78, 0x6f, 0xfb,
    0x55, 0x9b, 0x55, 0x55, 0x55, 0x6c, 0xc9, 0x92, 0x25, 0xe7, 0x0e, 0x1f,
    0x3e, 0x7c, 0xb7, 0x24, 0x49, 0x87, 0x7a, 0xa0, 0xac, 0x6b, 0x81, 0x58,
    0x5e, 0x5e, 0xbe, 0xec, 0xcb, 0x2f, 0xbf, 0x2c, 0x25, 0x84, 0x60, 0xea,
    0xd4, 0xa9, 0x46, 0x83, 0xc1, 0x30, 0xdf, 0x6d, 0x42, 0x85, 0xc1, 0x2e,
    0x31, 0xb7, 0x33, 0x9c, 0xc1, 0x06, 0x5a, 0xca, 0x53, 0x72, 0x63, 0x91,
    0xa3, 0xd3, 0xe9, 0x9e, 0x78, 0xe0, 0x81, 0x07, 0x9e, 0x1c, 0x33, 0x66,
    0x4c, 0x1b, 0x62, 0x4a, 0x4b, 0x4b, 0xb1, 0x64, 0xc9, 0x92, 0xd3, 0x99,
    0x99, 0x99, 0xf7, 0x88, 0xa2, 0x78, 0x4d, 0x9e, 0xdc, 0x9e, 0x82, 0xa2,
    0x28, 0xe7, 0xb2, 0xb2, 0xb2, 0xbe, 0x38, 0x7d, 0xfa, 0x34, 0x0b, 0x08,
    0x08, 0xc0, 0x98, 0x31, 0x63, 0xa6, 0x03, 0x08, 0x6b, 0x9f, 0x4e, 0x52,
    0x00, 0x87, 0xec, 0xaa, 0x39, 0x84, 0x00, 0xbe, 0x3a, 0x5a, 0x83, 0x3e,
    0x6a, 0x8e, 0x9b, 0xd1, 0x2d, 0x72, 0x08, 0x21, 0xb7, 0x4f, 0x9d, 0x3a,
    0xf5, 0xf5, 0x7b, 0xef, 0xbd, 0x57, 0xd3, 0xda, 0x25, 0x53, 0x5d, 0x5d,
    0xcd, 0x96, 0x2e, 0x5d, 0x9a, 0x73, 0xe2, 0xc4, 0x89, 0x19, 0xa2, 0x28,
    0x5e, 0xd5, 0x64, 0xec, 0x03, 0x28, 0x15, 0x15, 0x15, 0x1f, 0x6d, 0xd9,
    0xb2, 0xa5, 0x86, 0xe7, 0x79, 0xdc, 0x79, 0xe7, 0x9d, 0xde, 0x3c, 0xcf,
    0x3f, 0xd8, 0x3e, 0x11, 0x63, 0x80, 0x53, 0x76, 0xed, 0x73, 0x4c, 0x6a,
    0x02, 0x15, 0x87, 0x2a, 0x74, 0xd3, 0x75, 0xd3, 0x55, 0x5c, 0x33, 0x39,
    0x3c, 0xcf, 0x47, 0x8d, 0x1d, 0x3b, 0x76, 0xc5, 0xa3, 0x8f, 0x3e, 0xea,
    0xad, 0x52, 0xa9, 0x5a, 0x7e, 0x6f, 0x68, 0x68, 0xc0, 0xbb, 0xef, 0xbe,
    0x7b, 0x29, 0x2b, 0x2b, 0xeb, 0x51, 0x49, 0x92, 0xce, 0xf4, 0x88, 0x94,
    0x3d, 0x00, 0xc6, 0xd8, 0xb9, 0x23, 0x47, 0x8e, 0x6c, 0x2a, 0x28, 0x28,
    0x60, 0x31, 0x31, 0x31, 0x34, 0x35, 0x35, 0xf5, 0x31, 0x00, 0xfa, 0xf6,
    0xe9, 0x44, 0xc5, 0xd5, 0x94, 0xf6, 0xd6, 0x12, 0x28, 0x0c, 0xd5, 0xe8,
    0xc3, 0x65, 0xc0, 0xc0, 0xb5, 0x93, 0xa3, 0x0b, 0x0e, 0x0e, 0x5e, 0xf6,
    0xf8, 0xe3, 0x8f, 0x47, 0x79, 0x7a, 0x7a, 0xb6, 0xfc, 0xd8, 0xd8, 0xd8,
    0x88, 0x95, 0x2b, 0x57, 0x56, 0xec, 0xdf, 0xbf, 0x7f, 0x9e, 0xd3, 0xe9,
    0x3c, 0xda, 0x33, 0x22, 0xf6, 0x0c, 0x18, 0x63, 0x52, 0x59, 0x59, 0xd9,
    0x07, 0x5b, 0xb7, 0x6e, 0x6d, 0xd4, 0x68, 0x34, 0x98, 0x3c, 0x79, 0x72,
    0x18, 0xa5, 0x74, 0x7a, 0xeb, 0x34, 0x04, 0x80, 0xa4, 0x40, 0xd5, 0x7e,
    0x0c, 0xea, 0xa3, 0xa5, 0xa0, 0x40, 0x69, 0x4f, 0xb8, 0x6e, 0xba, 0x82,
    0x6b, 0x22, 0xc7, 0x68, 0x34, 0x3e, 0xfd, 0xe8, 0xa3, 0x8f, 0x4e, 0x6b,
    0x6d, 0x99, 0x49, 0x92, 0x84, 0x75, 0xeb, 0xd6, 0xd5, 0x6f, 0xdd, 0xba,
    0x75, 0xa1, 0xc3, 0xe1, 0xd8, 0x81, 0xeb, 0x70, 0x67, 0x9a, 0xa2, 0x28,
    0xd9, 0x7b, 0xf6, 0xec, 0xf9, 0xa1, 0xbc, 0xbc, 0x1c, 0xc3, 0x87, 0x0f,
    0x57, 0x0d, 0x18, 0x30, 0xe0, 0x09, 0xb4, 0xda, 0x69, 0xc1, 0x53, 0x40,
    0x52, 0x98, 0xaa, 0xfd, 0x73, 0x3e, 0x5a, 0xa2, 0xe8, 0x55, 0xa4, 0x47,
    0x5c, 0x37, 0x5d, 0x41, 0x97, 0xc9, 0x21, 0x84, 0x8c, 0x9b, 0x32, 0x65,
    0xca, 0x0b, 0xe3, 0xc7, 0x8f, 0x17, 0x5a, 0xf7, 0x33, 0x3b, 0x76, 0xec,
    0x70, 0x6e, 0xde, 0xbc, 0x79, 0x99, 0xdd, 0x6e, 0xdf, 0x88, 0xeb, 0x90,
    0x18, 0x00, 0x50, 0x14, 0xc5, 0x51, 0x5a, 0x5a, 0xfa, 0xcf, 0x8c, 0x8c,
    0x0c, 0xc5, 0x60, 0x30, 0x60, 0xe4, 0xc8, 0x91, 0xc9, 0x00, 0x62, 0x9a,
    0xef, 0xf3, 0x1c, 0xa1, 0xa2, 0xe2, 0xea, 0x5b, 0xf3, 0xd4, 0x10, 0xa6,
    0xe6, 0xd0, 0xa5, 0xbd, 0x35, 0x3d, 0x81, 0xae, 0x92, 0xe3, 0x95, 0x94,
    0x94, 0xb4, 0x6c, 0xee, 0xdc, 0xb9, 0x7e, 0xad, 0xfb, 0x99, 0xec, 0xec,
    0x6c, 0x7c, 0xfe, 0xf9, 0xe7, 0x9b, 0x1a, 0x1a, 0x1a, 0x96, 0xa3, 0x07,
    0x5c, 0xea, 0xbd, 0x09, 0x51, 0x14, 0x4f, 0x66, 0x66, 0x66, 0xe6, 0x11,
    0x42, 0x90, 0x94, 0x94, 0xa4, 0xe7, 0x79, 0x7e, 0x54, 0xf3, 0x3d, 0x02,
    0x68, 0xec, 0x92, 0xeb, 0x9e, 0x25, 0xa3, 0x8a, 0x50, 0x35, 0x47, 0x7a,
    0xdd, 0xa3, 0xd1, 0x1e, 0x5d, 0x22, 0xc7, 0x64, 0x32, 0x3d, 0xf3, 0xc0,
    0x03, 0x0f, 0xa4, 0xf8, 0xfa, 0xfa, 0xb6, 0xfc, 0x56, 0x51, 0x51, 0xc1,
    0x3e, 0xfc, 0xf0, 0xc3, 0x23, 0xe7, 0xcf, 0x9f, 0xff, 0xa3, 0x2c, 0xcb,
    0xd7, 0x3c, 0x85, 0xdb, 0x57, 0x50, 0x14, 0xa5, 0x2e, 0x3f, 0x3f, 0xff,
    0x58, 0x6d, 0x6d, 0x2d, 0x62, 0x63, 0x63, 0x39, 0xb5, 0x5a, 0x3d, 0xb2,
    0xd5, 0x6d, 0x5d, 0xa3, 0xe4, 0xaa, 0xf4, 0x9e, 0x6a, 0x42, 0x08, 0xb9,
    0xe2, 0x4c, 0x6c, 0xaf, 0xa0, 0xd3, 0xe4, 0x50, 0x4a, 0x53, 0x27, 0x4d,
    0x9a, 0xb4, 0x20, 0x25, 0x25, 0xa5, 0xc5, 0x93, 0x2d, 0x8a, 0x22, 0xd6,
    0xad, 0x5b, 0x57, 0x75, 0xea, 0xd4, 0xa9, 0x17, 0x00, 0x5c, 0xec, 0x15,
    0x09, 0x7b, 0x1e, 0x92, 0xc5, 0x62, 0xd9, 0x73, 0xfa, 0xf4, 0x69, 0xc5,
    0xc3, 0xc3, 0x03, 0x37, 0xdd, 0x74, 0xd3, 0x04, 0xfc, 0xf6, 0x1d, 0x74,
    0x36, 0xd1, 0x2d, 0x39, 0x4c, 0x61, 0xa8, 0xeb, 0x53, 0x29, 0xd1, 0x79,
    0x72, 0xb4, 0x91, 0x91, 0x91, 0x4b, 0x66, 0xcf, 0x9e, 0xed, 0x2f, 0x08,
    0xbf, 0x35, 0xc9, 0xfb, 0xf6, 0xed, 0x93, 0x77, 0xec, 0xd8, 0xb1, 0xdc,
    0x6e, 0xb7, 0xef, 0xef, 0x1d, 0xf1, 0x7a, 0x07, 0x0d, 0x0d, 0x0d, 0xbb,
    0xb3, 0xb3, 0xb3, 0x15, 0x41, 0x10, 0x10, 0x1d, 0x1d, 0x1d, 0x08, 0x20,
    0x12, 0x00, 0x18, 0xa0, 0xb3, 0xcb, 0xae, 0xe6, 0xb2, 0x4e, 0x20, 0x36,
    0xa7, 0xcc, 0xfa, 0x74, 0x00, 0x0a, 0x74, 0x92, 0x1c, 0x95, 0x4a, 0x35,
    0x67, 0xce, 0x9c, 0x39, 0xb7, 0x06, 0x05, 0x05, 0xb5, 0xb4, 0xc7, 0x25,
    0x25, 0x25, 0x58, 0xbf, 0x7e, 0xfd, 0xee, 0xba, 0xba, 0xba, 0x0f, 0x70,
    0x9d, 0xf7, 0x33, 0x6e, 0x50, 0x7c, 0xf2, 0xe4, 0xc9, 0x1c, 0x42, 0x08,
    0x12, 0x13, 0x13, 0x35, 0x3c, 0xcf, 0x8f, 0x06, 0x00, 0x30, 0x68, 0xed,
    0x22, 0x73, 0x21, 0xc7, 0x43, 0x85, 0x7a, 0xd6, 0x0f, 0xef, 0x78, 0x55,
    0x72, 0x08, 0x21, 0x3e, 0x29, 0x29, 0x29, 0x69, 0xe3, 0xc6, 0x8d, 0x53,
    0x37, 0x5b, 0x67, 0xa2, 0x28, 0x62, 0xfd, 0xfa, 0xf5, 0x15, 0x79, 0x79,
    0x79, 0x7f, 0x92, 0x65, 0xf9, 0x86, 0x8b, 0x5d, 0xa3, 0x28, 0x8a, 0xe5,
    0xd2, 0xa5, 0x4b, 0x47, 0x2b, 0x2a, 0x2a, 0x30, 0x78, 0xf0, 0x60, 0x4e,
    0x10, 0x84, 0x91, 0x40, 0x93, 0xe6, 0x34, 0xba, 0xd1, 0x0f, 0xb3, 0x9a,
    0x56, 0x6b, 0x38, 0x72, 0xfd, 0x91, 0xa3, 0xd5, 0x6a, 0xe7, 0xcd, 0x98,
    0x31, 0x63, 0x90, 0x87, 0x87, 0x47, 0xcb, 0x6f, 0x47, 0x8e, 0x1c, 0x51,
    0x76, 0xed, 0xda, 0xf5, 0x0f, 0x87, 0xc3, 0xd1, 0x5f, 0xce, 0xcc, 0xee,
    0x42, 0xb6, 0x5a, 0xad, 0xbb, 0x72, 0x72, 0x72, 0x14, 0x0f, 0x0f, 0x0f,
    0xc4, 0xc7, 0xc7, 0x37, 0x6f, 0xbf, 0xd0, 0xd9, 0x24, 0xd7, 0x4d, 0xb9,
    0xde, 0x5a, 0x52, 0x4d, 0x48, 0xdf, 0x7a, 0x07, 0x80, 0xab, 0x90, 0xc3,
    0x71, 0x5c, 0xf8, 0x98, 0x31, 0x63, 0x16, 0x24, 0x27, 0x27, 0xb7, 0x18,
    0x01, 0x16, 0x8b, 0x05, 0x9b, 0x37, 0x6f, 0x3e, 0x51, 0x55, 0x55, 0xf5,
    0x31, 0x6e, 0xbc, 0xe6, 0xac, 0x05, 0x56, 0xab, 0xf5, 0x97, 0xfc, 0xfc,
    0x7c, 0xca, 0xf3, 0x3c, 0x82, 0x82, 0x82, 0x42, 0x00, 0x78, 0x28, 0x0c,
    0x3a, 0x9b, 0xc8, 0x5c, 0xbe, 0x89, 0x97, 0x86, 0x34, 0xe0, 0x7a, 0x6b,
    0xd6, 0x0c, 0x06, 0xc3, 0xb3, 0x33, 0x67, 0xce, 0x0c, 0x6b, 0xbd, 0xda,
    0x3f, 0x23, 0x23, 0xc3, 0x79, 0xf2, 0xe4, 0xc9, 0xf4, 0xfe, 0x0e, 0xda,
    0xd0, 0x5d, 0x70, 0x1c, 0x57, 0x5e, 0x51, 0x51, 0x61, 0xa3, 0x94, 0xe2,
    0xf2, 0xac, 0x6d, 0x98, 0xa8, 0x30, 0x0f, 0x9b, 0xd8, 0x76, 0x9c, 0x23,
    0x50, 0x40, 0xa7, 0x22, 0x16, 0x5c, 0x4f, 0xe4, 0x70, 0x1c, 0x37, 0x60,
    0xcc, 0x98, 0x31, 0xf7, 0xc7, 0xc4, 0xc4, 0xb4, 0xa4, 0x29, 0x2f, 0x2f,
    0x67, 0xdf, 0x7f, 0xff, 0xfd, 0x0e, 0x9b, 0xcd, 0xd6, 0x99, 0x35, 0x60,
    0xd7, 0x35, 0x18, 0x63, 0xce, 0xf2, 0xf2, 0xf2, 0x8b, 0x00, 0x10, 0x14,
    0x14, 0xc4, 0x73, 0x1c, 0x17, 0x21, 0x29, 0xf0, 0x68, 0x3f, 0xce, 0x31,
    0xa8, 0x08, 0x38, 0x82, 0x7a, 0xf4, 0xb1, 0xd3, 0x13, 0xb8, 0x02, 0x39,
    0x1a, 0x8d, 0xe6, 0xb1, 0xa9, 0x53, 0xa7, 0xfa, 0xb5, 0x36, 0x9d, 0x7f,
    0xf8, 0xe1, 0x07, 0xeb, 0xd9, 0xb3, 0x67, 0xff, 0x2a, 0xcb, 0x72, 0x77,
    0xd7, 0x96, 0xf5, 0x3b, 0x64, 0x59, 0x76, 0x16, 0x15, 0x15, 0x5d, 0x60,
    0x8c, 0x21, 0x30, 0x30, 0x90, 0xe7, 0x38, 0x6e, 0x00, 0xdc, 0x0c, 0x42,
    0x8d, 0x6a, 0x02, 0x85, 0xa1, 0x01, 0xd7, 0x0b, 0x39, 0x84, 0x10, 0xbf,
    0xe1, 0xc3, 0x87, 0x3f, 0xdc, 0x5a, 0x6b, 0x4a, 0x4b, 0x4b, 0xb1, 0x6b,
    0xd7, 0xae, 0x1f, 0x9d, 0x4e, 0xe7, 0x8d, 0x6a, 0x04, 0xb4, 0x87, 0x68,
    0xb1, 0x58, 0x4a, 0x1a, 0x1a, 0x1a, 0x10, 0x18, 0x18, 0x48, 0x44, 0x51,
    0x0c, 0xe1, 0x08, 0xb4, 0xb6, 0x76, 0x33, 0x36, 0x9e, 0x6a, 0x02, 0x59,
    0x41, 0x7d, 0x5f, 0x7b, 0xa4, 0x81, 0x0e, 0xc8, 0x11, 0x04, 0xe1, 0x81,
    0x69, 0xd3, 0xa6, 0x05, 0xb7, 0xee, 0x6b, 0x7e, 0xfa, 0xe9, 0xa7, 0xc6,
    0x8b, 0x17, 0x2f, 0xfe, 0x93, 0x31, 0x76, 0x63, 0xee, 0x99, 0x77, 0x85,
    0x4c, 0x08, 0x29, 0x2c, 0x2f, 0x2f, 0x87, 0xc1, 0x60, 0x80, 0xc9, 0x64,
    0x0a, 0x17, 0x28, 0xd4, 0x2e, 0x9a, 0xa3, 0x22, 0xe0, 0xb9, 0xfe, 0x09,
    0x75, 0xe9, 0x8e, 0x1c, 0x6d, 0x52, 0x52, 0xd2, 0x13, 0x89, 0x89, 0x89,
    0x2d, 0x16, 0x5a, 0x65, 0x65, 0x25, 0x32, 0x32, 0x32, 0xb6, 0xff, 0x1b,
    0x69, 0x0d, 0x00, 0xc0, 0xe1, 0x70, 0x9c, 0x2d, 0x2b, 0x2b, 0x53, 0x28,
    0xa5, 0x08, 0x0f, 0x0f, 0x8b, 0x26, 0x84, 0x68, 0xdd, 0x34, 0x6b, 0x8a,
    0x96, 0x23, 0x7d, 0xee, 0x91, 0x06, 0xdc, 0x90, 0xc3, 0x71, 0xdc, 0x84,
    0xf1, 0xe3, 0xc7, 0x47, 0xb4, 0xde, 0xd0, 0xb4, 0x63, 0xc7, 0x0e, 0xe7,
    0xa5, 0x4b, 0x97, 0xfe, 0xc9, 0x18, 0xb3, 0xf5, 0xa9, 0x74, 0xdd, 0x07,
    0x07, 0x40, 0x8b, 0x0e, 0xa2, 0x63, 0x39, 0x1c, 0x8e, 0xb2, 0xfa, 0xfa,
    0x7a, 0x85, 0x52, 0x0a, 0x2f, 0xb3, 0xd7, 0x00, 0xc0, 0x6d, 0xb3, 0xa6,
    0x08, 0x5c, 0xdf, 0x3b, 0x3d, 0x01, 0x37, 0xcb, 0x71, 0x0d, 0x06, 0xc3,
    0x8c, 0x91, 0x23, 0x47, 0xb6, 0x30, 0xe3, 0x74, 0x3a, 0xb1, 0x77, 0xef,
    0xde, 0x63, 0x37, 0xa8, 0xd6, 0x44, 0x03, 0x58, 0x81, 0xa6, 0xc5, 0x80,
    0x85, 0x68, 0x8a, 0x7c, 0x58, 0x0f, 0xc0, 0x01, 0xc0, 0x21, 0xcb, 0xf2,
    0x4d, 0x05, 0x05, 0x05, 0x24, 0x3b, 0x3b, 0x1b, 0x16, 0x8b, 0x45, 0x7b,
    0xa0, 0x48, 0x0c, 0xb1, 0xb6, 0x73, 0x7c, 0x72, 0x04, 0xdc, 0xff, 0x9c,
    0x17, 0x39, 0x00, 0x7e, 0x68, 0x32, 0xa7, 0x15, 0x74, 0x7d, 0xbe, 0x8a,
    0xa0, 0xa9, 0xa2, 0x70, 0x68, 0x52, 0x08, 0x19, 0x9d, 0x58, 0xa0, 0xd8,
    0xbe, 0x46, 0x99, 0x6e, 0xbb, 0xed, 0xb6, 0xdc, 0x57, 0x5e, 0x79, 0xc5,
    0x8f, 0xe7, 0x9b, 0x78, 0x3b, 0x7e, 0xfc, 0x38, 0x5b, 0xb2, 0x64, 0xc9,
    0x9f, 0x2a, 0x2a, 0x2a, 0xfe, 0xd2, 0x45, 0x81, 0xae, 0x07, 0xa4, 0x00,
    0x38, 0xd2, 0xd9, 0xc4, 0x04, 0xae, 0x5f, 0xdd, 0xa8, 0x22, 0xb0, 0xcb,
    0xec, 0xa2, 0x53, 0x86, 0x15, 0x4d, 0x11, 0x13, 0x45, 0x37, 0xc9, 0xae,
    0x06, 0x0a, 0x40, 0xd5, 0xea, 0xca, 0x05, 0x70, 0xd5, 0x58, 0x06, 0x6d,
    0x34, 0x87, 0xe3, 0xb8, 0x3b, 0xc7, 0x8e, 0x1d, 0x6b, 0x6e, 0x26, 0x06,
    0x00, 0x7e, 0xfe, 0xf9, 0x67, 0x5b, 0x55, 0x55, 0xd5, 0xe6, 0x2e, 0x0a,
    0x73, 0x43, 0xc2, 0xdd, 0x17, 0xaf, 0x77, 0x32, 0xc0, 0xcd, 0x32, 0xaa,
    0x6e, 0xa2, 0x53, 0x13, 0x77, 0x6d, 0xfa, 0x1c, 0x4f, 0x4f, 0xcf, 0x69,
    0x29, 0x29, 0x29, 0x2d, 0x03, 0x1b, 0xab, 0xd5, 0x8a, 0xc3, 0x87, 0x0f,
    0xef, 0x55, 0x14, 0xa5, 0xa0, 0x87, 0x85, 0xfb, 0xff, 0x1d, 0x9d, 0xda,
    0x39, 0xde, 0x9a, 0x1c, 0xfd, 0xcd, 0x37, 0xdf, 0x7c, 0x9b, 0x5e, 0xff,
    0xdb, 0x6a, 0xa1, 0x9c, 0x9c, 0x1c, 0x56, 0x55, 0x55, 0xf5, 0x23, 0x80,
    0x1b, 0xcd, 0x10, 0xf8, 0xb7, 0x40, 0x0b, 0x39, 0x1c, 0xc7, 0xdd, 0x92,
    0x92, 0x92, 0x62, 0x68, 0xdd, 0xa4, 0x65, 0x66, 0x66, 0x8a, 0x35, 0x35,
    0x35, 0xdb, 0xfa, 0x45, 0xb2, 0x7f, 0x6f, 0x74, 0x4a, 0x73, 0x5a, 0x98,
    0xe0, 0x38, 0x6e, 0xf2, 0xb0, 0x61, 0xc3, 0x5a, 0x56, 0x6d, 0xc8, 0xb2,
    0x8c, 0x63, 0xc7, 0x8e, 0xfd, 0x82, 0x26, 0x2b, 0xe7, 0x46, 0x85, 0x8c,
    0xa6, 0x5d, 0xd8, 0x15, 0x00, 0x0a, 0xd0, 0x64, 0xad, 0x59, 0xd0, 0xd4,
    0xa9, 0x8b, 0x1c, 0xc7, 0xc5, 0x4f, 0x9c, 0x38, 0x71, 0x5a, 0x48, 0x48,
    0x08, 0x39, 0xb0, 0x77, 0x17, 0x0b, 0x93, 0x0a, 0xc9, 0xb6, 0x82, 0xb6,
    0xb6, 0xf4, 0xac, 0x41, 0xc2, 0xf9, 0x6f, 0xf3, 0xc4, 0x2f, 0x1d, 0x72,
    0xcb, 0x52, 0x5c, 0x8a, 0x26, 0xf3, 0xbc, 0xf5, 0xa5, 0xbb, 0xc2, 0xff,
    0xaa, 0xcb, 0xcf, 0x90, 0x56, 0x7f, 0x3b, 0xb5, 0x8b, 0xaf, 0x99, 0x1c,
    0x9a, 0x98, 0x98, 0x38, 0xad, 0xf5, 0xf6, 0xf3, 0xf3, 0xe7, 0xcf, 0xa3,
    0xac, 0xac, 0x6c, 0x1f, 0x63, 0xec, 0x46, 0xf6, 0xa3, 0x9d, 0x04, 0x10,
    0x82, 0x0e, 0x9a, 0x65, 0xb3, 0xd9, 0xbc, 0x78, 0xd6, 0xac, 0x59, 0x77,
    0x0f, 0x1a, 0x34, 0x08, 0xf6, 0xb2, 0xf3, 0xb6, 0xd8, 0xfa, 0x52, 0x7d,
    0x7b, 0x72, 0xfe, 0x32, 0x4e, 0x77, 0xea, 0xd3, 0xbb, 0xe8, 0x6b, 0xd7,
    0x12, 0x52, 0xe5, 0x32, 0x28, 0x00, 0x4d, 0xab, 0x4b, 0x8b, 0x4e, 0x5a,
    0x7b, 0xcd, 0xe4, 0x44, 0xc5, 0xc5, 0xc5, 0x05, 0xb5, 0x6e, 0xd2, 0xb2,
    0xb3, 0xb3, 0x95, 0xea, 0xea, 0xea, 0x1f, 0x3a, 0x9b, 0xd1, 0x75, 0x0a,
    0x09, 0x1d, 0x2f, 0x3e, 0x27, 0x8a, 0xa2, 0x04, 0xfb, 0xf8, 0xf8, 0x40,
    0x51, 0x14, 0xa8, 0x9c, 0xb5, 0x75, 0x35, 0x76, 0x45, 0x8b, 0x56, 0x4d,
    0xbd, 0x9a, 0x03, 0xb4, 0x02, 0xe9, 0xae, 0x47, 0x5a, 0x41, 0x53, 0xe5,
    0xe8, 0x72, 0xbf, 0x4d, 0x01, 0x40, 0x10, 0x84, 0xd1, 0x09, 0x09, 0x09,
    0x6d, 0x16, 0xd3, 0x9d, 0x3d, 0x7b, 0xd6, 0x02, 0xe0, 0xba, 0x59, 0xeb,
    0xdc, 0x0b, 0xe0, 0x29, 0xa5, 0x01, 0x5e, 0x5e, 0x5e, 0x60, 0x8c, 0x41,
    0xdd, 0x58, 0x69, 0x2f, 0xb3, 0xb6, 0x8d, 0x15, 0x65, 0xd2, 0x10, 0x10,
    0xa0, 0x0e, 0xfd, 0xe0, 0x91, 0x06, 0x2e, 0x93, 0xa3, 0x28, 0x4a, 0x6a,
    0x5c, 0x5c, 0x5c, 0x4b, 0x8d, 0xb9, 0x1c, 0x6c, 0x3b, 0x53, 0x92, 0xa4,
    0x1b, 0xb9, 0x49, 0xbb, 0x22, 0x28, 0xa5, 0xea, 0xb0, 0xb0, 0xb0, 0x28,
    0x41, 0x10, 0x20, 0xcb, 0x32, 0x04, 0x47, 0x8d, 0xbe, 0xc4, 0xd2, 0x36,
    0x20, 0x91, 0xa7, 0x9a, 0x42, 0x52, 0x58, 0x7d, 0x77, 0xcf, 0x24, 0xb8,
    0x66, 0x19, 0x01, 0x60, 0xf0, 0xe0, 0xc1, 0xe3, 0x5a, 0xaf, 0x11, 0x28,
    0x2d, 0x2d, 0x45, 0x6d, 0x6d, 0xed, 0x69, 0xfc, 0x7b, 0x9b, 0xd0, 0x1e,
    0x91, 0x91, 0x91, 0x83, 0x01, 0xa0, 0xb0, 0xb0, 0x10, 0x5e, 0x6a, 0xe8,
    0x4b, 0xac, 0x6d, 0x15, 0xc4, 0xa4, 0x06, 0x14, 0xd6, 0x3f, 0x7e, 0x35,
    0xa0, 0x89, 0x1c, 0xef, 0xe8, 0xe8, 0xe8, 0x58, 0x8e, 0xfb, 0xad, 0xd2,
    0x9c, 0x3d, 0x7b, 0x56, 0xb1, 0xd9, 0x6c, 0x07, 0x71, 0x63, 0xf7, 0x37,
    0x57, 0x04, 0xa5, 0x34, 0x2e, 0x32, 0x32, 0x92, 0x07, 0x80, 0x82, 0xfc,
    0x7c, 0x71, 0xb0, 0x37, 0x57, 0x52, 0x6a, 0x69, 0xfb, 0xba, 0x26, 0x0d,
    0x85, 0x86, 0x27, 0x15, 0xfd, 0x22, 0x20, 0x9a, 0xc8, 0x89, 0x8b, 0x8c,
    0x8c, 0x64, 0xad, 0x17, 0xa5, 0x97, 0x96, 0x96, 0x12, 0x8b, 0xc5, 0x72,
    0xba, 0xbf, 0x84, 0xea, 0x0b, 0x98, 0x4c, 0xa6, 0xb1, 0xd1, 0xd1, 0xd1,
    0x14, 0x00, 0x0a, 0xf2, 0xcf, 0xb1, 0x01, 0x9e, 0x28, 0xbf, 0xec, 0xaa,
    0xf9, 0x2d, 0x8d, 0x86, 0xc8, 0xaa, 0x7e, 0x9a, 0xcb, 0x01, 0x00, 0x5e,
    0x10, 0x84, 0xe8, 0xd0, 0xd0, 0xd0, 0x36, 0x3e, 0xb6, 0xb2, 0xb2, 0x32,
    0x86, 0x5e, 0x18, 0xdf, 0x58, 0xd3, 0xcc, 0xb4, 0x51, 0x64, 0xff, 0x7d,
    0xb4, 0x4c, 0x7a, 0xa2, 0xd2, 0xd6, 0xb1, 0x52, 0xf2, 0x14, 0x98, 0x14,
    0x21, 0xfc, 0x43, 0xcb, 0x93, 0xff, 0xee, 0xa5, 0xf6, 0x5e, 0x6b, 0x34,
    0x1a, 0x47, 0xc5, 0xc4, 0xc4, 0x40, 0x92, 0x24, 0x5c, 0xba, 0x78, 0xc1,
    0x22, 0x06, 0xbb, 0x7a, 0xe8, 0x4d, 0x6a, 0x02, 0xa1, 0x8b, 0x21, 0x23,
    0x7b, 0x12, 0xbc, 0x24, 0x49, 0x11, 0xed, 0x83, 0x39, 0xd4, 0xd4, 0xd4,
    0x94, 0x0b, 0x82, 0x60, 0x77, 0x3a, 0x7b, 0xf6, 0xd8, 0x1a, 0x7d, 0x7a,
    0x8d, 0x52, 0xfb, 0x9c, 0xe9, 0x87, 0xed, 0xf9, 0xd2, 0xcb, 0xcb, 0x8f,
    0xda, 0xaf, 0xb8, 0xf2, 0xe7, 0xab, 0x7b, 0x3c, 0x7e, 0x7f, 0x5b, 0x04,
    0xff, 0x1e, 0x7a, 0x21, 0x5e, 0x01, 0xc7, 0x71, 0xe6, 0xe4, 0xe4, 0xe4,
    0x51, 0x3c, 0xcf, 0xc3, 0x6a, 0xb5, 0xe2, 0x4c, 0xf6, 0xa9, 0xdd, 0x45,
    0x46, 0xc5, 0x65, 0x87, 0xb5, 0x51, 0x4d, 0x38, 0x9e, 0xa2, 0xdf, 0xc8,
    0xa1, 0x6a, 0xb5, 0x3a, 0xa2, 0xf5, 0xae, 0x01, 0x00, 0x28, 0x2e, 0x2e,
    0x2e, 0x70, 0x3a, 0x9d, 0xbd, 0xb2, 0xe7, 0x9e, 0x10, 0x64, 0x4d, 0x89,
    0xe4, 0x4f, 0x00, 0x80, 0xa8, 0x74, 0x7c, 0x7d, 0x91, 0xed, 0x08, 0x6d,
    0x70, 0x62, 0xba, 0x35, 0xad, 0xc7, 0x03, 0xae, 0x43, 0xa7, 0xd3, 0xdd,
    0x9a, 0x94, 0x94, 0xa4, 0x07, 0x80, 0xbc, 0xbc, 0x3c, 0x46, 0x9d, 0x96,
    0xc3, 0x55, 0x76, 0xe6, 0xd7, 0x3e, 0x9d, 0x97, 0x86, 0x00, 0xe8, 0x47,
    0x72, 0xc2, 0xc3, 0xc3, 0xa3, 0x5b, 0x1b, 0x03, 0x00, 0x50, 0x51, 0x51,
    0x51, 0x89, 0x5e, 0xda, 0x39, 0xcc, 0x53, 0x62, 0x1d, 0xec, 0xc3, 0xbf,
    0x33, 0x37, 0xce, 0x65, 0x77, 0x5f, 0x1b, 0xfc, 0x70, 0x5e, 0xa4, 0x97,
    0xea, 0xe5, 0xc7, 0x24, 0xc5, 0xfd, 0xd6, 0xf3, 0x6e, 0x40, 0xe3, 0xe5,
    0xe5, 0x35, 0x2b, 0x35, 0x35, 0x95, 0x30, 0xc6, 0x70, 0xec, 0xd8, 0xb1,
    0xc6, 0xc7, 0x6e, 0xe2, 0x4b, 0xcf, 0xd5, 0xc8, 0x2e, 0x91, 0x37, 0x4d,
    0x6a, 0xe2, 0x10, 0x65, 0xd6, 0x6f, 0xdb, 0x5a, 0xa8, 0xd1, 0x68, 0x74,
    0x09, 0x54, 0xaa, 0x28, 0x4a, 0x73, 0x80, 0xea, 0x1e, 0x87, 0x3e, 0xbd,
    0x86, 0x19, 0x54, 0xd8, 0xf8, 0x6c, 0x8a, 0x66, 0xb7, 0xb7, 0xb6, 0x63,
    0xff, 0x9f, 0x4d, 0x04, 0x36, 0xe5, 0x8a, 0xa3, 0x15, 0x86, 0xa4, 0x9e,
    0x2c, 0x9f, 0x52, 0x1a, 0x3e, 0x62, 0xc4, 0x88, 0x89, 0x06, 0x83, 0x01,
    0x0e, 0x87, 0x03, 0x47, 0x8e, 0x1c, 0x39, 0xf7, 0xfb, 0x44, 0x95, 0x2a,
    0xbb, 0xd2, 0x35, 0xae, 0x67, 0x80, 0x07, 0xbd, 0xd8, 0x1f, 0x0b, 0xd8,
    0x9b, 0x41, 0x05, 0x41, 0x50, 0xb7, 0x8f, 0x1c, 0xc8, 0xdc, 0x05, 0x55,
    0xee, 0xc9, 0x42, 0x09, 0xb1, 0x0d, 0x34, 0xd1, 0xc5, 0x2f, 0x0d, 0xd7,
    0x5c, 0xb1, 0x56, 0x7e, 0x75, 0xc6, 0xc9, 0x97, 0x5b, 0xd9, 0x7c, 0x6b,
    0x9a, 0xb9, 0xa7, 0xa2, 0x5b, 0x11, 0xb3, 0xd9, 0x3c, 0x67, 0xdc, 0xb8,
    0x71, 0x3a, 0x00, 0xb8, 0x78, 0xf1, 0x22, 0xcb, 0x3d, 0x73, 0x7a, 0x83,
    0x8a, 0x23, 0xf1, 0xd9, 0x6e, 0x4e, 0xfb, 0x88, 0x36, 0xd3, 0x73, 0x2a,
    0x8e, 0xf4, 0xf9, 0xd6, 0x8f, 0x66, 0x50, 0x9e, 0xe7, 0x5d, 0x36, 0xa8,
    0xb2, 0x5e, 0x66, 0x47, 0x9f, 0x5e, 0x03, 0x4a, 0x70, 0xf8, 0xfe, 0x38,
    0xd5, 0x3f, 0xc6, 0x85, 0xf2, 0x1d, 0x96, 0x75, 0xa1, 0x4e, 0xc1, 0x8e,
    0x0b, 0xe2, 0x3d, 0xb2, 0xc2, 0xba, 0x14, 0xa7, 0xb3, 0x23, 0x10, 0x42,
    0x02, 0xe2, 0xe3, 0xe3, 0x1f, 0x4e, 0x48, 0x48, 0x20, 0x8c, 0x31, 0xec,
    0xde, 0xbd, 0xdb, 0xea, 0xa7, 0x51, 0xb6, 0x54, 0xda, 0x94, 0x41, 0xc5,
    0xed, 0x06, 0xa0, 0x1e, 0x2a, 0x02, 0x5f, 0x1d, 0x2d, 0x42, 0x7f, 0x6a,
    0x0e, 0xc7, 0x71, 0x2e, 0xe4, 0xf4, 0x05, 0x3c, 0xdf, 0xad, 0x55, 0x3c,
    0xd5, 0x64, 0xd9, 0x92, 0x31, 0xda, 0x1c, 0x0f, 0x95, 0xfb, 0xe6, 0x8d,
    0x01, 0xf8, 0x32, 0xc7, 0x69, 0xaa, 0x6a, 0x64, 0x0f, 0x5b, 0xd3, 0xcc,
    0xdd, 0x8d, 0x36, 0x42, 0x4c, 0x26, 0xd3, 0xdc, 0x69, 0xd3, 0xa6, 0x0d,
    0xe0, 0x38, 0x0e, 0x0d, 0x0d, 0x0d, 0xd8, 0xbb, 0x77, 0xef, 0x2f, 0x5f,
    0xdf, 0xa3, 0xfb, 0xf5, 0x78, 0xb9, 0x3c, 0xa4, 0x7d, 0x75, 0x0c, 0x35,
    0x50, 0x48, 0x0a, 0x2b, 0x44, 0x3f, 0xf9, 0xd5, 0x80, 0x26, 0x72, 0x5c,
    0xed, 0x7b, 0x93, 0xc9, 0x13, 0x7d, 0x70, 0xf0, 0x11, 0x47, 0x49, 0xed,
    0xcd, 0xfe, 0xdc, 0xa2, 0x3f, 0x0c, 0x55, 0x77, 0x68, 0xb3, 0xff, 0x5c,
    0x2c, 0x91, 0x5d, 0x17, 0xa5, 0xf9, 0xb2, 0xc2, 0x42, 0xbb, 0x53, 0x16,
    0x21, 0x24, 0x28, 0x3e, 0x3e, 0x7e, 0x7e, 0x6a, 0x6a, 0x2a, 0x05, 0x80,
    0xfd, 0xfb, 0xf7, 0x3b, 0x0b, 0x0a, 0x0a, 0x56, 0xde, 0xe4, 0xc3, 0xfb,
    0xe5, 0x55, 0xcb, 0x2e, 0x96, 0x5a, 0x98, 0x91, 0x32, 0x9e, 0x92, 0xf3,
    0xfd, 0xb1, 0xd2, 0xb3, 0x19, 0xd4, 0x6e, 0xb7, 0xd7, 0xb7, 0xff, 0x31,
    0x22, 0x22, 0x22, 0x5a, 0x10, 0x84, 0x1e, 0x39, 0x51, 0xe3, 0x4a, 0xd0,
    0xa7, 0xd7, 0x80, 0xa3, 0x64, 0xc7, 0x7f, 0x25, 0xab, 0x3f, 0x1b, 0xe4,
    0xcd, 0xb9, 0x6d, 0xde, 0x64, 0x05, 0xf8, 0x30, 0xcb, 0x11, 0x5c, 0x66,
    0x65, 0x0b, 0xda, 0x1f, 0x24, 0xd4, 0x05, 0xf0, 0xbe, 0xbe, 0xbe, 0x4f,
    0xcf, 0x9e, 0x3d, 0x3b, 0x46, 0x10, 0x84, 0xe6, 0x63, 0x2e, 0x7f, 0x95,
    0x65, 0xf9, 0x5b, 0xab, 0xc8, 0x86, 0xe4, 0x54, 0x29, 0x2e, 0xda, 0x11,
    0x66, 0xa4, 0x8a, 0x96, 0x27, 0xe7, 0xae, 0xb1, 0xbc, 0x1e, 0x01, 0x2d,
    0x2e, 0x2e, 0xfe, 0xb5, 0x7d, 0x17, 0x13, 0x18, 0x18, 0x18, 0x28, 0x49,
    0x92, 0xeb, 0x11, 0xb8, 0xbd, 0x00, 0xc3, 0x3b, 0x35, 0x8a, 0xa7, 0x9a,
    0xbc, 0xb1, 0x28, 0x55, 0x6d, 0xe9, 0xc8, 0x76, 0x3b, 0x5c, 0x2c, 0x91,
    0xed, 0x17, 0xc4, 0xc7, 0x24, 0x85, 0x0d, 0xbc, 0x96, 0x32, 0x04, 0x41,
    0x48, 0xbe, 0xe5, 0x96, 0x5b, 0xfe, 0x2b, 0x39, 0x39, 0x99, 0x02, 0xc0,
    0xd1, 0xa3, 0x47, 0xc5, 0xac, 0xac, 0xac, 0x55, 0xd6, 0x34, 0xb3, 0xcd,
    0x2e, 0xb1, 0x9b, 0x73, 0x2a, 0x5d, 0xcd, 0xe8, 0x50, 0x23, 0xe5, 0x78,
    0x8a, 0xfc, 0x6b, 0x29, 0xaf, 0xa7, 0x40, 0x0b, 0x0b, 0x0b, 0x0b, 0x64,
    0xb9, 0x6d, 0x9f, 0x17, 0x14, 0x14, 0x44, 0x78, 0x9e, 0xbf, 0xa6, 0x0f,
    0x71, 0x8d, 0x28, 0x98, 0x1e, 0x2d, 0x7c, 0x9c, 0xe0, 0xdb, 0x81, 0xf6,
    0x30, 0x60, 0x75, 0x96, 0xc3, 0xaf, 0xa8, 0x41, 0x79, 0xaa, 0xab, 0x96,
    0x1b, 0xcf, 0xf3, 0x9e, 0x03, 0x07, 0x0e, 0x5c, 0x32, 0x6b, 0xd6, 0x2c,
    0x2f, 0x4a, 0x29, 0xea, 0xeb, 0xeb, 0xf1, 0xaf, 0x7f, 0xfd, 0x2b, 0x5b,
    0x14, 0xc5, 0xcf, 0x18, 0x83, 0xba, 0xda, 0xce, 0x52, 0xce, 0xd6, 0xb8,
    0xf6, 0xf9, 0x81, 0x7a, 0xd2, 0xe0, 0x94, 0x59, 0xbf, 0x0d, 0x40, 0x01,
    0x80, 0x8a, 0xa2, 0x78, 0xb1, 0xa2, 0xa2, 0xad, 0xe3, 0x75, 0xc0, 0x80,
    0x01, 0xc4, 0x68, 0x34, 0x8e, 0x40, 0x1f, 0x1d, 0xf2, 0xea, 0xf9, 0x6e,
    0x2d, 0x74, 0x3c, 0x49, 0x7f, 0x2e, 0x55, 0x5d, 0x4b, 0x3b, 0x28, 0x31,
    0xb3, 0x4c, 0x26, 0x3f, 0xe6, 0x4b, 0x0f, 0x8a, 0x32, 0x1b, 0xdc, 0x85,
    0xac, 0x79, 0x4f, 0x4f, 0xcf, 0x67, 0x1e, 0x78, 0xe0, 0x81, 0xdb, 0x82,
    0x83, 0x83, 0xc1, 0x18, 0x43, 0x46, 0x46, 0x86, 0xfd, 0xe4, 0xc9, 0x93,
    0xcb, 0x18, 0x63, 0x75, 0x0a, 0x60, 0xda, 0x57, 0x28, 0x8d, 0x12, 0xdd,
    0x74, 0xf9, 0x83, 0xbc, 0xb9, 0x1c, 0x8e, 0xf6, 0xfd, 0x3e, 0xd0, 0xd6,
    0xa0, 0x3c, 0xcf, 0x17, 0x14, 0x15, 0x15, 0xb5, 0xa9, 0xb1, 0xb1, 0xb1,
    0xb1, 0x24, 0x30, 0x30, 0x70, 0x2a, 0xc7, 0x71, 0x2e, 0x51, 0x95, 0x7a,
    0x0b, 0xc6, 0x77, 0x6b, 0x0b, 0xa7, 0x46, 0x09, 0x1f, 0x26, 0xfb, 0x73,
    0x1d, 0x1e, 0xc2, 0xf0, 0xc9, 0x09, 0x87, 0x77, 0x41, 0xbd, 0xf2, 0xac,
    0x35, 0xcd, 0xdc, 0x29, 0x0b, 0x53, 0xa7, 0xd3, 0x4d, 0xbe, 0xf3, 0xce,
    0x3b, 0x5f, 0x18, 0x37, 0x6e, 0x9c, 0x00, 0x00, 0x45, 0x45, 0x45, 0x6c,
    0xd3, 0xa6, 0x4d, 0x3b, 0x45, 0x51, 0xdc, 0x0c, 0x00, 0x36, 0x91, 0x8d,
    0xde, 0x5f, 0x28, 0xb9, 0xbc, 0xa3, 0xa7, 0x9a, 0x20, 0xd6, 0x9b, 0x3b,
    0xc1, 0x91, 0xfe, 0xdd, 0x56, 0x49, 0x25, 0x49, 0x3a, 0x70, 0xf2, 0xe4,
    0xc9, 0x36, 0x42, 0x08, 0x82, 0x80, 0xd1, 0xa3, 0x47, 0xa7, 0x52, 0x4a,
    0xbb, 0x52, 0x4b, 0xbb, 0x0d, 0x0d, 0x4f, 0x96, 0xff, 0x21, 0x45, 0x53,
    0xc5, 0x77, 0x60, 0x34, 0x9f, 0xaa, 0x90, 0xb1, 0xf9, 0x57, 0xe7, 0x6c,
    0x9b, 0xc8, 0x86, 0x5f, 0x2d, 0x2f, 0x8e, 0xe3, 0x92, 0x52, 0x53, 0x53,
    0xdf, 0x9e, 0x3b, 0x77, 0xae, 0x27, 0xcf, 0xf3, 0xb0, 0xdb, 0xed, 0xf8,
    0xec, 0xb3, 0xcf, 0x8a, 0xce, 0x9f, 0x3f, 0xbf, 0x18, 0x80, 0xc3, 0x9a,
    0x66, 0xe6, 0x2c, 0x4e, 0x76, 0xfb, 0xbe, 0x42, 0xc9, 0xa5, 0xb4, 0xcb,
    0xcd, 0xeb, 0x09, 0xf4, 0xa3, 0x19, 0x0d, 0x00, 0x94, 0x31, 0x76, 0x3a,
    0x3b, 0x3b, 0xbb, 0xb4, 0x7d, 0xbf, 0x33, 0x6a, 0xd4, 0x28, 0xde, 0x6c,
    0x36, 0xdf, 0x87, 0x3e, 0x3c, 0x29, 0xc4, 0xf8, 0x4e, 0x6d, 0xc9, 0x94,
    0x48, 0x61, 0x65, 0x6a, 0x00, 0xef, 0xf6, 0xa3, 0x30, 0x00, 0x9f, 0x64,
    0x39, 0x0d, 0x67, 0xaa, 0xe4, 0x3f, 0xd6, 0x3e, 0x67, 0xf2, 0x70, 0x97,
    0xe6, 0x32, 0xa2, 0x92, 0x93, 0x93, 0x3f, 0x78, 0xea, 0xa9, 0xa7, 0x06,
    0x7b, 0x7a, 0x7a, 0x36, 0x37, 0x67, 0x8e, 0x9d, 0x3b, 0x77, 0x2e, 0x65,
    0x8c, 0x65, 0x01, 0x80, 0xac, 0x30, 0xcf, 0xa3, 0x25, 0xd2, 0xed, 0x85,
    0x0d, 0xae, 0x45, 0xdd, 0xec, 0xcf, 0x31, 0x2d, 0x4f, 0x8e, 0xf4, 0xa7,
    0x19, 0x0d, 0x5c, 0x5e, 0xf1, 0x7e, 0xe2, 0xc4, 0x89, 0x6f, 0xdb, 0xf7,
    0x3b, 0x91, 0x91, 0x91, 0x64, 0xd0, 0xa0, 0x41, 0xd3, 0x29, 0xa5, 0x41,
    0x7d, 0x29, 0x90, 0x96, 0xc7, 0x8a, 0x67, 0x52, 0xd4, 0xa5, 0xaa, 0x0e,
    0x8c, 0xe6, 0x4b, 0x0d, 0x0a, 0xf9, 0x2c, 0xdb, 0x79, 0x9b, 0x55, 0x64,
    0x53, 0xdd, 0x79, 0xac, 0x09, 0x21, 0x61, 0x37, 0xdd, 0x74, 0xd3, 0xfb,
    0x4f, 0x3f, 0xfd, 0xf4, 0x88, 0x90, 0x90, 0x26, 0xc7, 0xc2, 0xe9, 0xd3,
    0xa7, 0xe5, 0xcf, 0x3f, 0xff, 0xfc, 0x1b, 0xab, 0xd5, 0xfa, 0x49, 0x73,
    0x3a, 0xab, 0x88, 0x71, 0xdf, 0x9f, 0x13, 0xc3, 0xdd, 0x95, 0x31, 0xc4,
    0x9f, 0xb7, 0xa1, 0x13, 0x41, 0xb9, 0x7b, 0x1b, 0x14, 0x00, 0x1c, 0x0e,
    0xc7, 0x17, 0x3b, 0x76, 0xec, 0x70, 0xb6, 0x36, 0xa9, 0x29, 0xa5, 0x98,
    0x31, 0x63, 0x46, 0xa4, 0xb7, 0xb7, 0xf7, 0x02, 0xf4, 0xe1, 0x49, 0xbc,
    0x1e, 0xef, 0xd4, 0x96, 0xdf, 0x1e, 0x21, 0xbc, 0x3f, 0x32, 0xc8, 0xbd,
    0xf6, 0x00, 0xc0, 0x57, 0xa7, 0x9d, 0xaa, 0xa3, 0xa5, 0xf2, 0x0b, 0x0a,
    0x43, 0xfb, 0x83, 0xed, 0xa2, 0xe3, 0xe3, 0xe3, 0x3f, 0x59, 0xb8, 0x70,
    0xe1, 0xa4, 0x98, 0x98, 0xa6, 0x48, 0x5d, 0xc5, 0xc5, 0xc5, 0x58, 0xb9,
    0x72, 0xe5, 0xd1, 0xa2, 0xa2, 0xa2, 0x34, 0x00, 0x8d, 0x00, 0xd0, 0xf0,
    0xbc, 0x49, 0x55, 0x6e, 0x53, 0xee, 0xfb, 0xf1, 0xbc, 0xeb, 0x29, 0x1c,
    0x3c, 0x05, 0x46, 0x07, 0xf3, 0x7b, 0xd9, 0xe5, 0xb4, 0xfd, 0x09, 0x0a,
    0x00, 0xb2, 0x2c, 0x1f, 0xdc, 0xbe, 0x7d, 0x7b, 0x96, 0xcd, 0xd6, 0x76,
    0x3d, 0xc7, 0xcd, 0x37, 0xdf, 0x4c, 0xc6, 0x8d, 0x1b, 0xb7, 0x40, 0xab,
    0xd5, 0x5e, 0xb5, 0x8d, 0xef, 0x49, 0x68, 0x05, 0xb2, 0xea, 0xe9, 0xa1,
    0xea, 0x42, 0x4d, 0x07, 0x46, 0x73, 0x9d, 0x83, 0x61, 0x75, 0x96, 0x23,
    0xb9, 0xc2, 0xa6, 0xb4, 0xb8, 0x75, 0x28, 0xa5, 0x89, 0x43, 0x87, 0x0e,
    0x5d, 0x93, 0x96, 0x96, 0x76, 0x6b, 0x42, 0x42, 0x02, 0x01, 0x80, 0xda,
    0xda, 0x5a, 0x7c, 0xf4, 0xd1, 0x47, 0x67, 0x8f, 0x1d, 0x3b, 0xf6, 0xa4,
    0x24, 0x49, 0x2d, 0x33, 0xbb, 0x32, 0x43, 0xf0, 0xce, 0x0b, 0xe2, 0x6d,
    0x15, 0x8d, 0xae, 0x96, 0x7b, 0xbc, 0x0f, 0x07, 0x7f, 0x3d, 0xd9, 0xcb,
    0xf5, 0x43, 0x50, 0x88, 0xf6, 0x68, 0xae, 0x39, 0xf2, 0xd9, 0xb3, 0x67,
    0x97, 0xba, 0xd3, 0x9e, 0x47, 0x1e, 0x79, 0xc4, 0x3b, 0x36, 0x36, 0x36,
    0xbd, 0xab, 0x87, 0x04, 0x75, 0x07, 0xfa, 0xf4, 0x9a, 0xca, 0x49, 0x11,
    0xc2, 0x8a, 0xb1, 0x21, 0x42, 0x87, 0xd6, 0xd2, 0xb6, 0x7c, 0x91, 0xfe,
    0x54, 0x20, 0x2e, 0x2c, 0x6a, 0x50, 0x92, 0xf4, 0x7a, 0xfd, 0x5d, 0x63,
    0xc7, 0x8e, 0xfd, 0xf2, 0xc5, 0x17, 0x5f, 0x1c, 0xd9, 0xac, 0x31, 0x75,
    0x75, 0x75, 0x58, 0xbd, 0x7a, 0x75, 0x61, 0x46, 0x46, 0xc6, 0xb3, 0x8c,
    0xb1, 0x96, 0xe8, 0xbc, 0xd6, 0x34, 0x33, 0x57, 0x6e, 0x65, 0x4f, 0xac,
    0x3f, 0x2d, 0xba, 0x9d, 0xc5, 0x1b, 0x1f, 0x26, 0x28, 0x1c, 0xc5, 0x4f,
    0xfd, 0xdd, 0xdf, 0x00, 0xad, 0x3a, 0x7b, 0x45, 0x51, 0xbe, 0xdd, 0xb0,
    0x61, 0xc3, 0x81, 0xea, 0xea, 0xea, 0x36, 0xd5, 0xc9, 0xdb, 0xdb, 0x1b,
    0x0b, 0x16, 0x2c, 0x18, 0x11, 0x13, 0x13, 0xb3, 0x5a, 0x10, 0x84, 0x58,
    0xf4, 0xd1, 0xd8, 0x47, 0xcd, 0x91, 0xd5, 0x0b, 0x92, 0xd5, 0x17, 0x74,
    0x82, 0xfb, 0xe2, 0x1c, 0x32, 0xf0, 0xb7, 0x43, 0xf6, 0xd0, 0x03, 0x45,
    0xd2, 0xfa, 0x87, 0x66, 0x4e, 0x5d, 0xf7, 0xf2, 0xcb, 0x2f, 0xc7, 0x85,
    0x86, 0x36, 0xb9, 0xdf, 0xea, 0xea, 0xea, 0xb0, 0x6a, 0xd5, 0xaa, 0xc2,
    0xef, 0xbe, 0xfb, 0xee, 0x49, 0x49, 0x92, 0xfe, 0xa7, 0xf5, 0x73, 0xa2,
    0xcc, 0xa2, 0x32, 0x2e, 0x88, 0xf3, 0x0e, 0x95, 0x48, 0x2e, 0x19, 0x53,
    0x02, 0x4c, 0x0c, 0xe7, 0x4b, 0x29, 0x21, 0x59, 0xbd, 0xf1, 0x4e, 0x5d,
    0x45, 0xeb, 0xbe, 0x44, 0xa9, 0xaf, 0xaf, 0xcf, 0x76, 0x38, 0x1c, 0xb3,
    0x52, 0x52, 0x52, 0xb4, 0xad, 0x67, 0x47, 0xfd, 0xfd, 0xfd, 0x91, 0x98,
    0x98, 0x38, 0xb0, 0xb8, 0xb8, 0x78, 0x52, 0x65, 0x65, 0x65, 0x9e, 0xa2,
    0x28, 0x17, 0x19, 0x73, 0x8d, 0xae, 0xd4, 0x93, 0x78, 0xf3, 0x80, 0xdd,
    0xbe, 0xea, 0x0e, 0x1d, 0xb2, 0xca, 0xe5, 0xdb, 0xf2, 0xaa, 0x15, 0xb7,
    0x16, 0x63, 0xb5, 0x9d, 0x11, 0x91, 0x51, 0xef, 0xb4, 0xa9, 0x89, 0x1a,
    0x55, 0xf8, 0x50, 0x30, 0xca, 0xa3, 0xaa, 0xaa, 0x0a, 0x2b, 0x57, 0xae,
    0xbc, 0xf4, 0xc3, 0x0f, 0x3f, 0x3c, 0x29, 0xcb, 0xf2, 0x96, 0xd6, 0xe9,
    0xeb, 0x9f, 0x37, 0x6b, 0x2f, 0xd4, 0x29, 0x6f, 0xbf, 0xbc, 0xbb, 0x71,
    0x44, 0x99, 0xd5, 0x35, 0xc6, 0x4d, 0x92, 0x3f, 0xc7, 0x5e, 0x1d, 0xad,
    0xfd, 0x3b, 0x4f, 0xc9, 0x8e, 0x37, 0x0f, 0xf4, 0xca, 0x61, 0xf1, 0x5d,
    0x42, 0x9b, 0x8e, 0x9e, 0x31, 0x56, 0x5c, 0x50, 0x50, 0x40, 0x7d, 0x7c,
    0x7c, 0x46, 0x47, 0x46, 0x46, 0xf2, 0xad, 0x09, 0x32, 0x9b, 0xcd, 0x64,
    0xd8, 0xb0, 0x61, 0xbe, 0x8a, 0xa2, 0xdc, 0x53, 0x56, 0x56, 0x66, 0xb6,
    0x5a, 0xad, 0xd9, 0x68, 0x5a, 0xb1, 0xdf, 0x6b, 0x78, 0x75, 0xb4, 0x36,
    0x27, 0xca, 0x4c, 0xc7, 0x6e, 0xcb, 0x97, 0xc2, 0xea, 0x9d, 0xae, 0x1f,
    0x13, 0x00, 0xce, 0xd6, 0xc8, 0x68, 0x2c, 0x39, 0x87, 0x31, 0x81, 0x32,
    0xf2, 0xed, 0x3a, 0xf6, 0xce, 0xf2, 0x15, 0xa7, 0x33, 0x32, 0x32, 0xe6,
    0x2b, 0x8a, 0xf2, 0x53, 0xeb, 0x74, 0xd6, 0x34, 0x33, 0xa9, 0x77, 0x2a,
    0xf7, 0xfd, 0xfd, 0x88, 0x63, 0xf1, 0xf7, 0xe7, 0x44, 0x97, 0xde, 0x8c,
    0x12, 0xe0, 0x95, 0x91, 0x5a, 0xdb, 0xd0, 0x40, 0xfe, 0x31, 0x7d, 0x7a,
    0xcd, 0x75, 0xb1, 0xd2, 0xd5, 0xc5, 0x0a, 0x93, 0x24, 0xe9, 0x60, 0x66,
    0x66, 0xa6, 0x44, 0x08, 0x49, 0x8d, 0x8d, 0x8d, 0x55, 0xb7, 0x8e, 0xe0,
    0xa1, 0xd1, 0x68, 0x30, 0x74, 0xe8, 0x50, 0xf5, 0xc0, 0x81, 0x03, 0x47,
    0xd5, 0xd6, 0xd6, 0xde, 0xd1, 0xd0, 0xd0, 0xc0, 0x9c, 0x4e, 0x67, 0x01,
    0x7a, 0xc9, 0xb2, 0x79, 0xf3, 0x80, 0xdd, 0xf9, 0x64, 0xb2, 0xe6, 0x4c,
    0x98, 0x91, 0xce, 0xda, 0x7d, 0x49, 0xd2, 0xb8, 0x73, 0xb3, 0x00, 0xc0,
    0xa9, 0x72, 0x11, 0x75, 0x85, 0xb9, 0x08, 0x2a, 0xde, 0x55, 0xe5, 0x61,
    0xb9, 0x38, 0x7f, 0xdb, 0x1c, 0x8f, 0x9d, 0xad, 0x6b, 0xbe, 0x35, 0xcd,
    0x4c, 0x6c, 0x22, 0x1b, 0xb6, 0xf5, 0x9c, 0xb4, 0xea, 0x8d, 0x9f, 0xed,
    0x66, 0xc9, 0x4d, 0x3e, 0xb1, 0xde, 0x1c, 0x7b, 0xf3, 0x16, 0xed, 0x5a,
    0x9f, 0xe5, 0xb5, 0xeb, 0x7a, 0xe3, 0x5d, 0xae, 0x05, 0xee, 0x4c, 0x64,
    0x45, 0x14, 0xc5, 0x7d, 0x99, 0x99, 0x99, 0x97, 0x6a, 0x6a, 0x6a, 0xc6,
    0xc4, 0xc4, 0xc4, 0xe8, 0x74, 0x3a, 0x1d, 0x69, 0x9e, 0xca, 0x26, 0x84,
    0x20, 0x28, 0x28, 0x08, 0xe3, 0xc7, 0x8f, 0xf7, 0x0d, 0x0d, 0x0d, 0x9d,
    0x62, 0xb5, 0x5a, 0xef, 0x74, 0x38, 0x1c, 0x3e, 0x0e, 0x87, 0xa3, 0x14,
    0x4d, 0xfb, 0x4e, 0xba, 0x3b, 0xad, 0x4b, 0x01, 0xe8, 0x39, 0x8e, 0x0b,
    0xf4, 0xf4, 0xf4, 0x9c, 0xbb, 0xa5, 0xc2, 0x7b, 0xfe, 0xad, 0xc3, 0xe2,
    0xa3, 0x7d, 0xe5, 0x4a, 0x3e, 0xb3, 0xd4, 0x09, 0x77, 0x73, 0xb4, 0x0c,
    0xc0, 0xa9, 0x72, 0x09, 0x17, 0x6a, 0x9d, 0xba, 0xfb, 0x06, 0x0b, 0x23,
    0xbc, 0x34, 0x84, 0xbc, 0x3e, 0x56, 0x7b, 0xe9, 0x95, 0xd1, 0x5a, 0x69,
    0xf1, 0x48, 0xad, 0xce, 0x26, 0xb1, 0x29, 0xdb, 0x0b, 0xc4, 0x8f, 0xd3,
    0x32, 0x6c, 0x61, 0x75, 0x0e, 0xd7, 0x0c, 0x04, 0x0e, 0x78, 0x7b, 0x82,
    0xae, 0x32, 0xd9, 0x9f, 0x7b, 0xe0, 0xad, 0x03, 0xae, 0x53, 0x28, 0xfd,
    0x85, 0x2b, 0x76, 0xee, 0x1c, 0xc7, 0xa5, 0x44, 0x46, 0x46, 0xbe, 0x33,
    0x7f, 0xfe, 0xfc, 0x51, 0xc3, 0x86, 0x0d, 0xe3, 0x5a, 0x6b, 0x51, 0x33,
    0x24, 0x49, 0x42, 0x4e, 0x4e, 0x0e, 0xdb, 0xb3, 0x67, 0x8f, 0xed, 0xf8,
    0xf1, 0xe3, 0x47, 0xab, 0xab, 0xab, 0xb3, 0x2c, 0x16, 0xcb, 0x3e, 0x9b,
    0xcd, 0x76, 0x98, 0x52, 0x5a, 0x2d, 0xcb, 0xb2, 0x88, 0x26, 0x37, 0x88,
    0x8c, 0xdf, 0xa6, 0x7c, 0x09, 0x9a, 0xb6, 0x9f, 0x70, 0x68, 0x5a, 0xd8,
    0x28, 0x48, 0x92, 0x14, 0x60, 0x34, 0x1a, 0x47, 0x6a, 0x34, 0x9a, 0x11,
    0xde, 0xde, 0xde, 0x71, 0x71, 0x71, 0x71, 0x49, 0xc3, 0x86, 0x0d, 0xd3,
    0x25, 0x27, 0x27, 0x13, 0xbd, 0x56, 0x0d, 0xc3, 0xb1, 0x4f, 0xf1, 0xb7,
    0x4f, 0xfe, 0x85, 0x75, 0x27, 0x2c, 0x70, 0x57, 0xf3, 0x9b, 0xa1, 0xe6,
    0x80, 0x89, 0xe1, 0x02, 0x9b, 0x3d, 0x58, 0x28, 0x4a, 0xf2, 0xe3, 0x4f,
    0x95, 0xdb, 0x14, 0xdf, 0xef, 0xf2, 0xc4, 0x21, 0x6b, 0x4e, 0x39, 0xf9,
    0x06, 0xa7, 0x2b, 0x31, 0x04, 0xc0, 0xb4, 0x28, 0x41, 0x5a, 0x3b, 0x4d,
    0xff, 0x82, 0xe9, 0xdd, 0xda, 0xe5, 0x9d, 0xfb, 0x6c, 0x7d, 0x83, 0xce,
    0x58, 0x5e, 0x06, 0xbd, 0x5e, 0xff, 0xc2, 0xc4, 0x89, 0x13, 0x9f, 0x9a,
    0x33, 0x67, 0x8e, 0x77, 0x58, 0x58, 0x18, 0x69, 0xbf, 0x94, 0xaa, 0x19,
    0x8a, 0xa2, 0xa0, 0xb8, 0xb8, 0x18, 0xb9, 0xb9, 0xb9, 0xca, 0x99, 0x33,
    0x67, 0xa4, 0xbc, 0xbc, 0xbc, 0xd3, 0xe5, 0xe5, 0xe5, 0xa5, 0x8d, 0x8d,
    0x8d, 0x36, 0x45, 0x51, 0x1a, 0x18, 0x63, 0x16, 0x4a, 0x69, 0xa3, 0xa2,
    0x28, 0x1e, 0x94, 0x52, 0x2f, 0x9d, 0x4e, 0xe7, 0xe9, 0xe3, 0xe3, 0xe3,
    0xed, 0xda, 0x60, 0xf5, 0xaa, 0x00, 0x00, 0x02, 0x3f, 0x49, 0x44, 0x41,
    0x54, 0xe3, 0xe3, 0x13, 0x14, 0x1e, 0x1e, 0x1e, 0x10, 0x1d, 0x1d, 0xcd,
    0xa2, 0xa2, 0xa2, 0xa8, 0x9f, 0x9f, 0xcb, 0xc4, 0x24, 0xa0, 0xc8, 0xd0,
    0x1c, 0xf9, 0x18, 0x2b, 0xd6, 0x7c, 0x8d, 0xcf, 0x4e, 0xda, 0xae, 0x48,
    0x50, 0x57, 0x90, 0xe8, 0xcb, 0xb1, 0x2f, 0xa7, 0xeb, 0xb7, 0x44, 0x78,
    0x72, 0x33, 0xf5, 0xe9, 0x35, 0x7d, 0x7a, 0x3e, 0xce, 0xd5, 0xd0, 0x69,
    0xb3, 0x98, 0xe3, 0xb8, 0x58, 0x4f, 0x4f, 0xcf, 0x97, 0x26, 0x4f, 0x9e,
    0x3c, 0x63, 0xda, 0xb4, 0x69, 0xc6, 0xe0, 0xe0, 0x60, 0xd2, 0x7a, 0xb3,
    0xd5, 0x95, 0xa0, 0x28, 0x0a, 0x1a, 0x1b, 0x1b, 0x61, 0xb3, 0xd9, 0x60,
    0xb7, 0xdb, 0xa1, 0xd3, 0xe9, 0x60, 0x34, 0x1a, 0xe1, 0x4e, 0x13, 0xdb,
    0x43, 0x92, 0x24, 0x54, 0x56, 0x56, 0x62, 0xef, 0xde, 0xbd, 0xf6, 0x43,
    0x07, 0x7e, 0x2e, 0x58, 0x14, 0x9c, 0x9b, 0x93, 0x59, 0xe2, 0xb8, 0xfd,
    0xfd, 0x63, 0x0e, 0x0f, 0x77, 0x4d, 0x54, 0x57, 0x10, 0x62, 0xa0, 0x6c,
    0xfd, 0x74, 0x7d, 0x66, 0xb2, 0x3f, 0x3f, 0x59, 0x9f, 0x5e, 0xd3, 0x2f,
    0x21, 0x54, 0xae, 0x84, 0x2e, 0x8f, 0x59, 0x38, 0x8e, 0x4b, 0x54, 0xab,
    0xd5, 0x8f, 0x0c, 0x1f, 0x3e, 0x7c, 0xee, 0xed, 0xb7, 0xdf, 0xee, 0x97,
    0x9c, 0x9c, 0xcc, 0xe9, 0x74, 0x3a, 0x74, 0xa4, 0x4d, 0x5d, 0x85, 0xa2,
    0x28, 0x90, 0x24, 0x09, 0xb5, 0xb5, 0xb5, 0xc8, 0xcc, 0xcc, 0x14, 0xf7,
    0xee, 0xdd, 0x5b, 0x7d, 0xf8, 0xf0, 0xe1, 0x8d, 0x76, 0xbb, 0xfd, 0x6b,
    0x59, 0x96, 0xf7, 0x5b, 0xd3, 0xcc, 0xa2, 0xc2, 0xd8, 0x94, 0x3d, 0x97,
    0xa4, 0x77, 0xff, 0xbc, 0xb7, 0x31, 0xfa, 0x58, 0x99, 0x4c, 0x95, 0x2e,
    0x72, 0x44, 0x00, 0x24, 0xfa, 0x71, 0xec, 0x9f, 0xb7, 0xeb, 0x7e, 0x89,
    0xf3, 0xe6, 0xee, 0xf7, 0x5a, 0x5e, 0x9b, 0xd7, 0x23, 0xc2, 0xf7, 0x30,
    0xba, 0x33, 0xa0, 0xf4, 0xe4, 0x38, 0xee, 0x6e, 0x93, 0xc9, 0x74, 0x57,
    0x72, 0x72, 0xf2, 0xa4, 0xc4, 0xc4, 0x44, 0xe3, 0xe0, 0xc1, 0x83, 0xf9,
    0x88, 0x88, 0x08, 0xa2, 0x52, 0xa9, 0x40, 0x08, 0x69, 0x73, 0xb5, 0x06,
    0x63, 0xac, 0xcd, 0x25, 0x49, 0x12, 0xf2, 0xf3, 0xf3, 0xd9, 0xa9, 0x53,
    0xa7, 0x9c, 0xb9, 0xb9, 0xb9, 0xd2, 0xb9, 0x73, 0xe7, 0x32, 0xcf, 0x9e,
    0x3d, 0x7b, 0x80, 0x52, 0xfa, 0xb3, 0x24, 0x49, 0x3f, 0xa1, 0xe9, 0xb8,
    0xc6, 0x36, 0x68, 0x78, 0xde, 0xe4, 0x57, 0x69, 0x63, 0x6f, 0xae, 0x3f,
    0xed, 0x9c, 0xbb, 0x3a, 0xcb, 0xa1, 0xcd, 0xaf, 0x53, 0x48, 0x67, 0x48,
    0xd2, 0xf2, 0x04, 0xb3, 0x06, 0x09, 0xe2, 0xe2, 0x11, 0x9a, 0xef, 0xc2,
    0x3c, 0xb9, 0xf9, 0xfa, 0xf4, 0x9a, 0x7e, 0x9d, 0xed, 0xbc, 0x12, 0x7a,
    0x6a, 0xb4, 0xaf, 0xa3, 0x94, 0xa6, 0x50, 0x4a, 0x53, 0x54, 0x2a, 0xd5,
    0x90, 0xf0, 0xf0, 0xf0, 0xc1, 0x26, 0x93, 0x29, 0x40, 0xa7, 0xd3, 0x99,
    0xb5, 0x5a, 0xad, 0xc6, 0x60, 0x30, 0x10, 0x83, 0xc1, 0xa0, 0x08, 0x82,
    0xc0, 0xea, 0xeb, 0xeb, 0x69, 0x5d, 0x5d, 0x1d, 0x2c, 0x16, 0x8b, 0xcd,
    0x62, 0xb1, 0x94, 0x57, 0x56, 0x56, 0x16, 0x95, 0x94, 0x94, 0x14, 0x3a,
    0x9d, 0xce, 0xe3, 0x8a, 0xa2, 0x1c, 0xb8, 0xec, 0x6a, 0xe9, 0xf4, 0xa6,
    0xad, 0xda, 0x45, 0xa6, 0x9b, 0x2c, 0x4e, 0xb6, 0xf0, 0xdb, 0x3c, 0x71,
    0xee, 0xba, 0x6c, 0xa7, 0xe1, 0x78, 0xb9, 0x4c, 0x1a, 0x25, 0xd6, 0xb2,
    0x5c, 0x95, 0x5c, 0xbe, 0x82, 0x3c, 0x28, 0x26, 0x45, 0x08, 0xf2, 0x63,
    0x89, 0xaa, 0xec, 0x24, 0x7f, 0xee, 0x4d, 0x8e, 0x90, 0x8d, 0xed, 0xcf,
    0xe5, 0xbc, 0xde, 0xd0, 0x17, 0xae, 0x18, 0x35, 0x00, 0xf3, 0xe5, 0x4b,
    0x0d, 0xa0, 0x0a, 0x4d, 0x5b, 0xcf, 0x7b, 0x74, 0x08, 0x5e, 0xff, 0xbc,
    0x29, 0x44, 0x61, 0xb8, 0x57, 0x56, 0x30, 0xe4, 0x64, 0x85, 0x9c, 0x7c,
    0xb1, 0x5e, 0x89, 0x26, 0x80, 0x22, 0x50, 0x38, 0xc3, 0x3d, 0x69, 0x7e,
    0x9c, 0x0f, 0xb7, 0x87, 0x31, 0xec, 0x14, 0x38, 0xb2, 0x5d, 0x9f, 0x5e,
    0xd3, 0xb3, 0xdb, 0x27, 0x7a, 0x09, 0xff, 0x0b, 0x15, 0xf2, 0x8c, 0x79,
    0xcf, 0x19, 0x12, 0xee, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44,
    0xae, 0x42, 0x60, 0x82
};



About::About( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    QImage img;
    img.loadFromData( image0_data, sizeof( image0_data ), "PNG" );
    image0 = img;
    if ( !name )
	setName( "about" );

    tabLicense = new QTabWidget( this, "tabLicense" );
    tabLicense->setGeometry( QRect( 10, 40, 540, 430 ) );

    tab = new QWidget( tabLicense, "tab" );

    pixmapLabel1 = new QLabel( tab, "pixmapLabel1" );
    pixmapLabel1->setGeometry( QRect( 220, 20, 100, 100 ) );
    pixmapLabel1->setPixmap( image0 );
    pixmapLabel1->setScaledContents( TRUE );

    textAbout = new QTextEdit( tab, "textAbout" );
    textAbout->setGeometry( QRect( 10, 150, 510, 240 ) );
    textAbout->setWordWrap( QTextEdit::WidgetWidth );
    textAbout->setReadOnly( TRUE );
    tabLicense->insertTab( tab, QString::fromLatin1("") );

    TabPage = new QWidget( tabLicense, "TabPage" );

    textAuthors = new QTextEdit( TabPage, "textAuthors" );
    textAuthors->setGeometry( QRect( 10, 20, 510, 360 ) );
    textAuthors->setWordWrap( QTextEdit::WidgetWidth );
    tabLicense->insertTab( TabPage, QString::fromLatin1("") );
    
    tab_2 = new QWidget( tabLicense, "tab_2" );

    textLicense = new QTextEdit( tab_2, "textLicense" );
    textLicense->setGeometry( QRect( 10, 20, 510, 360 ) );
    textLicense->setWordWrap( QTextEdit::WidgetWidth );
    tabLicense->insertTab( tab_2, QString::fromLatin1("") );
    languageChange();
    resize( QSize(557, 478).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
    
    textAuthors->setReadOnly(1);
    textLicense->setReadOnly(1);
    textAbout->setReadOnly(1);
}

/*
 *  Destroys the object and frees any allocated resources
 */
About::~About()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void About::languageChange()
{
    setCaption( tr( "About..." ) );
    textAbout->setText( tr( "<br>\n"
"<h2 align=\"center\">QFlash v.0.1</h2>\n"
"<br>\n"
"<p align=\"center\">QFlash is a free development environment to make flash SWF files</p>\n"
"<p align=\"center\"><a href=\"http://qflash.sourceforge.net\"> http://qflash.sourceforge.net</a></p>\n"
"<p align=\"center\">If you have any doubt:<br><br>jangoo@users.sourceforge.net</p>\n"
"\n" ) );
    tabLicense->changeTab( tab, tr( "About..." ) );
    textAuthors->setText( "<br><h3  align=\"center\">  " + tr( "Authors" ) + "\n"
"</h3>\n"
"<p  align=\"center\">  Sergio Perez <br>\n"
"  jangoo@gmail.com</p>\n"
"\n"
"\n"
"<p  align=\"center\">  Jordi Rosello <br>\n"
"  eksone@wannado.es</p>\n"
"\n"
"<p  align=\"center\">  Veacheslav Deorditsa <br> \n"
"slava37md@yandex.ru</p>\n"
"\n"
"<h3  align=\"center\">"+ tr("Collaborators" )+ "</h3>\n"
"\n"
"  <p  align=\"center\">Luis Lara<br>\n"
"  sir.luislara@gmail.com</p>\n"
"\n"
"<p  align=\"center\">Gazb<br>\n"
"gazb.ming@gmail.com</p>\n"
"\n"
"<p  align=\"center\">Edwin Aguiar<br>\n"
"cte_barracuda@hotmail.com</p>\n"
"\n"
"<p  align=\"center\">Minguts<br>\n"
"minguts@yahoo.com</p>"
"\n"
"<p  align=\"center\">Adonay Sanz<br>\n"
"http://www.k-demar.org/\n"
"adonay@k-demar.org</p>\n"


 );

    tabLicense->changeTab( TabPage, tr( "Authors" ) );
    textLicense->setText( "This program is distributed under the terms of the GPL v2.\n"
"\n"
"		    GNU GENERAL PUBLIC LICENSE\n"
"		       Version 2, June 1991\n"
"\n"
" Copyright (C) 1989, 1991 Free Software Foundation, Inc.\n"
"               59 Temple Place, Suite 330, Boston, MA 02111-1307, USA\n"
" Everyone is permitted to copy and distribute verbatim copies\n"
" of this license document, but changing it is not allowed.\n"
"\n"
"			    Preamble\n"
"\n"
"  The licenses for most software are designed to take away your\n"
"freedom to share and change it.  By contrast, the GNU General Public\n"
"License is intended to guarantee your freedom to share and change free\n"
"software--to make sure the software is free for all its users.  This\n"
"General Public License applies to most of the Free Software\n"
"Foundation's software and to any other program whose authors commit to\n"
"using it.  (Some other Free Software Foundation software is covered by\n"
"the GNU Library General Public License instead.)  You can apply it to\n"
"your programs, too.\n"
"\n"
"  When we speak of free software, we are referring to freedom, not\n"
"price.  Our General Public Licenses are designed to make sure that you\n"
"have the freedom to distribute copies of free software (and charge for\n"
"this service if you wish), that you receive source code or can get it\n"
"if you want it, that you can change the software or use pieces of it\n"
"in new free programs; and that you know you can do these things.\n"
"\n"
"  To protect your rights, we need to make restrictions that forbid\n"
"anyone to deny you these rights or to ask you to surrender the rights.\n"
"These restrictions translate to certain responsibilities for you if you\n"
"distribute copies of the software, or if you modify it.\n"
"\n"
"  For example, if you distribute copies of such a program, whether\n"
"gratis or for a fee, you must give the recipients all the rights that\n"
"you have.  You must make sure that they, too, receive or can get the\n"
"source code.  And you must show them these terms so they know their\n"
"rights.\n"
"\n"
"  We protect your rights with two steps: (1) copyright the software, and\n"
"(2) offer you this license which gives you legal permission to copy,\n"
"distribute and/or modify the software.\n"
"\n"
"  Also, for each author's protection and ours, we want to make certain\n"
"that everyone understands that there is no warranty for this free\n"
"software.  If the software is modified by someone else and passed on, we\n"
"want its recipients to know that what they have is not the original, so\n"
"that any problems introduced by others will not reflect on the original\n"
"authors' reputations.\n"
"\n"
"  Finally, any free program is threatened constantly by software\n"
"patents.  We wish to avoid the danger that redistributors of a free\n"
"program will individually obtain patent licenses, in effect making the\n"
"program proprietary.  To prevent this, we have made it clear that any\n"
"patent must be licensed for everyone's free use or not licensed at all.\n"
"\n"
"  The precise terms and conditions for copying, distribution and\n"
"modification follow.\n"
" \n"
"		    GNU GENERAL PUBLIC LICENSE\n"
"   TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION\n"
"\n"
"  0. This License applies to any program or other work which contains\n"
"a notice placed by the copyright holder saying it may be distributed\n"
"under the terms of this General Public License.  The \"Program\", below,\n"
"refers to any such program or work, and a \"work based on the Program\"\n"
"means either the Program or any derivative work under copyright law:\n"
"that is to say, a work containing the Program or a portion of it,\n"
"either verbatim or with modifications and/or translated into another\n"
"language.  (Hereinafter, translation is included without limitation in\n"
"the term \"modification\".)  Each licensee is addressed as \"you\".\n"
"\n"
"Activities other than copying, distribution and modification are not\n"
"covered by this License; they are outside its scope.  The act of\n"
"running the Program is not restricted, and the output from the Program\n"
"is covered only if its contents constitute a work based on the\n"
"Program (independent of having been made by running the Program).\n"
"Whether that is true depends on what the Program does.\n"
"\n"
"  1. You may copy and distribute verbatim copies of the Program's\n"
"source code as you receive it, in any medium, provided that you\n"
"conspicuously and appropriately publish on each copy an appropriate\n"
"copyright notice and disclaimer of warranty; keep intact all the\n"
"notices that refer to this License and to the absence of any warranty;\n"
"and give any other recipients of the Program a copy of this License\n"
"along with the Program.\n"
"\n"
"You may charge a fee for the physical act of transferring a copy, and\n"
"you may at your option offer warranty protection in exchange for a fee.\n"
"\n"
"  2. You may modify your copy or copies of the Program or any portion\n"
"of it, thus forming a work based on the Program, and copy and\n"
"distribute such modifications or work under the terms of Section 1\n"
"above, provided that you also meet all of these conditions:\n"
"\n"
"    a) You must cause the modified files to carry prominent notices\n"
"    stating that you changed the files and the date of any change.\n"
"\n"
"    b) You must cause any work that you distribute or publish, that in\n"
"    whole or in part contains or is derived from the Program or any\n"
"    part thereof, to be licensed as a whole at no charge to all third\n"
"    parties under the terms of this License.\n"
"\n"
"    c) If the modified program normally reads commands interactively\n"
"    when run, you must cause it, when started running for such\n"
"    interactive use in the most ordinary way, to print or display an\n"
"    announcement including an appropriate copyright notice and a\n"
"    notice that there is no warranty (or else, saying that you provide\n"
"    a warranty) and that users may redistribute the program under\n"
"    these conditions, and telling the user how to view a copy of this\n"
"    License.  (Exception: if the Program itself is interactive but\n"
"    does not normally print such an announcement, your work based on\n"
"    the Program is not required to print an announcement.)\n"
" \n"
"These requirements apply to the modified work as a whole.  If\n"
"identifiable sections of that work are not derived from the Program,\n"
"and can be reasonably considered independent and separate works in\n"
"themselves, then this License, and its terms, do not apply to those\n"
"sections when you distribute them as separate works.  But when you\n"
"distribute the same sections as part of a whole which is a work based\n"
"on the Program, the distribution of the whole must be on the terms of\n"
"this License, whose permissions for other licensees extend to the\n"
"entire whole, and thus to each and every part regardless of who wrote it.\n"
"\n"
"Thus, it is not the intent of this section to claim rights or contest\n"
"your rights to work written entirely by you; rather, the intent is to\n"
"exercise the right to control the distribution of derivative or\n"
"collective works based on the Program.\n"
"\n"
"In addition, mere aggregation of another work not based on the Program\n"
"with the Program (or with a work based on the Program) on a volume of\n"
"a storage or distribution medium does not bring the other work under\n"
"the scope of this License.\n"
"\n"
"  3. You may copy and distribute the Program (or a work based on it,\n"
"under Section 2) in object code or executable form under the terms of\n"
"Sections 1 and 2 above provided that you also do one of the following:\n"
"\n"
"    a) Accompany it with the complete corresponding machine-readable\n"
"    source code, which must be distributed under the terms of Sections\n"
"    1 and 2 above on a medium customarily used for software interchange; or,\n"
"\n"
"    b) Accompany it with a written offer, valid for at least three\n"
"    years, to give any third party, for a charge no more than your\n"
"    cost of physically performing source distribution, a complete\n"
"    machine-readable copy of the corresponding source code, to be\n"
"    distributed under the terms of Sections 1 and 2 above on a medium\n"
"    customarily used for software interchange; or,\n"
"\n"
"    c) Accompany it with the information you received as to the offer\n"
"    to distribute corresponding source code.  (This alternative is\n"
"    allowed only for noncommercial distribution and only if you\n"
"    received the program in object code or executable form with such\n"
"    an offer, in accord with Subsection b above.)\n"
"\n"
"The source code for a work means the preferred form of the work for\n"
"making modifications to it.  For an executable work, complete source\n"
"code means all the source code for all modules it contains, plus any\n"
"associated interface definition files, plus the scripts used to\n"
"control compilation and installation of the executable.  However, as a\n"
"special exception, the source code distributed need not include\n"
"anything that is normally distributed (in either source or binary\n"
"form) with the major components (compiler, kernel, and so on) of the\n"
"operating system on which the executable runs, unless that component\n"
"itself accompanies the executable.\n"
"\n"
"If distribution of executable or object code is made by offering\n"
"access to copy from a designated place, then offering equivalent\n"
"access to copy the source code from the same place counts as\n"
"distribution of the source code, even though third parties are not\n"
"compelled to copy the source along with the object code.\n"
" \n"
"  4. You may not copy, modify, sublicense, or distribute the Program\n"
"except as expressly provided under this License.  Any attempt\n"
"otherwise to copy, modify, sublicense or distribute the Program is\n"
"void, and will automatically terminate your rights under this License.\n"
"However, parties who have received copies, or rights, from you under\n"
"this License will not have their licenses terminated so long as such\n"
"parties remain in full compliance.\n"
"\n"
"  5. You are not required to accept this License, since you have not\n"
"signed it.  However, nothing else grants you permission to modify or\n"
"distribute the Program or its derivative works.  These actions are\n"
"prohibited by law if you do not accept this License.  Therefore, by\n"
"modifying or distributing the Program (or any work based on the\n"
"Program), you indicate your acceptance of this License to do so, and\n"
"all its terms and conditions for copying, distributing or modifying\n"
"the Program or works based on it.\n"
"\n"
"  6. Each time you redistribute the Program (or any work based on the\n"
"Program), the recipient automatically receives a license from the\n"
"original licensor to copy, distribute or modify the Program subject to\n"
"these terms and conditions.  You may not impose any further\n"
"restrictions on the recipients' exercise of the rights granted herein.\n"
"You are not responsible for enforcing compliance by third parties to\n"
"this License.\n"
"\n"
"  7. If, as a consequence of a court judgment or allegation of patent\n"
"infringement or for any other reason (not limited to patent issues),\n"
"conditions are imposed on you (whether by court order, agreement or\n"
"otherwise) that contradict the conditions of this License, they do not\n"
"excuse you from the conditions of this License.  If you cannot\n"
"distribute so as to satisfy simultaneously your obligations under this\n"
"License and any other pertinent obligations, then as a consequence you\n"
"may not distribute the Program at all.  For example, if a patent\n"
"license would not permit royalty-free redistribution of the Program by\n"
"all those who receive copies directly or indirectly through you, then\n"
"the only way you could satisfy both it and this License would be to\n"
"refrain entirely from distribution of the Program.\n"
"\n"
"If any portion of this section is held invalid or unenforceable under\n"
"any particular circumstance, the balance of the section is intended to\n"
"apply and the section as a whole is intended to apply in other\n"
"circumstances.\n"
"\n"
"It is not the purpose of this section to induce you to infringe any\n"
"patents or other property right claims or to contest validity of any\n"
"such claims; this section has the sole purpose of protecting the\n"
"integrity of the free software distribution system, which is\n"
"implemented by public license practices.  Many people have made\n"
"generous contributions to the wide range of software distributed\n"
"through that system in reliance on consistent application of that\n"
"system; it is up to the author/donor to decide if he or she is willing\n"
"to distribute software through any other system and a licensee cannot\n"
"impose that choice.\n"
"\n"
"This section is intended to make thoroughly clear what is believed to\n"
"be a consequence of the rest of this License.\n"
" \n"
"  8. If the distribution and/or use of the Program is restricted in\n"
"certain countries either by patents or by copyrighted interfaces, the\n"
"original copyright holder who places the Program under this License\n"
"may add an explicit geographical distribution limitation excluding\n"
"those countries, so that distribution is permitted only in or among\n"
"countries not thus excluded.  In such case, this License incorporates\n"
"the limitation as if written in the body of this License.\n"
"\n"
"  9. The Free Software Foundation may publish revised and/or new versions\n"
"of the General Public License from time to time.  Such new versions will\n"
"be similar in spirit to the present version, but may differ in detail to\n"
"address new problems or concerns.\n"
"\n"
"Each version is given a distinguishing version number.  If the Program\n"
"specifies a version number of this License which applies to it and \"any\n"
"later version\", you have the option of following the terms and conditions\n"
"either of that version or of any later version published by the Free\n"
"Software Foundation.  If the Program does not specify a version number of\n"
"this License, you may choose any version ever published by the Free Software\n"
"Foundation.\n"
"\n"
"  10. If you wish to incorporate parts of the Program into other free\n"
"programs whose distribution conditions are different, write to the author\n"
"to ask for permission.  For software which is copyrighted by the Free\n"
"Software Foundation, write to the Free Software Foundation; we sometimes\n"
"make exceptions for this.  Our decision will be guided by the two goals\n"
"of preserving the free status of all derivatives of our free software and\n"
"of promoting the sharing and reuse of software generally.\n"
"\n"
"			    NO WARRANTY\n"
"\n"
"  11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY\n"
"FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN\n"
"OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES\n"
"PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED\n"
"OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF\n"
"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS\n"
"TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE\n"
"PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,\n"
"REPAIR OR CORRECTION.\n"
"\n"
"  12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING\n"
"WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR\n"
"REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,\n"
"INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING\n"
"OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED\n"
"TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY\n"
"YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER\n"
"PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE\n"
"POSSIBILITY OF SUCH DAMAGES.\n"
"\n"
"" );
    tabLicense->changeTab( tab_2, tr( "GPL Licence" ) );
}

