/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot;

import com.group_finity.mascot.Main;
import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.NativeFactory;
import com.group_finity.mascot.exception.CantBeAliveException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MascotEventHandler
implements MouseListener {
    private static final Logger log = Logger.getLogger(MascotEventHandler.class.getName());
    private static boolean showSystemTrayMenu = false;
    private final Mascot mascot;

    public static void setShowSystemTrayMenu(boolean showSystemTrayMenu) {
        MascotEventHandler.showSystemTrayMenu = showSystemTrayMenu;
    }

    public static boolean isShowSystemTrayMenu() {
        return showSystemTrayMenu;
    }

    public MascotEventHandler(Mascot mascot) {
        this.mascot = mascot;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.getMascot().getBehavior() != null) {
            try {
                this.getMascot().getBehavior().mousePressed(event);
            }
            catch (CantBeAliveException e) {
                log.log(Level.SEVERE, "\u751f\u304d\u7d9a\u3051\u308b\u3053\u3068\u304c\u51fa\u6765\u306a\u3044\u72b6\u6cc1", e);
                this.getMascot().dispose();
            }
        }
    }

    @Override
    public void mouseReleased(final MouseEvent event) {
        if (event.isPopupTrigger()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MascotEventHandler.this.showPopup(event.getX(), event.getY());
                }
            });
        } else if (this.getMascot().getBehavior() != null) {
            try {
                this.getMascot().getBehavior().mouseReleased(event);
            }
            catch (CantBeAliveException e) {
                log.log(Level.SEVERE, "\u751f\u304d\u7d9a\u3051\u308b\u3053\u3068\u304c\u51fa\u6765\u306a\u3044\u72b6\u6cc1", e);
                this.getMascot().dispose();
            }
        }
    }

    private void showPopup(int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                MascotEventHandler.this.getMascot().setAnimating(true);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MascotEventHandler.this.getMascot().setAnimating(false);
            }
        });
        JMenuItem disposeMenu = new JMenuItem("\u3070\u3044\u3070\u3044");
        disposeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MascotEventHandler.this.getMascot().dispose();
            }
        });
        popup.add(disposeMenu);
        if (MascotEventHandler.isShowSystemTrayMenu()) {
            popup.add(new JSeparator());
            JMenuItem increaseMenu = new JMenuItem("\u5897\u3084\u3059");
            increaseMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Main.getInstance().createMascot();
                }
            });
            JMenuItem gatherMenu = new JMenuItem("\u3042\u3064\u307e\u308c\uff01");
            gatherMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    MascotEventHandler.this.getMascot().getManager().setBehaviorAll(Main.getInstance().getConfiguration(), "\u30de\u30a6\u30b9\u306e\u5468\u308a\u306b\u96c6\u307e\u308b");
                }
            });
            JMenuItem oneMenu = new JMenuItem("\u4e00\u5339\u3060\u3051\u6b8b\u3059");
            oneMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    MascotEventHandler.this.getMascot().getManager().remainOne();
                }
            });
            JMenuItem restoreMenu = new JMenuItem("IE\u3092\u5143\u306b\u623b\u3059");
            restoreMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    NativeFactory.getInstance().getEnvironment().restoreIE();
                }
            });
            JMenuItem closeMenu = new JMenuItem("\u5168\u90e8\u3070\u3044\u3070\u3044");
            closeMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Main.getInstance().exit();
                }
            });
            popup.add(increaseMenu);
            popup.add(gatherMenu);
            popup.add(oneMenu);
            popup.add(restoreMenu);
            popup.add(new JSeparator());
            popup.add(closeMenu);
        }
        popup.show(this.getMascot().getWindow().asJWindow(), x, y);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private Mascot getMascot() {
        return this.mascot;
    }
}

