package editrocket.plugins;
	
import javax.swing.*;
import java.awt.event.*;
import java.util.*;

public class PluginExample implements EditRocketPlugin
{
	
	public void load()
	{
		EditRocketPluginManager pluginManager = EditRocketPluginManagerFactory.getInstance();

		pluginManager.log("in load() in PluginExample ");
		
		//add a menu item to the Plugins menu
		JMenuItem menuItem = new JMenuItem("Plugin Example");
		pluginManager.addPluginMenuItem(menuItem);
		
		//add an ActionListener to perform operations when the
		//menu item is selected
		menuItem.addActionListener(new PluginExampleListener());
	}
	
	public String getName()
	{
		return "Plugin Example";
	}

	public String getVersion()
	{
		return "1.0";
	}
	
	public String getDescription()
	{
		return "Example of how to use EditRocket plugins";
	}
	
	private static class PluginExampleListener implements ActionListener
	{
	
		public PluginExampleListener()
		{}	
		
		public void actionPerformed(ActionEvent e)
		{
			EditRocketPluginManager pluginManager = 
				EditRocketPluginManagerFactory.getInstance();
			pluginManager.log("in actionPerformed");
			
			int majorVersion = pluginManager.getMajorVersion();
			int minorVersion = pluginManager.getMinorVersion();
			String versionString = pluginManager.getVersionString();
			boolean registered = pluginManager.isRegistered();
			
			String editorText = pluginManager.getText();
			String selectedText = pluginManager.getSelectedText();
			int lineCount = pluginManager.getLineCount();
			int cursorPosition = pluginManager.getCursorPosition();
			int cursorLine = pluginManager.getCursorLine();
			
			JPanel testPanel = new JPanel();
			JTextArea textArea = new JTextArea(20,50);
			JScrollPane scrollPane = new JScrollPane(textArea);
			testPanel.add(scrollPane);
			
			textArea.append("Major Version: "+majorVersion);
			textArea.append("\n");
			textArea.append("Minor Version: "+minorVersion);
			textArea.append("\n");
			textArea.append("Version String: "+versionString);
			textArea.append("\n");
			textArea.append("Registered: "+registered);
			textArea.append("\n");
			textArea.append("Selected Text: "+selectedText);
			textArea.append("\n"); 
			textArea.append("Line Count: "+lineCount);
			textArea.append("\n");
			textArea.append("Cursor Position: " +cursorPosition);
			textArea.append("\n");
			textArea.append("Cursor Line: " +cursorLine);
			textArea.append("\n");
			textArea.append("Editor Contents: " +editorText);
			
			textArea.setCaretPosition(0);
			
			JFrame testFrame = new JFrame("PluginExample");
			testFrame.setSize(400,400);
			testFrame.getContentPane().add(testPanel);
			testFrame.pack();
			testFrame.setVisible(true);
		}
	}
}