/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import sun.java2d.SunGraphics2D;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.CompositePipe;
import sun.java2d.pipe.ParallelogramPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderingEngine;
import sun.java2d.pipe.ShapeDrawPipe;

public class AAShapePipe
implements ShapeDrawPipe,
ParallelogramPipe {
    static RenderingEngine renderengine = RenderingEngine.getInstance();
    CompositePipe outpipe;
    private static byte[] theTile;

    public AAShapePipe(CompositePipe compositePipe) {
        this.outpipe = compositePipe;
    }

    @Override
    public void draw(SunGraphics2D sunGraphics2D, Shape shape) {
        BasicStroke basicStroke;
        if (sunGraphics2D.stroke instanceof BasicStroke) {
            basicStroke = (BasicStroke)sunGraphics2D.stroke;
        } else {
            shape = sunGraphics2D.stroke.createStrokedShape(shape);
            basicStroke = null;
        }
        this.renderPath(sunGraphics2D, shape, basicStroke);
    }

    @Override
    public void fill(SunGraphics2D sunGraphics2D, Shape shape) {
        this.renderPath(sunGraphics2D, shape, null);
    }

    private static Rectangle2D computeBBox(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        d3 -= d;
        if (d6 < 0.0) {
            d += d3;
            d3 = -d3;
        }
        d4 -= d2;
        if (d5 < 0.0) {
            d2 += d4;
            d4 = -d4;
        }
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    @Override
    public void fillParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        int[] nArray;
        Region region = sunGraphics2D.getCompClip();
        AATileGenerator aATileGenerator = renderengine.getAATileGenerator(d5, d6, d7, d8, d9, d10, 0.0, 0.0, region, nArray = new int[4]);
        if (aATileGenerator == null) {
            return;
        }
        this.renderTiles(sunGraphics2D, AAShapePipe.computeBBox(d, d2, d3, d4), aATileGenerator, nArray);
    }

    @Override
    public void drawParallelogram(SunGraphics2D sunGraphics2D, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        int[] nArray;
        Region region = sunGraphics2D.getCompClip();
        AATileGenerator aATileGenerator = renderengine.getAATileGenerator(d5, d6, d7, d8, d9, d10, d11, d12, region, nArray = new int[4]);
        if (aATileGenerator == null) {
            return;
        }
        this.renderTiles(sunGraphics2D, AAShapePipe.computeBBox(d, d2, d3, d4), aATileGenerator, nArray);
    }

    public static synchronized byte[] getAlphaTile(int n) {
        byte[] byArray = theTile;
        if (byArray == null || byArray.length < n) {
            byArray = new byte[n];
        } else {
            theTile = null;
        }
        return byArray;
    }

    public static synchronized void dropAlphaTile(byte[] byArray) {
        theTile = byArray;
    }

    public void renderPath(SunGraphics2D sunGraphics2D, Shape shape, BasicStroke basicStroke) {
        int[] nArray;
        boolean bl = basicStroke != null && sunGraphics2D.strokeHint != 2;
        boolean bl2 = sunGraphics2D.strokeState <= 1;
        Region region = sunGraphics2D.getCompClip();
        AATileGenerator aATileGenerator = renderengine.getAATileGenerator(shape, sunGraphics2D.transform, region, basicStroke, bl2, bl, nArray = new int[4]);
        if (aATileGenerator == null) {
            return;
        }
        this.renderTiles(sunGraphics2D, shape, aATileGenerator, nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renderTiles(SunGraphics2D sunGraphics2D, Shape shape, AATileGenerator aATileGenerator, int[] nArray) {
        Object object = null;
        byte[] byArray = null;
        try {
            object = this.outpipe.startSequence(sunGraphics2D, shape, new Rectangle(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]), nArray);
            int n = aATileGenerator.getTileWidth();
            int n2 = aATileGenerator.getTileHeight();
            byArray = AAShapePipe.getAlphaTile(n * n2);
            for (int i = nArray[1]; i < nArray[3]; i += n2) {
                for (int j = nArray[0]; j < nArray[2]; j += n) {
                    byte[] byArray2;
                    int n3 = Math.min(n, nArray[2] - j);
                    int n4 = Math.min(n2, nArray[3] - i);
                    int n5 = aATileGenerator.getTypicalAlpha();
                    if (n5 == 0 || !this.outpipe.needTile(object, j, i, n3, n4)) {
                        aATileGenerator.nextTile();
                        this.outpipe.skipTile(object, j, i);
                        continue;
                    }
                    if (n5 == 255) {
                        byArray2 = null;
                        aATileGenerator.nextTile();
                    } else {
                        byArray2 = byArray;
                        aATileGenerator.getAlpha(byArray, 0, n);
                    }
                    this.outpipe.renderPathTile(object, byArray2, 0, n, j, i, n3, n4);
                }
            }
            aATileGenerator.dispose();
            if (object != null) {
                this.outpipe.endSequence(object);
            }
            if (byArray == null) return;
        }
        catch (Throwable throwable) {
            aATileGenerator.dispose();
            if (object != null) {
                this.outpipe.endSequence(object);
            }
            if (byArray == null) throw throwable;
            AAShapePipe.dropAlphaTile(byArray);
            throw throwable;
        }
        AAShapePipe.dropAlphaTile(byArray);
    }
}

