/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.gui;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.util.Objects;
import sun.font.FontManager;

public class FontFactory {
    private static final Logger logger = Logger.getLogger(FontFactory.class.getName());
    private static final boolean loggableFine = logger.isLoggable(Level.FINE);
    private static final FontFactory instance = new FontFactory();
    private final Set fontFamilies = new HashSet(40);
    private final Map fontMap = new HashMap(50);
    private final Map registeredFonts = new HashMap(0);
    private String defaultFontName = "SansSerif";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FontFactory() {
        boolean bl = loggableFine;
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        Set set = this.fontFamilies;
        FontFactory fontFactory = this;
        synchronized (fontFactory) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (bl) {
                    logger.fine("FontFactory(): family=" + string);
                }
                set.add(string.toLowerCase());
            }
        }
    }

    public static final FontFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFont(String string, int n, InputStream inputStream) throws FontFormatException, IOException {
        Font font = Font.createFont(n, inputStream);
        FontFactory fontFactory = this;
        synchronized (fontFactory) {
            this.registeredFonts.put(string.toLowerCase(), font);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFont(String string) {
        FontFactory fontFactory = this;
        synchronized (fontFactory) {
            this.registeredFonts.remove(string.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font getFont(String string, String string2, String string3, String string4, float f, Set set, Integer n) {
        FontKey fontKey = new FontKey(string, string2, string3, string4, f, set, n);
        FontFactory fontFactory = this;
        synchronized (fontFactory) {
            Font font = (Font)this.fontMap.get(fontKey);
            if (font == null) {
                font = this.createFont(fontKey);
                this.fontMap.put(fontKey, font);
            }
            return font;
        }
    }

    public String getDefaultFontName() {
        return this.defaultFontName;
    }

    public void setDefaultFontName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("defaultFontName cannot be null");
        }
        this.defaultFontName = string;
    }

    private final Font createFont(FontKey fontKey) {
        Font font = this.createFont_Impl(fontKey);
        return FontFactory.superscriptFont(font, fontKey.superscript);
    }

    public static Font superscriptFont(Font font, Integer n) {
        if (n == null) {
            return font;
        }
        Integer n2 = (Integer)font.getAttributes().get(TextAttribute.SUPERSCRIPT);
        if (n2 == null) {
            n2 = new Integer(0);
        }
        if (n2.equals(n)) {
            return font;
        }
        HashMap<TextAttribute, Integer> hashMap = new HashMap<TextAttribute, Integer>();
        hashMap.put(TextAttribute.SUPERSCRIPT, n);
        return font.deriveFont(hashMap);
    }

    private final Font createFont_Impl(FontKey fontKey) {
        Object object;
        Object object2;
        String string = fontKey.fontFamily;
        String string2 = null;
        Set set = this.fontFamilies;
        Map map = this.registeredFonts;
        Font font = null;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken().trim();
                object = ((String)object2).toLowerCase();
                if (map.containsKey(object)) {
                    font = (Font)map.get(object);
                    break;
                }
                if (!set.contains(object)) continue;
                string2 = object;
                break;
            }
        }
        int n = 0;
        if ("italic".equalsIgnoreCase(fontKey.fontStyle)) {
            n |= 2;
        }
        if ("bold".equalsIgnoreCase(fontKey.fontWeight) || "bolder".equalsIgnoreCase(fontKey.fontWeight)) {
            n |= 1;
        }
        if (font != null) {
            return font.deriveFont(n, fontKey.fontSize);
        }
        if (string2 != null) {
            object2 = this.createFont(string2, n, Math.round(fontKey.fontSize));
            object = fontKey.locales;
            if (object == null) {
                Locale locale = Locale.getDefault();
                if (((Font)object2).canDisplayUpTo(locale.getDisplayLanguage(locale)) == -1) {
                    return object2;
                }
            } else {
                Iterator iterator = object.iterator();
                boolean bl = true;
                while (iterator.hasNext()) {
                    Locale locale = (Locale)iterator.next();
                    if (((Font)object2).canDisplayUpTo(locale.getDisplayLanguage(locale)) == -1) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    return object2;
                }
            }
        }
        return this.createFont(this.defaultFontName, n, Math.round(fontKey.fontSize));
    }

    private Font createFont(String string, int n, int n2) {
        return FontManager.getCompositeFontUIResource((Font)new Font(string, n, n2));
    }

    private static class FontKey {
        public final String fontFamily;
        public final String fontStyle;
        public final String fontVariant;
        public final String fontWeight;
        public final float fontSize;
        public final Set locales;
        public final Integer superscript;
        private int cachedHash = -1;

        public FontKey(String string, String string2, String string3, String string4, float f, Set set, Integer n) {
            this.fontFamily = string == null ? null : string.intern();
            this.fontStyle = string2 == null ? null : string2.intern();
            this.fontVariant = string3 == null ? null : string3.intern();
            this.fontWeight = string4 == null ? null : string4.intern();
            this.fontSize = f;
            this.locales = set;
            this.superscript = n;
        }

        public boolean equals(Object object) {
            FontKey fontKey;
            if (object == this) {
                return true;
            }
            try {
                fontKey = (FontKey)object;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            return this.fontSize == fontKey.fontSize && this.fontFamily == fontKey.fontFamily && this.fontStyle == fontKey.fontStyle && this.fontWeight == fontKey.fontWeight && this.fontVariant == fontKey.fontVariant && this.superscript == fontKey.superscript && Objects.equals(this.locales, fontKey.locales);
        }

        public int hashCode() {
            String string;
            String string2;
            int n = this.cachedHash;
            if (n != -1) {
                return n;
            }
            String string3 = this.fontFamily;
            if (string3 == null) {
                string3 = "";
            }
            if ((string2 = this.fontWeight) == null) {
                string2 = "";
            }
            if ((string = this.fontStyle) == null) {
                string = "";
            }
            Integer n2 = this.superscript;
            this.cachedHash = n = string3.hashCode() ^ string2.hashCode() ^ string.hashCode() ^ (int)this.fontSize ^ (n2 == null ? 0 : n2);
            return n;
        }

        public String toString() {
            return "FontKey[family=" + this.fontFamily + ",size=" + this.fontSize + ",style=" + this.fontStyle + ",weight=" + this.fontWeight + ",variant=" + this.fontVariant + ",superscript=" + this.superscript + "]";
        }
    }
}

