/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class Strings {
    private static final MessageDigest MESSAGE_DIGEST;
    public static final String[] EMPTY_ARRAY;
    private static final String HEX_CHARS = "0123456789ABCDEF";

    private Strings() {
    }

    public static int compareVersions(String string, String string2, boolean bl) {
        if (string == null) {
            return string2 == null ? 0 : -1;
        }
        if (string2 == null) {
            return 1;
        }
        if (bl) {
            int n;
            String string3 = Strings.leadingDigits(string);
            String string4 = Strings.leadingDigits(string2);
            if (string3.length() == 0) {
                if (string4.length() == 0) {
                    return 0;
                }
                return -1;
            }
            if (string4.length() == 0) {
                return 1;
            }
            try {
                n = Integer.parseInt(string3) - Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n == 0) {
                return Strings.compareVersions(string.substring(string3.length()), string2.substring(string4.length()), false);
            }
            return n;
        }
        String string5 = Strings.leadingNonDigits(string);
        String string6 = Strings.leadingNonDigits(string2);
        if (string5.length() == 0) {
            if (string6.length() == 0) {
                return 0;
            }
            return -1;
        }
        if (string6.length() == 0) {
            return 1;
        }
        int n = string5.compareTo(string6);
        if (n == 0) {
            return Strings.compareVersions(string.substring(string5.length()), string2.substring(string6.length()), true);
        }
        return n;
    }

    public static String leadingDigits(String string) {
        char c;
        int n = string.length();
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n && Character.isDigit(c = string.charAt(i)); ++i) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(3);
            }
            stringBuffer.append(c);
        }
        return stringBuffer == null ? "" : stringBuffer.toString();
    }

    public static String leadingNonDigits(String string) {
        char c;
        int n = string.length();
        StringBuffer stringBuffer = null;
        for (int i = 0; i < n && !Character.isDigit(c = string.charAt(i)); ++i) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(3);
            }
            stringBuffer.append(c);
        }
        return stringBuffer == null ? "" : stringBuffer.toString();
    }

    public static boolean isBlank(String string) {
        return string == null || "".equals(string);
    }

    public static int countLines(String string) {
        int n;
        int n2 = 0;
        int n3 = 1;
        while ((n = string.indexOf(10, n2)) != -1) {
            ++n3;
            n2 = n + 1;
        }
        return n3;
    }

    public static boolean isJavaIdentifier(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String getJavaStringLiteral(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static String getJavaIdentifier(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            char c = string.charAt(i);
            boolean bl2 = bl = i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c);
            if (bl) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(String string) {
        byte[] byArray;
        byte[] byArray2;
        try {
            byArray2 = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        Object object = MESSAGE_DIGEST;
        synchronized (object) {
            MESSAGE_DIGEST.update(byArray2);
            byArray = MESSAGE_DIGEST.digest();
        }
        object = new char[32];
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            int n2 = by & 0xF;
            int n3 = (by & 0xF0) >> 4;
            object[i * 2] = HEX_CHARS.charAt(n3);
            object[i * 2 + 1] = HEX_CHARS.charAt(n2);
        }
        return new String((char[])object);
    }

    public static String getHash32(String string) throws UnsupportedEncodingException {
        String string2 = Strings.getMD5(string);
        return string2.substring(0, 8);
    }

    public static String getHash64(String string) throws UnsupportedEncodingException {
        String string2 = Strings.getMD5(string);
        return string2.substring(0, 16);
    }

    public static int countChars(String string, char c) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (c != string.charAt(i)) continue;
            ++n2;
        }
        return n2;
    }

    public static String unquote(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String[] split(String string) {
        int n = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = null;
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (stringBuffer == null) continue block3;
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = null;
                    continue block3;
                }
                default: {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer != null) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList.toArray(EMPTY_ARRAY);
    }

    public static String truncate(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() <= n) {
            return string;
        }
        return string.substring(0, Math.max(n - 3, 0)) + "...";
    }

    public static String strictHtmlEncode(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (bl) {
                        stringBuffer.append("&quot;");
                        continue block6;
                    }
                    stringBuffer.append(c);
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String trimForAlphaNumDash(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-') continue;
            return string.substring(0, i);
        }
        return string;
    }

    public static String getCRLFString(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    bl = true;
                    continue block4;
                }
                case '\n': {
                    bl = false;
                    stringBuffer.append("\r\n");
                    continue block4;
                }
                default: {
                    if (bl) {
                        bl = false;
                        stringBuffer.append("\r\n");
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    static {
        MessageDigest messageDigest;
        EMPTY_ARRAY = new String[0];
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException();
        }
        MESSAGE_DIGEST = messageDigest;
    }
}

