/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.util.SimpleThreadPoolTask;

public class SimpleThreadPool {
    private static final Logger logger = Logger.getLogger(SimpleThreadPool.class.getName());
    private final LinkedList taskList = new LinkedList();
    private final Set runningSet = new HashSet();
    private final int minThreads;
    private final int maxThreads;
    private final String name;
    private final int idleAliveMillis;
    private final Object taskMonitor = new Object();
    private final ThreadGroup threadGroup;
    private int numThreads = 0;
    private int numIdleThreads = 0;
    private int threadNumber = 0;

    public SimpleThreadPool(String string, int n, int n2, int n3) {
        this.minThreads = n;
        this.maxThreads = n2;
        this.idleAliveMillis = n3;
        this.name = string;
        this.threadGroup = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SimpleThreadPoolTask simpleThreadPoolTask) {
        Object object;
        if (simpleThreadPoolTask == null) {
            throw new IllegalArgumentException("null task");
        }
        Object object2 = object = this.taskMonitor;
        synchronized (object2) {
            if (this.numIdleThreads == 0) {
                this.addThreadImpl();
            }
            this.taskList.add(simpleThreadPoolTask);
            object.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(SimpleThreadPoolTask simpleThreadPoolTask) {
        Object object = this.taskMonitor;
        synchronized (object) {
            this.taskList.remove(simpleThreadPoolTask);
        }
        simpleThreadPoolTask.cancel();
    }

    private void addThreadImpl() {
        if (this.numThreads < this.maxThreads) {
            Thread thread = new Thread(this.threadGroup, new ThreadRunnable(), this.name + this.threadNumber++);
            thread.setDaemon(true);
            thread.start();
            ++this.numThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this.taskMonitor;
        synchronized (object) {
            this.taskList.clear();
            Iterator iterator = this.runningSet.iterator();
            while (iterator.hasNext()) {
                ((SimpleThreadPoolTask)iterator.next()).cancel();
            }
        }
    }

    static /* synthetic */ Object access$100(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.taskMonitor;
    }

    static /* synthetic */ LinkedList access$200(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.taskList;
    }

    static /* synthetic */ Set access$300(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.runningSet;
    }

    static /* synthetic */ int access$400(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.idleAliveMillis;
    }

    static /* synthetic */ int access$508(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.numIdleThreads++;
    }

    static /* synthetic */ int access$600(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.numThreads;
    }

    static /* synthetic */ int access$700(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.minThreads;
    }

    static /* synthetic */ int access$610(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.numThreads--;
    }

    static /* synthetic */ int access$510(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.numIdleThreads--;
    }

    static /* synthetic */ Logger access$800() {
        return logger;
    }

    static /* synthetic */ String access$900(SimpleThreadPool simpleThreadPool) {
        return simpleThreadPool.name;
    }

    private class ThreadRunnable
    implements Runnable {
        private ThreadRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            var1_1 = SimpleThreadPool.access$100(SimpleThreadPool.this);
            var2_2 = SimpleThreadPool.access$200(SimpleThreadPool.this);
            var3_3 = SimpleThreadPool.access$300(SimpleThreadPool.this);
            var4_4 = SimpleThreadPool.access$400(SimpleThreadPool.this);
            var5_5 = null;
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        var6_6 = var1_1;
                        synchronized (var6_6) {
                            if (var5_5 != null) {
                                var3_3.remove(var5_5);
                            }
                            SimpleThreadPool.access$508(SimpleThreadPool.this);
                            try {
                                var7_9 = System.currentTimeMillis();
                                while (true) {
                                    if (var2_2.isEmpty()) {
                                        var9_13 = (long)var4_4 - (System.currentTimeMillis() - var7_9);
                                        if (var9_13 <= 0L) {
                                            if (SimpleThreadPool.access$600(SimpleThreadPool.this) > SimpleThreadPool.access$700(SimpleThreadPool.this)) {
                                                SimpleThreadPool.access$610(SimpleThreadPool.this);
                                                return;
                                            }
                                            var7_9 = System.currentTimeMillis();
                                            continue;
                                        }
                                        var1_1.wait(var9_13);
                                        continue;
                                    }
                                    break;
                                }
                            }
                            finally {
                                SimpleThreadPool.access$510(SimpleThreadPool.this);
                            }
                            var5_5 = (SimpleThreadPoolTask)SimpleThreadPool.access$200(SimpleThreadPool.this).removeFirst();
                            var3_3.add(var5_5);
                        }
                        var6_6 = Thread.currentThread();
                        var7_8 = var6_6.getName();
                        try {
                            try {
                                var6_6.setName(var7_8 + ":" + var5_5.toString());
                            }
                            catch (Throwable var8_11) {
                                SimpleThreadPool.access$800().log(Level.WARNING, "run(): Unable to set task name.", var8_11);
                            }
                            try {
                                var5_5.run();
                            }
                            catch (Throwable var8_12) {
                                SimpleThreadPool.access$800().log(Level.SEVERE, "run(): Error in task: " + var5_5 + ".", var8_12);
                            }
                        }
                        finally {
                            var6_6.setName(var7_8);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable var6_7) {
                    SimpleThreadPool.access$800().log(Level.SEVERE, "run(): Error in thread pool: " + SimpleThreadPool.access$900(SimpleThreadPool.this) + ".", var6_7);
                    continue;
                }
                ** GOTO lbl-1000
                break;
            }
        }
    }
}

