/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.js;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.js.JavaClassWrapper;
import org.lobobrowser.js.JavaConstructorObject;
import org.lobobrowser.js.JavaInstantiator;
import org.lobobrowser.js.JavaScript;
import org.lobobrowser.js.PropertyInfo;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;

public class JavaObjectWrapper
extends ScriptableObject {
    private static final Logger logger = Logger.getLogger(JavaObjectWrapper.class.getName());
    private static final boolean loggableInfo = logger.isLoggable(Level.INFO);
    private final Object delegate;
    private final JavaClassWrapper classWrapper;

    public JavaObjectWrapper(JavaClassWrapper javaClassWrapper) throws InstantiationException, IllegalAccessException {
        Object object;
        this.classWrapper = javaClassWrapper;
        this.delegate = object = this.classWrapper.newInstance();
    }

    public JavaObjectWrapper(JavaClassWrapper javaClassWrapper, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Argument delegate cannot be null.");
        }
        this.classWrapper = javaClassWrapper;
        this.delegate = object;
    }

    public Object getJavaObject() {
        return this.delegate;
    }

    public String getClassName() {
        return this.classWrapper.getClassName();
    }

    public Object get(int n, Scriptable scriptable) {
        PropertyInfo propertyInfo = this.classWrapper.getIntegerIndexer();
        if (propertyInfo == null) {
            return super.get(n, scriptable);
        }
        try {
            Method method = propertyInfo.getGetter();
            if (method == null) {
                throw new EvaluatorException("Indexer is write-only");
            }
            Object object = this.getJavaObject();
            if (object == null) {
                throw new IllegalStateException("Java object (class=" + this.classWrapper + ") is null.");
            }
            Object object2 = method.invoke(object, new Integer(n));
            if (object2 == null) {
                return Scriptable.NOT_FOUND;
            }
            return JavaScript.getInstance().getJavascriptObject(object2, this.getParentScope());
        }
        catch (Exception exception) {
            throw new WrappedException((Throwable)exception);
        }
    }

    public Object get(String string, Scriptable scriptable) {
        Method method;
        PropertyInfo propertyInfo = this.classWrapper.getProperty(string);
        if (propertyInfo != null) {
            Method method2 = propertyInfo.getGetter();
            if (method2 == null) {
                throw new EvaluatorException("Property '" + string + "' is not readable");
            }
            try {
                Object object = this.getJavaObject();
                if (object == null) {
                    throw new IllegalStateException("Java object (class=" + this.classWrapper + ") is null.");
                }
                Object object2 = method2.invoke(object, (Object[])null);
                return JavaScript.getInstance().getJavascriptObject(object2, scriptable.getParentScope());
            }
            catch (Exception exception) {
                throw new WrappedException((Throwable)exception);
            }
        }
        Function function = this.classWrapper.getFunction(string);
        if (function != null) {
            return function;
        }
        Object object = super.get(string, scriptable);
        if (object != Scriptable.NOT_FOUND) {
            return object;
        }
        PropertyInfo propertyInfo2 = this.classWrapper.getNameIndexer();
        if (propertyInfo2 != null && (method = propertyInfo2.getGetter()) != null) {
            Object object3 = this.getJavaObject();
            if (object3 == null) {
                throw new IllegalStateException("Java object (class=" + this.classWrapper + ") is null.");
            }
            try {
                Object object4 = method.invoke(object3, string);
                if (object4 == null) {
                    return super.get(string, scriptable);
                }
                return JavaScript.getInstance().getJavascriptObject(object4, scriptable.getParentScope());
            }
            catch (Exception exception) {
                throw new WrappedException((Throwable)exception);
            }
        }
        return Scriptable.NOT_FOUND;
    }

    public void put(int n, Scriptable scriptable, Object object) {
        PropertyInfo propertyInfo = this.classWrapper.getIntegerIndexer();
        if (propertyInfo == null) {
            super.put(n, scriptable, object);
        } else {
            try {
                Method method = propertyInfo.getSetter();
                if (method == null) {
                    throw new EvaluatorException("Indexer is read-only");
                }
                Object object2 = JavaScript.getInstance().getJavaObject(object, propertyInfo.getPropertyType());
                method.invoke(this.getJavaObject(), new Integer(n), object2);
            }
            catch (Exception exception) {
                throw new WrappedException((Throwable)exception);
            }
        }
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (object instanceof Undefined) {
            super.put(string, scriptable, object);
        } else {
            PropertyInfo propertyInfo = this.classWrapper.getProperty(string);
            if (propertyInfo != null) {
                Method method = propertyInfo.getSetter();
                if (method == null) {
                    throw new EvaluatorException("Property '" + string + "' is not settable in " + this.classWrapper.getClassName() + ".");
                }
                try {
                    Object object2 = JavaScript.getInstance().getJavaObject(object, propertyInfo.getPropertyType());
                    method.invoke(this.getJavaObject(), object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    IllegalArgumentException illegalArgumentException2 = new IllegalArgumentException("Property named '" + string + "' could not be set with value " + object + ".", illegalArgumentException);
                    throw new WrappedException((Throwable)illegalArgumentException2);
                }
                catch (Exception exception) {
                    throw new WrappedException((Throwable)exception);
                }
            } else {
                PropertyInfo propertyInfo2 = this.classWrapper.getNameIndexer();
                if (propertyInfo2 != null) {
                    Method method = propertyInfo2.getSetter();
                    if (method != null) {
                        try {
                            Object object3 = JavaScript.getInstance().getJavaObject(object, propertyInfo2.getPropertyType());
                            method.invoke(this.getJavaObject(), string, object3);
                        }
                        catch (Exception exception) {
                            throw new WrappedException((Throwable)exception);
                        }
                    } else {
                        super.put(string, scriptable, object);
                    }
                } else {
                    super.put(string, scriptable, object);
                }
            }
        }
    }

    public static Function getConstructor(String string, JavaClassWrapper javaClassWrapper, Scriptable scriptable) {
        return new JavaConstructorObject(string, javaClassWrapper);
    }

    public static Function getConstructor(String string, JavaClassWrapper javaClassWrapper, Scriptable scriptable, JavaInstantiator javaInstantiator) {
        return new JavaConstructorObject(string, javaClassWrapper, javaInstantiator);
    }

    public Object getDefaultValue(Class clazz) {
        if (loggableInfo) {
            logger.info("getDefaultValue(): hint=" + clazz + ",this=" + this.getJavaObject());
        }
        if (clazz == null || String.class.equals(clazz)) {
            Object object = this.getJavaObject();
            if (object == null) {
                throw new IllegalStateException("Java object (class=" + this.classWrapper + ") is null.");
            }
            return object.toString();
        }
        if (Number.class.isAssignableFrom(clazz)) {
            Object object = this.getJavaObject();
            if (object instanceof Number) {
                return object;
            }
            if (object instanceof String) {
                return Double.valueOf((String)object);
            }
            return super.getDefaultValue(clazz);
        }
        return super.getDefaultValue(clazz);
    }

    public String toString() {
        Object object = this.getJavaObject();
        String string = object == null ? "<null>" : object.getClass().getName();
        return "JavaObjectWrapper[object=" + this.getJavaObject() + ",type=" + string + "]";
    }
}

