/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.test.NodeTreeModel;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.lobobrowser.util.io.IORoutines;
import org.w3c.dom.Document;

public class ParserTest
extends JFrame {
    private static final Logger logger = Logger.getLogger(ParserTest.class.getName());
    private final JTree tree;
    private final JTextArea textArea;

    public ParserTest() throws HeadlessException {
        this("HTML Parser-Only Test Tool");
    }

    public ParserTest(String string) throws HeadlessException {
        super(string);
        this.setDefaultCloseOperation(3);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        final JTextField jTextField = new JTextField();
        JButton jButton = new JButton("Parse & Render");
        JTabbedPane jTabbedPane = new JTabbedPane();
        JTree jTree = new JTree();
        jTree.setModel(null);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        this.tree = jTree;
        container.add((Component)jPanel, "North");
        container.add((Component)jPanel2, "Center");
        jPanel.add((Component)new JLabel("URL: "), "West");
        jPanel.add((Component)jTextField, "Center");
        jPanel.add((Component)jButton, "East");
        jPanel2.add((Component)jTabbedPane, "Center");
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        this.textArea = jTextArea;
        JScrollPane jScrollPane2 = new JScrollPane(jTextArea);
        jTabbedPane.addTab("HTML DOM", jScrollPane);
        jTabbedPane.addTab("Source Code", jScrollPane2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParserTest.this.process(jTextField.getText());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String string) {
        try {
            byte[] byArray;
            Object object;
            URL uRL;
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                int n = string.indexOf(58);
                if (n == -1 || n == 1) {
                    uRL = new URL("file:" + string);
                }
                throw malformedURLException;
            }
            logger.info("process(): Loading URI=[" + string + "].");
            long l = System.currentTimeMillis();
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible;) Cobra/0.96.1+");
            uRLConnection.setRequestProperty("Cookie", "");
            if (uRLConnection instanceof HttpURLConnection) {
                object = (HttpURLConnection)uRLConnection;
                ((HttpURLConnection)object).setInstanceFollowRedirects(true);
                int n = ((HttpURLConnection)object).getResponseCode();
                logger.info("process(): HTTP response code: " + n);
            }
            object = uRLConnection.getInputStream();
            try {
                byArray = IORoutines.load((InputStream)object, 8192);
            }
            finally {
                ((InputStream)object).close();
            }
            String string2 = new String(byArray, "ISO-8859-1");
            this.textArea.setText(string2);
            long l2 = System.currentTimeMillis();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            SimpleUserAgentContext simpleUserAgentContext = new SimpleUserAgentContext();
            DocumentBuilderImpl documentBuilderImpl = new DocumentBuilderImpl(simpleUserAgentContext);
            String string3 = uRL.toExternalForm();
            Document document = documentBuilderImpl.parse(new InputSourceImpl(byteArrayInputStream, string3, "ISO-8859-1"));
            long l3 = System.currentTimeMillis();
            logger.info("Parsed URI=[" + string + "]: Parse elapsed: " + (l3 - l2) + " ms. Load elapsed: " + (l2 - l) + " ms.");
            this.tree.setModel(new NodeTreeModel(document));
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Error trying to load URI=[" + string + "].", exception);
        }
    }

    public static void main(String[] stringArray) {
        ParserTest parserTest = new ParserTest();
        parserTest.setSize(800, 400);
        parserTest.setExtendedState(6);
        parserTest.setVisible(true);
    }
}

