/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Color;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableElementImpl;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.BorderInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.StyleSheetRenderState;
import org.lobobrowser.util.gui.ColorFactory;

public class TableRenderState
extends StyleSheetRenderState {
    private BackgroundInfo backgroundInfo = INVALID_BACKGROUND_INFO;

    public TableRenderState(RenderState renderState, HTMLElementImpl hTMLElementImpl) {
        super(renderState, hTMLElementImpl);
    }

    public Color getTextBackgroundColor() {
        return super.getTextBackgroundColor();
    }

    protected int getDefaultDisplay() {
        return 6;
    }

    public void invalidate() {
        super.invalidate();
        this.backgroundInfo = INVALID_BACKGROUND_INFO;
    }

    public BackgroundInfo getBackgroundInfo() {
        String string;
        BackgroundInfo backgroundInfo = this.backgroundInfo;
        if (backgroundInfo != INVALID_BACKGROUND_INFO) {
            return backgroundInfo;
        }
        backgroundInfo = super.getBackgroundInfo();
        HTMLTableElementImpl hTMLTableElementImpl = (HTMLTableElementImpl)this.element;
        if (!(backgroundInfo != null && backgroundInfo.backgroundColor != null || (string = hTMLTableElementImpl.getBgColor()) == null || "".equals(string))) {
            Color color = ColorFactory.getInstance().getColor(string);
            if (backgroundInfo == null) {
                backgroundInfo = new BackgroundInfo();
            }
            backgroundInfo.backgroundColor = color;
        }
        if (!(backgroundInfo != null && backgroundInfo.backgroundImage != null || (string = hTMLTableElementImpl.getAttribute("background")) == null || "".equals(string))) {
            if (backgroundInfo == null) {
                backgroundInfo = new BackgroundInfo();
            }
            backgroundInfo.backgroundImage = this.document.getFullURL(string);
        }
        this.backgroundInfo = backgroundInfo;
        return backgroundInfo;
    }

    public BorderInfo getBorderInfo() {
        BorderInfo borderInfo = this.borderInfo;
        if (borderInfo != INVALID_BORDER_INFO) {
            return borderInfo;
        }
        borderInfo = super.getBorderInfo();
        if (borderInfo == null || borderInfo.topStyle == 0 && borderInfo.bottomStyle == 0 && borderInfo.leftStyle == 0 && borderInfo.rightStyle == 0) {
            String string;
            HTMLElementImpl hTMLElementImpl;
            if (borderInfo == null) {
                borderInfo = new BorderInfo();
            }
            if ((hTMLElementImpl = this.element) != null && (string = hTMLElementImpl.getAttribute("border")) != null) {
                int n;
                int n2;
                if ((string = string.trim()).endsWith("%")) {
                    n2 = 3;
                    try {
                        n = Integer.parseInt(string.substring(0, string.length() - 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                    }
                } else {
                    n2 = 1;
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                    }
                }
                HtmlInsets htmlInsets = new HtmlInsets();
                htmlInsets.right = htmlInsets.bottom = n;
                htmlInsets.left = htmlInsets.bottom;
                htmlInsets.top = htmlInsets.bottom;
                htmlInsets.rightType = htmlInsets.bottomType = n2;
                htmlInsets.leftType = htmlInsets.bottomType;
                htmlInsets.topType = htmlInsets.bottomType;
                borderInfo.insets = htmlInsets;
                if (borderInfo.topColor == null) {
                    borderInfo.topColor = Color.LIGHT_GRAY;
                }
                if (borderInfo.leftColor == null) {
                    borderInfo.leftColor = Color.LIGHT_GRAY;
                }
                if (borderInfo.rightColor == null) {
                    borderInfo.rightColor = Color.GRAY;
                }
                if (borderInfo.bottomColor == null) {
                    borderInfo.bottomColor = Color.GRAY;
                }
                if (n != 0) {
                    borderInfo.bottomStyle = 4;
                    borderInfo.rightStyle = 4;
                    borderInfo.leftStyle = 4;
                    borderInfo.topStyle = 4;
                }
            }
        }
        this.borderInfo = borderInfo;
        return borderInfo;
    }
}

