/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Color;
import org.lobobrowser.html.domimpl.ElementImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableCellElementImpl;
import org.lobobrowser.html.domimpl.HTMLTableRowElementImpl;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.DisplayRenderState;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.RenderThreadState;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLTableElement;

public class TableCellRenderState
extends DisplayRenderState {
    private int alignXPercent = -1;
    private int alignYPercent = -1;
    private BackgroundInfo backgroundInfo = INVALID_BACKGROUND_INFO;
    private HtmlInsets paddingInsets = INVALID_INSETS;

    public TableCellRenderState(RenderState renderState, HTMLElementImpl hTMLElementImpl) {
        super(renderState, hTMLElementImpl, 5);
    }

    public void invalidate() {
        super.invalidate();
        this.alignXPercent = -1;
        this.alignYPercent = -1;
        this.backgroundInfo = INVALID_BACKGROUND_INFO;
        this.paddingInsets = INVALID_INSETS;
    }

    public int getAlignXPercent() {
        String string;
        int n = this.alignXPercent;
        if (n != -1) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        if (abstractCSS2Properties != null && (string = abstractCSS2Properties.getTextAlign()) != null && string.length() != 0) {
            return super.getAlignXPercent();
        }
        string = this.element.getAttribute("align");
        HTMLElementImpl hTMLElementImpl = this.element;
        HTMLElement hTMLElement = null;
        Node node = hTMLElementImpl.getParentNode();
        if (node instanceof HTMLElement) {
            hTMLElement = (HTMLElement)node;
        }
        if (string == null || string.length() == 0) {
            if (hTMLElement != null) {
                string = hTMLElement.getAttribute("align");
                if (string != null && string.length() == 0) {
                    string = null;
                }
            } else {
                string = null;
            }
        }
        n = string == null ? ("TH".equalsIgnoreCase(hTMLElementImpl.getNodeName()) ? 50 : 0) : ("center".equalsIgnoreCase(string) || "middle".equalsIgnoreCase(string) ? 50 : ("left".equalsIgnoreCase(string) ? 0 : ("right".equalsIgnoreCase(string) ? 100 : 0)));
        this.alignXPercent = n;
        return n;
    }

    public int getAlignYPercent() {
        String string;
        int n = this.alignYPercent;
        if (n != -1) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        if (abstractCSS2Properties != null && (string = abstractCSS2Properties.getVerticalAlign()) != null && string.length() != 0) {
            return super.getAlignYPercent();
        }
        string = this.element.getAttribute("valign");
        HTMLElementImpl hTMLElementImpl = this.element;
        HTMLElement hTMLElement = null;
        Node node = hTMLElementImpl.getParentNode();
        if (node instanceof HTMLElement) {
            hTMLElement = (HTMLElement)node;
        }
        if (string == null || string.length() == 0) {
            if (hTMLElement != null) {
                string = hTMLElement.getAttribute("valign");
                if (string != null && string.length() == 0) {
                    string = null;
                }
            } else {
                string = null;
            }
        }
        n = string == null ? 50 : ("top".equalsIgnoreCase(string) ? 0 : ("middle".equalsIgnoreCase(string) || "center".equalsIgnoreCase(string) ? 50 : ("bottom".equalsIgnoreCase(string) ? 100 : 50)));
        this.alignYPercent = n;
        return n;
    }

    public BackgroundInfo getBackgroundInfo() {
        String string;
        BackgroundInfo backgroundInfo = this.backgroundInfo;
        if (backgroundInfo != INVALID_BACKGROUND_INFO) {
            return backgroundInfo;
        }
        backgroundInfo = super.getBackgroundInfo();
        HTMLTableCellElementImpl hTMLTableCellElementImpl = (HTMLTableCellElementImpl)this.element;
        HTMLTableRowElementImpl hTMLTableRowElementImpl = null;
        Node node = hTMLTableCellElementImpl.getParentNode();
        if (node instanceof HTMLTableRowElementImpl) {
            hTMLTableRowElementImpl = (HTMLTableRowElementImpl)node;
        }
        if (backgroundInfo == null || backgroundInfo.backgroundColor == null) {
            string = hTMLTableCellElementImpl.getBgColor();
            if ((string == null || "".equals(string)) && hTMLTableRowElementImpl != null) {
                string = hTMLTableRowElementImpl.getBgColor();
            }
            if (string != null && !"".equals(string)) {
                Color color = ColorFactory.getInstance().getColor(string);
                if (backgroundInfo == null) {
                    backgroundInfo = new BackgroundInfo();
                }
                backgroundInfo.backgroundColor = color;
            }
        }
        if (!(backgroundInfo != null && backgroundInfo.backgroundImage != null || (string = hTMLTableCellElementImpl.getAttribute("background")) == null || "".equals(string))) {
            if (backgroundInfo == null) {
                backgroundInfo = new BackgroundInfo();
            }
            backgroundInfo.backgroundImage = this.document.getFullURL(string);
        }
        this.backgroundInfo = backgroundInfo;
        return backgroundInfo;
    }

    private HTMLTableElement getTableElement() {
        Node node;
        for (node = this.element.getParentNode(); node != null && !(node instanceof HTMLTableElement); node = node.getParentNode()) {
        }
        return (HTMLTableElement)node;
    }

    public HtmlInsets getPaddingInsets() {
        HtmlInsets htmlInsets = this.paddingInsets;
        if (htmlInsets != INVALID_INSETS) {
            return htmlInsets;
        }
        htmlInsets = super.getPaddingInsets();
        if (htmlInsets == null) {
            HTMLTableElement hTMLTableElement = this.getTableElement();
            if (hTMLTableElement == null) {
                return null;
            }
            String string = hTMLTableElement.getAttribute("cellpadding");
            if (string != null && string.length() != 0) {
                int n;
                int n2;
                if ((string = string.trim()).endsWith("%")) {
                    n2 = 3;
                    try {
                        n = Integer.parseInt(string.substring(0, string.length() - 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                    }
                } else {
                    n2 = 1;
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                    }
                }
                htmlInsets = new HtmlInsets();
                htmlInsets.right = htmlInsets.bottom = n;
                htmlInsets.left = htmlInsets.bottom;
                htmlInsets.top = htmlInsets.bottom;
                htmlInsets.rightType = htmlInsets.bottomType = n2;
                htmlInsets.leftType = htmlInsets.bottomType;
                htmlInsets.topType = htmlInsets.bottomType;
            }
        }
        this.paddingInsets = htmlInsets;
        return htmlInsets;
    }

    public int getWhiteSpace() {
        Object object;
        Object object2;
        String string;
        if (RenderThreadState.getState().overrideNoWrap) {
            return 2;
        }
        Integer n = this.iWhiteSpace;
        if (n != null) {
            return n;
        }
        AbstractCSS2Properties abstractCSS2Properties = this.getCssProperties();
        String string2 = string = abstractCSS2Properties == null ? null : abstractCSS2Properties.getWhiteSpace();
        int n2 = string == null ? ((object2 = this.element) != null && ((HTMLElementImpl)object2).getAttributeAsBoolean("nowrap") ? 2 : ((object = this.prevRenderState) != null ? object.getWhiteSpace() : 0)) : ("nowrap".equals(object2 = string.toLowerCase()) ? 2 : ("pre".equals(object2) ? 1 : 0));
        if (n2 == 2) {
            object2 = this.element;
            Object object3 = object = abstractCSS2Properties == null ? null : abstractCSS2Properties.getWidth();
            if (object == null) {
                object = ((ElementImpl)object2).getAttribute("width");
                if (object != null && ((String)object).length() > 0 && !((String)object).endsWith("%")) {
                    n2 = 0;
                }
            } else if (!((String)object).trim().endsWith("%")) {
                n2 = 0;
            }
        }
        this.iWhiteSpace = new Integer(n2);
        return n2;
    }
}

