/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.style.CSSUtilities;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class StyleSheetAggregator {
    private final HTMLDocumentImpl document;
    private final Map classMapsByElement = new HashMap();
    private final Map idMapsByElement = new HashMap();
    private final Map rulesByElement = new HashMap();

    public StyleSheetAggregator(HTMLDocumentImpl hTMLDocumentImpl) {
        this.document = hTMLDocumentImpl;
    }

    public final void addStyleSheets(Collection collection) throws MalformedURLException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CSSStyleSheet cSSStyleSheet = (CSSStyleSheet)iterator.next();
            this.addStyleSheet(cSSStyleSheet);
        }
    }

    private final void addStyleSheet(CSSStyleSheet cSSStyleSheet) throws MalformedURLException {
        CSSRuleList cSSRuleList = cSSStyleSheet.getCssRules();
        int n = cSSRuleList.getLength();
        for (int i = 0; i < n; ++i) {
            CSSRule cSSRule = cSSRuleList.item(i);
            this.addRule(cSSStyleSheet, cSSRule);
        }
    }

    private final void addRule(CSSStyleSheet cSSStyleSheet, CSSRule cSSRule) throws MalformedURLException {
        block11: {
            CSSMediaRule cSSMediaRule;
            MediaList mediaList;
            HTMLDocumentImpl hTMLDocumentImpl;
            block12: {
                CSSImportRule cSSImportRule;
                block10: {
                    hTMLDocumentImpl = this.document;
                    if (!(cSSRule instanceof CSSStyleRule)) break block10;
                    CSSStyleRule cSSStyleRule = (CSSStyleRule)cSSRule;
                    String string = cSSStyleRule.getSelectorText();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2;
                        String string3;
                        String string4 = stringTokenizer.nextToken().toLowerCase();
                        ArrayList<SimpleSelector> arrayList = null;
                        String string5 = null;
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string4, " \t\r\n");
                        if (stringTokenizer2.hasMoreTokens()) {
                            arrayList = new ArrayList<SimpleSelector>();
                            SimpleSelector simpleSelector = null;
                            while (true) {
                                if (">".equals(string3 = stringTokenizer2.nextToken())) {
                                    if (simpleSelector == null) continue;
                                    simpleSelector.setSelectorType(1);
                                    continue;
                                }
                                if ("+".equals(string3)) {
                                    if (simpleSelector == null) continue;
                                    simpleSelector.setSelectorType(2);
                                    continue;
                                }
                                int n = string3.indexOf(58);
                                string2 = n == -1 ? string3 : string3.substring(0, n);
                                String string6 = n == -1 ? null : string3.substring(n + 1);
                                simpleSelector = new SimpleSelector(string2, string6);
                                arrayList.add(simpleSelector);
                                if (!stringTokenizer2.hasMoreTokens()) break;
                            }
                            string5 = string2;
                        }
                        if (string5 == null) continue;
                        int n = string5.indexOf(46);
                        if (n != -1) {
                            string3 = string5.substring(0, n);
                            String string7 = string5.substring(n + 1);
                            this.addClassRule(string3, string7, cSSStyleRule, arrayList);
                            continue;
                        }
                        int n2 = string5.indexOf(35);
                        if (n2 != -1) {
                            String string8 = string5.substring(0, n2);
                            string2 = string5.substring(n2 + 1);
                            this.addIdRule(string8, string2, cSSStyleRule, arrayList);
                            continue;
                        }
                        String string9 = string5;
                        this.addElementRule(string9, cSSStyleRule, arrayList);
                    }
                    break block11;
                }
                if (!(cSSRule instanceof CSSImportRule)) break block12;
                UserAgentContext userAgentContext = hTMLDocumentImpl.getUserAgentContext();
                if (!userAgentContext.isExternalCSSEnabled() || !CSSUtilities.matchesMedia((cSSImportRule = (CSSImportRule)cSSRule).getMedia(), userAgentContext)) break block11;
                String string = cSSImportRule.getHref();
                String string10 = cSSStyleSheet.getHref();
                String string11 = string10 == null ? hTMLDocumentImpl.getBaseURI() : string10;
                CSSStyleSheet cSSStyleSheet2 = CSSUtilities.parse(cSSStyleSheet.getOwnerNode(), string, hTMLDocumentImpl, string11, false);
                if (cSSStyleSheet2 != null) {
                    this.addStyleSheet(cSSStyleSheet2);
                }
                break block11;
            }
            if (cSSRule instanceof CSSMediaRule && CSSUtilities.matchesMedia(mediaList = (cSSMediaRule = (CSSMediaRule)cSSRule).getMedia(), hTMLDocumentImpl.getUserAgentContext())) {
                CSSRuleList cSSRuleList = cSSMediaRule.getCssRules();
                int n = cSSRuleList.getLength();
                for (int i = 0; i < n; ++i) {
                    CSSRule cSSRule2 = cSSRuleList.item(i);
                    this.addRule(cSSStyleSheet, cSSRule2);
                }
            }
        }
    }

    private final void addClassRule(String string, String string2, CSSStyleRule cSSStyleRule, ArrayList arrayList) {
        LinkedList<StyleRuleInfo> linkedList;
        HashMap<String, LinkedList<StyleRuleInfo>> hashMap = (HashMap<String, LinkedList<StyleRuleInfo>>)this.classMapsByElement.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, LinkedList<StyleRuleInfo>>();
            this.classMapsByElement.put(string, hashMap);
        }
        if ((linkedList = (LinkedList<StyleRuleInfo>)hashMap.get(string2)) == null) {
            linkedList = new LinkedList<StyleRuleInfo>();
            hashMap.put(string2, linkedList);
        }
        linkedList.add(new StyleRuleInfo(arrayList, cSSStyleRule));
    }

    private final void addIdRule(String string, String string2, CSSStyleRule cSSStyleRule, ArrayList arrayList) {
        LinkedList<StyleRuleInfo> linkedList;
        HashMap<String, LinkedList<StyleRuleInfo>> hashMap = (HashMap<String, LinkedList<StyleRuleInfo>>)this.idMapsByElement.get(string);
        if (hashMap == null) {
            hashMap = new HashMap<String, LinkedList<StyleRuleInfo>>();
            this.idMapsByElement.put(string, hashMap);
        }
        if ((linkedList = (LinkedList<StyleRuleInfo>)hashMap.get(string2)) == null) {
            linkedList = new LinkedList<StyleRuleInfo>();
            hashMap.put(string2, linkedList);
        }
        linkedList.add(new StyleRuleInfo(arrayList, cSSStyleRule));
    }

    private final void addElementRule(String string, CSSStyleRule cSSStyleRule, ArrayList arrayList) {
        LinkedList<StyleRuleInfo> linkedList = (LinkedList<StyleRuleInfo>)this.rulesByElement.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<StyleRuleInfo>();
            this.rulesByElement.put(string, linkedList);
        }
        linkedList.add(new StyleRuleInfo(arrayList, cSSStyleRule));
    }

    public final Collection getActiveStyleDeclarations(HTMLElementImpl hTMLElementImpl, String string, String string2, String string3, Set set) {
        CSSStyleRule cSSStyleRule;
        CSSStyleSheet cSSStyleSheet;
        StyleRuleInfo styleRuleInfo;
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        LinkedList<CSSStyleDeclaration> linkedList = null;
        String string4 = string.toLowerCase();
        Collection collection = (Collection)this.rulesByElement.get(string4);
        if (collection != null) {
            object3 = collection.iterator();
            while (object3.hasNext()) {
                object2 = (StyleRuleInfo)object3.next();
                if (!((StyleRuleInfo)object2).isSelectorMatch(hTMLElementImpl, set) || (iterator = (object = ((StyleRuleInfo)object2).styleRule).getParentStyleSheet()) != null && iterator.getDisabled()) continue;
                if (linkedList == null) {
                    linkedList = new LinkedList<CSSStyleDeclaration>();
                }
                linkedList.add(object.getStyle());
            }
        }
        if ((collection = (Collection)this.rulesByElement.get("*")) != null) {
            object3 = collection.iterator();
            while (object3.hasNext()) {
                object2 = (StyleRuleInfo)object3.next();
                if (!((StyleRuleInfo)object2).isSelectorMatch(hTMLElementImpl, set) || (iterator = (object = ((StyleRuleInfo)object2).styleRule).getParentStyleSheet()) != null && iterator.getDisabled()) continue;
                if (linkedList == null) {
                    linkedList = new LinkedList();
                }
                linkedList.add(object.getStyle());
            }
        }
        if (string3 != null) {
            object3 = string3.toLowerCase();
            object2 = (Map)this.classMapsByElement.get(string4);
            if (object2 != null && (object = (Collection)object2.get(object3)) != null) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    styleRuleInfo = (StyleRuleInfo)iterator.next();
                    if (!styleRuleInfo.isSelectorMatch(hTMLElementImpl, set) || (cSSStyleSheet = (cSSStyleRule = styleRuleInfo.styleRule).getParentStyleSheet()) != null && cSSStyleSheet.getDisabled()) continue;
                    if (linkedList == null) {
                        linkedList = new LinkedList();
                    }
                    linkedList.add(cSSStyleRule.getStyle());
                }
            }
            if ((object2 = (Map)this.classMapsByElement.get("*")) != null && (object = (Collection)object2.get(object3)) != null) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    styleRuleInfo = (StyleRuleInfo)iterator.next();
                    if (!styleRuleInfo.isSelectorMatch(hTMLElementImpl, set) || (cSSStyleSheet = (cSSStyleRule = styleRuleInfo.styleRule).getParentStyleSheet()) != null && cSSStyleSheet.getDisabled()) continue;
                    if (linkedList == null) {
                        linkedList = new LinkedList();
                    }
                    linkedList.add(cSSStyleRule.getStyle());
                }
            }
        }
        if (string2 != null) {
            object3 = (Map)this.idMapsByElement.get(string4);
            if (object3 != null && (object = (Collection)object3.get(object2 = string2.toLowerCase())) != null) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    styleRuleInfo = (StyleRuleInfo)iterator.next();
                    if (!styleRuleInfo.isSelectorMatch(hTMLElementImpl, set) || (cSSStyleSheet = (cSSStyleRule = styleRuleInfo.styleRule).getParentStyleSheet()) != null && cSSStyleSheet.getDisabled()) continue;
                    if (linkedList == null) {
                        linkedList = new LinkedList();
                    }
                    linkedList.add(cSSStyleRule.getStyle());
                }
            }
            if ((object3 = (Map)this.idMapsByElement.get("*")) != null && (object = (Collection)object3.get(object2 = string2.toLowerCase())) != null) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    styleRuleInfo = (StyleRuleInfo)iterator.next();
                    if (!styleRuleInfo.isSelectorMatch(hTMLElementImpl, set) || (cSSStyleSheet = (cSSStyleRule = styleRuleInfo.styleRule).getParentStyleSheet()) != null && cSSStyleSheet.getDisabled()) continue;
                    if (linkedList == null) {
                        linkedList = new LinkedList();
                    }
                    linkedList.add(cSSStyleRule.getStyle());
                }
            }
        }
        return linkedList;
    }

    public final boolean affectedByPseudoNameInAncestor(HTMLElementImpl hTMLElementImpl, HTMLElementImpl hTMLElementImpl2, String string, String string2, String[] stringArray, String string3) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Iterator iterator;
        String string4 = string.toLowerCase();
        Collection collection = (Collection)this.rulesByElement.get(string4);
        if (collection != null) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object5 = (StyleRuleInfo)iterator.next();
                object4 = ((StyleRuleInfo)object5).styleRule.getParentStyleSheet();
                if (object4 != null && object4.getDisabled() || !((StyleRuleInfo)object5).affectedByPseudoNameInAncestor(hTMLElementImpl, hTMLElementImpl2, string3)) continue;
                return true;
            }
        }
        if ((collection = (Collection)this.rulesByElement.get("*")) != null) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                object5 = (StyleRuleInfo)iterator.next();
                object4 = ((StyleRuleInfo)object5).styleRule.getParentStyleSheet();
                if (object4 != null && object4.getDisabled() || !((StyleRuleInfo)object5).affectedByPseudoNameInAncestor(hTMLElementImpl, hTMLElementImpl2, string3)) continue;
                return true;
            }
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                CSSStyleSheet cSSStyleSheet;
                StyleRuleInfo styleRuleInfo;
                object5 = stringArray[i];
                object4 = ((String)object5).toLowerCase();
                object3 = (Map)this.classMapsByElement.get(string4);
                if (object3 != null && (object2 = (Collection)object3.get(object4)) != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        styleRuleInfo = (StyleRuleInfo)object.next();
                        cSSStyleSheet = styleRuleInfo.styleRule.getParentStyleSheet();
                        if (cSSStyleSheet != null && cSSStyleSheet.getDisabled() || !styleRuleInfo.affectedByPseudoNameInAncestor(hTMLElementImpl, hTMLElementImpl2, string3)) continue;
                        return true;
                    }
                }
                if ((object3 = (Map)this.classMapsByElement.get("*")) == null || (object2 = (Collection)object3.get(object4)) == null) continue;
                object = object2.iterator();
                while (object.hasNext()) {
                    styleRuleInfo = (StyleRuleInfo)object.next();
                    cSSStyleSheet = styleRuleInfo.styleRule.getParentStyleSheet();
                    if (cSSStyleSheet != null && cSSStyleSheet.getDisabled() || !styleRuleInfo.affectedByPseudoNameInAncestor(hTMLElementImpl, hTMLElementImpl2, string3)) continue;
                    return true;
                }
            }
        }
        if (string2 != null) {
            Map map = (Map)this.idMapsByElement.get(string4);
            if (map != null && (object4 = (Collection)map.get(object5 = string2.toLowerCase())) != null) {
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (StyleRuleInfo)object3.next();
                    object = ((StyleRuleInfo)object2).styleRule.getParentStyleSheet();
                    if (object != null && object.getDisabled() || !((StyleRuleInfo)object2).affectedByPseudoNameInAncestor(hTMLElementImpl, hTMLElementImpl2, string3)) continue;
                    return true;
                }
            }
            if ((map = (Map)this.idMapsByElement.get("*")) != null && (object4 = (Collection)map.get(object5 = string2.toLowerCase())) != null) {
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (StyleRuleInfo)object3.next();
                    object = ((StyleRuleInfo)object2).styleRule.getParentStyleSheet();
                    if (object != null && object.getDisabled() || !((StyleRuleInfo)object2).affectedByPseudoNameInAncestor(hTMLElementImpl, hTMLElementImpl2, string3)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static class SimpleSelector {
        public static final int ANCESTOR = 0;
        public static final int PARENT = 1;
        public static final int PRECEEDING_SIBLING = 2;
        public final String simpleSelectorText;
        public final String pseudoElement;
        public int selectorType;

        public SimpleSelector(String string, String string2) {
            this.simpleSelectorText = string;
            this.pseudoElement = string2;
            this.selectorType = 0;
        }

        public final boolean matches(HTMLElementImpl hTMLElementImpl) {
            Set set = hTMLElementImpl.getPseudoNames();
            if (set == null) {
                return this.pseudoElement == null;
            }
            String string = this.pseudoElement;
            return string == null || set.contains(string);
        }

        public final boolean matches(Set set) {
            if (set == null) {
                return this.pseudoElement == null;
            }
            String string = this.pseudoElement;
            return string == null || set.contains(string);
        }

        public final boolean matches(String string) {
            if (string == null) {
                return this.pseudoElement == null;
            }
            String string2 = this.pseudoElement;
            return string2 == null || string.equals(string2);
        }

        public final boolean hasPseudoName(String string) {
            return string.equals(this.pseudoElement);
        }

        public int getSelectorType() {
            return this.selectorType;
        }

        public void setSelectorType(int n) {
            this.selectorType = n;
        }
    }

    private static class StyleRuleInfo {
        private final CSSStyleRule styleRule;
        private final ArrayList ancestorSelectors;

        public StyleRuleInfo(ArrayList arrayList, CSSStyleRule cSSStyleRule) {
            this.ancestorSelectors = arrayList;
            this.styleRule = cSSStyleRule;
        }

        public final boolean affectedByPseudoNameInAncestor(HTMLElementImpl hTMLElementImpl, HTMLElementImpl hTMLElementImpl2, String string) {
            ArrayList arrayList = this.ancestorSelectors;
            HTMLElementImpl hTMLElementImpl3 = hTMLElementImpl;
            int n = arrayList.size();
            boolean bl = true;
            int n2 = n;
            while (--n2 >= 0) {
                HTMLElementImpl hTMLElementImpl4;
                String string2;
                SimpleSelector simpleSelector = (SimpleSelector)arrayList.get(n2);
                if (bl) {
                    if (hTMLElementImpl2 == hTMLElementImpl) {
                        return simpleSelector.hasPseudoName(string);
                    }
                    bl = false;
                    continue;
                }
                String string3 = simpleSelector.simpleSelectorText;
                int n3 = string3.indexOf(46);
                if (n3 != -1) {
                    String string4 = string3.substring(0, n3);
                    string2 = string3.substring(n3 + 1);
                    hTMLElementImpl4 = hTMLElementImpl3.getAncestorWithClass(string4, string2);
                } else {
                    int n4 = string3.indexOf(35);
                    if (n4 != -1) {
                        string2 = string3.substring(0, n4);
                        String string5 = string3.substring(n4 + 1);
                        hTMLElementImpl4 = hTMLElementImpl3.getAncestorWithId(string2, string5);
                    } else {
                        string2 = string3;
                        hTMLElementImpl4 = hTMLElementImpl3.getAncestor(string2);
                    }
                }
                if (hTMLElementImpl4 == null) {
                    return false;
                }
                hTMLElementImpl3 = hTMLElementImpl4;
                if (hTMLElementImpl3 != hTMLElementImpl2) continue;
                return simpleSelector.hasPseudoName(string);
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSelectorMatch(HTMLElementImpl hTMLElementImpl, Set set) {
            ArrayList arrayList = this.ancestorSelectors;
            HTMLElementImpl hTMLElementImpl2 = hTMLElementImpl;
            int n = arrayList.size();
            boolean bl = true;
            int n2 = n;
            while (--n2 >= 0) {
                HTMLElementImpl hTMLElementImpl3;
                String string;
                SimpleSelector simpleSelector = (SimpleSelector)arrayList.get(n2);
                if (bl) {
                    if (!simpleSelector.matches(set)) {
                        return false;
                    }
                    bl = false;
                    continue;
                }
                String string2 = simpleSelector.simpleSelectorText;
                int n3 = string2.indexOf(46);
                int n4 = simpleSelector.selectorType;
                if (n3 != -1) {
                    String string3 = string2.substring(0, n3);
                    string = string2.substring(n3 + 1);
                    if (n4 == 0) {
                        hTMLElementImpl3 = hTMLElementImpl2.getAncestorWithClass(string3, string);
                    } else if (n4 == 1) {
                        hTMLElementImpl3 = hTMLElementImpl2.getParentWithClass(string3, string);
                    } else {
                        if (n4 != 2) throw new IllegalStateException("selectorType=" + n4);
                        hTMLElementImpl3 = hTMLElementImpl2.getPreceedingSiblingWithClass(string3, string);
                    }
                } else {
                    int n5 = string2.indexOf(35);
                    if (n5 != -1) {
                        string = string2.substring(0, n5);
                        String string4 = string2.substring(n5 + 1);
                        if (n4 == 0) {
                            hTMLElementImpl3 = hTMLElementImpl2.getAncestorWithId(string, string4);
                        } else if (n4 == 1) {
                            hTMLElementImpl3 = hTMLElementImpl2.getParentWithId(string, string4);
                        } else {
                            if (n4 != 2) throw new IllegalStateException("selectorType=" + n4);
                            hTMLElementImpl3 = hTMLElementImpl2.getPreceedingSiblingWithId(string, string4);
                        }
                    } else {
                        string = string2;
                        if (n4 == 0) {
                            hTMLElementImpl3 = hTMLElementImpl2.getAncestor(string);
                        } else if (n4 == 1) {
                            hTMLElementImpl3 = hTMLElementImpl2.getParent(string);
                        } else {
                            if (n4 != 2) throw new IllegalStateException("selectorType=" + n4);
                            hTMLElementImpl3 = hTMLElementImpl2.getPreceedingSibling(string);
                        }
                    }
                }
                if (hTMLElementImpl3 == null) {
                    return false;
                }
                if (!simpleSelector.matches(hTMLElementImpl3)) {
                    return false;
                }
                hTMLElementImpl2 = hTMLElementImpl3;
            }
            return true;
        }
    }
}

