/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.style.BorderInfo;
import org.lobobrowser.html.style.FontInfo;
import org.lobobrowser.html.style.HtmlInsets;
import org.lobobrowser.html.style.ListStyle;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.Urls;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.css.CSS2Properties;

public class HtmlValues {
    public static final Map SYSTEM_FONTS = new HashMap();
    private static final Logger logger = Logger.getLogger(HtmlValues.class.getName());
    public static final float DEFAULT_FONT_SIZE = 14.0f;
    public static final int DEFAULT_FONT_SIZE_INT = 14;
    public static final Float DEFAULT_FONT_SIZE_BOX = new Float(14.0f);
    public static final int DEFAULT_BORDER_WIDTH = 2;
    public static final int BORDER_STYLE_NONE = 0;
    public static final int BORDER_STYLE_HIDDEN = 1;
    public static final int BORDER_STYLE_DOTTED = 2;
    public static final int BORDER_STYLE_DASHED = 3;
    public static final int BORDER_STYLE_SOLID = 4;
    public static final int BORDER_STYLE_DOUBLE = 5;
    public static final int BORDER_STYLE_GROOVE = 6;
    public static final int BORDER_STYLE_RIDGE = 7;
    public static final int BORDER_STYLE_INSET = 8;
    public static final int BORDER_STYLE_OUTSET = 9;

    private HtmlValues() {
    }

    public static boolean isBorderStyle(String string) {
        String string2 = string.toLowerCase();
        return string2.equals("solid") || string2.equals("dashed") || string2.equals("dotted") || string2.equals("double") || string2.equals("none") || string2.equals("hidden") || string2.equals("groove") || string2.equals("ridge") || string2.equals("inset") || string2.equals("outset");
    }

    public static HtmlInsets getMarginInsets(CSS2Properties cSS2Properties, RenderState renderState) {
        HtmlInsets htmlInsets = null;
        String string = cSS2Properties.getMarginTop();
        htmlInsets = HtmlValues.updateTopInset(htmlInsets, string, renderState);
        String string2 = cSS2Properties.getMarginLeft();
        htmlInsets = HtmlValues.updateLeftInset(htmlInsets, string2, renderState);
        String string3 = cSS2Properties.getMarginBottom();
        htmlInsets = HtmlValues.updateBottomInset(htmlInsets, string3, renderState);
        String string4 = cSS2Properties.getMarginRight();
        htmlInsets = HtmlValues.updateRightInset(htmlInsets, string4, renderState);
        return htmlInsets;
    }

    public static HtmlInsets getPaddingInsets(CSS2Properties cSS2Properties, RenderState renderState) {
        HtmlInsets htmlInsets = null;
        String string = cSS2Properties.getPaddingTop();
        htmlInsets = HtmlValues.updateTopInset(htmlInsets, string, renderState);
        String string2 = cSS2Properties.getPaddingLeft();
        htmlInsets = HtmlValues.updateLeftInset(htmlInsets, string2, renderState);
        String string3 = cSS2Properties.getPaddingBottom();
        htmlInsets = HtmlValues.updateBottomInset(htmlInsets, string3, renderState);
        String string4 = cSS2Properties.getPaddingRight();
        htmlInsets = HtmlValues.updateRightInset(htmlInsets, string4, renderState);
        return htmlInsets;
    }

    public static HtmlInsets getBorderInsets(Insets insets, CSS2Properties cSS2Properties, RenderState renderState) {
        String string;
        HtmlInsets htmlInsets = null;
        if (insets.top != 0) {
            string = cSS2Properties.getBorderTopWidth();
            htmlInsets = HtmlValues.updateTopInset(htmlInsets, string, renderState);
        }
        if (insets.left != 0) {
            string = cSS2Properties.getBorderLeftWidth();
            htmlInsets = HtmlValues.updateLeftInset(htmlInsets, string, renderState);
        }
        if (insets.bottom != 0) {
            string = cSS2Properties.getBorderBottomWidth();
            htmlInsets = HtmlValues.updateBottomInset(htmlInsets, string, renderState);
        }
        if (insets.right != 0) {
            string = cSS2Properties.getBorderRightWidth();
            htmlInsets = HtmlValues.updateRightInset(htmlInsets, string, renderState);
        }
        return htmlInsets;
    }

    public static void populateBorderInsets(BorderInfo borderInfo, CSS2Properties cSS2Properties, RenderState renderState) {
        String string;
        HtmlInsets htmlInsets = null;
        if (borderInfo.topStyle != 0) {
            string = cSS2Properties.getBorderTopWidth();
            htmlInsets = HtmlValues.updateTopInset(htmlInsets, string, renderState);
        }
        if (borderInfo.leftStyle != 0) {
            string = cSS2Properties.getBorderLeftWidth();
            htmlInsets = HtmlValues.updateLeftInset(htmlInsets, string, renderState);
        }
        if (borderInfo.bottomStyle != 0) {
            string = cSS2Properties.getBorderBottomWidth();
            htmlInsets = HtmlValues.updateBottomInset(htmlInsets, string, renderState);
        }
        if (borderInfo.rightStyle != 0) {
            string = cSS2Properties.getBorderRightWidth();
            htmlInsets = HtmlValues.updateRightInset(htmlInsets, string, renderState);
        }
        borderInfo.insets = htmlInsets;
    }

    private static int getBorderWidth(String string, int n, RenderState renderState) {
        if (n == 0) {
            return 0;
        }
        if (string == null || string.length() == 0) {
            return 2;
        }
        return HtmlValues.getPixelSize(string, renderState, 2);
    }

    private static HtmlInsets updateTopInset(HtmlInsets htmlInsets, String string, RenderState renderState) {
        if (string == null) {
            return htmlInsets;
        }
        if ((string = string.trim()).length() == 0) {
            return htmlInsets;
        }
        if (htmlInsets == null) {
            htmlInsets = new HtmlInsets();
        }
        if ("auto".equalsIgnoreCase(string)) {
            htmlInsets.topType = 2;
        } else if (string.endsWith("%")) {
            htmlInsets.topType = 3;
            try {
                htmlInsets.top = Integer.parseInt(string.substring(0, string.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                htmlInsets.top = 0;
            }
        } else {
            htmlInsets.topType = 1;
            htmlInsets.top = HtmlValues.getPixelSize(string, renderState, 0);
        }
        return htmlInsets;
    }

    private static HtmlInsets updateLeftInset(HtmlInsets htmlInsets, String string, RenderState renderState) {
        if (string == null) {
            return htmlInsets;
        }
        if ((string = string.trim()).length() == 0) {
            return htmlInsets;
        }
        if (htmlInsets == null) {
            htmlInsets = new HtmlInsets();
        }
        if ("auto".equalsIgnoreCase(string)) {
            htmlInsets.leftType = 2;
        } else if (string.endsWith("%")) {
            htmlInsets.leftType = 3;
            try {
                htmlInsets.left = Integer.parseInt(string.substring(0, string.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                htmlInsets.left = 0;
            }
        } else {
            htmlInsets.leftType = 1;
            htmlInsets.left = HtmlValues.getPixelSize(string, renderState, 0);
        }
        return htmlInsets;
    }

    private static HtmlInsets updateBottomInset(HtmlInsets htmlInsets, String string, RenderState renderState) {
        if (string == null) {
            return htmlInsets;
        }
        if ((string = string.trim()).length() == 0) {
            return htmlInsets;
        }
        if (htmlInsets == null) {
            htmlInsets = new HtmlInsets();
        }
        if ("auto".equalsIgnoreCase(string)) {
            htmlInsets.bottomType = 2;
        } else if (string.endsWith("%")) {
            htmlInsets.bottomType = 3;
            try {
                htmlInsets.bottom = Integer.parseInt(string.substring(0, string.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                htmlInsets.bottom = 0;
            }
        } else {
            htmlInsets.bottomType = 1;
            htmlInsets.bottom = HtmlValues.getPixelSize(string, renderState, 0);
        }
        return htmlInsets;
    }

    private static HtmlInsets updateRightInset(HtmlInsets htmlInsets, String string, RenderState renderState) {
        if (string == null) {
            return htmlInsets;
        }
        if ((string = string.trim()).length() == 0) {
            return htmlInsets;
        }
        if (htmlInsets == null) {
            htmlInsets = new HtmlInsets();
        }
        if ("auto".equalsIgnoreCase(string)) {
            htmlInsets.rightType = 2;
        } else if (string.endsWith("%")) {
            htmlInsets.rightType = 3;
            try {
                htmlInsets.right = Integer.parseInt(string.substring(0, string.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                htmlInsets.right = 0;
            }
        } else {
            htmlInsets.rightType = 1;
            htmlInsets.right = HtmlValues.getPixelSize(string, renderState, 0);
        }
        return htmlInsets;
    }

    public static Insets getInsets(String string, RenderState renderState, boolean bl) {
        int[] nArray = new int[4];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            nArray[0] = HtmlValues.getPixelSize(string2, renderState, 0);
            if (bl || nArray[0] >= 0) {
                n = 1;
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    nArray[1] = HtmlValues.getPixelSize(string2, renderState, 0);
                    if (bl || nArray[1] >= 0) {
                        n = 2;
                        if (stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken();
                            nArray[2] = HtmlValues.getPixelSize(string2, renderState, 0);
                            if (bl || nArray[2] >= 0) {
                                n = 3;
                                if (stringTokenizer.hasMoreTokens()) {
                                    string2 = stringTokenizer.nextToken();
                                    nArray[3] = HtmlValues.getPixelSize(string2, renderState, 0);
                                    n = 4;
                                    if (!bl && nArray[3] < 0) {
                                        nArray[3] = 0;
                                    }
                                }
                            } else {
                                n = 4;
                                nArray[2] = 0;
                            }
                        }
                    } else {
                        n = 4;
                        nArray[1] = 0;
                    }
                }
            } else {
                n = 1;
                nArray[0] = 0;
            }
        }
        if (n == 4) {
            return new Insets(nArray[0], nArray[3], nArray[2], nArray[1]);
        }
        if (n == 1) {
            int n2 = nArray[0];
            return new Insets(n2, n2, n2, n2);
        }
        if (n == 2) {
            return new Insets(nArray[0], nArray[1], nArray[0], nArray[1]);
        }
        if (n == 3) {
            return new Insets(nArray[0], nArray[1], nArray[2], nArray[1]);
        }
        return null;
    }

    public static final int getFontNumberOldStyle(String string, RenderState renderState) {
        int n;
        string = string.trim();
        try {
            n = string.startsWith("+") ? renderState.getFontBase() + Integer.parseInt(string.substring(1)) : (string.startsWith("-") ? renderState.getFontBase() + Integer.parseInt(string) : Integer.parseInt(string));
            if (n < 1) {
                n = 1;
            } else if (n > 7) {
                n = 7;
            }
        }
        catch (NumberFormatException numberFormatException) {
            n = 3;
        }
        return n;
    }

    public static final float getFontSize(int n) {
        switch (n) {
            case 1: {
                return 10.0f;
            }
            case 2: {
                return 11.0f;
            }
            case 3: {
                return 13.0f;
            }
            case 4: {
                return 16.0f;
            }
            case 5: {
                return 21.0f;
            }
            case 6: {
                return 29.0f;
            }
            case 7: {
                return 42.0f;
            }
        }
        return 63.0f;
    }

    public static final String getFontSizeSpec(int n) {
        switch (n) {
            case 1: {
                return "10px";
            }
            case 2: {
                return "11px";
            }
            case 3: {
                return "13px";
            }
            case 4: {
                return "16px";
            }
            case 5: {
                return "21px";
            }
            case 6: {
                return "29px";
            }
            case 7: {
                return "42px";
            }
        }
        return "63px";
    }

    public static final float getFontSize(String string, RenderState renderState) {
        String string2 = string.toLowerCase();
        if (string2.endsWith("em")) {
            double d;
            if (renderState == null) {
                return 14.0f;
            }
            Font font = renderState.getFont();
            String string3 = string2.substring(0, string2.length() - 2);
            try {
                d = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return 14.0f;
            }
            return (int)Math.round((double)font.getSize() * d);
        }
        if (string2.endsWith("px") || string2.endsWith("pt") || string2.endsWith("cm") || string2.endsWith("pc") || string2.endsWith("cm") || string2.endsWith("mm") || string2.endsWith("ex")) {
            int n = HtmlValues.getPixelSize(string, renderState, 14);
            int n2 = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
            return n * 96 / n2;
        }
        if (string2.endsWith("%")) {
            String string4 = string2.substring(0, string2.length() - 1);
            try {
                double d = Double.parseDouble(string4);
                double d2 = renderState == null ? 14.0 : (double)renderState.getFont().getSize();
                return (float)(d2 * d / 100.0);
            }
            catch (NumberFormatException numberFormatException) {
                return 14.0f;
            }
        }
        if ("small".equals(string2)) {
            return 12.0f;
        }
        if ("medium".equals(string2)) {
            return 14.0f;
        }
        if ("large".equals(string2)) {
            return 20.0f;
        }
        if ("x-small".equals(string2)) {
            return 11.0f;
        }
        if ("xx-small".equals(string2)) {
            return 10.0f;
        }
        if ("x-large".equals(string2)) {
            return 26.0f;
        }
        if ("xx-large".equals(string2)) {
            return 40.0f;
        }
        if ("larger".equals(string2)) {
            int n = renderState == null ? 14 : renderState.getFont().getSize();
            return (float)n * 1.2f;
        }
        if ("smaller".equals(string2)) {
            int n = renderState == null ? 14 : renderState.getFont().getSize();
            return (float)n / 1.2f;
        }
        return HtmlValues.getPixelSize(string, renderState, 14);
    }

    public static final int getPixelSize(String string, RenderState renderState, int n, int n2) {
        if (string.endsWith("%")) {
            String string2 = string.substring(0, string.length() - 1);
            try {
                double d = Double.parseDouble(string2);
                return (int)Math.round((double)n2 * d / 100.0);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        return HtmlValues.getPixelSize(string, renderState, n);
    }

    public static final int getPixelSize(String string, RenderState renderState, int n) {
        String string2 = string.toLowerCase();
        if (string2.endsWith("px")) {
            String string3 = string2.substring(0, string2.length() - 2);
            try {
                return (int)Math.round(Double.parseDouble(string3));
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }
        if (string2.endsWith("em") && renderState != null) {
            double d;
            Font font = renderState.getFont();
            String string4 = string2.substring(0, string2.length() - 2);
            try {
                d = Double.parseDouble(string4);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
            int n2 = font.getSize();
            int n3 = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
            double d2 = n2 * n3 / 96;
            return (int)Math.round(d2 * d);
        }
        if (string2.endsWith("pt")) {
            double d;
            String string5 = string2.substring(0, string2.length() - 2);
            try {
                d = Double.parseDouble(string5);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
            int n4 = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
            double d3 = d / 72.0;
            return (int)Math.round((double)n4 * d3);
        }
        if (string2.endsWith("pc")) {
            double d;
            String string6 = string2.substring(0, string2.length() - 2);
            try {
                d = Double.parseDouble(string6);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
            int n5 = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
            double d4 = d / 6.0;
            return (int)Math.round((double)n5 * d4);
        }
        if (string2.endsWith("cm")) {
            double d;
            String string7 = string2.substring(0, string2.length() - 2);
            try {
                d = Double.parseDouble(string7);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
            int n6 = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
            double d5 = d / 2.54;
            return (int)Math.round((double)n6 * d5);
        }
        if (string2.endsWith("mm")) {
            double d;
            String string8 = string2.substring(0, string2.length() - 2);
            try {
                d = Double.parseDouble(string8);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
            int n7 = GraphicsEnvironment.isHeadless() ? 72 : Toolkit.getDefaultToolkit().getScreenResolution();
            double d6 = d / 25.4;
            return (int)Math.round((double)n7 * d6);
        }
        if (string2.endsWith("ex") && renderState != null) {
            double d;
            double d7 = (double)renderState.getFontMetrics().getAscent() * 0.47;
            String string9 = string2.substring(0, string2.length() - 2);
            try {
                d = Double.parseDouble(string9);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
            return (int)Math.round(d7 * d);
        }
        String string10 = string2;
        try {
            return (int)Math.round(Double.parseDouble(string10));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static int getOldSyntaxPixelSize(String string, int n, int n2) {
        if (string == null) {
            return n2;
        }
        string = string.trim();
        try {
            if (string.endsWith("%")) {
                return n * Integer.parseInt(string.substring(0, string.length() - 1)) / 100;
            }
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static int getOldSyntaxPixelSizeSimple(String string, int n) {
        if (string == null) {
            return n;
        }
        string = string.trim();
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static URL getURIFromStyleValue(String string) {
        String string2 = "url(";
        if (!string.toLowerCase().startsWith(string2)) {
            return null;
        }
        int n = string2.length();
        int n2 = string.lastIndexOf(41);
        if (n2 == -1) {
            return null;
        }
        String string3 = string.substring(n, n2);
        String string4 = HtmlValues.unquoteAndUnescape(string3);
        try {
            return Urls.createURL(null, string4);
        }
        catch (MalformedURLException malformedURLException) {
            logger.log(Level.WARNING, "Unable to create URL for URI=[" + string4 + "].", malformedURLException);
            return null;
        }
    }

    public static String unquoteAndUnescape(String string) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        boolean bl = false;
        boolean bl2 = false;
        if (n < n2) {
            c = string.charAt(n);
            switch (c) {
                case '\'': {
                    bl2 = true;
                    break;
                }
                case '\"': {
                    break;
                }
                case '\\': {
                    bl = true;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        block10: while (n < n2) {
            c = string.charAt(n);
            switch (c) {
                case '\'': {
                    if (!bl && bl2) break block10;
                    bl = false;
                    stringBuffer.append(c);
                    break;
                }
                case '\"': {
                    if (!bl && !bl2) break block10;
                    bl = false;
                    stringBuffer.append(c);
                    break;
                }
                case '\\': {
                    if (bl) {
                        bl = false;
                        stringBuffer.append(c);
                        break;
                    }
                    bl = true;
                    break;
                }
                default: {
                    if (bl) {
                        bl = false;
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String quoteAndEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'");
        int n = string.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block4;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    public static String getColorFromBackground(String string) {
        String[] stringArray = HtmlValues.splitCssValue(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!ColorFactory.getInstance().isColor(string2)) continue;
            return string2;
        }
        return null;
    }

    public static boolean isLength(String string) {
        if (string.endsWith("px") || string.endsWith("pt") || string.endsWith("pc") || string.endsWith("cm") || string.endsWith("mm") || string.endsWith("ex") || string.endsWith("em")) {
            return true;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String[] splitCssValue(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        int n = string.length();
        int n2 = 0;
        StringBuffer stringBuffer = null;
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '(': {
                    ++n2;
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(c);
                    continue block5;
                }
                case ')': {
                    --n2;
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(c);
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (n2 == 0) {
                        arrayList.add(stringBuffer.toString());
                        stringBuffer = null;
                        continue block5;
                    }
                }
                default: {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer != null) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isUrl(String string) {
        return string.toLowerCase().startsWith("url(");
    }

    public static int getListStyleType(String string) {
        String string2 = string.toLowerCase();
        if ("none".equals(string2)) {
            return 0;
        }
        if ("disc".equals(string2)) {
            return 1;
        }
        if ("circle".equals(string2)) {
            return 2;
        }
        if ("square".equals(string2)) {
            return 3;
        }
        if ("decimal".equals(string2)) {
            return 4;
        }
        if ("lower-alpha".equals(string2) || "lower-latin".equals(string2)) {
            return 5;
        }
        if ("upper-alpha".equals(string2) || "upper-latin".equals(string2)) {
            return 6;
        }
        return 256;
    }

    public static int getListStyleTypeDeprecated(String string) {
        String string2 = string.toLowerCase();
        if ("disc".equals(string2)) {
            return 1;
        }
        if ("circle".equals(string2)) {
            return 2;
        }
        if ("square".equals(string2)) {
            return 3;
        }
        if ("1".equals(string2)) {
            return 4;
        }
        if ("a".equals(string2)) {
            return 5;
        }
        if ("A".equals(string2)) {
            return 6;
        }
        return 256;
    }

    public static int getListStylePosition(String string) {
        String string2 = string.toLowerCase();
        if ("inside".equals(string2)) {
            return 0;
        }
        if ("outside".equals(string2)) {
            return 0;
        }
        return 0;
    }

    public static ListStyle getListStyle(String string) {
        ListStyle listStyle = new ListStyle();
        String[] stringArray = HtmlValues.splitCssValue(string);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string2 = stringArray[i];
            int n2 = HtmlValues.getListStyleType(string2);
            if (n2 != 256) {
                listStyle.type = n2;
                continue;
            }
            if (HtmlValues.isUrl(string2) || (n = HtmlValues.getListStylePosition(string2)) == 0) continue;
            listStyle.position = n;
        }
        return listStyle;
    }

    public static boolean isFontStyle(String string) {
        return "italic".equals(string) || "normal".equals(string) || "oblique".equals(string);
    }

    public static boolean isFontVariant(String string) {
        return "small-caps".equals(string) || "normal".equals(string);
    }

    public static boolean isFontWeight(String string) {
        if ("bold".equals(string) || "bolder".equals(string) || "lighter".equals(string)) {
            return true;
        }
        try {
            int n = Integer.parseInt(string);
            return n % 100 == 0 && n >= 100 && n <= 900;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static BorderInfo getBorderInfo(CSS2Properties cSS2Properties, RenderState renderState) {
        String string;
        String string2;
        String string3;
        BorderInfo borderInfo = new BorderInfo();
        borderInfo.topStyle = HtmlValues.getBorderStyle(cSS2Properties.getBorderTopStyle());
        borderInfo.rightStyle = HtmlValues.getBorderStyle(cSS2Properties.getBorderRightStyle());
        borderInfo.bottomStyle = HtmlValues.getBorderStyle(cSS2Properties.getBorderBottomStyle());
        borderInfo.leftStyle = HtmlValues.getBorderStyle(cSS2Properties.getBorderLeftStyle());
        ColorFactory colorFactory = ColorFactory.getInstance();
        String string4 = cSS2Properties.getBorderTopColor();
        if (string4 != null) {
            borderInfo.topColor = colorFactory.getColor(string4);
        }
        if ((string3 = cSS2Properties.getBorderRightColor()) != null) {
            borderInfo.rightColor = colorFactory.getColor(string3);
        }
        if ((string2 = cSS2Properties.getBorderBottomColor()) != null) {
            borderInfo.bottomColor = colorFactory.getColor(string2);
        }
        if ((string = cSS2Properties.getBorderLeftColor()) != null) {
            borderInfo.leftColor = colorFactory.getColor(string);
        }
        HtmlValues.populateBorderInsets(borderInfo, cSS2Properties, renderState);
        return borderInfo;
    }

    public static Insets getBorderStyles(CSS2Properties cSS2Properties) {
        int n = HtmlValues.getBorderStyle(cSS2Properties.getBorderTopStyle());
        int n2 = HtmlValues.getBorderStyle(cSS2Properties.getBorderRightStyle());
        int n3 = HtmlValues.getBorderStyle(cSS2Properties.getBorderBottomStyle());
        int n4 = HtmlValues.getBorderStyle(cSS2Properties.getBorderLeftStyle());
        return new Insets(n, n4, n3, n2);
    }

    private static int getBorderStyle(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        String string2 = string.toLowerCase();
        if ("solid".equals(string2)) {
            return 4;
        }
        if ("dashed".equals(string2)) {
            return 3;
        }
        if ("dotted".equals(string2)) {
            return 2;
        }
        if ("none".equals(string2)) {
            return 0;
        }
        if ("hidden".equals(string2)) {
            return 1;
        }
        if ("double".equals(string2)) {
            return 5;
        }
        if ("groove".equals(string2)) {
            return 6;
        }
        if ("ridge".equals(string2)) {
            return 7;
        }
        if ("inset".equals(string2)) {
            return 8;
        }
        if ("outset".equals(string2)) {
            return 9;
        }
        return 0;
    }

    public static boolean isBackgroundRepeat(String string) {
        String string2 = string.toLowerCase();
        return string2.indexOf("repeat") != -1;
    }

    public static boolean isBackgroundPosition(String string) {
        return HtmlValues.isLength(string) || string.endsWith("%") || string.equalsIgnoreCase("top") || string.equalsIgnoreCase("center") || string.equalsIgnoreCase("bottom") || string.equalsIgnoreCase("left") || string.equalsIgnoreCase("right");
    }

    static {
        FontInfo fontInfo = new FontInfo();
        SYSTEM_FONTS.put("caption", fontInfo);
        SYSTEM_FONTS.put("icon", fontInfo);
        SYSTEM_FONTS.put("menu", fontInfo);
        SYSTEM_FONTS.put("message-box", fontInfo);
        SYSTEM_FONTS.put("small-caption", fontInfo);
        SYSTEM_FONTS.put("status-bar", fontInfo);
    }
}

