/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.Urls;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSUtilities {
    private static final Logger logger = Logger.getLogger(CSSUtilities.class.getName());

    private CSSUtilities() {
    }

    public static String preProcessCss(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                String string4 = string2.trim();
                if (string4.length() == 0) continue;
                if (string3 != null) {
                    stringBuffer.append(string3);
                    stringBuffer.append("\r\n");
                    string3 = null;
                }
                if (string4.startsWith("//")) {
                    string3 = string2;
                    continue;
                }
                stringBuffer.append(string2);
                stringBuffer.append("\r\n");
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    public static InputSource getCssInputSourceForStyleSheet(String string, String string2) {
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        inputSource.setURI(string2);
        return inputSource;
    }

    public static CSSStyleSheet parse(Node node, String string, HTMLDocumentImpl hTMLDocumentImpl, String string2, boolean bl) throws MalformedURLException {
        UserAgentContext userAgentContext = hTMLDocumentImpl.getUserAgentContext();
        final HttpRequest httpRequest = userAgentContext.createHttpRequest();
        URL uRL = new URL(string2);
        URL uRL2 = Urls.createURL(uRL, string);
        final String string3 = uRL2 == null ? string : uRL2.toExternalForm();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            try {
                httpRequest.open("GET", string3, false);
                httpRequest.send(null);
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "parse()", iOException);
            }
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        httpRequest.open("GET", string3, false);
                        httpRequest.send(null);
                    }
                    catch (IOException iOException) {
                        logger.log(Level.WARNING, "parse()", iOException);
                    }
                    return null;
                }
            });
        }
        int n = httpRequest.getStatus();
        if (n != 200 && n != 0) {
            logger.warning("Unable to parse CSS. URI=[" + string3 + "]. Response status was " + n + ".");
            return null;
        }
        String string4 = httpRequest.getResponseText();
        if (string4 != null && !"".equals(string4)) {
            String string5 = bl ? CSSUtilities.preProcessCss(string4) : string4;
            CSSOMParser cSSOMParser = new CSSOMParser();
            InputSource inputSource = CSSUtilities.getCssInputSourceForStyleSheet(string5, string3);
            inputSource.setURI(string3);
            try {
                CSSStyleSheetImpl cSSStyleSheetImpl = (CSSStyleSheetImpl)cSSOMParser.parseStyleSheet(inputSource);
                cSSStyleSheetImpl.setHref(string3);
                cSSStyleSheetImpl.setOwnerNode(node);
                return cSSStyleSheetImpl;
            }
            catch (Throwable throwable) {
                logger.log(Level.WARNING, "Unable to parse CSS. URI=[" + string3 + "].", throwable);
                return null;
            }
        }
        return null;
    }

    public static boolean matchesMedia(String string, UserAgentContext userAgentContext) {
        if (string == null || string.length() == 0) {
            return true;
        }
        if (userAgentContext == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = Strings.trimForAlphaNumDash(string2);
            if (!userAgentContext.isMedia(string3)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesMedia(MediaList mediaList, UserAgentContext userAgentContext) {
        if (mediaList == null) {
            return true;
        }
        int n = mediaList.getLength();
        if (n == 0) {
            return true;
        }
        if (userAgentContext == null) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = mediaList.item(i);
            if (!userAgentContext.isMedia(string)) continue;
            return true;
        }
        return false;
    }
}

