/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.renderer.BaseRListElement;
import org.lobobrowser.html.renderer.FloatingBoundsSource;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.RBlockViewport;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RList;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.style.ListStyle;
import org.lobobrowser.html.style.RenderState;
import org.w3c.dom.html2.HTMLElement;

class RListItem
extends BaseRListElement {
    private static final int BULLET_WIDTH = 5;
    private static final int BULLET_HEIGHT = 5;
    private static final int BULLET_RMARGIN = 5;
    private static final int BULLET_SPACE_WIDTH = 36;
    private static final Integer UNSET = new Integer(Integer.MIN_VALUE);
    private Integer value = null;
    private int count;

    public RListItem(NodeImpl nodeImpl, int n, UserAgentContext userAgentContext, HtmlRendererContext htmlRendererContext, FrameContext frameContext, RenderableContainer renderableContainer, RCollection rCollection) {
        super(nodeImpl, n, userAgentContext, htmlRendererContext, frameContext, renderableContainer);
    }

    public int getViewportListNesting(int n) {
        return n + 1;
    }

    public void invalidateLayoutLocal() {
        super.invalidateLayoutLocal();
        this.value = null;
    }

    private Integer getValue() {
        Integer n = this.value;
        if (n == null) {
            String string;
            HTMLElement hTMLElement = (HTMLElement)((Object)this.modelNode);
            String string2 = string = hTMLElement == null ? null : hTMLElement.getAttribute("value");
            if (string == null) {
                n = UNSET;
            } else {
                try {
                    n = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = UNSET;
                }
            }
            this.value = n;
        }
        return n;
    }

    public void doLayout(int n, int n2, boolean bl, boolean bl2, FloatingBoundsSource floatingBoundsSource, int n3, int n4, boolean bl3) {
        super.doLayout(n, n2, bl, bl2, floatingBoundsSource, n3, n4, bl3);
        RenderState renderState = this.modelNode.getRenderState();
        Integer n5 = this.getValue();
        if (n5 == UNSET) {
            this.count = renderState.incrementCount("$cobra.counter", this.listNesting);
        } else {
            int n6;
            this.count = n6 = n5.intValue();
            renderState.resetCount("$cobra.counter", this.listNesting, n6 + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        super.paint(graphics);
        RenderState renderState = this.modelNode.getRenderState();
        Insets insets = this.marginInsets;
        RBlockViewport rBlockViewport = this.bodyLayout;
        if (rBlockViewport != null) {
            int n;
            ListStyle listStyle = this.listStyle;
            int n2 = n = listStyle == null ? 256 : listStyle.type;
            if (n != 0) {
                Object object;
                Object object2;
                if (n == 256) {
                    object2 = this.getOriginalOrCurrentParent();
                    if (!(object2 instanceof RList)) {
                        object2 = object2.getOriginalOrCurrentParent();
                    }
                    n = object2 instanceof RList ? ((object = ((RList)object2).listStyle) == null ? 1 : ((ListStyle)object).type) : 1;
                }
                object2 = graphics.getColor();
                graphics.setColor(renderState.getColor());
                try {
                    object = this.getInsets(this.hasHScrollBar, this.hasVScrollBar);
                    Insets insets2 = this.paddingInsets;
                    int n3 = rBlockViewport.getFirstBaselineOffset();
                    int n4 = (insets == null ? 0 : insets.left) - 5;
                    int n5 = ((Insets)object).top + n3 + (insets2 == null ? 0 : insets2.top);
                    int n6 = n5 - 5;
                    int n7 = n4 - 5;
                    int n8 = this.count;
                    String string = null;
                    switch (n) {
                        case 4: {
                            string = n8 + ".";
                            break;
                        }
                        case 5: {
                            string = (char)(97 + n8) + ".";
                            break;
                        }
                        case 6: {
                            string = (char)(65 + n8) + ".";
                            break;
                        }
                        case 1: {
                            graphics.fillOval(n7, n6, 5, 5);
                            break;
                        }
                        case 2: {
                            graphics.drawOval(n7, n6, 5, 5);
                            break;
                        }
                        case 3: {
                            graphics.fillRect(n7, n6, 5, 5);
                        }
                    }
                    if (string != null) {
                        FontMetrics fontMetrics = graphics.getFontMetrics();
                        int n9 = n4 - fontMetrics.stringWidth(string);
                        int n10 = n5;
                        graphics.drawString(string, n9, n10);
                    }
                }
                finally {
                    graphics.setColor((Color)object2);
                }
            }
        }
    }
}

