/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.LineBreak;
import org.lobobrowser.html.renderer.MarkupUtilities;
import org.lobobrowser.html.renderer.OverflowException;
import org.lobobrowser.html.renderer.RBlank;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RFloatInfo;
import org.lobobrowser.html.renderer.RSpacing;
import org.lobobrowser.html.renderer.RStyleChanger;
import org.lobobrowser.html.renderer.RUIControl;
import org.lobobrowser.html.renderer.RWord;
import org.lobobrowser.html.renderer.Renderable;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.RenderState;

class RLine
extends BaseRCollection {
    private final ArrayList renderables = new ArrayList(8);
    private int baseLineOffset;
    private int desiredMaxWidth;
    private int xoffset;
    private boolean allowOverflow = false;
    private boolean firstAllowOverflowWord = false;
    private BoundableRenderable mousePressTarget;
    private LineBreak lineBreak;

    public RLine(ModelNode modelNode, RenderableContainer renderableContainer, int n, int n2, int n3, int n4, boolean bl) {
        super(renderableContainer, modelNode);
        this.x = n;
        this.y = n2;
        this.height = n4;
        this.desiredMaxWidth = n3;
        this.layoutUpTreeCanBeInvalidated = true;
        this.allowOverflow = bl;
    }

    public void setAllowOverflow(boolean bl) {
        if (bl != this.allowOverflow) {
            this.allowOverflow = bl;
            if (bl) {
                this.firstAllowOverflowWord = true;
            }
        }
    }

    public boolean isAllowOverflow() {
        return this.allowOverflow;
    }

    public void changeLimits(int n, int n2) {
        this.x = n;
        this.desiredMaxWidth = n2;
    }

    public int getBaselineOffset() {
        return this.baseLineOffset;
    }

    protected void invalidateLayoutLocal() {
        this.layoutUpTreeCanBeInvalidated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Font font;
        Object object;
        RenderState renderState = this.modelNode.getRenderState();
        if (renderState != null) {
            object = renderState.getColor();
            graphics.setColor((Color)object);
            font = renderState.getFont();
            graphics.setFont(font);
        }
        if ((object = this.renderables.iterator()) != null) {
            while (object.hasNext()) {
                BoundableRenderable boundableRenderable;
                font = object.next();
                if (font instanceof RElement) {
                    boundableRenderable = (RElement)((Object)font);
                    Graphics graphics2 = graphics.create(boundableRenderable.getX(), boundableRenderable.getY(), boundableRenderable.getWidth(), boundableRenderable.getHeight());
                    try {
                        boundableRenderable.paint(graphics2);
                        continue;
                    }
                    finally {
                        graphics2.dispose();
                        continue;
                    }
                }
                if (font instanceof BoundableRenderable) {
                    boundableRenderable = (BoundableRenderable)((Object)font);
                    boundableRenderable.paintTranslated(graphics);
                    continue;
                }
                ((Renderable)((Object)font)).paint(graphics);
            }
        }
    }

    public boolean extractSelectionText(StringBuffer stringBuffer, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        boolean bl2 = super.extractSelectionText(stringBuffer, bl, renderableSpot, renderableSpot2);
        if (bl2) {
            LineBreak lineBreak = this.lineBreak;
            if (lineBreak != null) {
                stringBuffer.append(System.getProperty("line.separator"));
            } else {
                ArrayList arrayList = this.renderables;
                int n = arrayList.size();
                if (n > 0 && !(arrayList.get(n - 1) instanceof RBlank)) {
                    stringBuffer.append(" ");
                }
            }
        }
        return bl2;
    }

    public final void addStyleChanger(RStyleChanger rStyleChanger) {
        this.renderables.add(rStyleChanger);
    }

    public final void simplyAdd(Renderable renderable) {
        this.renderables.add(renderable);
    }

    public final void add(Renderable renderable) throws OverflowException {
        if (renderable instanceof RWord) {
            this.addWord((RWord)renderable);
        } else if (renderable instanceof RBlank) {
            this.addBlank((RBlank)renderable);
        } else if (renderable instanceof RUIControl) {
            this.addElement((RElement)renderable);
        } else if (renderable instanceof RSpacing) {
            this.addSpacing((RSpacing)renderable);
        } else if (renderable instanceof RStyleChanger) {
            this.addStyleChanger((RStyleChanger)renderable);
        } else if (renderable instanceof RFloatInfo) {
            this.simplyAdd((RFloatInfo)renderable);
        } else {
            throw new IllegalArgumentException("Can't add " + renderable);
        }
    }

    public final void addWord(RWord rWord) throws OverflowException {
        int n;
        int n2;
        int n3 = this.xoffset;
        int n4 = rWord.width;
        boolean bl = this.allowOverflow;
        boolean bl2 = this.firstAllowOverflowWord;
        if (bl && bl2) {
            this.firstAllowOverflowWord = false;
        }
        if ((!bl || bl2) && n3 != 0 && n3 + n4 > this.desiredMaxWidth) {
            ArrayList arrayList = this.renderables;
            ArrayList<RWord> arrayList2 = null;
            n2 = 0;
            n = n3;
            int n5 = n3;
            int n6 = arrayList.size();
            while (--n6 >= 0) {
                BoundableRenderable boundableRenderable;
                Renderable renderable = (Renderable)arrayList.get(n6);
                if (renderable instanceof RWord || !(renderable instanceof BoundableRenderable)) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<RWord>();
                    }
                    if (renderable != rWord && renderable instanceof RWord && ((RWord)renderable).getX() == 0) {
                        n2 = 1;
                        break;
                    }
                    arrayList2.add(0, (RWord)renderable);
                    arrayList.remove(n6);
                    continue;
                }
                if (renderable instanceof RBlank) {
                    boundableRenderable = (RBlank)renderable;
                    n5 = ((BaseBoundableRenderable)boundableRenderable).getX();
                    n = n5 + ((BaseBoundableRenderable)boundableRenderable).getWidth();
                    break;
                }
                boundableRenderable = (BoundableRenderable)renderable;
                n5 = n = boundableRenderable.getX() + boundableRenderable.getWidth();
                break;
            }
            if (n2 != 0) {
                if (arrayList2 != null) {
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        arrayList.add(iterator.next());
                    }
                }
            } else {
                this.xoffset = n;
                this.width = n5;
                if (arrayList2 == null) {
                    throw new OverflowException(Collections.singleton(rWord));
                }
                arrayList2.add(rWord);
                throw new OverflowException(arrayList2);
            }
        }
        int n7 = 0;
        int n8 = this.height - this.baseLineOffset;
        if (rWord.descent > n8) {
            n7 += rWord.descent - n8;
        }
        if (rWord.ascentPlusLeading > (n2 = this.baseLineOffset)) {
            n7 += rWord.ascentPlusLeading - n2;
        }
        if (n7 > 0) {
            n = this.height + n7;
            this.adjustHeight(n, n, 4);
        }
        this.renderables.add(rWord);
        rWord.setParent(this);
        n = n3;
        this.width = this.xoffset = (n3 += n4);
        rWord.setOrigin(n, this.baseLineOffset - rWord.ascentPlusLeading);
    }

    public final void addBlank(RBlank rBlank) {
        int n = this.xoffset;
        int n2 = rBlank.width;
        rBlank.setOrigin(n, this.baseLineOffset - rBlank.ascentPlusLeading);
        this.renderables.add(rBlank);
        rBlank.setParent(this);
        this.xoffset = n + n2;
    }

    public final void addSpacing(RSpacing rSpacing) {
        int n = this.xoffset;
        int n2 = rSpacing.width;
        rSpacing.setOrigin(n, (this.height - rSpacing.height) / 2);
        this.renderables.add(rSpacing);
        rSpacing.setParent(this);
        this.width = this.xoffset = n + n2;
    }

    private final void setElementY(RElement rElement, int n, int n2) {
        int n3;
        switch (n2) {
            case 4: {
                n3 = this.height - n;
                break;
            }
            case 3: {
                n3 = (this.height - n) / 2;
                break;
            }
            case 2: 
            case 5: {
                n3 = this.baseLineOffset - n;
                break;
            }
            case 1: {
                n3 = this.baseLineOffset - n / 2;
                break;
            }
            case 0: {
                n3 = 0;
                break;
            }
            default: {
                n3 = this.baseLineOffset - n;
            }
        }
        rElement.setY(n3);
    }

    private final void addElement(RElement rElement) throws OverflowException {
        int n;
        int n2;
        int n3 = this.xoffset;
        int n4 = this.desiredMaxWidth;
        int n5 = rElement.getWidth();
        boolean bl = this.allowOverflow;
        boolean bl2 = this.firstAllowOverflowWord;
        if (bl && bl2) {
            this.firstAllowOverflowWord = false;
        }
        if ((!bl || bl2) && n3 != 0 && n3 + n5 > n4) {
            throw new OverflowException(Collections.singleton(rElement));
        }
        int n6 = this.height;
        int n7 = rElement.getHeight();
        int n8 = rElement.getVAlign();
        switch (n8) {
            case 2: 
            case 5: {
                n2 = n7 + (n6 - this.baseLineOffset);
                break;
            }
            case 1: {
                n2 = Math.max(n7, n7 / 2 + (n6 - this.baseLineOffset));
                break;
            }
            default: {
                n2 = n7;
            }
        }
        if (n2 > n6) {
            this.adjustHeight(n2, n7, n8);
        }
        this.renderables.add(rElement);
        rElement.setParent(this);
        rElement.setX(n3);
        this.setElementY(rElement, n7, n8);
        this.width = this.xoffset = (n = n3 + n5);
    }

    private void adjustHeight(int n, int n2, int n3) {
        int n4;
        FontMetrics fontMetrics;
        Object object;
        this.height = n;
        ArrayList arrayList = this.renderables;
        FontMetrics fontMetrics2 = this.modelNode.getRenderState().getFontMetrics();
        int n5 = fontMetrics2.getDescent();
        int n6 = fontMetrics2.getAscent() + fontMetrics2.getLeading();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n7;
            Object e = iterator.next();
            if (!(e instanceof RStyleChanger)) continue;
            object = (RStyleChanger)e;
            fontMetrics = ((RStyleChanger)object).getModelNode().getRenderState().getFontMetrics();
            int n8 = fontMetrics.getDescent();
            if (n8 > n5) {
                n5 = n8;
            }
            if ((n7 = fontMetrics.getAscent() + fontMetrics.getLeading()) <= n6) continue;
            n6 = n7;
        }
        int n9 = n5 + n6;
        switch (n3) {
            case 4: {
                n4 = n - n5;
                break;
            }
            case 3: {
                n4 = (n + n9) / 2 - n5;
                break;
            }
            case 2: 
            case 5: {
                n4 = n2;
                break;
            }
            case 1: {
                n4 = n / 2;
                break;
            }
            case 0: {
                n4 = n6;
                break;
            }
            default: {
                n4 = n2;
            }
        }
        this.baseLineOffset = n4;
        object = arrayList.iterator();
        while (object.hasNext()) {
            BoundableRenderable boundableRenderable;
            fontMetrics = object.next();
            if (fontMetrics instanceof RWord) {
                boundableRenderable = (RWord)((Object)fontMetrics);
                ((BaseBoundableRenderable)boundableRenderable).setY(n4 - ((RWord)boundableRenderable).ascentPlusLeading);
                continue;
            }
            if (fontMetrics instanceof RBlank) {
                boundableRenderable = (RBlank)((Object)fontMetrics);
                ((BaseBoundableRenderable)boundableRenderable).setY(n4 - ((RBlank)boundableRenderable).ascentPlusLeading);
                continue;
            }
            if (!(fontMetrics instanceof RElement)) continue;
            boundableRenderable = (RElement)((Object)fontMetrics);
            this.setElementY((RElement)boundableRenderable, boundableRenderable.getHeight(), boundableRenderable.getVAlign());
        }
    }

    public boolean onMouseClick(MouseEvent mouseEvent, int n, int n2) {
        Renderable[] renderableArray = this.renderables.toArray(Renderable.EMPTY_ARRAY);
        BoundableRenderable boundableRenderable = MarkupUtilities.findRenderable(renderableArray, n, n2, false);
        if (boundableRenderable != null) {
            Rectangle rectangle = boundableRenderable.getBounds();
            return boundableRenderable.onMouseClick(mouseEvent, n - rectangle.x, n2 - rectangle.y);
        }
        return true;
    }

    public boolean onDoubleClick(MouseEvent mouseEvent, int n, int n2) {
        Renderable[] renderableArray = this.renderables.toArray(Renderable.EMPTY_ARRAY);
        BoundableRenderable boundableRenderable = MarkupUtilities.findRenderable(renderableArray, n, n2, false);
        if (boundableRenderable != null) {
            Rectangle rectangle = boundableRenderable.getBounds();
            return boundableRenderable.onDoubleClick(mouseEvent, n - rectangle.x, n2 - rectangle.y);
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent, int n, int n2) {
        Renderable[] renderableArray = this.renderables.toArray(Renderable.EMPTY_ARRAY);
        BoundableRenderable boundableRenderable = MarkupUtilities.findRenderable(renderableArray, n, n2, false);
        if (boundableRenderable != null) {
            this.mousePressTarget = boundableRenderable;
            Rectangle rectangle = boundableRenderable.getBounds();
            return boundableRenderable.onMousePressed(mouseEvent, n - rectangle.x, n2 - rectangle.y);
        }
        return true;
    }

    public RenderableSpot getLowestRenderableSpot(int n, int n2) {
        Renderable[] renderableArray = this.renderables.toArray(Renderable.EMPTY_ARRAY);
        BoundableRenderable boundableRenderable = MarkupUtilities.findRenderable(renderableArray, n, n2, false);
        if (boundableRenderable != null) {
            Rectangle rectangle = boundableRenderable.getBounds();
            return boundableRenderable.getLowestRenderableSpot(n - rectangle.x, n2 - rectangle.y);
        }
        return new RenderableSpot(this, n, n2);
    }

    public boolean onMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        Renderable[] renderableArray = this.renderables.toArray(Renderable.EMPTY_ARRAY);
        BoundableRenderable boundableRenderable = MarkupUtilities.findRenderable(renderableArray, n, n2, false);
        if (boundableRenderable != null) {
            Rectangle rectangle = boundableRenderable.getBounds();
            BoundableRenderable boundableRenderable2 = this.mousePressTarget;
            if (boundableRenderable2 != null && boundableRenderable != boundableRenderable2) {
                boundableRenderable2.onMouseDisarmed(mouseEvent);
                this.mousePressTarget = null;
            }
            return boundableRenderable.onMouseReleased(mouseEvent, n - rectangle.x, n2 - rectangle.y);
        }
        BoundableRenderable boundableRenderable3 = this.mousePressTarget;
        if (boundableRenderable3 != null) {
            boundableRenderable3.onMouseDisarmed(mouseEvent);
            this.mousePressTarget = null;
        }
        return true;
    }

    public boolean onMouseDisarmed(MouseEvent mouseEvent) {
        BoundableRenderable boundableRenderable = this.mousePressTarget;
        if (boundableRenderable != null) {
            this.mousePressTarget = null;
            return boundableRenderable.onMouseDisarmed(mouseEvent);
        }
        return true;
    }

    public Color getBlockBackgroundColor() {
        return this.container.getPaintedBackgroundColor();
    }

    public Iterator getRenderables() {
        return this.renderables.iterator();
    }

    public boolean isContainedByNode() {
        return false;
    }

    public LineBreak getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(LineBreak lineBreak) {
        this.lineBreak = lineBreak;
    }

    public boolean isEmpty() {
        return this.xoffset == 0;
    }
}

