/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseBoundableRenderable;
import org.lobobrowser.html.renderer.HtmlController;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.html.style.RenderState;

final class RBlank
extends BaseBoundableRenderable {
    public final int ascentPlusLeading;
    private final FontMetrics fontMetrics;

    public RBlank(ModelNode modelNode, FontMetrics fontMetrics, RenderableContainer renderableContainer, int n, int n2, int n3) {
        super(renderableContainer, modelNode);
        this.fontMetrics = fontMetrics;
        this.ascentPlusLeading = n;
        this.width = n2;
        this.height = n3;
    }

    protected void invalidateLayoutLocal() {
    }

    public boolean onMouseClick(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onMouseClick(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public boolean onDoubleClick(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onDoubleClick(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onMouseDown(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onMouseUp(modelNode, mouseEvent, n, n2);
        }
        return true;
    }

    public boolean onMouseDisarmed(MouseEvent mouseEvent) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onMouseDisarmed(modelNode, mouseEvent);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics graphics) {
        Color color;
        int n;
        RenderState renderState = this.modelNode.getRenderState();
        Color color2 = renderState.getTextBackgroundColor();
        if (color2 != null) {
            Color color3 = graphics.getColor();
            try {
                graphics.setColor(color2);
                graphics.fillRect(0, 0, this.width, this.height);
            }
            finally {
                graphics.setColor(color3);
            }
        }
        if ((n = renderState.getTextDecorationMask()) != 0) {
            if ((n & 1) != 0) {
                int n2 = this.ascentPlusLeading + 2;
                graphics.drawLine(0, n2, this.width, n2);
            }
            if ((n & 4) != 0) {
                FontMetrics fontMetrics = this.fontMetrics;
                int n3 = fontMetrics.getLeading() + (fontMetrics.getAscent() + fontMetrics.getDescent()) / 2;
                graphics.drawLine(0, n3, this.width, n3);
            }
            if ((n & 2) != 0) {
                int n4 = this.fontMetrics.getLeading();
                graphics.drawLine(0, n4, this.width, n4);
            }
            if ((n & 8) != 0) {
                // empty if block
            }
        }
        if ((color = renderState.getOverlayColor()) != null) {
            Color color4 = graphics.getColor();
            try {
                graphics.setColor(color);
                graphics.fillRect(0, 0, this.width, this.height);
            }
            finally {
                graphics.setColor(color4);
            }
        }
    }

    public boolean paintSelection(Graphics graphics, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        if (this == renderableSpot.renderable || this == renderableSpot2.renderable ? bl : !bl) {
            return false;
        }
        graphics.setColor(SELECTION_COLOR);
        graphics.setXORMode(SELECTION_XOR);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setPaintMode();
        return true;
    }

    public boolean extractSelectionText(StringBuffer stringBuffer, boolean bl, RenderableSpot renderableSpot, RenderableSpot renderableSpot2) {
        if (this == renderableSpot.renderable || this == renderableSpot2.renderable ? bl : !bl) {
            return false;
        }
        stringBuffer.append(' ');
        return true;
    }

    public RenderableSpot getLowestRenderableSpot(int n, int n2) {
        return new RenderableSpot(this, n, n2);
    }

    public boolean isContainedByNode() {
        return true;
    }

    public boolean onRightClick(MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode = this.modelNode;
        if (modelNode != null) {
            return HtmlController.getInstance().onContextMenu(modelNode, mouseEvent, n, n2);
        }
        return true;
    }
}

