/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.util.Strings;
import org.lobobrowser.util.gui.WrapperLayout;

class InputTextAreaControl
extends BaseInputControl {
    private final JTextComponent widget;
    private int cols = -1;
    private int rows = -1;

    public InputTextAreaControl(HTMLBaseInputElement hTMLBaseInputElement) {
        super(hTMLBaseInputElement);
        JTextComponent jTextComponent;
        this.setLayout(WrapperLayout.getInstance());
        this.widget = jTextComponent = this.createTextField();
        this.add(new JScrollPane(jTextComponent));
        HTMLElementImpl hTMLElementImpl = this.controlElement;
        String string = hTMLElementImpl.getTextContent();
        ((JTextArea)jTextComponent).setLineWrap(true);
        jTextComponent.setText(string);
    }

    public void reset(int n, int n2) {
        String string;
        super.reset(n, n2);
        HTMLElementImpl hTMLElementImpl = this.controlElement;
        String string2 = hTMLElementImpl.getAttribute("cols");
        if (string2 != null) {
            try {
                this.setCols(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = hTMLElementImpl.getAttribute("rows")) != null) {
            try {
                this.setRows(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected JTextComponent createTextField() {
        return new JTextArea();
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public void setCols(int n) {
        if (n != this.cols) {
            this.cols = n;
            this.invalidate();
        }
    }

    public void setRows(int n) {
        if (n != this.rows) {
            this.rows = n;
            this.invalidate();
        }
    }

    public Dimension getPreferredSize() {
        int n;
        Serializable serializable;
        int n2;
        int n3 = this.cols;
        if (n3 == -1) {
            n2 = 100;
        } else {
            Font font = this.widget.getFont();
            FontMetrics fontMetrics = this.widget.getFontMetrics(font);
            serializable = this.widget.getInsets();
            n2 = ((Insets)serializable).left + ((Insets)serializable).right + fontMetrics.charWidth('*') * n3;
        }
        int n4 = this.rows;
        if (n4 == -1) {
            n = 100;
        } else {
            serializable = this.widget.getFont();
            FontMetrics fontMetrics = this.widget.getFontMetrics((Font)serializable);
            Insets insets = this.widget.getInsets();
            n = insets.top + insets.bottom + fontMetrics.getHeight() * n4;
        }
        return new Dimension(n2, n);
    }

    public boolean getReadOnly() {
        return !this.widget.isEditable();
    }

    public String getValue() {
        String string = this.widget.getText();
        return Strings.getCRLFString(string);
    }

    public void setReadOnly(boolean bl) {
        this.widget.setEditable(bl);
    }

    public void setValue(String string) {
        this.widget.setText(string);
    }

    public void resetInput() {
        this.widget.setText("");
    }
}

