/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.domimpl.ElementImpl;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLButtonElementImpl;
import org.lobobrowser.html.domimpl.HTMLInputElementImpl;
import org.lobobrowser.html.domimpl.HTMLLinkElementImpl;
import org.lobobrowser.html.domimpl.HTMLSelectElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.js.Event;
import org.lobobrowser.html.js.Executor;
import org.mozilla.javascript.Function;
import org.w3c.dom.html2.HTMLElement;

class HtmlController {
    private static final Logger logger = Logger.getLogger(HtmlController.class.getName());
    private static final HtmlController instance = new HtmlController();

    HtmlController() {
    }

    static HtmlController getInstance() {
        return instance;
    }

    public boolean onEnterPressed(ModelNode modelNode, InputEvent inputEvent) {
        HTMLInputElementImpl hTMLInputElementImpl;
        if (modelNode instanceof HTMLInputElementImpl && (hTMLInputElementImpl = (HTMLInputElementImpl)modelNode).isSubmittableWithEnterKey()) {
            hTMLInputElementImpl.submitForm(null);
            return false;
        }
        return false;
    }

    public boolean onMouseClick(ModelNode modelNode, MouseEvent mouseEvent, int n, int n2) {
        Object object;
        Object object2;
        ModelNode modelNode2;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("onMouseClick(): node=" + modelNode + ",class=" + modelNode.getClass().getName());
        }
        if (modelNode instanceof HTMLAbstractUIElement) {
            modelNode2 = (HTMLAbstractUIElement)modelNode;
            object2 = ((HTMLAbstractUIElement)modelNode2).getOnclick();
            if (object2 != null && !Executor.executeFunction((NodeImpl)modelNode2, (Function)object2, (Event)(object = new Event("click", (HTMLElement)((Object)modelNode2), mouseEvent, n, n2)))) {
                return false;
            }
            object = ((NodeImpl)modelNode2).getHtmlRendererContext();
            if (object != null && !object.onMouseClick((HTMLElement)((Object)modelNode2), mouseEvent)) {
                return false;
            }
        }
        if (modelNode instanceof HTMLLinkElementImpl) {
            ((HTMLLinkElementImpl)modelNode).navigate();
            return false;
        }
        if (modelNode instanceof HTMLButtonElementImpl) {
            modelNode2 = (HTMLButtonElementImpl)modelNode;
            object2 = ((ElementImpl)modelNode2).getAttribute("type");
            object = object2 == null ? "submit" : ((String)object2).trim().toLowerCase();
            if ("submit".equals(object)) {
                String string = ((HTMLBaseInputElement)modelNode2).getName();
                FormInput[] formInputArray = string == null ? null : new FormInput[]{new FormInput(string, ((HTMLBaseInputElement)modelNode2).getValue())};
                ((HTMLBaseInputElement)modelNode2).submitForm(formInputArray);
            } else if ("reset".equals(object)) {
                ((HTMLBaseInputElement)modelNode2).resetForm();
            }
            return false;
        }
        modelNode2 = modelNode.getParentModelNode();
        if (modelNode2 == null) {
            return true;
        }
        return this.onMouseClick(modelNode2, mouseEvent, n, n2);
    }

    public boolean onContextMenu(ModelNode modelNode, MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode2;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("onContextMenu(): node=" + modelNode + ",class=" + modelNode.getClass().getName());
        }
        if (modelNode instanceof HTMLAbstractUIElement) {
            Object object;
            modelNode2 = (HTMLAbstractUIElement)modelNode;
            Function function = ((HTMLAbstractUIElement)modelNode2).getOncontextmenu();
            if (function != null && !Executor.executeFunction((NodeImpl)modelNode2, function, (Event)(object = new Event("contextmenu", (HTMLElement)((Object)modelNode2), mouseEvent, n, n2)))) {
                return false;
            }
            object = ((NodeImpl)modelNode2).getHtmlRendererContext();
            if (object != null && !object.onContextMenu((HTMLElement)((Object)modelNode2), mouseEvent)) {
                return false;
            }
        }
        if ((modelNode2 = modelNode.getParentModelNode()) == null) {
            return true;
        }
        return this.onContextMenu(modelNode2, mouseEvent, n, n2);
    }

    public void onMouseOver(ModelNode modelNode, MouseEvent mouseEvent, int n, int n2, ModelNode modelNode2) {
        while (modelNode != null && modelNode != modelNode2) {
            if (modelNode instanceof HTMLAbstractUIElement) {
                Object object;
                HTMLAbstractUIElement hTMLAbstractUIElement = (HTMLAbstractUIElement)modelNode;
                hTMLAbstractUIElement.setMouseOver(true);
                Function function = hTMLAbstractUIElement.getOnmouseover();
                if (function != null) {
                    object = new Event("mouseover", hTMLAbstractUIElement, mouseEvent, n, n2);
                    Executor.executeFunction(hTMLAbstractUIElement, function, (Event)object);
                }
                if ((object = hTMLAbstractUIElement.getHtmlRendererContext()) != null) {
                    object.onMouseOver(hTMLAbstractUIElement, mouseEvent);
                }
            }
            modelNode = modelNode.getParentModelNode();
        }
    }

    public void onMouseOut(ModelNode modelNode, MouseEvent mouseEvent, int n, int n2, ModelNode modelNode2) {
        while (modelNode != null && modelNode != modelNode2) {
            if (modelNode instanceof HTMLAbstractUIElement) {
                Object object;
                HTMLAbstractUIElement hTMLAbstractUIElement = (HTMLAbstractUIElement)modelNode;
                hTMLAbstractUIElement.setMouseOver(false);
                Function function = hTMLAbstractUIElement.getOnmouseout();
                if (function != null) {
                    object = new Event("mouseout", hTMLAbstractUIElement, mouseEvent, n, n2);
                    Executor.executeFunction(hTMLAbstractUIElement, function, (Event)object);
                }
                if ((object = hTMLAbstractUIElement.getHtmlRendererContext()) != null) {
                    object.onMouseOut(hTMLAbstractUIElement, mouseEvent);
                }
            }
            modelNode = modelNode.getParentModelNode();
        }
    }

    public boolean onDoubleClick(ModelNode modelNode, MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode2;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("onDoubleClick(): node=" + modelNode + ",class=" + modelNode.getClass().getName());
        }
        if (modelNode instanceof HTMLAbstractUIElement) {
            Object object;
            modelNode2 = (HTMLAbstractUIElement)modelNode;
            Function function = ((HTMLAbstractUIElement)modelNode2).getOndblclick();
            if (function != null && !Executor.executeFunction((NodeImpl)modelNode2, function, (Event)(object = new Event("dblclick", (HTMLElement)((Object)modelNode2), mouseEvent, n, n2)))) {
                return false;
            }
            object = ((NodeImpl)modelNode2).getHtmlRendererContext();
            if (object != null && !object.onDoubleClick((HTMLElement)((Object)modelNode2), mouseEvent)) {
                return false;
            }
        }
        if ((modelNode2 = modelNode.getParentModelNode()) == null) {
            return true;
        }
        return this.onDoubleClick(modelNode2, mouseEvent, n, n2);
    }

    public boolean onMouseDisarmed(ModelNode modelNode, MouseEvent mouseEvent) {
        if (modelNode instanceof HTMLLinkElementImpl) {
            ((HTMLLinkElementImpl)modelNode).getCurrentStyle().setOverlayColor(null);
            return false;
        }
        ModelNode modelNode2 = modelNode.getParentModelNode();
        if (modelNode2 == null) {
            return true;
        }
        return this.onMouseDisarmed(modelNode2, mouseEvent);
    }

    public boolean onMouseDown(ModelNode modelNode, MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode2;
        Function function;
        boolean bl = true;
        if (modelNode instanceof HTMLAbstractUIElement && (function = (modelNode2 = (HTMLAbstractUIElement)modelNode).getOnmousedown()) != null) {
            Event event = new Event("mousedown", (HTMLElement)((Object)modelNode2), mouseEvent, n, n2);
            bl = Executor.executeFunction(modelNode2, function, event);
        }
        if (modelNode instanceof HTMLLinkElementImpl) {
            ((HTMLLinkElementImpl)modelNode).getCurrentStyle().setOverlayColor("#9090FF80");
            return false;
        }
        if (!bl) {
            return false;
        }
        modelNode2 = modelNode.getParentModelNode();
        if (modelNode2 == null) {
            return true;
        }
        return this.onMouseDown(modelNode2, mouseEvent, n, n2);
    }

    public boolean onMouseUp(ModelNode modelNode, MouseEvent mouseEvent, int n, int n2) {
        ModelNode modelNode2;
        Function function;
        boolean bl = true;
        if (modelNode instanceof HTMLAbstractUIElement && (function = (modelNode2 = (HTMLAbstractUIElement)modelNode).getOnmouseup()) != null) {
            Event event = new Event("mouseup", (HTMLElement)((Object)modelNode2), mouseEvent, n, n2);
            bl = Executor.executeFunction(modelNode2, function, event);
        }
        if (modelNode instanceof HTMLLinkElementImpl) {
            ((HTMLLinkElementImpl)modelNode).getCurrentStyle().setOverlayColor(null);
            return false;
        }
        if (!bl) {
            return false;
        }
        modelNode2 = modelNode.getParentModelNode();
        if (modelNode2 == null) {
            return true;
        }
        return this.onMouseUp(modelNode2, mouseEvent, n, n2);
    }

    public boolean onPressed(ModelNode modelNode, InputEvent inputEvent, int n, int n2) {
        Object object;
        HTMLAbstractUIElement hTMLAbstractUIElement;
        Object object2;
        if (modelNode instanceof HTMLAbstractUIElement && (object2 = (hTMLAbstractUIElement = (HTMLAbstractUIElement)modelNode).getOnclick()) != null && !Executor.executeFunction(hTMLAbstractUIElement, (Function)object2, (Event)(object = new Event("click", hTMLAbstractUIElement, inputEvent, n, n2)))) {
            return false;
        }
        if (modelNode instanceof HTMLInputElementImpl) {
            hTMLAbstractUIElement = (HTMLInputElementImpl)modelNode;
            if (((HTMLInputElementImpl)hTMLAbstractUIElement).isSubmitInput()) {
                object = ((HTMLBaseInputElement)hTMLAbstractUIElement).getName();
                object2 = object == null ? null : new FormInput[]{new FormInput((String)object, ((HTMLBaseInputElement)hTMLAbstractUIElement).getValue())};
                ((HTMLBaseInputElement)hTMLAbstractUIElement).submitForm((FormInput[])object2);
            } else if (((HTMLInputElementImpl)hTMLAbstractUIElement).isImageInput()) {
                object2 = ((HTMLBaseInputElement)hTMLAbstractUIElement).getName();
                object = object2 == null ? "" : (String)object2 + ".";
                FormInput[] formInputArray = new FormInput[]{new FormInput((String)object + "x", String.valueOf(n)), new FormInput((String)object + "y", String.valueOf(n2))};
                ((HTMLBaseInputElement)hTMLAbstractUIElement).submitForm(formInputArray);
            } else if (((HTMLInputElementImpl)hTMLAbstractUIElement).isResetInput()) {
                ((HTMLBaseInputElement)hTMLAbstractUIElement).resetForm();
            }
        }
        return false;
    }

    public boolean onChange(ModelNode modelNode) {
        Event event;
        HTMLSelectElementImpl hTMLSelectElementImpl;
        Function function;
        if (modelNode instanceof HTMLSelectElementImpl && (function = (hTMLSelectElementImpl = (HTMLSelectElementImpl)modelNode).getOnchange()) != null && !Executor.executeFunction(hTMLSelectElementImpl, function, event = new Event("change", hTMLSelectElementImpl))) {
            return false;
        }
        return false;
    }
}

