/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.parser.CSSOMParser;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.style.CSSUtilities;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.html2.HTMLStyleElement;

public class HTMLStyleElementImpl
extends HTMLElementImpl
implements HTMLStyleElement {
    private CSSStyleSheet styleSheet;
    private boolean disabled;

    public HTMLStyleElementImpl() {
        super("STYLE", true);
    }

    public HTMLStyleElementImpl(String string) {
        super(string, true);
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
        CSSStyleSheet cSSStyleSheet = this.styleSheet;
        if (cSSStyleSheet != null) {
            cSSStyleSheet.setDisabled(bl);
        }
    }

    public String getMedia() {
        return this.getAttribute("media");
    }

    public void setMedia(String string) {
        this.setAttribute("media", string);
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public void setType(String string) {
        this.setAttribute("type", string);
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        if ("cobra.suspend".equals(string) && object != Boolean.TRUE) {
            this.processStyle();
        } else if ("styleSheet.disabled.changed".equals(string)) {
            this.informDocumentInvalid();
        }
        return super.setUserData(string, object, userDataHandler);
    }

    protected void processStyle() {
        String string;
        this.styleSheet = null;
        if (CSSUtilities.matchesMedia(this.getMedia(), this.getUserAgentContext()) && (string = this.getRawInnerText(true)) != null && !"".equals(string)) {
            String string2 = CSSUtilities.preProcessCss(string);
            HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.getOwnerDocument();
            CSSOMParser cSSOMParser = new CSSOMParser();
            String string3 = hTMLDocumentImpl.getBaseURI();
            InputSource inputSource = CSSUtilities.getCssInputSourceForStyleSheet(string2, string3);
            try {
                CSSStyleSheetImpl cSSStyleSheetImpl = (CSSStyleSheetImpl)cSSOMParser.parseStyleSheet(inputSource);
                cSSStyleSheetImpl.setOwnerNode(this);
                cSSStyleSheetImpl.setHref(string3);
                hTMLDocumentImpl.addStyleSheet(cSSStyleSheetImpl);
                this.styleSheet = cSSStyleSheetImpl;
                if (cSSStyleSheetImpl instanceof CSSStyleSheetImpl) {
                    CSSStyleSheetImpl cSSStyleSheetImpl2 = cSSStyleSheetImpl;
                    cSSStyleSheetImpl2.setDisabledOnly(this.disabled);
                } else {
                    cSSStyleSheetImpl.setDisabled(this.disabled);
                }
            }
            catch (Throwable throwable) {
                this.warn("Unable to parse style sheet", throwable);
            }
        }
    }

    protected void appendInnerTextImpl(StringBuffer stringBuffer) {
    }
}

