/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.domimpl.DescendentHTMLCollection;
import org.lobobrowser.html.domimpl.HTMLAbstractUIElement;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.domimpl.NodeVisitor;
import org.lobobrowser.html.domimpl.StopVisitorException;
import org.lobobrowser.html.js.Executor;
import org.mozilla.javascript.Function;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLFormElement;

public class HTMLFormElementImpl
extends HTMLAbstractUIElement
implements HTMLFormElement {
    private HTMLCollection elements;
    private Function onsubmit;

    public HTMLFormElementImpl(String string) {
        super(string);
    }

    public HTMLFormElementImpl() {
        super("FORM");
    }

    public Object namedItem(final String string) {
        try {
            this.visit(new NodeVisitor(){

                public void visit(Node node) {
                    if (HTMLFormElementImpl.isInput(node) && string.equals(((Element)node).getAttribute("name"))) {
                        throw new StopVisitorException(node);
                    }
                }
            });
        }
        catch (StopVisitorException stopVisitorException) {
            return stopVisitorException.getTag();
        }
        return null;
    }

    public Object item(final int n) {
        try {
            this.visit(new NodeVisitor(){
                private int current = 0;

                public void visit(Node node) {
                    if (HTMLFormElementImpl.isInput(node)) {
                        if (this.current == n) {
                            throw new StopVisitorException(node);
                        }
                        ++this.current;
                    }
                }
            });
        }
        catch (StopVisitorException stopVisitorException) {
            return stopVisitorException.getTag();
        }
        return null;
    }

    public HTMLCollection getElements() {
        HTMLCollection hTMLCollection = this.elements;
        if (hTMLCollection == null) {
            this.elements = hTMLCollection = new DescendentHTMLCollection(this, new InputFilter(), this.treeLock, false);
        }
        return hTMLCollection;
    }

    public int getLength() {
        return this.getElements().getLength();
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public void setName(String string) {
        this.setAttribute("name", string);
    }

    public String getAcceptCharset() {
        return this.getAttribute("acceptCharset");
    }

    public void setAcceptCharset(String string) {
        this.setAttribute("acceptCharset", string);
    }

    public String getAction() {
        return this.getAttribute("action");
    }

    public void setAction(String string) {
        this.setAttribute("action", string);
    }

    public String getEnctype() {
        return this.getAttribute("enctype");
    }

    public void setEnctype(String string) {
        this.setAttribute("enctype", string);
    }

    public String getMethod() {
        String string = this.getAttribute("method");
        if (string == null) {
            string = "GET";
        }
        return string;
    }

    public void setMethod(String string) {
        this.setAttribute("method", string);
    }

    public String getTarget() {
        return this.getAttribute("target");
    }

    public void setTarget(String string) {
        this.setAttribute("target", string);
    }

    public void submit() {
        this.submit(null);
    }

    public void setOnsubmit(Function function) {
        this.onsubmit = function;
    }

    public Function getOnsubmit() {
        return this.getEventFunction(this.onsubmit, "onsubmit");
    }

    public final void submit(FormInput[] formInputArray) {
        Function function = this.getOnsubmit();
        if (function != null && !Executor.executeFunction(this, function, null)) {
            return;
        }
        HtmlRendererContext htmlRendererContext = this.getHtmlRendererContext();
        if (htmlRendererContext != null) {
            final ArrayList<FormInput> arrayList = new ArrayList<FormInput>();
            if (formInputArray != null) {
                for (int i = 0; i < formInputArray.length; ++i) {
                    arrayList.add(formInputArray[i]);
                }
            }
            this.visit(new NodeVisitor(){

                public void visit(Node node) {
                    FormInput[] formInputArray;
                    if (node instanceof HTMLElementImpl && (formInputArray = ((HTMLElementImpl)node).getFormInputs()) != null) {
                        for (int i = 0; i < formInputArray.length; ++i) {
                            FormInput formInput = formInputArray[i];
                            if (formInput.getName() == null) {
                                throw new IllegalStateException("Form input does not have a name: " + node);
                            }
                            arrayList.add(formInput);
                        }
                    }
                }
            });
            FormInput[] formInputArray2 = arrayList.toArray(FormInput.EMPTY_ARRAY);
            String string = this.getAction();
            if (string == null) {
                string = this.getBaseURI();
            }
            try {
                URL uRL = this.getFullURL(string);
                htmlRendererContext.submitForm(this.getMethod(), uRL, this.getTarget(), this.getEnctype(), formInputArray2);
            }
            catch (MalformedURLException malformedURLException) {
                this.warn("submit()", malformedURLException);
            }
        }
    }

    public void reset() {
        this.visit(new NodeVisitor(){

            public void visit(Node node) {
                if (node instanceof HTMLBaseInputElement) {
                    ((HTMLBaseInputElement)node).resetInput();
                }
            }
        });
    }

    static boolean isInput(Node node) {
        String string = node.getNodeName().toLowerCase();
        return string.equals("input") || string.equals("textarea") || string.equals("select");
    }

    private class InputFilter
    implements NodeFilter {
        private InputFilter() {
        }

        public boolean accept(Node node) {
            return HTMLFormElementImpl.isInput(node);
        }
    }
}

