/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.domimpl;

import com.steadystate.css.parser.CSSOMParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.domimpl.ElementImpl;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.parser.HtmlParser;
import org.lobobrowser.html.style.AbstractCSS2Properties;
import org.lobobrowser.html.style.CSS2PropertiesContext;
import org.lobobrowser.html.style.ComputedCSS2Properties;
import org.lobobrowser.html.style.LocalCSS2Properties;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.html.style.StyleSheetAggregator;
import org.lobobrowser.html.style.StyleSheetRenderState;
import org.lobobrowser.js.AbstractScriptableDelegate;
import org.lobobrowser.util.Strings;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.html2.HTMLElement;

public class HTMLElementImpl
extends ElementImpl
implements HTMLElement,
CSS2PropertiesContext {
    private final boolean noStyleSheet;
    private volatile AbstractCSS2Properties currentStyleDeclarationState;
    private volatile AbstractCSS2Properties localStyleDeclarationState;
    private Map computedStyles;
    private boolean isMouseOver = false;
    private Boolean isHoverStyle = null;
    private Map hasHoverStyleByElement = null;

    public HTMLElementImpl(String string, boolean bl) {
        super(string);
        this.noStyleSheet = bl;
    }

    public HTMLElementImpl(String string) {
        super(string);
        this.noStyleSheet = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void forgetLocalStyle() {
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            this.currentStyleDeclarationState = null;
            this.localStyleDeclarationState = null;
            this.computedStyles = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void forgetStyle(boolean bl) {
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            ArrayList arrayList;
            this.currentStyleDeclarationState = null;
            this.computedStyles = null;
            this.isHoverStyle = null;
            this.hasHoverStyleByElement = null;
            if (bl && (arrayList = this.nodeList) != null) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof HTMLElementImpl)) continue;
                    ((HTMLElementImpl)e).forgetStyle(bl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCSS2Properties getCurrentStyle() {
        AbstractCSS2Properties abstractCSS2Properties;
        AbstractScriptableDelegate abstractScriptableDelegate = this;
        synchronized (abstractScriptableDelegate) {
            abstractCSS2Properties = this.currentStyleDeclarationState;
            if (abstractCSS2Properties != null) {
                return abstractCSS2Properties;
            }
        }
        abstractCSS2Properties = this.createDefaultStyleSheet();
        abstractCSS2Properties = this.addStyleSheetDeclarations(abstractCSS2Properties, this.getPseudoNames());
        abstractScriptableDelegate = this.getStyle();
        if (abstractCSS2Properties == null) {
            abstractCSS2Properties = new ComputedCSS2Properties(this);
            abstractCSS2Properties.setLocalStyleProperties((AbstractCSS2Properties)abstractScriptableDelegate);
        } else {
            abstractCSS2Properties.setLocalStyleProperties((AbstractCSS2Properties)abstractScriptableDelegate);
        }
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            AbstractCSS2Properties abstractCSS2Properties2 = this.currentStyleDeclarationState;
            if (abstractCSS2Properties2 != null) {
                return abstractCSS2Properties2;
            }
            this.currentStyleDeclarationState = abstractCSS2Properties;
            return abstractCSS2Properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCSS2Properties getStyle() {
        AbstractCSS2Properties abstractCSS2Properties;
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            abstractCSS2Properties = this.localStyleDeclarationState;
            if (abstractCSS2Properties != null) {
                return abstractCSS2Properties;
            }
            abstractCSS2Properties = new LocalCSS2Properties(this);
            String string = this.getAttribute("style");
            if (string != null && string.length() != 0) {
                CSSOMParser cSSOMParser = new CSSOMParser();
                InputSource inputSource = this.getCssInputSourceForDecl(string);
                try {
                    CSSStyleDeclaration cSSStyleDeclaration = cSSOMParser.parseStyleDeclaration(inputSource);
                    abstractCSS2Properties.addStyleDeclaration(cSSStyleDeclaration);
                }
                catch (Exception exception) {
                    String string2 = this.getId();
                    String string3 = string2 == null ? "" : " with ID '" + string2 + "'";
                    this.warn("Unable to parse style attribute value for element " + this.getTagName() + string3 + " in " + this.getDocumentURL() + ".", exception);
                }
            }
            this.localStyleDeclarationState = abstractCSS2Properties;
        }
        return abstractCSS2Properties;
    }

    protected AbstractCSS2Properties createDefaultStyleSheet() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractCSS2Properties getComputedStyle(String string) {
        AbstractCSS2Properties abstractCSS2Properties;
        Object object;
        if (string == null) {
            string = "";
        }
        Object object2 = this;
        synchronized (object2) {
            object = this.computedStyles;
            if (object != null && (abstractCSS2Properties = (AbstractCSS2Properties)object.get(string)) != null) {
                return abstractCSS2Properties;
            }
        }
        object2 = string.length() == 0 ? null : Collections.singleton(string);
        object = this.createDefaultStyleSheet();
        object = this.addStyleSheetDeclarations((AbstractCSS2Properties)object, (Set)object2);
        abstractCSS2Properties = this.getStyle();
        if (object == null) {
            object = new ComputedCSS2Properties(this);
            ((AbstractCSS2Properties)object).setLocalStyleProperties(abstractCSS2Properties);
        } else {
            ((AbstractCSS2Properties)object).setLocalStyleProperties(abstractCSS2Properties);
        }
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            HashMap<String, Object> hashMap = this.computedStyles;
            if (hashMap == null) {
                this.computedStyles = hashMap = new HashMap<String, Object>(2);
            } else {
                AbstractCSS2Properties abstractCSS2Properties2 = (AbstractCSS2Properties)hashMap.get(string);
                if (abstractCSS2Properties2 != null) {
                    return abstractCSS2Properties2;
                }
            }
            hashMap.put(string, object);
        }
        return object;
    }

    public void setStyle(Object object) {
        throw new DOMException(9, "Cannot set style property");
    }

    public void setCurrentStyle(Object object) {
        throw new DOMException(9, "Cannot set currentStyle property");
    }

    public String getClassName() {
        String string = this.getAttribute("class");
        return string == null ? "" : string;
    }

    public void setClassName(String string) {
        this.setAttribute("class", string);
    }

    public String getCharset() {
        return this.getAttribute("charset");
    }

    public void setCharset(String string) {
        this.setAttribute("charset", string);
    }

    public void warn(String string, Throwable throwable) {
        logger.log(Level.WARNING, string, throwable);
    }

    public void warn(String string) {
        logger.log(Level.WARNING, string);
    }

    protected int getAttributeAsInt(String string, int n) {
        String string2 = this.getAttribute(string);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            this.warn("Bad integer", exception);
            return n;
        }
    }

    public boolean getAttributeAsBoolean(String string) {
        return this.getAttribute(string) != null;
    }

    protected void assignAttributeField(String string, String string2) {
        if (!this.notificationsSuspended) {
            this.informInvalidAttibute(string);
        } else if ("style".equals(string)) {
            this.forgetLocalStyle();
        }
        super.assignAttributeField(string, string2);
    }

    protected final InputSource getCssInputSourceForDecl(String string) {
        StringReader stringReader = new StringReader("{" + string + "}");
        InputSource inputSource = new InputSource(stringReader);
        return inputSource;
    }

    protected final AbstractCSS2Properties addStyleSheetDeclarations(AbstractCSS2Properties abstractCSS2Properties, Set set) {
        block7: {
            block6: {
                Node node = this.parentNode;
                if (node == null) {
                    return abstractCSS2Properties;
                }
                String string = this.getClassName();
                if (string == null || string.length() == 0) break block6;
                String string2 = this.getId();
                String string3 = this.getTagName();
                String[] stringArray = Strings.split(string);
                int n = stringArray.length;
                while (--n >= 0) {
                    String string4 = stringArray[n];
                    Collection collection = this.findStyleDeclarations(string3, string2, string4, set);
                    if (collection == null) continue;
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        CSSStyleDeclaration cSSStyleDeclaration = (CSSStyleDeclaration)iterator.next();
                        if (abstractCSS2Properties == null) {
                            abstractCSS2Properties = new ComputedCSS2Properties(this);
                        }
                        abstractCSS2Properties.addStyleDeclaration(cSSStyleDeclaration);
                    }
                }
                break block7;
            }
            String string = this.getId();
            String string5 = this.getTagName();
            Collection collection = this.findStyleDeclarations(string5, string, null, set);
            if (collection == null) break block7;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                CSSStyleDeclaration cSSStyleDeclaration = (CSSStyleDeclaration)iterator.next();
                if (abstractCSS2Properties == null) {
                    abstractCSS2Properties = new ComputedCSS2Properties(this);
                }
                abstractCSS2Properties.addStyleDeclaration(cSSStyleDeclaration);
            }
        }
        return abstractCSS2Properties;
    }

    public void setMouseOver(boolean bl) {
        if (this.isMouseOver != bl) {
            this.isMouseOver = bl;
            this.invalidateDescendentsForHover();
            if (this.hasHoverStyle()) {
                this.informInvalid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateDescendentsForHover() {
        Object object = this.treeLock;
        synchronized (object) {
            this.invalidateDescendentsForHoverImpl(this);
        }
    }

    private void invalidateDescendentsForHoverImpl(HTMLElementImpl hTMLElementImpl) {
        ArrayList arrayList = this.nodeList;
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Object e = arrayList.get(i);
                if (!(e instanceof HTMLElementImpl)) continue;
                HTMLElementImpl hTMLElementImpl2 = (HTMLElementImpl)e;
                if (hTMLElementImpl2.hasHoverStyle(hTMLElementImpl)) {
                    hTMLElementImpl2.informInvalid();
                }
                hTMLElementImpl2.invalidateDescendentsForHoverImpl(hTMLElementImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasHoverStyle() {
        Object object;
        Boolean bl;
        NodeImpl nodeImpl = this;
        synchronized (nodeImpl) {
            bl = this.isHoverStyle;
            if (bl != null) {
                return bl;
            }
        }
        nodeImpl = (HTMLDocumentImpl)this.document;
        if (nodeImpl == null) {
            bl = Boolean.FALSE;
        } else {
            object = ((HTMLDocumentImpl)nodeImpl).getStyleSheetAggregator();
            String string = this.getId();
            String string2 = this.getTagName();
            String string3 = this.getClassName();
            String[] stringArray = null;
            if (string3 != null && string3.length() != 0) {
                stringArray = Strings.split(string3);
            }
            bl = ((StyleSheetAggregator)object).affectedByPseudoNameInAncestor(this, this, string2, string, stringArray, "hover");
        }
        object = this;
        synchronized (object) {
            this.isHoverStyle = bl;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasHoverStyle(HTMLElementImpl hTMLElementImpl) {
        Object object;
        Object object2;
        HashMap<HTMLElementImpl, Object> hashMap;
        Object object3 = this;
        synchronized (object3) {
            hashMap = this.hasHoverStyleByElement;
            if (hashMap != null && (object2 = (Boolean)hashMap.get(hTMLElementImpl)) != null) {
                return (Boolean)object2;
            }
        }
        object2 = (HTMLDocumentImpl)this.document;
        if (object2 == null) {
            object3 = Boolean.FALSE;
        } else {
            object = ((HTMLDocumentImpl)object2).getStyleSheetAggregator();
            String string = this.getId();
            String string2 = this.getTagName();
            String string3 = this.getClassName();
            String[] stringArray = null;
            if (string3 != null && string3.length() != 0) {
                stringArray = Strings.split(string3);
            }
            object3 = ((StyleSheetAggregator)object).affectedByPseudoNameInAncestor(this, hTMLElementImpl, string2, string, stringArray, "hover");
        }
        object = this;
        synchronized (object) {
            hashMap = this.hasHoverStyleByElement;
            if (hashMap == null) {
                this.hasHoverStyleByElement = hashMap = new HashMap<HTMLElementImpl, Object>(2);
            }
            hashMap.put(hTMLElementImpl, object3);
        }
        return (Boolean)object3;
    }

    public Set getPseudoNames() {
        HashSet<String> hashSet = null;
        if (this.isMouseOver) {
            if (hashSet == null) {
                hashSet = new HashSet<String>(1);
            }
            hashSet.add("hover");
        }
        return hashSet;
    }

    protected final Collection findStyleDeclarations(String string, String string2, String string3, Set set) {
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl == null) {
            return null;
        }
        StyleSheetAggregator styleSheetAggregator = hTMLDocumentImpl.getStyleSheetAggregator();
        return styleSheetAggregator.getActiveStyleDeclarations(this, string, string2, string3, set);
    }

    public void informInvalid() {
        this.forgetStyle(false);
        super.informInvalid();
    }

    public void informInvalidAttibute(String string) {
        if ("style".equals(string)) {
            this.forgetLocalStyle();
        } else if ("id".equals(string) || "class".equals(string)) {
            this.forgetStyle(false);
        }
        super.informInvalid();
    }

    protected FormInput[] getFormInputs() {
        return null;
    }

    private boolean classMatch(String string) {
        String string2 = this.getClassName();
        if (string2 == null || string2.length() == 0) {
            return string == null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.toLowerCase().equals(string)) continue;
            return true;
        }
        return false;
    }

    public HTMLElementImpl getAncestorWithClass(String string, String string2) {
        Node node = this.getParentNode();
        if (node instanceof HTMLElementImpl) {
            HTMLElementImpl hTMLElementImpl = (HTMLElementImpl)node;
            String string3 = hTMLElementImpl.getTagName().toLowerCase();
            if (("*".equals(string) || string.equals(string3)) && hTMLElementImpl.classMatch(string2)) {
                return hTMLElementImpl;
            }
            return hTMLElementImpl.getAncestorWithClass(string, string2);
        }
        return null;
    }

    public HTMLElementImpl getParentWithClass(String string, String string2) {
        Node node = this.getParentNode();
        if (node instanceof HTMLElementImpl) {
            HTMLElementImpl hTMLElementImpl = (HTMLElementImpl)node;
            String string3 = hTMLElementImpl.getTagName().toLowerCase();
            if (("*".equals(string) || string.equals(string3)) && hTMLElementImpl.classMatch(string2)) {
                return hTMLElementImpl;
            }
        }
        return null;
    }

    public HTMLElementImpl getPreceedingSiblingElement() {
        Node node = this.getParentNode();
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        int n = nodeList.getLength();
        HTMLElementImpl hTMLElementImpl = null;
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2 == this) {
                return hTMLElementImpl;
            }
            if (!(node2 instanceof HTMLElementImpl)) continue;
            hTMLElementImpl = (HTMLElementImpl)node2;
        }
        return null;
    }

    public HTMLElementImpl getPreceedingSiblingWithClass(String string, String string2) {
        HTMLElementImpl hTMLElementImpl = this.getPreceedingSiblingElement();
        if (hTMLElementImpl != null) {
            String string3 = hTMLElementImpl.getTagName().toLowerCase();
            if (("*".equals(string) || string.equals(string3)) && hTMLElementImpl.classMatch(string2)) {
                return hTMLElementImpl;
            }
        }
        return null;
    }

    public HTMLElementImpl getAncestorWithId(String string, String string2) {
        Node node = this.getParentNode();
        if (node instanceof HTMLElementImpl) {
            String string3;
            HTMLElementImpl hTMLElementImpl = (HTMLElementImpl)node;
            String string4 = hTMLElementImpl.getTagName().toLowerCase();
            String string5 = hTMLElementImpl.getId();
            String string6 = string3 = string5 == null ? null : string5.toLowerCase();
            if (("*".equals(string) || string.equals(string4)) && string2.equals(string3)) {
                return hTMLElementImpl;
            }
            return hTMLElementImpl.getAncestorWithId(string, string2);
        }
        return null;
    }

    public HTMLElementImpl getParentWithId(String string, String string2) {
        Node node = this.getParentNode();
        if (node instanceof HTMLElementImpl) {
            String string3;
            HTMLElementImpl hTMLElementImpl = (HTMLElementImpl)node;
            String string4 = hTMLElementImpl.getTagName().toLowerCase();
            String string5 = hTMLElementImpl.getId();
            String string6 = string3 = string5 == null ? null : string5.toLowerCase();
            if (("*".equals(string) || string.equals(string4)) && string2.equals(string3)) {
                return hTMLElementImpl;
            }
        }
        return null;
    }

    public HTMLElementImpl getPreceedingSiblingWithId(String string, String string2) {
        HTMLElementImpl hTMLElementImpl = this.getPreceedingSiblingElement();
        if (hTMLElementImpl != null) {
            String string3;
            String string4 = hTMLElementImpl.getTagName().toLowerCase();
            String string5 = hTMLElementImpl.getId();
            String string6 = string3 = string5 == null ? null : string5.toLowerCase();
            if (("*".equals(string) || string.equals(string4)) && string2.equals(string3)) {
                return hTMLElementImpl;
            }
        }
        return null;
    }

    public HTMLElementImpl getAncestor(String string) {
        Node node = this.getParentNode();
        if (node instanceof HTMLElementImpl) {
            HTMLElementImpl hTMLElementImpl = (HTMLElementImpl)node;
            if ("*".equals(string)) {
                return hTMLElementImpl;
            }
            String string2 = hTMLElementImpl.getTagName().toLowerCase();
            if (string.equals(string2)) {
                return hTMLElementImpl;
            }
            return hTMLElementImpl.getAncestor(string);
        }
        return null;
    }

    public HTMLElementImpl getParent(String string) {
        Node node = this.getParentNode();
        if (node instanceof HTMLElementImpl) {
            HTMLElementImpl hTMLElementImpl = (HTMLElementImpl)node;
            if ("*".equals(string)) {
                return hTMLElementImpl;
            }
            String string2 = hTMLElementImpl.getTagName().toLowerCase();
            if (string.equals(string2)) {
                return hTMLElementImpl;
            }
        }
        return null;
    }

    public HTMLElementImpl getPreceedingSibling(String string) {
        HTMLElementImpl hTMLElementImpl = this.getPreceedingSiblingElement();
        if (hTMLElementImpl != null) {
            if ("*".equals(string)) {
                return hTMLElementImpl;
            }
            String string2 = hTMLElementImpl.getTagName().toLowerCase();
            if (string.equals(string2)) {
                return hTMLElementImpl;
            }
        }
        return null;
    }

    protected Object getAncestorForJavaClass(Class clazz) {
        Node node = this.getParentNode();
        if (node == null || clazz.isInstance(node)) {
            return node;
        }
        if (node instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)node).getAncestorForJavaClass(clazz);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInnerHTML(String string) {
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl == null) {
            this.warn("setInnerHTML(): Element " + this + " does not belong to a document.");
            return;
        }
        HtmlParser htmlParser = new HtmlParser(hTMLDocumentImpl.getUserAgentContext(), hTMLDocumentImpl, null, null, null);
        Object object = this;
        synchronized (object) {
            ArrayList arrayList = this.nodeList;
            if (arrayList != null) {
                arrayList.clear();
            }
        }
        try {
            object = new StringReader(string);
            try {
                htmlParser.parse((Reader)object, (Node)this);
            }
            finally {
                ((Reader)object).close();
            }
        }
        catch (Exception exception) {
            this.warn("setInnerHTML(): Error setting inner HTML.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOuterHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        HTMLElementImpl hTMLElementImpl = this;
        synchronized (hTMLElementImpl) {
            this.appendOuterHTMLImpl(stringBuffer);
        }
        return stringBuffer.toString();
    }

    protected void appendOuterHTMLImpl(StringBuffer stringBuffer) {
        Object object;
        String string = this.getTagName();
        stringBuffer.append('<');
        stringBuffer.append(string);
        Map map = this.attributes;
        if (map != null) {
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                String string2 = (String)entry.getValue();
                if (string2 == null) continue;
                stringBuffer.append(' ');
                stringBuffer.append(entry.getKey());
                stringBuffer.append("=\"");
                stringBuffer.append(Strings.strictHtmlEncode(string2, true));
                stringBuffer.append("\"");
            }
        }
        if ((object = this.nodeList) == null || ((ArrayList)object).size() == 0) {
            stringBuffer.append("/>");
            return;
        }
        stringBuffer.append('>');
        this.appendInnerHTMLImpl(stringBuffer);
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append('>');
    }

    protected RenderState createRenderState(RenderState renderState) {
        return new StyleSheetRenderState(renderState, this);
    }

    public int getOffsetTop() {
        UINode uINode = this.getUINode();
        return uINode == null ? 0 : uINode.getBoundsRelativeToBlock().y;
    }

    public int getOffsetLeft() {
        UINode uINode = this.getUINode();
        return uINode == null ? 0 : uINode.getBoundsRelativeToBlock().x;
    }

    public int getOffsetWidth() {
        UINode uINode = this.getUINode();
        return uINode == null ? 0 : uINode.getBoundsRelativeToBlock().width;
    }

    public int getOffsetHeight() {
        UINode uINode = this.getUINode();
        return uINode == null ? 0 : uINode.getBoundsRelativeToBlock().height;
    }

    public AbstractCSS2Properties getParentStyle() {
        Node node = this.parentNode;
        if (node instanceof HTMLElementImpl) {
            return ((HTMLElementImpl)node).getCurrentStyle();
        }
        return null;
    }

    public String getDocumentBaseURI() {
        HTMLDocumentImpl hTMLDocumentImpl = (HTMLDocumentImpl)this.document;
        if (hTMLDocumentImpl != null) {
            return hTMLDocumentImpl.getBaseURI();
        }
        return null;
    }

    public String toString() {
        return super.toString() + "[currentStyle=" + this.getCurrentStyle() + "]";
    }
}

