/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser;

import java.io.Serializable;
import org.w3c.css.sac.LexicalUnit;

public class LexicalUnitImpl
implements LexicalUnit,
Serializable {
    private short _type;
    private LexicalUnit _next;
    private LexicalUnit _prev;
    private float _floatVal;
    private String _dimension;
    private String _function;
    private LexicalUnit _params;
    private String _stringVal;

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, short s) {
        this._type = s;
        this._prev = lexicalUnit;
        if (this._prev != null) {
            ((LexicalUnitImpl)this._prev)._next = this;
        }
    }

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, int n) {
        this(lexicalUnit, 13);
        this._floatVal = n;
    }

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, short s, float f) {
        this(lexicalUnit, s);
        this._floatVal = f;
    }

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, short s, String string, float f) {
        this(lexicalUnit, s);
        this._dimension = string;
        this._floatVal = f;
    }

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, short s, String string) {
        this(lexicalUnit, s);
        this._stringVal = string;
    }

    protected LexicalUnitImpl(LexicalUnit lexicalUnit, short s, String string, LexicalUnit lexicalUnit2) {
        this(lexicalUnit, s);
        this._function = string;
        this._params = lexicalUnit2;
    }

    public short getLexicalUnitType() {
        return this._type;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this._next;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this._prev;
    }

    public int getIntegerValue() {
        return (int)this._floatVal;
    }

    public float getFloatValue() {
        return this._floatVal;
    }

    public String getDimensionUnitText() {
        switch (this._type) {
            case 15: {
                return "em";
            }
            case 16: {
                return "ex";
            }
            case 17: {
                return "px";
            }
            case 18: {
                return "in";
            }
            case 19: {
                return "cm";
            }
            case 20: {
                return "mm";
            }
            case 21: {
                return "pt";
            }
            case 22: {
                return "pc";
            }
            case 23: {
                return "%";
            }
            case 28: {
                return "deg";
            }
            case 29: {
                return "grad";
            }
            case 30: {
                return "rad";
            }
            case 31: {
                return "ms";
            }
            case 32: {
                return "s";
            }
            case 33: {
                return "Hz";
            }
            case 34: {
                return "kHz";
            }
            case 42: {
                return this._dimension;
            }
        }
        return "";
    }

    public String getFunctionName() {
        return this._function;
    }

    public LexicalUnit getParameters() {
        return this._params;
    }

    public String getStringValue() {
        return this._stringVal;
    }

    public LexicalUnit getSubValues() {
        return this._params;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this._type) {
            case 0: {
                stringBuffer.append(",");
                break;
            }
            case 1: {
                stringBuffer.append("+");
                break;
            }
            case 2: {
                stringBuffer.append("-");
                break;
            }
            case 3: {
                stringBuffer.append("*");
                break;
            }
            case 4: {
                stringBuffer.append("/");
                break;
            }
            case 5: {
                stringBuffer.append("%");
                break;
            }
            case 6: {
                stringBuffer.append("^");
                break;
            }
            case 7: {
                stringBuffer.append("<");
                break;
            }
            case 8: {
                stringBuffer.append(">");
                break;
            }
            case 9: {
                stringBuffer.append("<=");
                break;
            }
            case 10: {
                stringBuffer.append(">=");
                break;
            }
            case 11: {
                stringBuffer.append("~");
                break;
            }
            case 43: {
                stringBuffer.append("=");
                break;
            }
            case 12: {
                stringBuffer.append("inherit");
                break;
            }
            case 13: {
                stringBuffer.append(String.valueOf(this.getIntegerValue()));
                break;
            }
            case 14: {
                stringBuffer.append(this.trimFloat(this.getFloatValue()));
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                stringBuffer.append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText());
                break;
            }
            case 24: {
                stringBuffer.append("url(").append(this.getStringValue()).append(")");
                break;
            }
            case 25: {
                stringBuffer.append("counter(");
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append(")");
                break;
            }
            case 26: {
                stringBuffer.append("counters(");
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append(")");
                break;
            }
            case 27: {
                stringBuffer.append("rgb(");
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append(")");
                break;
            }
            case 35: {
                stringBuffer.append(this.getStringValue());
                break;
            }
            case 36: {
                stringBuffer.append("\"").append(this.getStringValue()).append("\"");
                break;
            }
            case 37: {
                stringBuffer.append("attr(");
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append(")");
                break;
            }
            case 38: {
                stringBuffer.append("rect(");
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append(")");
                break;
            }
            case 39: {
                stringBuffer.append(this.getStringValue());
                break;
            }
            case 40: {
                stringBuffer.append(this.getStringValue());
                break;
            }
            case 41: {
                stringBuffer.append(this.getFunctionName());
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append(")");
                break;
            }
            case 44: {
                stringBuffer.append(this.getFunctionName() + "(");
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this._type) {
            case 0: {
                stringBuffer.append("SAC_OPERATOR_COMMA");
                break;
            }
            case 1: {
                stringBuffer.append("SAC_OPERATOR_PLUS");
                break;
            }
            case 2: {
                stringBuffer.append("SAC_OPERATOR_MINUS");
                break;
            }
            case 3: {
                stringBuffer.append("SAC_OPERATOR_MULTIPLY");
                break;
            }
            case 4: {
                stringBuffer.append("SAC_OPERATOR_SLASH");
                break;
            }
            case 5: {
                stringBuffer.append("SAC_OPERATOR_MOD");
                break;
            }
            case 6: {
                stringBuffer.append("SAC_OPERATOR_EXP");
                break;
            }
            case 7: {
                stringBuffer.append("SAC_OPERATOR_LT");
                break;
            }
            case 8: {
                stringBuffer.append("SAC_OPERATOR_GT");
                break;
            }
            case 9: {
                stringBuffer.append("SAC_OPERATOR_LE");
                break;
            }
            case 10: {
                stringBuffer.append("SAC_OPERATOR_GE");
                break;
            }
            case 11: {
                stringBuffer.append("SAC_OPERATOR_TILDE");
                break;
            }
            case 12: {
                stringBuffer.append("SAC_INHERIT");
                break;
            }
            case 13: {
                stringBuffer.append("SAC_INTEGER(").append(String.valueOf(this.getIntegerValue())).append(")");
                break;
            }
            case 14: {
                stringBuffer.append("SAC_REAL(").append(this.trimFloat(this.getFloatValue())).append(")");
                break;
            }
            case 15: {
                stringBuffer.append("SAC_EM(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 16: {
                stringBuffer.append("SAC_EX(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 17: {
                stringBuffer.append("SAC_PIXEL(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 18: {
                stringBuffer.append("SAC_INCH(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 19: {
                stringBuffer.append("SAC_CENTIMETER(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 20: {
                stringBuffer.append("SAC_MILLIMETER(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 21: {
                stringBuffer.append("SAC_POINT(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 22: {
                stringBuffer.append("SAC_PICA(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 23: {
                stringBuffer.append("SAC_PERCENTAGE(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 28: {
                stringBuffer.append("SAC_DEGREE(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 29: {
                stringBuffer.append("SAC_GRADIAN(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 30: {
                stringBuffer.append("SAC_RADIAN(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 31: {
                stringBuffer.append("SAC_MILLISECOND(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 32: {
                stringBuffer.append("SAC_SECOND(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 33: {
                stringBuffer.append("SAC_HERTZ(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 34: {
                stringBuffer.append("SAC_KILOHERTZ(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 42: {
                stringBuffer.append("SAC_DIMENSION(").append(this.trimFloat(this.getFloatValue())).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 24: {
                stringBuffer.append("SAC_URI(url(").append(this.getStringValue()).append("))");
                break;
            }
            case 25: {
                stringBuffer.append("SAC_COUNTER_FUNCTION(counter(");
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append("))");
                break;
            }
            case 26: {
                stringBuffer.append("SAC_COUNTERS_FUNCTION(counters(");
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append("))");
                break;
            }
            case 27: {
                stringBuffer.append("SAC_RGBCOLOR(rgb(");
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append("))");
                break;
            }
            case 35: {
                stringBuffer.append("SAC_IDENT(").append(this.getStringValue()).append(")");
                break;
            }
            case 36: {
                stringBuffer.append("SAC_STRING_VALUE(\"").append(this.getStringValue()).append("\")");
                break;
            }
            case 37: {
                stringBuffer.append("SAC_ATTR(attr(");
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append("))");
                break;
            }
            case 38: {
                stringBuffer.append("SAC_RECT_FUNCTION(rect(");
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append("))");
                break;
            }
            case 39: {
                stringBuffer.append("SAC_UNICODERANGE(").append(this.getStringValue()).append(")");
                break;
            }
            case 40: {
                stringBuffer.append("SAC_SUB_EXPRESSION(").append(this.getStringValue()).append(")");
                break;
            }
            case 41: {
                stringBuffer.append("SAC_FUNCTION(").append(this.getFunctionName()).append("(");
                this.appendParams(stringBuffer, this._params);
                stringBuffer.append("))");
            }
        }
        return stringBuffer.toString();
    }

    private void appendParams(StringBuffer stringBuffer, LexicalUnit lexicalUnit) {
        for (LexicalUnit lexicalUnit2 = lexicalUnit; lexicalUnit2 != null; lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) {
            stringBuffer.append(lexicalUnit2.toString());
        }
    }

    private String trimFloat(float f) {
        String string = String.valueOf(this.getFloatValue());
        return f - (float)((int)f) != 0.0f ? string : string.substring(0, string.length() - 2);
    }

    public static LexicalUnit createNumber(LexicalUnit lexicalUnit, float f) {
        if (f > (float)((int)f)) {
            return new LexicalUnitImpl(lexicalUnit, 14, f);
        }
        return new LexicalUnitImpl(lexicalUnit, (int)f);
    }

    public static LexicalUnit createPercentage(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 23, f);
    }

    public static LexicalUnit createPixel(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 17, f);
    }

    public static LexicalUnit createCentimeter(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 19, f);
    }

    public static LexicalUnit createMillimeter(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 20, f);
    }

    public static LexicalUnit createInch(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 18, f);
    }

    public static LexicalUnit createPoint(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 21, f);
    }

    public static LexicalUnit createPica(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 22, f);
    }

    public static LexicalUnit createEm(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 15, f);
    }

    public static LexicalUnit createEx(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 16, f);
    }

    public static LexicalUnit createDegree(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 28, f);
    }

    public static LexicalUnit createRadian(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 30, f);
    }

    public static LexicalUnit createGradian(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 29, f);
    }

    public static LexicalUnit createMillisecond(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 31, f);
    }

    public static LexicalUnit createSecond(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 32, f);
    }

    public static LexicalUnit createHertz(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 33, f);
    }

    public static LexicalUnit createDimension(LexicalUnit lexicalUnit, float f, String string) {
        return new LexicalUnitImpl(lexicalUnit, 42, string, f);
    }

    public static LexicalUnit createKiloHertz(LexicalUnit lexicalUnit, float f) {
        return new LexicalUnitImpl(lexicalUnit, 34, f);
    }

    public static LexicalUnit createCounter(LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new LexicalUnitImpl(lexicalUnit, 25, "counter", lexicalUnit2);
    }

    public static LexicalUnit createAlpha(LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new LexicalUnitImpl(lexicalUnit, 44, "alpha", lexicalUnit2);
    }

    public static LexicalUnit createCounters(LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new LexicalUnitImpl(lexicalUnit, 26, "counters", lexicalUnit2);
    }

    public static LexicalUnit createAttr(LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new LexicalUnitImpl(lexicalUnit, 37, "attr", lexicalUnit2);
    }

    public static LexicalUnit createRect(LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new LexicalUnitImpl(lexicalUnit, 38, "rect", lexicalUnit2);
    }

    public static LexicalUnit createRgbColor(LexicalUnit lexicalUnit, LexicalUnit lexicalUnit2) {
        return new LexicalUnitImpl(lexicalUnit, 27, "rgb", lexicalUnit2);
    }

    public static LexicalUnit createFunction(LexicalUnit lexicalUnit, String string, LexicalUnit lexicalUnit2) {
        return new LexicalUnitImpl(lexicalUnit, 41, string, lexicalUnit2);
    }

    public static LexicalUnit createString(LexicalUnit lexicalUnit, String string) {
        return new LexicalUnitImpl(lexicalUnit, 36, string);
    }

    public static LexicalUnit createIdent(LexicalUnit lexicalUnit, String string) {
        return new LexicalUnitImpl(lexicalUnit, 35, string);
    }

    public static LexicalUnit createURI(LexicalUnit lexicalUnit, String string) {
        return new LexicalUnitImpl(lexicalUnit, 24, string);
    }

    public static LexicalUnit createComma(LexicalUnit lexicalUnit) {
        return new LexicalUnitImpl(lexicalUnit, 0);
    }
}

