/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

final class WindowsFieldCaret
extends DefaultCaret
implements UIResource {
    private static final LayeredHighlighter.LayerPainter WindowsPainter = new WindowsHighlightPainter(null);
    private boolean isKeyboardFocusEvent = true;

    WindowsFieldCaret() {
    }

    public void focusGained(FocusEvent focusEvent) {
        JTextComponent jTextComponent;
        if (this.getComponent().isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
        }
        if ((jTextComponent = this.getComponent()).isEnabled() && this.isKeyboardFocusEvent) {
            if (jTextComponent instanceof JFormattedTextField) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        WindowsFieldCaret.super.setDot(0);
                        WindowsFieldCaret.super.moveDot(jTextComponent.getDocument().getLength());
                    }
                });
            } else {
                super.setDot(0);
                super.moveDot(jTextComponent.getDocument().getLength());
            }
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        if (!focusEvent.isTemporary()) {
            this.isKeyboardFocusEvent = true;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
        }
        super.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        if (mouseEvent.isPopupTrigger()) {
            this.isKeyboardFocusEvent = false;
            if (this.getComponent() != null && this.getComponent().isEnabled() && this.getComponent().isRequestFocusEnabled()) {
                this.getComponent().requestFocus();
            }
        }
    }

    protected void adjustVisibility(Rectangle rectangle) {
        SwingUtilities.invokeLater(new SafeScroller(rectangle));
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return WindowsPainter;
    }

    private static final class WindowsHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        WindowsHighlightPainter(Color color) {
            super(color);
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            Rectangle rectangle = shape.getBounds();
            try {
                int n3;
                TextUI textUI = jTextComponent.getUI();
                Rectangle rectangle2 = textUI.modelToView(jTextComponent, n);
                Rectangle rectangle3 = textUI.modelToView(jTextComponent, n2);
                Color color = this.getColor();
                if (color == null) {
                    graphics.setColor(jTextComponent.getSelectionColor());
                } else {
                    graphics.setColor(color);
                }
                boolean bl = false;
                boolean bl2 = false;
                if (jTextComponent.isEditable()) {
                    n3 = jTextComponent.getCaretPosition();
                    bl = n == n3;
                    boolean bl3 = bl2 = n2 == n3;
                }
                if (rectangle2.y == rectangle3.y) {
                    Rectangle rectangle4 = rectangle2.union(rectangle3);
                    if (rectangle4.width > 0) {
                        if (bl) {
                            ++rectangle4.x;
                            --rectangle4.width;
                        } else if (bl2) {
                            --rectangle4.width;
                        }
                    }
                    graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                } else {
                    n3 = rectangle.x + rectangle.width - rectangle2.x;
                    if (bl && n3 > 0) {
                        ++rectangle2.x;
                        --n3;
                    }
                    graphics.fillRect(rectangle2.x, rectangle2.y, n3, rectangle2.height);
                    if (rectangle2.y + rectangle2.height != rectangle3.y) {
                        graphics.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle3.y - (rectangle2.y + rectangle2.height));
                    }
                    if (bl2 && rectangle3.x > rectangle.x) {
                        --rectangle3.x;
                    }
                    graphics.fillRect(rectangle.x, rectangle3.y, rectangle3.x - rectangle.x, rectangle3.height);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            Color color = this.getColor();
            if (color == null) {
                graphics.setColor(jTextComponent.getSelectionColor());
            } else {
                graphics.setColor(color);
            }
            boolean bl = false;
            boolean bl2 = false;
            if (jTextComponent.isEditable()) {
                int n3 = jTextComponent.getCaretPosition();
                bl = n == n3;
                boolean bl3 = bl2 = n2 == n3;
            }
            if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                if (bl && rectangle.width > 0) {
                    graphics.fillRect(rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height);
                } else if (bl2 && rectangle.width > 0) {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                } else {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                return rectangle;
            }
            try {
                Rectangle rectangle;
                Shape shape2 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                Rectangle rectangle2 = rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
                if (bl && rectangle.width > 0) {
                    graphics.fillRect(rectangle.x + 1, rectangle.y, rectangle.width - 1, rectangle.height);
                } else if (bl2 && rectangle.width > 0) {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                } else {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                return rectangle;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
    }

    private final class SafeScroller
    implements Runnable {
        private Rectangle r;

        SafeScroller(Rectangle rectangle) {
            this.r = rectangle;
        }

        public void run() {
            JTextField jTextField = (JTextField)WindowsFieldCaret.this.getComponent();
            if (jTextField != null) {
                TextUI textUI = jTextField.getUI();
                int n = WindowsFieldCaret.this.getDot();
                Position.Bias bias = Position.Bias.Forward;
                Rectangle rectangle = null;
                try {
                    rectangle = textUI.modelToView(jTextField, n, bias);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                Insets insets = jTextField.getInsets();
                BoundedRangeModel boundedRangeModel = jTextField.getHorizontalVisibility();
                int n2 = this.r.x + boundedRangeModel.getValue() - insets.left;
                int n3 = boundedRangeModel.getExtent() / 4;
                if (this.r.x < insets.left) {
                    boundedRangeModel.setValue(n2 - n3);
                } else if (this.r.x + this.r.width > insets.left + boundedRangeModel.getExtent()) {
                    boundedRangeModel.setValue(n2 - 3 * n3);
                }
                if (rectangle != null) {
                    try {
                        Rectangle rectangle2 = textUI.modelToView(jTextField, n, bias);
                        if (rectangle2 != null && !rectangle2.equals(rectangle)) {
                            WindowsFieldCaret.this.damage(rectangle2);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

