/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.text.normalizer.UTF16;

public abstract class Trie {
    protected static final int LEAD_INDEX_OFFSET_ = 320;
    protected static final int INDEX_STAGE_1_SHIFT_ = 5;
    protected static final int INDEX_STAGE_2_SHIFT_ = 2;
    protected static final int INDEX_STAGE_3_MASK_ = 31;
    protected static final int SURROGATE_MASK_ = 1023;
    protected char[] m_index_;
    protected DataManipulate m_dataManipulate_;
    protected int m_dataOffset_;
    protected int m_dataLength_;
    private static final int HEADER_SIGNATURE_INDEX_ = 0;
    private static final int HEADER_OPTIONS_INDEX_ = 2;
    private static final int HEADER_INDEX_LENGTH_INDEX_ = 4;
    private static final int HEADER_DATA_LENGTH_INDEX_ = 6;
    private static final int HEADER_LENGTH_ = 8;
    private static final int HEADER_OPTIONS_LATIN1_IS_LINEAR_MASK_ = 512;
    private static final int HEADER_SIGNATURE_ = 1416784229;
    private static final int HEADER_OPTIONS_SHIFT_MASK_ = 15;
    private static final int HEADER_OPTIONS_INDEX_SHIFT_ = 4;
    private static final int HEADER_OPTIONS_DATA_IS_32_BIT_ = 256;
    private boolean m_isLatin1Linear_;
    private int m_options_;

    protected Trie(InputStream inputStream, DataManipulate dataManipulate) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        this.m_options_ = dataInputStream.readInt();
        if (!this.checkHeader(n)) {
            throw new IllegalArgumentException("ICU data file error: Trie header authentication failed, please check if you have the most updated ICU data file");
        }
        this.m_dataManipulate_ = dataManipulate;
        this.m_isLatin1Linear_ = (this.m_options_ & 0x200) != 0;
        this.m_dataOffset_ = dataInputStream.readInt();
        this.m_dataLength_ = dataInputStream.readInt();
        this.unserialize(inputStream);
    }

    protected Trie(char[] cArray, int n, DataManipulate dataManipulate) {
        this.m_options_ = n;
        this.m_dataManipulate_ = dataManipulate;
        this.m_isLatin1Linear_ = (this.m_options_ & 0x200) != 0;
        this.m_index_ = cArray;
        this.m_dataOffset_ = this.m_index_.length;
    }

    protected abstract int getSurrogateOffset(char var1, char var2);

    protected abstract int getValue(int var1);

    protected abstract int getInitialValue();

    protected final int getRawOffset(int n, char c) {
        return (this.m_index_[n + (c >> 5)] << 2) + (c & 0x1F);
    }

    protected final int getBMPOffset(char c) {
        return c >= '\ud800' && c <= '\udbff' ? this.getRawOffset(320, c) : this.getRawOffset(0, c);
    }

    protected final int getLeadOffset(char c) {
        return this.getRawOffset(0, c);
    }

    protected final int getCodePointOffset(int n) {
        if (n >= 0 && n < 65536) {
            return this.getBMPOffset((char)n);
        }
        if (n >= 0 && n <= 0x10FFFF) {
            return this.getSurrogateOffset(UTF16.getLeadSurrogate((int)n), (char)(n & 0x3FF));
        }
        return -1;
    }

    protected void unserialize(InputStream inputStream) throws IOException {
        this.m_index_ = new char[this.m_dataOffset_];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        for (int i = 0; i < this.m_dataOffset_; ++i) {
            this.m_index_[i] = dataInputStream.readChar();
        }
    }

    protected final boolean isIntTrie() {
        return (this.m_options_ & 0x100) != 0;
    }

    protected final boolean isCharTrie() {
        return (this.m_options_ & 0x100) == 0;
    }

    private final boolean checkHeader(int n) {
        if (n != 1416784229) {
            return false;
        }
        return (this.m_options_ & 0xF) == 5 && (this.m_options_ >> 4 & 0xF) == 2;
    }

    public static interface DataManipulate {
        public int getFoldingOffset(int var1);
    }
}

