/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Enumeration;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.X509Key;

public class CertificateX509Key
implements CertAttrSet {
    public static final String IDENT = "x509.info.key";
    public static final String NAME = "key";
    public static final String KEY = "value";
    private PublicKey key;

    public CertificateX509Key(PublicKey publicKey) {
        this.key = publicKey;
    }

    public CertificateX509Key(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        this.key = X509Key.parse(derValue);
    }

    public CertificateX509Key(InputStream inputStream) throws IOException {
        DerValue derValue = new DerValue(inputStream);
        this.key = X509Key.parse(derValue);
    }

    public String toString() {
        if (this.key == null) {
            return "";
        }
        return this.key.toString();
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.write(this.key.getEncoded());
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (!string.equalsIgnoreCase(KEY)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
        }
        this.key = (PublicKey)object;
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(KEY)) {
            return this.key;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
    }

    public void delete(String string) throws IOException {
        if (!string.equalsIgnoreCase(KEY)) {
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
        }
        this.key = null;
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement((Object)KEY);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }
}

