/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jca;

import java.security.AccessController;
import sun.security.jca.ProviderList;

public class Providers {
    private static final ThreadLocal<ProviderList> threadLists = new InheritableThreadLocal<ProviderList>();
    private static volatile int threadListsUsed;
    private static volatile ProviderList providerList;
    private static volatile boolean policyInitialized;
    private static final String[] jarClassNames;

    private Providers() {
    }

    public static Object startJarVerification() {
        ProviderList providerList = Providers.getProviderList();
        ProviderList providerList2 = providerList.getJarList(jarClassNames);
        return Providers.beginThreadProviderList(providerList2);
    }

    public static void stopJarVerification(Object object) {
        Providers.endThreadProviderList((ProviderList)object);
    }

    public static ProviderList getProviderList() {
        ProviderList providerList;
        block5: {
            if (!policyInitialized) {
                try {
                    if (System.getSecurityManager() != null) {
                        AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
                    }
                    policyInitialized = true;
                }
                catch (Exception exception) {
                    if (ProviderList.debug == null) break block5;
                    ProviderList.debug.println("policy init failed");
                    exception.printStackTrace();
                }
            }
        }
        if ((providerList = Providers.getThreadProviderList()) == null) {
            providerList = Providers.getSystemProviderList();
        }
        return providerList;
    }

    public static void setProviderList(ProviderList providerList) {
        if (Providers.getThreadProviderList() == null) {
            Providers.setSystemProviderList(providerList);
        } else {
            Providers.changeThreadProviderList(providerList);
        }
    }

    public static synchronized ProviderList getFullProviderList() {
        ProviderList providerList = Providers.getThreadProviderList();
        if (providerList != null) {
            ProviderList providerList2 = providerList.removeInvalid();
            if (providerList2 != providerList) {
                Providers.changeThreadProviderList(providerList2);
                providerList = providerList2;
            }
            return providerList;
        }
        providerList = Providers.getSystemProviderList();
        ProviderList providerList3 = providerList.removeInvalid();
        if (providerList3 != providerList) {
            Providers.setSystemProviderList(providerList3);
            providerList = providerList3;
        }
        return providerList;
    }

    private static ProviderList getSystemProviderList() {
        return providerList;
    }

    private static void setSystemProviderList(ProviderList providerList) {
        Providers.providerList = providerList;
    }

    public static ProviderList getThreadProviderList() {
        if (threadListsUsed == 0) {
            return null;
        }
        return threadLists.get();
    }

    private static void changeThreadProviderList(ProviderList providerList) {
        threadLists.set(providerList);
    }

    public static synchronized ProviderList beginThreadProviderList(ProviderList providerList) {
        if (ProviderList.debug != null) {
            ProviderList.debug.println("ThreadLocal providers: " + providerList);
        }
        ProviderList providerList2 = threadLists.get();
        ++threadListsUsed;
        threadLists.set(providerList);
        return providerList2;
    }

    public static synchronized void endThreadProviderList(ProviderList providerList) {
        if (providerList == null) {
            if (ProviderList.debug != null) {
                ProviderList.debug.println("Disabling ThreadLocal providers");
            }
            threadLists.remove();
        } else {
            if (ProviderList.debug != null) {
                ProviderList.debug.println("Restoring previous ThreadLocal providers: " + providerList);
            }
            threadLists.set(providerList);
        }
        --threadListsUsed;
    }

    static {
        providerList = ProviderList.EMPTY;
        providerList = ProviderList.fromSecurityProperties();
        jarClassNames = new String[]{"sun.security.provider.Sun", "sun.security.rsa.SunRsaSign"};
    }
}

